/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.demo.service;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.demo.payload.DemoSimplePayload;
import com.elitesland.tw.tw5.api.demo.query.DemoSimpleQuery;
import com.elitesland.tw.tw5.api.demo.service.DemoSimpleService;
import com.elitesland.tw.tw5.api.demo.vo.DemoSimpleVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.common.workFlow.WorkflowUtil;
import com.elitesland.tw.tw5.server.demo.convert.DemoSimpleConvert;
import com.elitesland.tw.tw5.server.demo.dao.DemoSimpleDAO;
import com.elitesland.tw.tw5.server.demo.entity.DemoSimpleDO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.payload.DeleteProcessPayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.CollectionUtils;

@Service
public class DemoSimpleServiceImpl
implements DemoSimpleService {
    private static final Logger log = LoggerFactory.getLogger(DemoSimpleServiceImpl.class);
    private final DemoSimpleDAO dao;
    private final TransactionUtilService transactionUtilService;
    private final TransactionTemplate transactionTemplate;
    private final CacheUtil cacheUtil;
    private final WorkflowUtil workflowUtil;

    @Transactional
    public DemoSimpleVO insert(DemoSimplePayload payload) {
        DemoSimpleDO ado = DemoSimpleConvert.INSTANCE.toDo(payload);
        this.transactionTemplate.setPropagationBehavior(3);
        this.transactionTemplate.execute(transactionStatus -> {
            this.dao.save(ado);
            return null;
        });
        DemoSimpleVO demoSimpleVO = DemoSimpleConvert.INSTANCE.toVo(ado);
        if (payload.getSubmit() != null && payload.getSubmit().booleanValue()) {
            this.submitProc(demoSimpleVO);
        }
        return demoSimpleVO;
    }

    public DemoSimpleVO update(DemoSimplePayload payload) {
        this.dao.updateByKeyDynamic(payload);
        DemoSimpleVO demoSimpleVO = this.dao.queryByKey(payload.getId());
        if (payload.getSubmit() != null && payload.getSubmit().booleanValue()) {
            this.submitProc(demoSimpleVO);
        }
        return demoSimpleVO;
    }

    public DemoSimpleVO queryByKey(Long key) {
        return this.dao.queryByKey(key);
    }

    public PagingVO<DemoSimpleVO> paging(DemoSimpleQuery query) {
        PagingVO<DemoSimpleVO> demoSimpleVOPagingVO = this.dao.queryPaging(query);
        List records = demoSimpleVOPagingVO.getRecords();
        records.forEach(demoSimpleVO -> this.transferCustomerDatas(records));
        demoSimpleVOPagingVO.setRecords(records);
        return demoSimpleVOPagingVO;
    }

    private void transferCustomerDatas(List<DemoSimpleVO> records) {
        for (DemoSimpleVO vo : records) {
            if (!ObjectUtils.isEmpty((Object)vo.getCreateUserId())) {
                vo.setCreator(this.cacheUtil.getUserName(vo.getCreateUserId()));
            }
            if (!ObjectUtils.isEmpty((Object)vo.getObjectStatus())) {
                switch (vo.getObjectStatus()) {
                    case "APPROVING": {
                        vo.setObjectStatusDesc("\u5ba1\u6279\u4e2d");
                        break;
                    }
                    case "new": {
                        vo.setObjectStatusDesc("\u65b0\u5efa");
                        break;
                    }
                    case "active": {
                        vo.setObjectStatusDesc("\u6fc0\u6d3b");
                        break;
                    }
                    case "invalid": {
                        vo.setObjectStatusDesc("\u65e0\u6548");
                    }
                }
            }
            if (ObjectUtils.isEmpty((Object)vo.getProcInstStatus())) continue;
            vo.setProcInstStatusDesc(vo.getProcInstStatus().getDesc());
        }
    }

    public List<DemoSimpleVO> queryList(DemoSimpleQuery query) {
        return this.dao.queryListDynamic(query);
    }

    @Transactional
    public void deleteSoft(List<Long> keys) {
        List<DemoSimpleVO> demoSimpleVOS = this.dao.queryByKeys(keys);
        if (CollectionUtils.isEmpty(demoSimpleVOS)) {
            throw TwException.error("", "\u5355\u636e\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        this.dao.deleteSoft(keys);
        for (DemoSimpleVO demoSimpleVO : demoSimpleVOS) {
            if (demoSimpleVO.getProcInstId() == null) continue;
            this.workflowUtil.deleteProcess(DeleteProcessPayload.of((String)demoSimpleVO.getProcInstId(), (String)""));
        }
    }

    private void submitProc(DemoSimpleVO demoSimpleVO) {
        HashMap<String, Serializable> variables = new HashMap<String, Serializable>();
        variables.put("isSpecial", Boolean.valueOf(true));
        variables.put("Activity_05zkia7", CollUtil.newArrayList((Object[])new String[]{"579786252467963621", "579785921050840585"}));
        variables.put("Activity_11rzme6", CollUtil.newArrayList((Object[])new String[]{"579786372043377650", "579786202115344318"}));
        ProcessInfo processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)ProcDefKey.FLOW_DEMO.name(), (String)(demoSimpleVO.getObjectName() + "-\u521b\u5efa\u6d41\u7a0b"), (String)("" + demoSimpleVO.getId()), variables));
        DemoSimplePayload updatePayLoad = new DemoSimplePayload();
        updatePayLoad.setProcInstId(processInfo.getProcInstId());
        updatePayLoad.setId(demoSimpleVO.getId());
        updatePayLoad.setProcInstStatus(processInfo.getProcInstStatus());
        updatePayLoad.setSubmitTime(LocalDateTime.now());
        updatePayLoad.setObjectStatus("APPROVING");
        this.transactionUtilService.executeWithRunnable(() -> this.dao.updateByKeyDynamic(updatePayLoad));
    }

    public DemoSimpleServiceImpl(DemoSimpleDAO dao, TransactionUtilService transactionUtilService, TransactionTemplate transactionTemplate, CacheUtil cacheUtil, WorkflowUtil workflowUtil) {
        this.dao = dao;
        this.transactionUtilService = transactionUtilService;
        this.transactionTemplate = transactionTemplate;
        this.cacheUtil = cacheUtil;
        this.workflowUtil = workflowUtil;
    }
}

