/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.log.aspect;

import com.el.coordinator.core.common.exception.ThrowableUtil;
import com.elitesland.tw.tw5.server.common.NotOnlineException;
import com.elitesland.tw.tw5.server.common.StringUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.RequestHolder;
import com.elitesland.tw.tw5.server.log.entity.LogDO;
import com.elitesland.tw.tw5.server.log.service.LogService;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import java.time.LocalDateTime;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class LogAspect {
    private static final Logger log = LoggerFactory.getLogger(LogAspect.class);
    private final LogService logService;

    public LogAspect(LogService logService) {
        this.logService = logService;
    }

    @Pointcut(value="execution(public * com.elitesland.tw.tw5crm.server..*.*Controller.*(..))")
    public void logPointcut() {
    }

    @Around(value="logPointcut()")
    public Object logAround(ProceedingJoinPoint joinPoint) throws Throwable {
        Object result = joinPoint.proceed();
        return result;
    }

    @AfterThrowing(pointcut="logPointcut()", throwing="e")
    public void logAfterThrowing(JoinPoint joinPoint, Throwable e) {
        try {
            LogDO log = new LogDO("ERROR", 0L);
            if (e instanceof TwException || e instanceof NotOnlineException) {
                return;
            }
            String stackTrace = ThrowableUtil.getStackTrace((Throwable)e);
            log.setExceptionDetail(stackTrace.getBytes());
            HttpServletRequest request = RequestHolder.getHttpServletRequest();
            log.setCreator(this.getLoginUserName());
            log.setCreateUserId(this.getLoginUserId());
            log.setCreateTime(LocalDateTime.now());
            log.setBrowser(StringUtil.getBrowser(request));
            log.setRequestIp(StringUtil.getIp(request));
            this.logService.save((ProceedingJoinPoint)joinPoint, log);
        }
        catch (Exception ex) {
            log.error("\u9519\u8bef\u65e5\u5fd7\u8bb0\u5f55\u5f02\u5e38", (Throwable)ex);
        }
    }

    public String getLoginUserName() {
        try {
            return GlobalUtil.getLoginUserName();
        }
        catch (Exception e) {
            return "";
        }
    }

    public Long getLoginUserId() {
        try {
            return GlobalUtil.getLoginUserId();
        }
        catch (Exception e) {
            return 0L;
        }
    }
}

