/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.ab.dao;

import com.elitesland.tw.tw5.api.prd.ab.vo.PrdAbInvoiceVO;
import com.elitesland.tw.tw5.server.prd.ab.entity.PrdAbInvoiceDO;
import com.elitesland.tw.tw5.server.prd.ab.entity.QPrdAbInvoiceDO;
import com.elitesland.tw.tw5.server.prd.ab.repo.PrdAbInvoiceRepo;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmCustomerDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPADeleteClause;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository
public class PrdAbInvoiceDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PrdAbInvoiceRepo repo;
    private final QPrdAbInvoiceDO qdo = QPrdAbInvoiceDO.prdAbInvoiceDO;
    private final QCrmCustomerDO qdoCustomer = QCrmCustomerDO.crmCustomerDO;

    public Long queryIdByBookId(Long bookId) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select(this.qdoCustomer.id).from((EntityPath)this.qdoCustomer);
        jpaQuery.where((Predicate)this.qdoCustomer.bookId.eq((Object)bookId));
        jpaQuery.where((Predicate)this.qdoCustomer.deleteFlag.eq((Object)0));
        return (Long)jpaQuery.fetchFirst();
    }

    public Long queryTW4IdById(Long id) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select(this.qdo.invoiceIdV4).from((EntityPath)this.qdo);
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (Long)jpaQuery.fetchFirst();
    }

    public List<Long> queryTW4IdsByIds(List<Long> ids) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select(this.qdo.invoiceIdV4).from((EntityPath)this.qdo);
        jpaQuery.where((Predicate)this.qdo.id.in(ids));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public PrdAbInvoiceDO save(PrdAbInvoiceDO ado) {
        return (PrdAbInvoiceDO)((Object)this.repo.save((Object)ado));
    }

    private JPAQuery<PrdAbInvoiceVO> getJpaQuerySelect() {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PrdAbInvoiceVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.bookId, this.qdo.invoiceMessage, this.qdo.invoiceTitle, this.qdo.taxRete, this.qdo.taxNo, this.qdo.invoiceType, this.qdo.invoiceAddress, this.qdo.invoicePhone, this.qdo.depositBank, this.qdo.invoiceAccount, this.qdo.currency, this.qdo.remark, this.qdo.defaultFlag})).from((EntityPath)this.qdo);
        return jpaQuery;
    }

    public List<PrdAbInvoiceVO> queryList(Long bookId) {
        JPAQuery<PrdAbInvoiceVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.bookId.eq((Object)bookId));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        return update.execute();
    }

    public long delete(List<Long> keys) {
        JPADeleteClause delete = this.jpaQueryFactory.delete((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.in(keys)});
        return delete.execute();
    }

    public PrdAbInvoiceDAO(JPAQueryFactory jpaQueryFactory, PrdAbInvoiceRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

