/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.ab.service;

import com.elitesland.tw.tw5.api.prd.ab.payload.PrdAbAccountPayload;
import com.elitesland.tw.tw5.api.prd.ab.service.PrdAbAccountService;
import com.elitesland.tw.tw5.api.prd.ab.vo.PrdAbAccountVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.service.TransferUtilServiceImpl;
import com.elitesland.tw.tw5.server.prd.ab.convert.PrdAbAccountConvert;
import com.elitesland.tw.tw5.server.prd.ab.dao.PrdAbAccountDAO;
import com.elitesland.tw.tw5.server.prd.ab.entity.PrdAbAccountDO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemLogEnum;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PrdAbAccountServiceImpl
implements PrdAbAccountService {
    private static final Logger log = LoggerFactory.getLogger(PrdAbAccountServiceImpl.class);
    private final CacheUtil cacheUtil;
    private final PrdAbAccountDAO dao;
    private final PrdSystemLogService logService;
    private final TransferUtilServiceImpl transferUtilService;
    private final HttpUtil httpUtil;
    @Value(value="${tw4.account.operation}")
    private String account_operation;
    @Value(value="${tw4.account.del}")
    private String account_del;

    @Transactional
    public PrdAbAccountVO save(PrdAbAccountPayload payload) {
        long accountIdV4 = 0L;
        PrdAbAccountDO contactsDO = PrdAbAccountConvert.INSTANCE.toDo(payload);
        contactsDO.setAccountIdV4(accountIdV4);
        contactsDO = this.dao.save(contactsDO);
        this.saveBaseLog(payload.getBookId(), payload.getObjectType(), PrdSystemLogEnum.CREATE.getDesc());
        return PrdAbAccountConvert.INSTANCE.toVo(contactsDO);
    }

    void saveBaseLog(Long bookId, String objectType, String logType) {
        Long customerId = this.dao.queryIdByBookId(bookId);
        this.logService.saveNewLog(customerId, objectType, logType + "\u94f6\u884c\u8d26\u6237");
    }

    @Transactional
    public boolean delete(Long bookId, String objectType, List<Long> keys) {
        this.dao.delete(keys);
        this.saveBaseLog(bookId, objectType, PrdSystemLogEnum.DELETE.getDesc());
        return true;
    }

    @Transactional
    public boolean update(PrdAbAccountPayload payload) {
        PrdAbAccountDO contactsDO = PrdAbAccountConvert.INSTANCE.toDo(payload);
        this.dao.save(contactsDO);
        this.saveBaseLog(payload.getBookId(), payload.getObjectType(), PrdSystemLogEnum.UPDATE.getDesc());
        return true;
    }

    public List<PrdAbAccountVO> queryList(Long bookId) {
        List<PrdAbAccountVO> contactsVOS = this.dao.queryList(bookId);
        contactsVOS.forEach(contactsVO -> this.transferSystemSelection((PrdAbAccountVO)contactsVO));
        return contactsVOS;
    }

    public List<PrdAbAccountVO> queryList(Long bookId, String accountType, Boolean defaultFlag, String accountNo) {
        List<PrdAbAccountVO> contactsVOS = this.dao.queryList(bookId, accountType, defaultFlag, accountNo);
        contactsVOS.forEach(contactsVO -> this.transferSystemSelection((PrdAbAccountVO)contactsVO));
        return contactsVOS;
    }

    void transferSystemSelection(PrdAbAccountVO vo) {
        vo.setAccountTypeName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.AbAccount_type.getCode(), vo.getAccountType()));
        vo.setCurrencyName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.SystemCurrCode.getCode(), vo.getCurrency()));
    }

    public PrdAbAccountServiceImpl(CacheUtil cacheUtil, PrdAbAccountDAO dao, PrdSystemLogService logService, TransferUtilServiceImpl transferUtilService, HttpUtil httpUtil) {
        this.cacheUtil = cacheUtil;
        this.dao = dao;
        this.logService = logService;
        this.transferUtilService = transferUtilService;
        this.httpUtil = httpUtil;
    }
}

