/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.ab.service;

import com.elitesland.tw.tw5.api.prd.ab.payload.PrdAbInvoicePayload;
import com.elitesland.tw.tw5.api.prd.ab.service.PrdAbInvoiceService;
import com.elitesland.tw.tw5.api.prd.ab.vo.PrdAbInvoiceVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.service.TransferUtilServiceImpl;
import com.elitesland.tw.tw5.server.prd.ab.convert.PrdAbInvoiceConvert;
import com.elitesland.tw.tw5.server.prd.ab.dao.PrdAbInvoiceDAO;
import com.elitesland.tw.tw5.server.prd.ab.entity.PrdAbInvoiceDO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemLogEnum;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PrdAbInvoiceServiceImpl
implements PrdAbInvoiceService {
    private static final Logger log = LoggerFactory.getLogger(PrdAbInvoiceServiceImpl.class);
    private final CacheUtil cacheUtil;
    private final PrdAbInvoiceDAO dao;
    private final PrdSystemLogService logService;
    private final TransferUtilServiceImpl transferUtilService;
    private final HttpUtil httpUtil;
    @Value(value="${tw4.invoice.operation}")
    private String invoice_operation;
    @Value(value="${tw4.invoice.del}")
    private String invoice_del;

    @Transactional
    public PrdAbInvoiceVO save(PrdAbInvoicePayload payload) {
        PrdAbInvoiceDO contactsDO = PrdAbInvoiceConvert.INSTANCE.toDo(payload);
        contactsDO = this.dao.save(contactsDO);
        this.saveBaseLog(payload.getBookId(), payload.getObjectType(), PrdSystemLogEnum.CREATE.getDesc());
        return PrdAbInvoiceConvert.INSTANCE.toVo(contactsDO);
    }

    void saveBaseLog(Long bookId, String objectType, String logType) {
        Long customerId = this.dao.queryIdByBookId(bookId);
        this.logService.saveNewLog(customerId, objectType, logType + "\u5f00\u7968\u6570\u636e");
    }

    @Transactional
    public boolean delete(Long bookId, String objectType, List<Long> keys) {
        this.dao.delete(keys);
        this.saveBaseLog(bookId, objectType, PrdSystemLogEnum.DELETE.getDesc());
        return true;
    }

    @Transactional
    public boolean update(PrdAbInvoicePayload payload) {
        PrdAbInvoiceDO contactsDO = PrdAbInvoiceConvert.INSTANCE.toDo(payload);
        this.dao.save(contactsDO);
        this.saveBaseLog(payload.getBookId(), payload.getObjectType(), PrdSystemLogEnum.UPDATE.getDesc());
        return true;
    }

    public List<PrdAbInvoiceVO> queryList(Long bookId) {
        List<PrdAbInvoiceVO> contactsVOS = this.dao.queryList(bookId);
        contactsVOS.forEach(contactsVO -> this.transferSystemSelection((PrdAbInvoiceVO)contactsVO));
        return contactsVOS;
    }

    void transferSystemSelection(PrdAbInvoiceVO vo) {
        vo.setTaxReteName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.AbTAX_RATE.getCode(), vo.getTaxRete()));
        vo.setInvoiceTypeName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.AbINV_TYPE.getCode(), vo.getInvoiceType()));
        vo.setCurrencyName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.SystemCurrCode.getCode(), vo.getCurrency()));
    }

    public PrdAbInvoiceServiceImpl(CacheUtil cacheUtil, PrdAbInvoiceDAO dao, PrdSystemLogService logService, TransferUtilServiceImpl transferUtilService, HttpUtil httpUtil) {
        this.cacheUtil = cacheUtil;
        this.dao = dao;
        this.logService = logService;
        this.transferUtilService = transferUtilService;
        this.httpUtil = httpUtil;
    }
}

