/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.controller;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmCustomerPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmCustomerQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmCustomerService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmFollowService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerSimpleVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerVO;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemLogQuery;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5ba2\u6237\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/api/crm"})
public class CrmCustomerController {
    private static final Logger log = LoggerFactory.getLogger(CrmCustomerController.class);
    private final CrmCustomerService service;
    private final CrmFollowService followService;

    @PostMapping(value={"/customer/insert"})
    public TwOutputUtil insert(CrmCustomerPayload payload) {
        CrmCustomerVO vo = this.service.insert(payload);
        return TwOutputUtil.ok(vo);
    }

    @PutMapping(value={"/customer/update"})
    public TwOutputUtil update(CrmCustomerPayload payload) {
        this.service.update(payload);
        return TwOutputUtil.ok();
    }

    @PutMapping(value={"/customer/updateProvinceCityDistrict"})
    public TwOutputUtil updateProvinceCityDistrict(CrmCustomerPayload payload) {
        this.service.updateProvinceCityDistrict(payload);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/customer/paging"})
    public TwOutputUtil paging(CrmCustomerQuery query) {
        return TwOutputUtil.ok(this.service.paging(query));
    }

    @GetMapping(value={"/customer/queryByKey/{id}"})
    public TwOutputUtil queryByKey(@PathVariable Long id) {
        CrmCustomerVO vo = this.service.queryDetail(id);
        return TwOutputUtil.ok(vo);
    }

    @GetMapping(value={"/customer/querySimpleByKey/{id}"})
    @ApiOperation(value="\u5ba2\u6237\u8be6\u60c5\u7b80\u7248\u67e5\u8be2")
    public TwOutputUtil querySimpleByKey(@PathVariable Long id) {
        CrmCustomerSimpleVO vo = this.service.querySimpleByKey(id);
        return TwOutputUtil.ok(vo);
    }

    @GetMapping(value={"/customer/queryByBookId"})
    public TwOutputUtil queryByBookId(Long bookId) {
        CrmCustomerVO vo = this.service.queryDetailByBookId(bookId);
        return TwOutputUtil.ok(vo);
    }

    @GetMapping(value={"/act/updateStatus"})
    public TwOutputUtil updateStatus(Long key, String customerStatus) {
        this.service.updateStatus(key, customerStatus);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/customer/queryList"})
    public TwOutputUtil queryList() {
        return TwOutputUtil.ok(this.service.queryList());
    }

    @GetMapping(value={"/customer/queryLogList"})
    public TwOutputUtil queryLogList(PrdSystemLogQuery query) {
        return TwOutputUtil.ok(this.service.queryLogList(query));
    }

    @GetMapping(value={"/customer/follow/list/{customerId}"})
    public TwOutputUtil queryLogList(@PathVariable Long customerId, Boolean withActivityFollows) {
        return TwOutputUtil.ok(this.service.queryFollowList(customerId, withActivityFollows));
    }

    @ApiOperation(value="\u6279\u91cf\u5bfc\u51faexcel")
    @GetMapping(value={"/customer/batchExport"})
    public void batchExport(HttpServletResponse response, CrmCustomerQuery query) {
        this.service.downloadBatch(response, query);
    }

    @GetMapping(value={"/customer/checkCustNameUnique"})
    public TwOutputUtil checkCustNameUnique(String custName) {
        return TwOutputUtil.ok(this.service.checkCustNameUnique(custName));
    }

    @GetMapping(value={"/customer/updateLongitudeLatitude"})
    @ApiOperation(value="\u540c\u6b65\u7ecf\u7eac\u5ea6")
    public TwOutputUtil updateLongitudeLatitude() {
        this.service.updateLongitudeLatitude();
        return TwOutputUtil.ok();
    }

    public CrmCustomerController(CrmCustomerService service, CrmFollowService followService) {
        this.service = service;
        this.followService = followService;
    }
}

