/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.controller;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.elitescloud.cloudt.common.base.BaseViewModel;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmCustomerOperationExcelExport;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmCustomerOperationPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmCustomerOperationBusinessQuery;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmCustomerOperationQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmCustomerOperationService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerDataVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerOperationVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.excel.ExcelUtil;
import com.elitesland.tw.tw5.server.log.constant.ApiRequestLogTypeEnum;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmCustomerOperationConvert;
import com.elitesland.tw.tw5.server.prd.qixin.service.QiXinService;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.tw.tw5.server.prd.tianyancha.service.TianYanChaService;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.TaskExecutor;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/crm"})
public class CrmCustomerOperationController {
    private static final Logger log = LoggerFactory.getLogger(CrmCustomerOperationController.class);
    private final CrmCustomerOperationService service;
    private final TianYanChaService tianYanChaService;
    private final QiXinService qiXinService;
    private final PrdSystemRoleDAO systemRoleDAO;
    private final UdcUtil udcUtil;
    private final TaskExecutor taskExecutor;

    @PostMapping(value={"/customerOperation"})
    public TwOutputUtil insert(@RequestBody CrmCustomerOperationPayload payload) {
        return TwOutputUtil.ok(this.service.insert(payload));
    }

    @PostMapping(value={"/customerOperation/excelImport"}, consumes={"multipart/form-data"})
    public TwOutputUtil excelImport(MultipartFile file, Boolean force, HttpServletResponse response) throws IOException {
        Map resultMap = this.service.excelImport(file, force, response);
        return TwOutputUtil.ok(resultMap);
    }

    @GetMapping(value={"/customerOperation/excelExport"})
    @UdcNameClass
    public void excelExport(CrmCustomerOperationQuery query, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String sheetName = "\u5ba2\u6237\u7ecf\u8425";
        OrderItem orderItem = OrderItem.asc((String)"createTime");
        query.defaultOrder(orderItem);
        List<CrmCustomerOperationVO> vos = this.queryListCommon(query);
        List resultList = CrmCustomerOperationConvert.INSTANCE.voListVoExcelExport(vos);
        resultList = this.udcUtil.translateList(resultList);
        String fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
        ExcelWriterSheetBuilder sheet = ((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), CrmCustomerOperationVO.class).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).sheet(sheetName);
        ExcelUtil.excelHelper(sheet, CrmCustomerOperationExcelExport.class, null);
        sheet.doWrite(resultList);
    }

    @PutMapping(value={"/customerOperation"})
    public TwOutputUtil update(CrmCustomerOperationPayload payload) {
        return TwOutputUtil.ok(this.service.update(payload));
    }

    @GetMapping(value={"/customerOperation/updateCustOperStatus"})
    public TwOutputUtil updateCustOperStatus(Long key, String custOperStatus) {
        this.service.updateCustOperStatus(key, custOperStatus);
        return TwOutputUtil.ok();
    }

    @PutMapping(value={"/customerOperation/relationCustomer"})
    public TwOutputUtil relationCustomer(CrmCustomerOperationPayload payload) {
        this.service.relationCustomer(payload);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/customerOperation/{key}"})
    @UdcNameClass
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        CrmCustomerOperationVO prdFileVO = this.service.queryByKey(key);
        return TwOutputUtil.ok(prdFileVO);
    }

    @GetMapping(value={"/customerOperation/checkCustNameUnique"})
    public TwOutputUtil checkCustNameUnique(String custName) {
        return TwOutputUtil.ok(this.service.checkCustNameUnique(custName));
    }

    @GetMapping(value={"/customerOperation/log/list/{key}"})
    @UdcNameClass
    public TwOutputUtil logList(@PathVariable Long key) {
        List prdSystemLogVOS = this.service.queryLogList(key);
        return TwOutputUtil.ok(prdSystemLogVOS);
    }

    @GetMapping(value={"/customerOperation/paging"})
    @UdcNameClass
    public TwOutputUtil paging(CrmCustomerOperationQuery query) {
        List<Long> userIdsByRole;
        Long loginUserId = GlobalUtil.getLoginUserId();
        query.setUserId(loginUserId);
        boolean isSystemAdmin = GlobalUtil.getLoginGeneralUser().isSystemAdmin();
        PagingVO paging = isSystemAdmin ? this.service.paging(query) : (!CollectionUtils.isEmpty(userIdsByRole = this.systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.CUST_OPER_MANAGER.getCode()))) && userIdsByRole.contains(loginUserId) ? this.service.paging(query) : this.service.pagingDataFilter(query));
        return TwOutputUtil.ok(paging);
    }

    @GetMapping(value={"/customerOperation/list"})
    @UdcNameClass
    public TwOutputUtil queryList(CrmCustomerOperationQuery query) {
        List<CrmCustomerOperationVO> vos = this.queryListCommon(query);
        return TwOutputUtil.ok(vos);
    }

    private List<CrmCustomerOperationVO> queryListCommon(CrmCustomerOperationQuery query) {
        List<Long> userIdsByRole;
        String idListStr = query.getIdListStr();
        if (StringUtils.hasText((String)idListStr)) {
            String[] split = idListStr.split(",");
            ArrayList<Long> idList = new ArrayList<Long>();
            for (String s : split) {
                idList.add(Long.valueOf(s));
            }
            query.setIdList(idList);
        }
        Long loginUserId = GlobalUtil.getLoginUserId();
        query.setUserId(loginUserId);
        boolean isSystemAdmin = GlobalUtil.getLoginGeneralUser().isSystemAdmin();
        List vos = isSystemAdmin ? this.service.queryList(query) : (!CollectionUtils.isEmpty(userIdsByRole = this.systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.CUST_OPER_MANAGER.getCode()))) && userIdsByRole.contains(loginUserId) ? this.service.queryList(query) : this.service.queryListDataFilter(query));
        if (null != query.getTreeSearch() && query.getTreeSearch().booleanValue() && !CollectionUtils.isEmpty((Collection)vos)) {
            List<CrmCustomerOperationVO> collection = this.treeDataSearch(vos);
            if (!CollectionUtils.isEmpty(collection)) {
                vos.addAll(collection);
            }
            vos = vos.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<CrmCustomerOperationVO>(Comparator.comparing(BaseViewModel::getId))), ArrayList::new));
        }
        return vos;
    }

    private List<CrmCustomerOperationVO> treeDataSearch(List<CrmCustomerOperationVO> vos) {
        ArrayList<CrmCustomerOperationVO> result = new ArrayList<CrmCustomerOperationVO>();
        if (!CollectionUtils.isEmpty(vos)) {
            vos.forEach(crmCustomerOperationVO -> {
                Long parentId = crmCustomerOperationVO.getParentId();
                if (parentId != null) {
                    CrmCustomerOperationVO operationVO = this.service.queryByKey(parentId);
                    result.add(operationVO);
                }
            });
            if (!CollectionUtils.isEmpty(this.treeDataSearch(result))) {
                result.addAll(this.treeDataSearch(result));
            }
        }
        return result;
    }

    @GetMapping(value={"/customerOperation/select/list"})
    public TwOutputUtil selectList(CrmCustomerOperationQuery query) {
        List vos = this.service.selectList(query);
        return TwOutputUtil.ok(vos);
    }

    @DeleteMapping(value={"/customerOperation/deleteSoft"})
    public TwOutputUtil deleteSoft(Long[] keys) {
        this.service.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/queryOperateFollowList/{operId}"})
    public TwOutputUtil queryOperateFollowList(@PathVariable Long operId) {
        List vos = this.service.queryOperateFollowList(operId);
        return TwOutputUtil.ok(vos);
    }

    @GetMapping(value={"/queryBusinessFollowPaging/paging"})
    @UdcNameClass
    public TwOutputUtil queryBusinessFollowPaging(CrmCustomerOperationBusinessQuery query) {
        Object paging = this.service.queryBusinessFollowPaging(query);
        return TwOutputUtil.ok(paging);
    }

    @GetMapping(value={"/queryCustomerByOperId/{operId}"})
    public TwOutputUtil queryCustomerByOperId(@PathVariable Long operId) {
        CrmCustomerDataVO customerDataVO = this.service.queryCustomerByOperId(operId);
        return TwOutputUtil.ok(customerDataVO);
    }

    @GetMapping(value={"/queryCustomerView/{operId}"})
    public TwOutputUtil queryCustomerView(@PathVariable Long operId) {
        Object view = this.service.queryCustomerView(operId);
        return TwOutputUtil.ok(view);
    }

    @GetMapping(value={"/customerOperation/search"})
    @Deprecated
    public TwOutputUtil search(String word, Integer pageSize, Integer pageNum, String type) {
        String result = "";
        if (!StringUtils.hasText((String)type)) {
            type = ApiRequestLogTypeEnum.QXB.getCode();
        }
        if (type.equals(ApiRequestLogTypeEnum.QXB.getCode())) {
            result = this.qiXinService.search(null, null, word, "" + pageNum);
        } else if (type.equals(ApiRequestLogTypeEnum.TYC.getCode())) {
            result = this.tianYanChaService.search(word, pageSize, pageNum);
        }
        return TwOutputUtil.ok(result);
    }

    @GetMapping(value={"/customerOperation/searchPro"})
    @Deprecated
    public TwOutputUtil searchByQxb(String matchType, String region, String keyword, String skip) {
        String result = this.qiXinService.search(matchType, region, keyword, skip);
        return TwOutputUtil.ok(result);
    }

    @PostMapping(value={"/customerOperation/fillQxbInfo"})
    public TwOutputUtil fillQxbInfo() {
        List operVOList = this.service.findOperationEnterpriseInfoAbsent();
        if (CollectionUtils.isEmpty((Collection)operVOList)) {
            return TwOutputUtil.ok();
        }
        StringBuffer fails = new StringBuffer();
        CompletableFuture[] futures = new CompletableFuture[operVOList.size()];
        for (int i = 0; i < operVOList.size(); ++i) {
            CrmCustomerOperationVO operVO = (CrmCustomerOperationVO)operVOList.get(i);
            futures[i] = CompletableFuture.runAsync(() -> {
                try {
                    boolean success = this.service.fillQxbInfo(operVO.getCustName(), operVO.getId().longValue());
                    if (!success) {
                        fails.append(operVO.getCustName() + ";");
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    fails.append(operVO.getCustName() + ";");
                }
            }, (Executor)this.taskExecutor);
        }
        try {
            CompletableFuture.allOf(futures).get();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        if (fails.isEmpty()) {
            return TwOutputUtil.ok();
        }
        fails.setLength(fails.length() - 1);
        return TwOutputUtil.error("fail", "\u5904\u7406\u5931\u8d25\u7684\u5ba2\u6237\u7ecf\u8425\uff1a" + fails, null);
    }

    public CrmCustomerOperationController(CrmCustomerOperationService service, TianYanChaService tianYanChaService, QiXinService qiXinService, PrdSystemRoleDAO systemRoleDAO, UdcUtil udcUtil, TaskExecutor taskExecutor) {
        this.service = service;
        this.tianYanChaService = tianYanChaService;
        this.qiXinService = qiXinService;
        this.systemRoleDAO = systemRoleDAO;
        this.udcUtil = udcUtil;
        this.taskExecutor = taskExecutor;
    }
}

