/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.controller;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmFollowPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmLeadsMembersPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmLeadsPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpportunityPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmLeadsOffshoreQuery;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmLeadsQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmFollowService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmLeadsService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmLeadsVO;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemLogQuery;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.CrmFollowObjectEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemLogEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(value="\u7ebf\u7d22\u7ba1\u7406")
@RestController
@RequestMapping(value={"/api/crm"})
public class CrmLeadsController {
    private static final Logger log = LoggerFactory.getLogger(CrmLeadsController.class);
    private final CrmLeadsService service;
    private final CrmFollowService followService;

    @PostMapping(value={"/leads/saveOne"})
    public TwOutputUtil insert(@RequestBody CrmLeadsPayload payload) {
        CrmLeadsVO vo = this.service.saveOne(payload);
        return TwOutputUtil.ok(vo);
    }

    @PostMapping(value={"/leads/distribute"})
    public TwOutputUtil distributeLeads(@RequestBody CrmLeadsPayload payload) {
        return TwOutputUtil.ok(this.service.distributeLeads(payload));
    }

    @PostMapping(value={"/leads/batchDistribute"})
    public TwOutputUtil distributeLeads(@RequestBody List<CrmLeadsPayload> payloads) {
        this.service.batchDistributeLeads(payloads);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/leads/receive/{id}"})
    public TwOutputUtil receiveLeads(@PathVariable Long id) {
        this.service.receiveLeads(id);
        return TwOutputUtil.ok();
    }

    @PostMapping(value={"/leads/withdraw"})
    public TwOutputUtil withdrawLeads(@RequestBody CrmLeadsPayload payload) {
        this.service.withdrawLeads(payload);
        return TwOutputUtil.ok();
    }

    @PostMapping(value={"/leads/back"})
    public TwOutputUtil backLeads(@RequestBody CrmLeadsPayload payload) {
        this.service.backLeads(payload);
        return TwOutputUtil.ok();
    }

    @PostMapping(value={"/leads/transfer/user"})
    public TwOutputUtil transferLeadsUser(@RequestBody CrmLeadsPayload payload) {
        this.service.transferLeadsUser(payload);
        return TwOutputUtil.ok();
    }

    @PostMapping(value={"/leads/transfer/offshore"})
    public TwOutputUtil transferLeadsOffshore(@RequestBody CrmLeadsPayload payload) {
        this.service.transferLeadsOffshore(payload);
        return TwOutputUtil.ok();
    }

    @PostMapping(value={"/leads/batchTransfer/offshore"})
    public TwOutputUtil transferLeadsOffshoreBatch(@RequestBody List<CrmLeadsPayload> payloads) {
        this.service.transferLeadsOffshoreBatch(payloads);
        return TwOutputUtil.ok();
    }

    @PostMapping(value={"/leads/remark"})
    public TwOutputUtil remarkLeads(@RequestBody CrmLeadsPayload payload) {
        this.service.remarkLeads(payload);
        return TwOutputUtil.ok();
    }

    @PostMapping(value={"/leads/batchRemark"})
    public TwOutputUtil batchRemarkLeads(@RequestBody List<CrmLeadsPayload> payloads) {
        this.service.batchRemarkLeads(payloads);
        return TwOutputUtil.ok();
    }

    @PostMapping(value={"/leads/toOppo/{id}"})
    public TwOutputUtil toOpportunity(@PathVariable Long id, @RequestBody CrmOpportunityPayload opportunityPayload) {
        Long opportunityId = this.service.toOpportunity(id, opportunityPayload);
        return TwOutputUtil.ok(opportunityId);
    }

    @GetMapping(value={"/leads/bindCustomer/{id}"})
    public TwOutputUtil bindCustomer(@PathVariable Long id) {
        Map result = new HashMap();
        try {
            result = this.service.bindCustomer(id);
        }
        catch (Exception e) {
            this.service.deleteSoft(Collections.singletonList(id));
            return TwOutputUtil.error("", "\u7ed1\u5b9a\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01", "");
        }
        return TwOutputUtil.ok(result);
    }

    @GetMapping(value={"/leads/bindCustomerBatch"})
    public TwOutputUtil bindCustomer(Long[] ids) {
        this.service.bindCustomerBatch(ids);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/leads/bindCustomerNotBind"})
    public TwOutputUtil bindCustomerNotBind() {
        this.service.bindCustomerNotBind();
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/leads/bindCustomers"})
    public TwOutputUtil bindCustomers() {
        return TwOutputUtil.ok(this.service.bindCustomers());
    }

    @ApiOperation(value="\u83b7\u53d6offshore\u8868\u7684\u5b57\u6bb5\u53ca\u540d\u79f0")
    @GetMapping(value={"/leads/fields"})
    public TwOutputUtil queryFields() {
        Map fields = this.service.queryFields();
        return TwOutputUtil.ok(fields);
    }

    @PostMapping(value={"/leads/dynamicUpdate"})
    public TwOutputUtil dynamicUpdate(@RequestBody CrmLeadsPayload payload) {
        this.service.dynamicUpdate(payload, PrdSystemLogEnum.UPDATE.getDesc());
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/leads/batchAddTags"})
    public TwOutputUtil batchAddTags(Long[] keys, String leadsTagIds) {
        this.service.batchAddTags(keys, leadsTagIds);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/leads/batchDelTags"})
    public TwOutputUtil batchDelTags(Long[] keys, String leadsTagIds) {
        this.service.batchDelTags(keys, leadsTagIds);
        return TwOutputUtil.ok();
    }

    @PostMapping(value={"/leads/updateMembers"})
    public TwOutputUtil updateMembers(@RequestBody List<CrmLeadsMembersPayload> members) {
        this.service.updateMembers(members);
        return TwOutputUtil.ok();
    }

    @PostMapping(value={"/leads/updateFollow"})
    public TwOutputUtil updateFollow(@RequestBody CrmFollowPayload payload) {
        this.service.updateFollow(payload);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/leads/paging/receive"})
    public TwOutputUtil queryListNotReceivedLeads(CrmLeadsOffshoreQuery query) {
        return TwOutputUtil.ok(this.service.queryListNotReceivedLeadsByUserId(query));
    }

    @GetMapping(value={"/leads/paging/distribute"})
    public TwOutputUtil queryListNotDistributedLeadsByUserId(CrmLeadsOffshoreQuery query) {
        return TwOutputUtil.ok(this.service.queryListNotDistributedLeadsByUserId(query));
    }

    @GetMapping(value={"/leads/page/market"})
    public TwOutputUtil pageListMarket(CrmLeadsQuery query) {
        return TwOutputUtil.ok(this.service.pageListMarketLeads(query));
    }

    @GetMapping(value={"/leads/list/market"})
    public TwOutputUtil queryListMarket(CrmLeadsQuery query) {
        return TwOutputUtil.ok(this.service.queryListMarketLeads(query));
    }

    @GetMapping(value={"/leads/list/offshore"})
    public TwOutputUtil queryListOffshore(CrmLeadsOffshoreQuery query) {
        return TwOutputUtil.ok(this.service.queryListOffshoreLeads(query));
    }

    @GetMapping(value={"/leads/paging/offshore"})
    public TwOutputUtil pagingOffshore(CrmLeadsOffshoreQuery query) {
        return TwOutputUtil.ok(this.service.pagingOffshoreLeads(query));
    }

    @GetMapping(value={"/leads/paging/offshore/filter"})
    public TwOutputUtil getOffshoreList(CrmLeadsOffshoreQuery query) {
        return TwOutputUtil.ok(this.service.getOffshoreList(query));
    }

    @GetMapping(value={"/leads/isOffshoreAdmin"})
    public TwOutputUtil isOffshoreAdmin() {
        return TwOutputUtil.ok(this.service.isOffshoreAdmin());
    }

    @GetMapping(value={"/leads/list"})
    public TwOutputUtil queryList(CrmLeadsOffshoreQuery query) {
        return TwOutputUtil.ok(this.service.queryList(query));
    }

    @GetMapping(value={"/leads/paging"})
    public TwOutputUtil paging(CrmLeadsQuery query) {
        return TwOutputUtil.ok(this.service.paging(query));
    }

    @GetMapping(value={"/leads/paging/personal"})
    public TwOutputUtil pagingPersonal(CrmLeadsQuery query) {
        return TwOutputUtil.ok(this.service.pagingPersonalLeads(query));
    }

    @GetMapping(value={"/leads/members/list/{leadsId}"})
    public TwOutputUtil queryMembersList(@PathVariable Long leadsId) {
        return TwOutputUtil.ok(this.service.queryMembersList(leadsId));
    }

    @GetMapping(value={"/leads/log/list/{leadsId}"})
    public TwOutputUtil queryLogList(@PathVariable Long leadsId, String stage) {
        return TwOutputUtil.ok(this.service.queryLogList(leadsId, stage));
    }

    @GetMapping(value={"/leads/log/paging"})
    public TwOutputUtil queryLogList(PrdSystemLogQuery query) {
        return TwOutputUtil.ok(this.service.pageLog(query));
    }

    @GetMapping(value={"/leads/follow/list/{leadsId}"})
    public TwOutputUtil queryFollowList(@PathVariable Long leadsId) {
        return TwOutputUtil.ok(this.followService.queryFollowList(leadsId, CrmFollowObjectEnum.Leads.name()));
    }

    @GetMapping(value={"/leads/detail"})
    public TwOutputUtil queryDetail(@RequestParam Long offshoreId, @RequestParam Long id) {
        CrmLeadsVO vo = this.service.queryDetail(offshoreId, id);
        return TwOutputUtil.ok(vo);
    }

    @DeleteMapping(value={"/leads/delete"})
    public TwOutputUtil delete(Long[] keys) {
        this.service.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @PostMapping(value={"/leads/close"})
    public TwOutputUtil close(@RequestBody CrmLeadsPayload payload) {
        this.service.closeLeads(payload);
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="\u6279\u91cf\u5bfc\u51fa\u8fd1\u6d77\u7ebf\u7d22excel")
    @GetMapping(value={"/leads/batchExport/offshore"})
    public void batchExport(HttpServletResponse response, CrmLeadsOffshoreQuery query) {
        this.service.downloadBatchOffshore(response, query);
    }

    @ApiOperation(value="\u6279\u91cf\u5bfc\u51fa\u7ebf\u7d22")
    @GetMapping(value={"/leads/batchExport"})
    public void batchExport(HttpServletResponse response, CrmLeadsQuery query) {
        this.service.downloadBatch(response, query);
    }

    @ApiOperation(value="\u6279\u91cf\u5bfc\u5165excel")
    @PostMapping(value={"/leads/batchImport"}, consumes={"multipart/form-data"})
    @Transactional
    public TwOutputUtil batchImport(HttpServletResponse response, MultipartFile file, Boolean force) {
        Map resultMap = this.service.importBatch(response, file, force);
        if (resultMap.get("ok").equals("ok")) {
            return TwOutputUtil.ok(resultMap);
        }
        if (resultMap.get("ok").equals("warn")) {
            return TwOutputUtil.warn("", "", resultMap);
        }
        return TwOutputUtil.error("", "", resultMap);
    }

    @GetMapping(value={"/leads/test"})
    public TwOutputUtil test(Integer nnum) {
        this.service.leadsNotReceiveRemind(nnum.intValue());
        return TwOutputUtil.ok();
    }

    public CrmLeadsController(CrmLeadsService service, CrmFollowService followService) {
        this.service = service;
        this.followService = followService;
    }
}

