/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.controller;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpportunityCompetitorPayload;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityCompetitorService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityCompetitorVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/crm"})
public class CrmOpportunityCompetitorController {
    private static final Logger log = LoggerFactory.getLogger(CrmOpportunityCompetitorController.class);
    private final CrmOpportunityCompetitorService service;

    @PostMapping(value={"/oppo/competitor/insert"})
    public TwOutputUtil insert(CrmOpportunityCompetitorPayload payload) {
        CrmOpportunityCompetitorVO vo = this.service.insert(payload);
        return TwOutputUtil.ok(vo);
    }

    @PutMapping(value={"/oppo/competitor/update"})
    public TwOutputUtil update(CrmOpportunityCompetitorPayload payload) {
        this.service.update(payload);
        return TwOutputUtil.ok();
    }

    @PostMapping(value={"/oppo/competitor/updateFromV4"})
    public TwOutputUtil updateFromV4(CrmOpportunityCompetitorPayload payload) {
        this.service.update(payload);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/oppo/competitor/queryList"})
    public TwOutputUtil queryList(Long oppoId) {
        return TwOutputUtil.ok(this.service.queryList(oppoId));
    }

    @DeleteMapping(value={"/oppo/competitor/deleteSoft"})
    public TwOutputUtil deleteSoft(Long oppoId, Long[] keys) {
        this.service.deleteSoft(oppoId, Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    public CrmOpportunityCompetitorController(CrmOpportunityCompetitorService service) {
        this.service = service;
    }
}

