/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.controller;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmFollowPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpportunityPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpportunityQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityVO;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemLogQuery;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/crm"})
public class CrmOpportunityController {
    private static final Logger log = LoggerFactory.getLogger(CrmOpportunityController.class);
    private final CrmOpportunityService service;

    @PostMapping(value={"/oppo/insert"})
    public TwOutputUtil insert(CrmOpportunityPayload payload) {
        CrmOpportunityVO vo = this.service.insert(payload);
        return TwOutputUtil.ok(vo);
    }

    @PutMapping(value={"/oppo/update"})
    public TwOutputUtil update(CrmOpportunityPayload payload) {
        if (payload.getOppoIdV4() != null) {
            payload.setId(this.service.getIdByV4(payload.getOppoIdV4()));
        }
        this.service.update(payload);
        return TwOutputUtil.ok();
    }

    @PostMapping(value={"/oppo/updateFromV4"})
    public TwOutputUtil updateFromV4(CrmOpportunityPayload payload) {
        if (payload.getOppoIdV4() != null) {
            payload.setId(this.service.getIdByV4(payload.getOppoIdV4()));
        }
        this.service.update(payload);
        return TwOutputUtil.ok();
    }

    @PostMapping(value={"/oppo/toggleCheckStatus"})
    public TwOutputUtil toggleCheckStatus(@RequestBody List<Long> ids) {
        this.service.toggleCheckStatus(ids);
        return TwOutputUtil.ok();
    }

    @PostMapping(value={"/oppo/paging"})
    @UdcNameClass
    public TwOutputUtil paging(@RequestBody CrmOpportunityQuery query) {
        return TwOutputUtil.ok(this.service.paging(query));
    }

    @GetMapping(value={"/oppo/queryByKey/{id}"})
    @UdcNameClass
    public TwOutputUtil queryByKey(@PathVariable Long id) {
        CrmOpportunityVO vo = this.service.queryByKey(id);
        return TwOutputUtil.ok(vo);
    }

    @GetMapping(value={"/oppo/changeStatus/{id}"})
    public TwOutputUtil changeStatus(@PathVariable Long id, Long oppoIdV4) {
        if (oppoIdV4 != null) {
            id = this.service.getIdByV4(oppoIdV4);
        }
        this.service.changeStatus(id);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/oppo/closeOpportunity"})
    public TwOutputUtil closeOpportunity(Long key, String closeReason, String loseReson, String clsoeRemark, Long oppoIdV4) {
        if (oppoIdV4 != null) {
            key = this.service.getIdByV4(oppoIdV4);
        }
        this.service.closeOpportunity(key, closeReason, loseReson, clsoeRemark);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/oppo/addMember"})
    public TwOutputUtil addMember(Long oppoId, Long[] userIds) {
        List memberVOS = this.service.addMember(oppoId, Arrays.asList(userIds));
        return TwOutputUtil.ok(memberVOS);
    }

    @DeleteMapping(value={"/oppo/deleteMember"})
    public TwOutputUtil deleteMember(Long oppoId, Long[] keys) {
        this.service.deleteMember(oppoId, Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @PostMapping(value={"/oppo/addFollow"})
    public TwOutputUtil addFollow(CrmFollowPayload payload) {
        this.service.addFollow(payload);
        return TwOutputUtil.ok();
    }

    @PutMapping(value={"/oppo/updateFollow"})
    public TwOutputUtil updateFollow(CrmFollowPayload payload) {
        this.service.updateFollow(payload);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/oppo/queryListFollow"})
    public TwOutputUtil queryListFollow(Long objectId) {
        return TwOutputUtil.ok(this.service.queryListFollow(objectId));
    }

    @GetMapping(value={"/oppo/queryLogList"})
    public TwOutputUtil queryLogList(PrdSystemLogQuery query) {
        return TwOutputUtil.ok(this.service.queryLogList(query));
    }

    @ApiOperation(value="\u6279\u91cf\u5bfc\u51faexcel")
    @GetMapping(value={"/oppo/batchExport"})
    public void batchExport(HttpServletResponse response, CrmOpportunityQuery query) throws IOException {
        this.service.downloadBatch(response, query);
    }

    @GetMapping(value={"/oppo/bindCustomer/{id}"})
    public TwOutputUtil bindCustomer(@PathVariable Long id) {
        Map result = new HashMap();
        try {
            result = this.service.bindCustomer(id);
        }
        catch (Exception e) {
            this.service.deleteSoft(id);
            return TwOutputUtil.error("", "\u7ed1\u5b9a\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01", "");
        }
        return TwOutputUtil.ok(result);
    }

    @GetMapping(value={"/oppo/bindCustomers"})
    public TwOutputUtil bindCustomers() {
        return TwOutputUtil.ok(this.service.bindCustomers());
    }

    @GetMapping(value={"/oppo/yeedoc/getUri/{id}"})
    public TwOutputUtil yeedocGetUri(@PathVariable Long id) {
        return TwOutputUtil.ok(this.service.yeedocGetUri(id));
    }

    public CrmOpportunityController(CrmOpportunityService service) {
        this.service = service;
    }
}

