/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpportunityPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpportunityQuery;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmActProjectVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOpportunityDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmActActivityDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmLeadsDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmOpportunityDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmOpportunitySalesDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmOpportunityAnalyzeRepo;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmOpportunityCompetitorRepo;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmOpportunityPartnerRepo;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmOpportunityRepo;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmOpportunitySalesRepo;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmOpportunityStakeholderRepo;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.prd.prj.entity.QPrjProjectDO;
import com.elitesland.tw.tw5.server.prd.prj.entity.QPrjProjectMemberDO;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class CrmOpportunityDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final CrmOpportunityRepo repo;
    private final CrmOpportunitySalesRepo repoSales;
    private final CrmOpportunityStakeholderRepo repoStakeholder;
    private final CrmOpportunityPartnerRepo repoPartner;
    private final CrmOpportunityCompetitorRepo repoCompetitor;
    private final CrmOpportunityAnalyzeRepo repoAnalyze;
    private final QCrmOpportunityDO qdo = QCrmOpportunityDO.crmOpportunityDO;
    private final QPrjProjectDO qdoProject = QPrjProjectDO.prjProjectDO;
    private final QPrjProjectDO qdoProject1 = new QPrjProjectDO("qdoProject1");
    private final QPrdOrgEmployeeDO qdoEmployee = QPrdOrgEmployeeDO.prdOrgEmployeeDO;
    private final QCrmLeadsDO qdoLeads = QCrmLeadsDO.crmLeadsDO;
    private final QPrjProjectMemberDO qdoMember = QPrjProjectMemberDO.prjProjectMemberDO;
    private final QCrmActActivityDO qdoActivity = QCrmActActivityDO.crmActActivityDO;
    private final QCrmOpportunitySalesDO qdoSales = QCrmOpportunitySalesDO.crmOpportunitySalesDO;

    public CrmOpportunityDO save(CrmOpportunityDO ado) {
        return (CrmOpportunityDO)((Object)this.repo.save((Object)ado));
    }

    private JPAQuery<CrmActProjectVO> getJpaQuerySelectProject() {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(CrmActProjectVO.class, (Expression[])new Expression[]{this.qdoProject.id, this.qdoProject.projectName, this.qdoProject.projectNo, this.qdoProject.manageUserId, this.qdoProject.projectStatus, this.qdoProject.closeReason, this.qdoEmployee.employeeName.as("manageUserName"), this.qdo.codeliUserId, this.qdo.oppoIdV4, this.qdo.deliUserId, this.qdo.preSaleUserId, this.qdo.coUserId, this.qdoProject.createUserId, this.qdoProject.creator, this.qdoProject.createTime})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qdoProject)).on((Predicate)this.qdoProject.id.longValue().eq((Expression)this.qdo.projectId.longValue()))).leftJoin((EntityPath)this.qdoEmployee)).on((Predicate)this.qdoEmployee.userId.longValue().eq((Expression)this.qdoProject.manageUserId.longValue()));
        return jpaQuery;
    }

    public CrmActProjectVO queryProjectBykey(Long key) {
        JPAQuery<CrmActProjectVO> jpaQuery = this.getJpaQuerySelectProject();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)key));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        jpaQuery.where((Predicate)this.qdoProject.deleteFlag.eq((Object)0));
        return (CrmActProjectVO)jpaQuery.fetchFirst();
    }

    public List<CrmActProjectVO> queryListByCustomId(Long customId) {
        JPAQuery<CrmActProjectVO> jpaQuery = this.getJpaQuerySelectProject();
        jpaQuery.where((Predicate)this.qdo.custBookId.eq((Object)customId));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        jpaQuery.where((Predicate)this.qdoProject.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public long updateProjectByKeyDynamic(CrmOpportunityPayload payload, Long projectId) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdoProject).where(new Predicate[]{this.qdoProject.id.eq((Object)projectId)});
        if (payload.getProjectName() != null) {
            update.set((Path)this.qdoProject.projectName, (Object)payload.getProjectName());
        }
        if (payload.getManageUserId() != null) {
            update.set(this.qdoProject.manageUserId, (Object)payload.getManageUserId());
        }
        if (payload.getOrgId() != null) {
            update.set(this.qdoProject.orgId, (Object)payload.getOrgId());
        }
        if (payload.getCompanyId() != null) {
            update.set(this.qdoProject.companyId, (Object)payload.getCompanyId());
        }
        if (payload.getFileCodes() != null) {
            update.set((Path)this.qdoProject.fileCodes, (Object)payload.getFileCodes());
        }
        if (payload.getLoseReason() != null) {
            update.set((Path)this.qdoProject.loseReason, (Object)payload.getLoseReason());
        }
        if (payload.getCloseReason() != null) {
            update.set((Path)this.qdoProject.closeReason, (Object)payload.getCloseReason());
        }
        if (payload.getClsoeRemark() != null) {
            update.set((Path)this.qdoProject.clsoeRemark, (Object)payload.getClsoeRemark());
        }
        if (payload.getProjectStatus() != null) {
            update.set((Path)this.qdoProject.projectStatus, (Object)payload.getProjectStatus());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0 && nullFields.contains("closeReason")) {
            update.setNull((Path)this.qdoProject.closeReason);
        }
        return update.execute();
    }

    @Transactional
    public long updateByKeyDynamic(CrmOpportunityPayload opportunityPayload) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)opportunityPayload.getId())});
        if (opportunityPayload.getFormalCustomerId() != null) {
            update.set(this.qdo.formalCustomerId, (Object)opportunityPayload.getFormalCustomerId());
        }
        if (opportunityPayload.getItemId() != null) {
            update.set((Path)this.qdo.itemId, (Object)opportunityPayload.getItemId());
        }
        return update.execute();
    }

    private JPAQuery<CrmOpportunityVO> getJpaQuerySelect() {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(CrmOpportunityVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.projectId, this.qdo.actId, this.qdoProject1.projectName.as("actName"), this.qdo.itemId, this.qdoProject.projectName, this.qdoProject.projectNo, this.qdoProject.orgId, this.qdoProject.manageUserId, this.qdoProject.companyId, this.qdoProject.fileCodes, this.qdoProject.projectStatus, this.qdoProject.closeReason, this.qdoProject.loseReason, this.qdoProject.clsoeRemark, this.qdo.leadsId, this.qdoLeads.leadsName, this.qdo.saleProduct, this.qdo.custRegion, this.qdo.isOldCust, this.qdo.custBookId, this.qdo.custBookName, this.qdo.custProject, this.qdo.contactName, this.qdo.contactPhone, this.qdo.contactDept, this.qdo.contactPosition, this.qdo.contactWebsite, this.qdo.custProp, this.qdo.custIdst, this.qdo.forecastWinDate, this.qdo.forecastAmount, this.qdo.probability, this.qdo.currCode, this.qdo.salePhase, this.qdo.deliveryAddress, this.qdo.oppoLevel, this.qdo.isNeedPartner, this.qdo.coopBookId, this.qdo.coopBookName, this.qdo.partnerDesc, this.qdo.preSaleOrgId, this.qdo.preSaleUserId, this.qdo.projectDifficult, this.qdo.projectImportance, this.qdo.deliOrgId, this.qdo.deliUserId, this.qdo.solutionDifficulty, this.qdo.solutionImportance, this.qdo.coOrgId, this.qdo.coUserId, this.qdo.codeliOrgId, this.qdo.codeliUserId, this.qdo.sourceType, this.qdo.internalOrgId, this.qdo.internalUserId, this.qdo.externalIden, this.qdo.externalName, this.qdo.externalPhone, this.qdo.profitDesc, this.qdo.extString1, this.qdo.extString2, this.qdo.extString3, this.qdo.extString4, this.qdo.extString5, this.qdo.remark, this.qdo.oppoIdV4, this.qdo.checkStatus, this.qdoProject.createUserId, this.qdoProject.creator, this.qdoProject.createTime})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qdoProject)).on((Predicate)this.qdoProject.id.longValue().eq((Expression)this.qdo.projectId.longValue()))).leftJoin((EntityPath)this.qdoLeads)).on((Predicate)this.qdoLeads.id.longValue().eq((Expression)this.qdo.leadsId.longValue()))).leftJoin((EntityPath)this.qdoProject1)).on((Predicate)this.qdoProject1.id.longValue().eq((Expression)this.qdo.actId.longValue()))).leftJoin((EntityPath)this.qdoMember)).on((Predicate)this.qdoMember.projectId.longValue().eq((Expression)this.qdoProject.id.longValue()));
        return jpaQuery;
    }

    public CrmOpportunityVO queryByKey(Long key) {
        JPAQuery<CrmOpportunityVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)key));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (CrmOpportunityVO)jpaQuery.fetchFirst();
    }

    public CrmOpportunityDO queryByKeySimple(Long key) {
        CrmOpportunityDO entity = this.repo.findById(key).orElseGet(CrmOpportunityDO::new);
        return entity;
    }

    private JPAQuery<CrmOpportunityVO> getJpaQueryWhere(CrmOpportunityQuery query, List<Long> oppoUserIds, List<Long> orgManageIds, List<Long> sapPermissionOrgIdList) {
        JPAQuery<CrmOpportunityVO> jpaQuery = this.getJpaQuerySelect();
        if (!ObjectUtils.isEmpty((Object)query.getOrgId())) {
            jpaQuery.where((Predicate)this.qdoProject.orgId.eq((Object)query.getOrgId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getManageUserId())) {
            jpaQuery.where((Predicate)this.qdoProject.manageUserId.eq((Object)query.getManageUserId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCreateUserId())) {
            jpaQuery.where((Predicate)this.qdoProject.createUserId.eq((Object)query.getCreateUserId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getProjectNameOrNo())) {
            jpaQuery.where((Predicate)this.qdoProject.projectName.like(SqlUtil.toSqlLikeString(query.getProjectNameOrNo())).or((Predicate)this.qdoProject.projectNo.like(SqlUtil.toSqlLikeString(query.getProjectNameOrNo()))));
        }
        if (!ObjectUtils.isEmpty((Object)query.getForecastWinDateRange())) {
            LocalDate startDate = null;
            LocalDate endDate = null;
            if ("0".equals(query.getForecastWinDateRange())) {
                endDate = LocalDate.now().plusMonths(3L);
            }
            if ("1".equals(query.getForecastWinDateRange())) {
                startDate = LocalDate.now().plusMonths(3L);
            }
            if ("2".equals(query.getForecastWinDateRange())) {
                startDate = LocalDate.now().plusMonths(6L);
            }
            if (startDate != null) {
                jpaQuery.where((Predicate)this.qdo.forecastWinDate.goe((Comparable)startDate));
            }
            if (endDate != null) {
                jpaQuery.where((Predicate)this.qdo.forecastWinDate.loe((Comparable)endDate));
            }
        }
        if (!ObjectUtils.isEmpty((Object)query.getPreSaleOrgId())) {
            jpaQuery.where((Predicate)this.qdo.preSaleOrgId.eq((Object)query.getPreSaleOrgId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPreSaleUserId())) {
            jpaQuery.where((Predicate)this.qdo.preSaleUserId.eq((Object)query.getPreSaleUserId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getDeliOrgId())) {
            jpaQuery.where((Predicate)this.qdo.deliOrgId.eq((Object)query.getDeliOrgId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getDeliUserId())) {
            jpaQuery.where((Predicate)this.qdo.deliUserId.eq((Object)query.getDeliUserId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustRegion())) {
            jpaQuery.where((Predicate)this.qdo.custRegion.eq((Object)query.getCustRegion()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getProjectStatus())) {
            if ("0".equals(query.getProjectStatusType())) {
                jpaQuery.where((Predicate)this.qdoProject.projectStatus.eq((Object)query.getProjectStatus()));
            } else {
                jpaQuery.where((Predicate)this.qdoProject.projectStatus.ne((Object)query.getProjectStatus()));
            }
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustBookName())) {
            jpaQuery.where((Predicate)this.qdo.custBookName.like(SqlUtil.toSqlLikeString(query.getCustBookName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getOppoLevel())) {
            jpaQuery.where((Predicate)this.qdo.oppoLevel.eq((Object)query.getOppoLevel()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getLeadsId())) {
            jpaQuery.where((Predicate)this.qdo.leadsId.eq((Object)query.getLeadsId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCoopBookId())) {
            jpaQuery.where((Predicate)this.qdo.coopBookId.eq((Object)query.getCoopBookId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCoopBookName())) {
            jpaQuery.where((Predicate)this.qdo.coopBookName.like(SqlUtil.toSqlLikeString(query.getCoopBookName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCoOrgId())) {
            jpaQuery.where((Predicate)this.qdo.coOrgId.eq((Object)query.getCoOrgId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCodeliOrgId())) {
            jpaQuery.where((Predicate)this.qdo.codeliOrgId.eq((Object)query.getCodeliOrgId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getInternalOrgId())) {
            jpaQuery.where((Predicate)this.qdo.internalOrgId.eq((Object)query.getInternalOrgId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getInternalUserId())) {
            jpaQuery.where((Predicate)this.qdo.internalUserId.eq((Object)query.getInternalUserId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustIdst())) {
            jpaQuery.where((Predicate)this.qdo.custIdst.eq((Object)query.getCustIdst()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getFormalCustomerId())) {
            jpaQuery.where((Predicate)this.qdo.formalCustomerId.eq((Object)query.getFormalCustomerId()));
        }
        if (oppoUserIds != null && !oppoUserIds.isEmpty()) {
            BooleanExpression temp = this.qdoMember.userId.in(oppoUserIds).or((Predicate)this.qdoProject.manageUserId.in(oppoUserIds)).or((Predicate)this.qdoProject.orgId.in(orgManageIds)).or((Predicate)this.qdo.preSaleOrgId.in(orgManageIds)).or((Predicate)this.qdo.deliOrgId.in(orgManageIds)).or((Predicate)this.qdo.coOrgId.in(orgManageIds)).or((Predicate)this.qdo.codeliOrgId.in(orgManageIds)).or((Predicate)this.qdo.internalOrgId.in(orgManageIds));
            if (CollectionUtils.isNotEmpty(sapPermissionOrgIdList)) {
                temp = ExpressionUtils.or((Predicate)temp, (Predicate)this.qdo.preSaleOrgId.in(sapPermissionOrgIdList).or((Predicate)this.qdo.deliOrgId.in(sapPermissionOrgIdList)));
            }
            jpaQuery.where((Predicate)temp);
            jpaQuery.where((Predicate)this.qdoMember.deleteFlag.eq((Object)0));
        }
        if (!ObjectUtils.isEmpty((Object[])query.getOppoIds())) {
            jpaQuery.where((Predicate)this.qdo.id.in((Object[])query.getOppoIds()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getOppoIdsV4())) {
            jpaQuery.where((Predicate)this.qdo.oppoIdV4.in((Collection)query.getOppoIdsV4()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSourceType())) {
            jpaQuery.where((Predicate)this.qdo.sourceType.eq((Object)query.getSourceType()));
        }
        if (StringUtils.isNotBlank((CharSequence)query.getCheckStatus())) {
            jpaQuery.where((Predicate)this.qdo.checkStatus.eq((Object)query.getCheckStatus()));
        }
        jpaQuery.groupBy(this.qdoProject.id);
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        jpaQuery.where((Predicate)this.qdoProject.deleteFlag.eq((Object)0));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery;
    }

    public PagingVO<CrmOpportunityVO> queryPaging(CrmOpportunityQuery query, List<Long> oppoUserIds, List<Long> orgManageIds, List<Long> sapPermissionOrgIdList) {
        JPAQuery<CrmOpportunityVO> jpaQuery = this.getJpaQueryWhere(query, oppoUserIds, orgManageIds, sapPermissionOrgIdList);
        QueryResults result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetchResults();
        System.out.println(result.getTotal());
        return PagingVO.builder().records(result.getResults()).total(result.getTotal()).build();
    }

    public List<CrmOpportunityVO> queryList(CrmOpportunityQuery query, List<Long> oppoUserIds, List<Long> orgManageIds) {
        JPAQuery<CrmOpportunityVO> jpaQuery = this.getJpaQueryWhere(query, oppoUserIds, orgManageIds, null);
        return jpaQuery.fetch();
    }

    public long updateStatus(Long key, String projectStatus) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdoProject).set((Path)this.qdoProject.projectStatus, (Object)projectStatus);
        update.where(new Predicate[]{this.qdoProject.id.eq((Object)key)});
        return update.execute();
    }

    public List<Map<String, Object>> queryEmployees(Set<Long> userIds) {
        return this.repo.queryEmployees(userIds);
    }

    public List<Map<String, Object>> queryOrgs(Set<Long> orgIds) {
        return this.repo.queryOrgs(orgIds);
    }

    public List<Map<String, Object>> queryBooks(Set<Long> bookIds) {
        return this.repo.queryBooks(bookIds);
    }

    public List<Long> queryByFormalCustomerId(Long customerId) {
        return this.repo.queryByFormalCustomerId(customerId);
    }

    public List<Long> findNotBindOppos() {
        return this.repo.findNotBindOppos();
    }

    public Long getIdByV4(Long oppoIdV4) {
        return this.repo.getIdByV4(oppoIdV4) == null ? null : this.repo.getIdByV4(oppoIdV4).get(0);
    }

    public void deleteSoft(Long id) {
        this.repo.deleteSoft(id);
    }

    public List<Map<String, Object>> getV4AndV5OppoIds() {
        return this.repo.getV4AndV5OppoIds();
    }

    public CrmOpportunityDAO(JPAQueryFactory jpaQueryFactory, CrmOpportunityRepo repo, CrmOpportunitySalesRepo repoSales, CrmOpportunityStakeholderRepo repoStakeholder, CrmOpportunityPartnerRepo repoPartner, CrmOpportunityCompetitorRepo repoCompetitor, CrmOpportunityAnalyzeRepo repoAnalyze) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
        this.repoSales = repoSales;
        this.repoStakeholder = repoStakeholder;
        this.repoPartner = repoPartner;
        this.repoCompetitor = repoCompetitor;
        this.repoAnalyze = repoAnalyze;
    }
}

