/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.service;

import com.elitescloud.cloudt.common.base.BaseModel;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmCustomerOperationMemberListPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmCustomerOperationMemberPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmCustomerOperationMemberQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmCustomerOperationMemberService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerOperationMemberVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemLogEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5.server.prd.crm.constant.CustomerOperationMemberTypeEnum;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmCustomerOperationMemberConvert;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmCustomerOperationMemberDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmCustomerOperationMemberRepo;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class CrmCustomerOperationMemberServiceImpl
implements CrmCustomerOperationMemberService {
    private static final Logger log = LoggerFactory.getLogger(CrmCustomerOperationMemberServiceImpl.class);
    private final CrmCustomerOperationMemberRepo repo;
    private final PrdSystemLogService logService;
    private final CacheUtil cacheUtil;

    @Transactional(rollbackFor={Exception.class})
    public CrmCustomerOperationMemberVO insert(CrmCustomerOperationMemberPayload payload) {
        this.check(payload);
        this.initDefaultValue(payload);
        CrmCustomerOperationMemberDO entityDo = CrmCustomerOperationMemberConvert.INSTANCE.toDo(payload);
        this.repo.save((Object)entityDo);
        return CrmCustomerOperationMemberConvert.INSTANCE.toVo(entityDo);
    }

    public List<CrmCustomerOperationMemberVO> saveAll(CrmCustomerOperationMemberListPayload payload) {
        if (null == payload.getOperId()) {
            throw TwException.error("", "operId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<CrmCustomerOperationMemberVO> list = new ArrayList<CrmCustomerOperationMemberVO>();
        this.deleteSoftByOperId(payload.getOperId());
        if (!CollectionUtils.isEmpty((Collection)payload.getMemberList())) {
            payload.getMemberList().forEach(crmCustomerOperationMemberPayload -> list.add(this.insert((CrmCustomerOperationMemberPayload)crmCustomerOperationMemberPayload)));
            this.logService.saveNewLog(payload.getOperId(), PrdSystemObjectEnum.CUSTOMER_OPERATION.getCode(), PrdSystemLogEnum.CREATE.getDesc() + PrdSystemObjectEnum.CUSTOMER_OPERATION_MEMBER.getDesc());
        }
        return list;
    }

    public void deleteSoftByOperId(Long operId) {
        CrmCustomerOperationMemberQuery query = new CrmCustomerOperationMemberQuery();
        query.setOperId(operId);
        List planTempDetailDOList = this.repo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder));
        List<Long> keys = planTempDetailDOList.stream().map(BaseModel::getId).collect(Collectors.toList());
        this.deleteSoftNoLog(keys);
    }

    private void initDefaultValue(CrmCustomerOperationMemberPayload payload) {
        if (!StringUtils.hasText((String)payload.getUserName())) {
            payload.setUserName(this.cacheUtil.getUserName(payload.getUserId()));
        }
        if (null == payload.getStartTime()) {
            payload.setStartTime(LocalDateTime.now());
        }
        if (!StringUtils.hasText((String)payload.getType())) {
            payload.setType(CustomerOperationMemberTypeEnum.TEMP.getCode());
            payload.setTypeName(CustomerOperationMemberTypeEnum.TEMP.getDesc());
        }
    }

    private void check(CrmCustomerOperationMemberPayload payload) {
        if (null == payload.getOperId()) {
            throw TwException.error("", "operId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == payload.getUserId()) {
            throw TwException.error("", "userId\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public CrmCustomerOperationMemberVO update(CrmCustomerOperationMemberPayload payload) {
        if (null != payload.getUserId() && !StringUtils.hasText((String)payload.getUserName())) {
            payload.setUserName(this.cacheUtil.getUserName(payload.getUserId()));
        }
        CrmCustomerOperationMemberDO entity = this.repo.findById(payload.getId()).orElseGet(CrmCustomerOperationMemberDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        CrmCustomerOperationMemberDO entityDo = CrmCustomerOperationMemberConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return CrmCustomerOperationMemberConvert.INSTANCE.toVo((CrmCustomerOperationMemberDO)((Object)this.repo.save((Object)entity)));
    }

    public CrmCustomerOperationMemberVO queryByKey(Long key) {
        CrmCustomerOperationMemberDO entity = this.repo.findById(key).orElseGet(CrmCustomerOperationMemberDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        CrmCustomerOperationMemberVO crmCustomerOperationVO = CrmCustomerOperationMemberConvert.INSTANCE.toVo(entity);
        return crmCustomerOperationVO;
    }

    public List<CrmCustomerOperationMemberVO> queryList(CrmCustomerOperationMemberQuery query) {
        OrderItem orderItem = OrderItem.desc((String)"createTime");
        query.defaultOrder(orderItem);
        return CrmCustomerOperationMemberConvert.INSTANCE.toVoList(this.repo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder)));
    }

    public PagingVO<CrmCustomerOperationMemberVO> paging(CrmCustomerOperationMemberQuery query) {
        OrderItem orderItem = OrderItem.desc((String)"createTime");
        query.defaultOrder(orderItem);
        Page page = this.repo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), (Pageable)query.getPageRequest());
        return PageUtil.toPageVo(page.map(CrmCustomerOperationMemberConvert.INSTANCE::toVo));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            Optional optional = this.repo.findById(keys.get(0));
            if (!optional.isEmpty()) {
                CrmCustomerOperationMemberDO entity = (CrmCustomerOperationMemberDO)((Object)optional.get());
                Long operId = entity.getOperId();
                this.logService.saveNewLog(operId, PrdSystemObjectEnum.CUSTOMER_OPERATION.getCode(), PrdSystemLogEnum.DELETE.getDesc() + PrdSystemObjectEnum.CUSTOMER_OPERATION_MEMBER.getDesc());
            }
            this.deleteSoftNoLog(keys);
        }
    }

    public void deleteSoftNoLog(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.repo.findById(id);
                if (!optional.isEmpty()) {
                    CrmCustomerOperationMemberDO entity = (CrmCustomerOperationMemberDO)((Object)((Object)optional.get()));
                    entity.setDeleteFlag(1);
                    this.repo.save((Object)entity);
                }
            });
        }
    }

    public CrmCustomerOperationMemberServiceImpl(CrmCustomerOperationMemberRepo repo, PrdSystemLogService logService, CacheUtil cacheUtil) {
        this.repo = repo;
        this.logService = logService;
        this.cacheUtil = cacheUtil;
    }
}

