/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.service;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.elitescloud.cloudt.authorization.core.SecurityContextUtil;
import com.elitescloud.cloudt.common.base.BaseModel;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmCustomerPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmFollowPayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpportunityExcelExport;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpportunityPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpportunityQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmCustomerService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmFollowService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmActProjectVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmFollowVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.prj.vo.PrjProjectMemberVO;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemLogQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemLogVO;
import com.elitesland.tw.tw5.server.common.ExcelUtil;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransferUtilServiceImpl;
import com.elitesland.tw.tw5.server.common.util.ChangeFieldLogUtil;
import com.elitesland.tw.tw5.server.common.util.ListCompareUtil;
import com.elitesland.tw.tw5.server.prd.ab.dao.PrdAbDAO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.CrmFollowObjectEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemLogEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.crm.constant.CrmOpportunityCheckStatusEnum;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmOpportunityConvert;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmActActivityDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmCustomerDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmLeadsDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmOpportunityDAO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmCustomerDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmLeadsDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOpportunityDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmOpportunityRepo;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgOrganizationDO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgOrganizationRefDO;
import com.elitesland.tw.tw5.server.prd.prj.dao.PrjProjectDAO;
import com.elitesland.tw.tw5.server.prd.prj.entity.PrjProjectDO;
import com.elitesland.tw.tw5.server.prd.prj.entity.PrjProjectMemberDO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import com.elitesland.tw.tw5.server.yeedoc.config.YeedocProperties;
import com.elitesland.tw.tw5.server.yeedoc.dto.CreateFolderDTO;
import com.elitesland.tw.tw5.server.yeedoc.service.YeedocService;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Service
public class CrmOpportunityServiceImpl
extends BaseServiceImpl
implements CrmOpportunityService {
    private static final Logger log = LoggerFactory.getLogger(CrmOpportunityServiceImpl.class);
    private final CacheUtil cacheUtil;
    private final PrjProjectDAO projectDAO;
    private final CrmOpportunityDAO dao;
    private final CrmOpportunityRepo repo;
    private final CrmActActivityDAO activityDAO;
    private final PrdOrgEmployeeDAO employeeDAO;
    private final PrdOrgOrganizationDAO orgOrganizationDAO;
    private final CrmFollowService followService;
    private final PrdSystemLogService logService;
    private final TransferUtilServiceImpl transferUtilService;
    private final HttpUtil httpUtil;
    private final ExcelUtil excelUtil;
    private final PrdSystemRoleDAO systemRoleDAO;
    private final CrmCustomerDAO crmCustomerDAO;
    private final CrmCustomerService customerService;
    private final PrdAbDAO abDAO;
    private final YeedocService yeedocService;
    private final YeedocProperties yeedocProperties;
    private final CrmLeadsDAO leadsDAO;
    private final UdcUtil udcUtil;
    private final ChangeFieldLogUtil changeFieldLogUtil;
    @Value(value="${tw4.opportunity.operation}")
    private String opportunity_operation;
    @Value(value="${tw4.opportunity.operation_close}")
    private String opportunity_operation_close;
    @Value(value="${tw4.opportunity.operation_change_status}")
    private String opportunity_operation_updateStatus;
    private static final String[] sapBuSystemRoleCodes = new String[]{"BD0020", "BD0031", "BD0035", "BD0037", "BD0036", "BD0030"};

    @Transactional(propagation=Propagation.REQUIRED)
    public CrmOpportunityVO insert(CrmOpportunityPayload payload) {
        GeneralUserDetails userDetails;
        if ((payload = this.transferV4(payload)).getIsNeedPartner() == null) {
            payload.setIsNeedPartner(Integer.valueOf(0));
        }
        String code = this.generateSeqNum("OPPORTUNITY", new String[0]);
        payload.setProjectNo(code);
        Map<Object, Object> map = new HashMap();
        map = this.transferUtilService.beanToMap(payload);
        Long leadsId = payload.getLeadsId();
        if (leadsId != null) {
            CrmLeadsDO leadsDO = this.leadsDAO.queryById(leadsId);
            map.put("leadsId", leadsDO.getLeadsIdV4());
        }
        Long userId = (userDetails = SecurityContextUtil.currentUser()) == null ? 0L : userDetails.getUser().getId();
        map.put("createUserId", this.employeeDAO.getV4UserId(userId));
        PrjProjectDO ado = CrmOpportunityConvert.INSTANCE.toProjectDo(payload);
        ado.setProjectStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
        ado.setProjectType(CrmFollowObjectEnum.Opportunity.getCode());
        ado.setProjectNo(code);
        ado = this.projectDAO.save(ado);
        CrmOpportunityDO crmOpportunityDO = CrmOpportunityConvert.INSTANCE.toDo(payload);
        crmOpportunityDO.setProjectId(ado.getId());
        crmOpportunityDO.setCheckStatus(CrmOpportunityCheckStatusEnum.NOT_CHECKED.getCode());
        crmOpportunityDO = this.dao.save(crmOpportunityDO);
        this.logService.saveNewLog(crmOpportunityDO.getId(), PrdSystemObjectEnum.Opportunity.getCode(), PrdSystemLogEnum.CREATE.getDesc() + PrdSystemObjectEnum.Opportunity.getDesc());
        ArrayList<Long> userIds = new ArrayList<Long>();
        userIds.add(ado.getCreateUserId());
        userIds.add(ado.getManageUserId());
        userIds.add(crmOpportunityDO.getPreSaleUserId());
        userIds.add(crmOpportunityDO.getDeliUserId());
        userIds.add(crmOpportunityDO.getCoUserId());
        userIds.add(crmOpportunityDO.getCodeliUserId());
        this.addProjectMember(ado.getId(), userIds, null);
        return CrmOpportunityConvert.INSTANCE.toVo(crmOpportunityDO);
    }

    private CrmOpportunityPayload transferV4(CrmOpportunityPayload payload) {
        if (payload.getCustBookIdV4() != null) {
            payload.setCustBookId(this.abDAO.getIdByV4(payload.getCustBookIdV4()));
        }
        if (payload.getOrgIdV4() != null) {
            payload.setOrgId(this.orgOrganizationDAO.getOrgIdByV4(payload.getOrgIdV4()));
        }
        if (payload.getManageUserIdV4() != null) {
            payload.setManageUserId(this.employeeDAO.getUserIdByV4(payload.getManageUserIdV4()));
        }
        if (payload.getCoOrgIdV4() != null) {
            payload.setCoOrgId(this.orgOrganizationDAO.getOrgIdByV4(payload.getCodeliOrgIdV4()));
        }
        if (payload.getCoUserIdV4() != null) {
            payload.setCoUserId(this.employeeDAO.getUserIdByV4(payload.getCoUserIdV4()));
        }
        if (payload.getDeliOrgIdV4() != null) {
            payload.setDeliOrgId(this.orgOrganizationDAO.getOrgIdByV4(payload.getDeliOrgIdV4()));
        }
        if (payload.getDeliUserIdV4() != null) {
            payload.setDeliUserId(this.employeeDAO.getUserIdByV4(payload.getDeliUserIdV4()));
        }
        if (payload.getDeliOrgIdV4() != null) {
            payload.setDeliOrgId(this.orgOrganizationDAO.getOrgIdByV4(payload.getDeliOrgIdV4()));
        }
        if (payload.getCodeliOrgIdV4() != null) {
            payload.setCodeliOrgId(this.orgOrganizationDAO.getOrgIdByV4(payload.getCodeliOrgIdV4()));
        }
        if (payload.getCodeliUserIdV4() != null) {
            payload.setCodeliUserId(this.employeeDAO.getUserIdByV4(payload.getCodeliUserIdV4()));
        }
        if (payload.getInternalUserIdV4() != null) {
            payload.setInternalUserId(this.employeeDAO.getUserIdByV4(payload.getInternalUserIdV4()));
        }
        if (payload.getInternalOrgIdV4() != null) {
            payload.setInternalOrgId(this.orgOrganizationDAO.getOrgIdByV4(payload.getInternalOrgIdV4()));
        }
        if (payload.getPreSaleOrgIdV4() != null) {
            payload.setPreSaleOrgId(this.orgOrganizationDAO.getOrgIdByV4(payload.getPreSaleOrgIdV4()));
        }
        if (payload.getPreSaleUserIdV4() != null) {
            payload.setPreSaleUserId(this.employeeDAO.getUserIdByV4(payload.getPreSaleUserIdV4()));
        }
        return payload;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public Long update(CrmOpportunityPayload payload) {
        this.transferV4(payload);
        CrmActProjectVO project = this.dao.queryProjectBykey(payload.getId());
        this.checkUpdate(project);
        Long userId = 0L;
        try {
            userId = GlobalUtil.getLoginUserId();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Map<String, List<Long>> userMangeIds = this.getUserMangeIds(payload, project);
        List<Long> addIds = userMangeIds.get("addIds");
        List<Long> deleteIds = userMangeIds.get("deleteIds");
        this.dao.updateProjectByKeyDynamic(payload, project.getId());
        CrmOpportunityDO oppoDO = (CrmOpportunityDO)((Object)this.repo.findById(payload.getId()).get());
        CrmOpportunityDO oldEntity = new CrmOpportunityDO();
        BeanUtils.copyProperties((Object)((Object)oppoDO), (Object)((Object)oldEntity));
        CrmOpportunityConvert.INSTANCE.copy(payload, oppoDO);
        oppoDO.setProjectId(project.getId());
        oppoDO.setOppoIdV4(project.getOppoIdV4());
        oppoDO = this.dao.save(oppoDO);
        String changeLog = this.changeFieldLogUtil.getFieldsUpdateLog(oppoDO, oldEntity);
        if (org.springframework.util.StringUtils.hasText((String)changeLog)) {
            this.logService.saveNewLog(oppoDO.getId(), PrdSystemObjectEnum.Opportunity.getCode(), changeLog);
        }
        this.deleteProjectMember(project.getId(), deleteIds, project.getOppoIdV4());
        this.addProjectMember(project.getId(), addIds, project.getOppoIdV4());
        return 0L;
    }

    @Transactional(rollbackFor={Exception.class})
    public void toggleCheckStatus(List<Long> ids) {
        List doList = this.repo.findAllById(ids);
        for (CrmOpportunityDO oppoDO : doList) {
            CrmOpportunityDO oldEntity = new CrmOpportunityDO();
            BeanUtils.copyProperties((Object)((Object)oppoDO), (Object)((Object)oldEntity));
            String newCheckStatus = this.toggleCheckStatus(oppoDO.getCheckStatus());
            oppoDO.setCheckStatus(newCheckStatus);
            this.repo.save((Object)oppoDO);
            String changeLog = this.changeFieldLogUtil.getFieldsUpdateLog(oppoDO, oldEntity);
            if (!org.springframework.util.StringUtils.hasText((String)changeLog)) continue;
            this.logService.saveNewLog(oppoDO.getId(), PrdSystemObjectEnum.Opportunity.getCode(), changeLog);
        }
    }

    private String toggleCheckStatus(String checkStatus) {
        if (CrmOpportunityCheckStatusEnum.NOT_CHECKED.getCode().equals(checkStatus)) {
            return CrmOpportunityCheckStatusEnum.CHECKED.getCode();
        }
        if (CrmOpportunityCheckStatusEnum.CHECKED.getCode().equals(checkStatus)) {
            return CrmOpportunityCheckStatusEnum.NOT_CHECKED.getCode();
        }
        return checkStatus;
    }

    public PagingVO<CrmOpportunityVO> paging(CrmOpportunityQuery query) {
        PagingVO<CrmOpportunityVO> opportunityVO = null;
        if (query.getFormalCustomerId() != null) {
            if (query.getIsPermission().booleanValue()) {
                Boolean marketAdminUserIdsByRole = this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.MARKET_ADMIN.getCode()));
                Boolean marketUserIdsByRole = this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.MARKET_RES.getCode()));
                Boolean saleAdminUserIdsByRole = this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SALE_ADMIN.getCode()));
                Boolean saleUserIdsByRole = this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SALE_RES.getCode()));
                if (saleUserIdsByRole.booleanValue() || saleAdminUserIdsByRole.booleanValue()) {
                    query.setSourceType("INTERNAL");
                } else if (marketAdminUserIdsByRole.booleanValue() || marketUserIdsByRole.booleanValue()) {
                    query.setSourceType("EXTERNAL");
                } else {
                    query.setCreateUserId(GlobalUtil.getLoginUserId());
                }
            }
            opportunityVO = this.dao.queryPaging(query, null, null, null);
        } else {
            Long userId = GlobalUtil.getLoginUserId();
            List sapPermissionOrgIdList = null;
            List<Long> orgManageIds = this.orgOrganizationDAO.queryByManageIdOrgIds(userId);
            List<Long> oppoUserIds = new ArrayList<Long>();
            List<Long> userIdsByRole = this.systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.SALE_ADMIN.getCode()));
            if (userIdsByRole != null && !userIdsByRole.isEmpty() && userIdsByRole.contains(userId)) {
                oppoUserIds = null;
            } else {
                PrdOrgEmployeeRefVO prdOrgEmployeeRefVO;
                boolean hasSapBuPermission = this.cacheUtil.hasSystemRolePermission(Arrays.asList(sapBuSystemRoleCodes));
                if (hasSapBuPermission) {
                    List<String> userSystemRoleCodes = this.cacheUtil.getSystemRoleCodes(userId);
                    List<String> userSapBuSystemRoleCodes = Arrays.stream(sapBuSystemRoleCodes).filter(s -> userSystemRoleCodes.contains(s)).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(userSapBuSystemRoleCodes)) {
                        sapPermissionOrgIdList = this.orgOrganizationDAO.queryByOrgCode(userSapBuSystemRoleCodes).stream().map(BaseModel::getId).collect(Collectors.toList());
                    }
                }
                if ((prdOrgEmployeeRefVO = this.employeeDAO.queryUserOrgData(userId)) != null && prdOrgEmployeeRefVO.getManageId() != null && userId.equals(prdOrgEmployeeRefVO.getManageId())) {
                    Long orgId = prdOrgEmployeeRefVO.getOrgId();
                    List<PrdOrgEmployeeRefVO> prdOrgEmployeeRefVOS = this.orgOrganizationDAO.queryEmployeeList(orgId);
                    oppoUserIds = prdOrgEmployeeRefVOS.stream().map(e -> e.getUserId()).collect(Collectors.toList());
                } else {
                    oppoUserIds = Collections.singletonList(userId);
                }
            }
            opportunityVO = this.dao.queryPaging(query, oppoUserIds, orgManageIds, sapPermissionOrgIdList);
        }
        List opportunitys = opportunityVO.getRecords();
        HashSet<Long> userIds = new HashSet<Long>();
        HashSet<Long> orgIds = new HashSet<Long>();
        HashSet<Long> bookIds = new HashSet<Long>();
        for (CrmOpportunityVO vo : opportunitys) {
            this.transferSystemSelection(vo);
            this.getIdDatas(userIds, orgIds, bookIds, vo);
        }
        List<Map<String, Object>> employees = this.dao.queryEmployees(userIds);
        HashMap employeeMap = new HashMap();
        employees.forEach(employee -> employeeMap.put(Long.valueOf("" + employee.get("userId")), (String)employee.get("employeeName")));
        List<Map<String, Object>> orgs = this.dao.queryOrgs(orgIds);
        HashMap orgMap = new HashMap();
        orgs.forEach(org -> orgMap.put(Long.valueOf("" + org.get("id")), (String)org.get("orgName")));
        List<Map<String, Object>> books = this.dao.queryBooks(bookIds);
        HashMap bookMap = new HashMap();
        books.forEach(book -> bookMap.put(Long.valueOf("" + book.get("id")), (String)book.get("bookName")));
        opportunitys.forEach(opportunity -> this.transferOpportunityDatas(employeeMap, orgMap, bookMap, (CrmOpportunityVO)opportunity));
        return opportunityVO;
    }

    private void allChildrenOrgId(Long parentOrgId, List<Long> childrenOrgIdList) {
        List<PrdOrgOrganizationRefDO> childrenOrgRefList = this.orgOrganizationDAO.queryAllByParentId(parentOrgId);
        if (CollectionUtils.isEmpty(childrenOrgRefList)) {
            return;
        }
        for (PrdOrgOrganizationRefDO orgRef : childrenOrgRefList) {
            childrenOrgIdList.add(orgRef.getOrgId());
            this.allChildrenOrgId(orgRef.getOrgId(), childrenOrgIdList);
        }
    }

    public List<CrmActProjectVO> queryList() {
        return null;
    }

    public CrmOpportunityVO queryByKey(Long key) {
        PrdOrgOrganizationDO prdOrgOrganizationDO;
        CrmOpportunityVO vo = this.dao.queryByKey(key);
        HashSet<Long> userIds = new HashSet<Long>();
        HashSet<Long> orgIds = new HashSet<Long>();
        this.transferSystemSelection(vo);
        HashSet<Long> bookIds = new HashSet<Long>();
        this.getIdDatas(userIds, orgIds, bookIds, vo);
        List<Map<String, Object>> employees = this.dao.queryEmployees(userIds);
        HashMap<Long, String> employeeMap = new HashMap<Long, String>();
        employees.forEach(employee -> employeeMap.put(Long.valueOf("" + employee.get("userId")), (String)employee.get("employeeName")));
        List<Map<String, Object>> orgs = this.dao.queryOrgs(orgIds);
        HashMap<Long, String> orgMap = new HashMap<Long, String>();
        orgs.forEach(org -> orgMap.put(Long.valueOf("" + org.get("id")), (String)org.get("orgName")));
        List<Map<String, Object>> books = this.dao.queryBooks(bookIds);
        HashMap<Long, String> bookMap = new HashMap<Long, String>();
        books.forEach(book -> bookMap.put(Long.valueOf("" + book.get("id")), (String)book.get("bookName")));
        this.transferOpportunityDatas(employeeMap, orgMap, bookMap, vo);
        vo.setMemberVOS(this.activityDAO.queryProjectMember(vo.getProjectId()));
        Long userId = GlobalUtil.getLoginUserId();
        List<Long> userIdsByRole = this.systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.PLATFORM_RES.getCode()));
        String isShow1 = "0";
        if (userIdsByRole != null && !userIdsByRole.isEmpty() && userIdsByRole.contains(userId)) {
            isShow1 = "1";
        }
        if (isShow1.equals("0") && (prdOrgOrganizationDO = this.orgOrganizationDAO.queryById(vo.getOrgId())).getManageId() != null && prdOrgOrganizationDO.getManageId().longValue() == userId.longValue()) {
            isShow1 = "1";
        }
        vo.setIsShow1(isShow1);
        return vo;
    }

    @Transactional
    public boolean changeStatus(Long key) {
        CrmActProjectVO project = this.dao.queryProjectBykey(key);
        String status = "";
        if (project.getProjectStatus().equals(WorkFlowStatusEnum.APPROVED_WORK.getCode())) {
            status = WorkFlowStatusEnum.PENDING_WORK.getCode();
        } else if (project.getProjectStatus().equals(WorkFlowStatusEnum.PENDING_WORK.getCode())) {
            status = WorkFlowStatusEnum.APPROVED_WORK.getCode();
        } else if (project.getProjectStatus().equals(WorkFlowStatusEnum.CLOSED_WORK.getCode())) {
            status = WorkFlowStatusEnum.APPROVED_WORK.getCode();
            CrmOpportunityPayload payload = new CrmOpportunityPayload();
            payload.setNullFields(Arrays.asList("closeReason"));
            this.dao.updateProjectByKeyDynamic(payload, project.getId());
        } else {
            throw TwException.error("", "\u6d3b\u52a8\u72b6\u6001\u4e3a\u6fc0\u6d3b/\u6682\u6302/\u5173\u95ed\u624d\u53ef\u8fdb\u884c\u8be5\u64cd\u4f5c");
        }
        this.logService.saveNewLog(key, PrdSystemObjectEnum.Opportunity.getCode(), this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.SystemStatus.getCode(), status) + PrdSystemObjectEnum.Opportunity.getDesc());
        this.dao.updateStatus(project.getId(), status);
        return true;
    }

    @Transactional
    public boolean closeOpportunity(Long key, String closeReason, String loseReson, String clsoeRemark) {
        CrmActProjectVO project = this.dao.queryProjectBykey(key);
        this.checkUpdate(project);
        CrmOpportunityPayload payload = new CrmOpportunityPayload();
        payload.setProjectStatus(WorkFlowStatusEnum.CLOSED_WORK.getCode());
        payload.setCloseReason(closeReason);
        payload.setLoseReason(loseReson);
        payload.setClsoeRemark(clsoeRemark);
        this.dao.updateProjectByKeyDynamic(payload, project.getId());
        this.logService.saveNewLog(key, PrdSystemObjectEnum.Opportunity.getCode(), PrdSystemLogEnum.CLOSE.getDesc() + PrdSystemObjectEnum.Opportunity.getDesc());
        return true;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public List<PrjProjectMemberVO> addMember(Long key, List<Long> userIds) {
        CrmActProjectVO project = this.dao.queryProjectBykey(key);
        this.checkUpdate(project);
        List<Long> updateUserIds = this.getUserMangeIds(project);
        Long userId = GlobalUtil.getLoginUserId();
        if (!updateUserIds.contains(userId)) {
            throw TwException.error("", "\u65e0\u6dfb\u52a0\u56e2\u961f\u6210\u5458\u6743\u9650");
        }
        this.logService.saveNewLog(key, PrdSystemObjectEnum.Opportunity.getCode(), PrdSystemObjectEnum.Opportunity.getDesc() + PrdSystemLogEnum.ADD.getDesc() + "\u56e2\u961f\u6210\u5458");
        this.addProjectMember(project.getId(), userIds, project.getOppoIdV4());
        return this.activityDAO.queryProjectMember(project.getId());
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public void deleteProjectMember(Long projectId, List<Long> userIds, Long tw4Oppid) {
        this.projectDAO.deleteMemberByUserId(projectId, userIds);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public void addProjectMember(Long projectId, List<Long> userIds, Long tw4Oppid) {
        List<PrjProjectMemberVO> memberVOS = this.activityDAO.queryProjectMember(projectId);
        List<Long> collect = userIds.stream().filter(userId -> memberVOS.stream().noneMatch(memberVO -> memberVO.getUserId().longValue() == userId.longValue())).collect(Collectors.toList());
        List<PrdOrgEmployeeVO> employeeVOS = this.activityDAO.queryEmployee(collect);
        ArrayList<PrjProjectMemberDO> memberDOS = new ArrayList<PrjProjectMemberDO>();
        for (PrdOrgEmployeeVO employeeVO : employeeVOS) {
            PrjProjectMemberDO memberDO = new PrjProjectMemberDO();
            memberDO.setProjectId(projectId);
            memberDO.setUserId(employeeVO.getUserId());
            memberDO.setEmployeeName(employeeVO.getEmployeeName());
            memberDOS.add(memberDO);
        }
        if (memberDOS.size() > 0) {
            this.projectDAO.saveMemberAll(memberDOS);
        }
    }

    List<Long> getUserMangeIds(CrmActProjectVO project) {
        ArrayList<Long> updateUserIds = new ArrayList<Long>();
        List<Long> userIdsByRole = this.systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SYS.getCode()));
        updateUserIds.addAll(userIdsByRole);
        if (project.getManageUserId() != null) {
            updateUserIds.add(project.getManageUserId());
        }
        if (project.getCodeliUserId() != null) {
            updateUserIds.add(project.getCodeliUserId());
        }
        if (project.getCoUserId() != null) {
            updateUserIds.add(project.getCoUserId());
        }
        if (project.getDeliUserId() != null) {
            updateUserIds.add(project.getDeliUserId());
        }
        if (project.getPreSaleUserId() != null) {
            updateUserIds.add(project.getPreSaleUserId());
        }
        if (project.getCreateUserId() != null) {
            updateUserIds.add(project.getCreateUserId());
        }
        return updateUserIds;
    }

    @Transactional
    public boolean deleteMember(Long oppoId, List<Long> keys) {
        CrmActProjectVO project = this.dao.queryProjectBykey(oppoId);
        this.checkUpdate(project);
        Long userId = GlobalUtil.getLoginUserId();
        List<Long> updateUserIds = this.getUserMangeIds(project);
        if (!updateUserIds.contains(userId)) {
            throw TwException.error("", "\u65e0\u5220\u9664\u56e2\u961f\u6210\u5458\u6743\u9650");
        }
        List<Long> userMemberIds = this.projectDAO.getUserIds(keys);
        if (updateUserIds.size() > 0 && updateUserIds.contains(userMemberIds.get(0))) {
            throw TwException.error("", "\u521b\u5efa\u4eba\u6216\u8d1f\u8d23\u4eba\u4e0d\u53ef\u5220\u9664");
        }
        this.projectDAO.deleteMemberSoft(keys, updateUserIds);
        this.logService.saveNewLog(oppoId, PrdSystemObjectEnum.Opportunity.getCode(), PrdSystemObjectEnum.Opportunity.getDesc() + PrdSystemLogEnum.DELETE.getDesc() + "\u56e2\u961f\u6210\u5458");
        return true;
    }

    public void addFollow(CrmFollowPayload payload) {
        CrmActProjectVO project = this.dao.queryProjectBykey(payload.getObjectId());
        this.checkUpdate(project);
        payload.setFollowObject(CrmFollowObjectEnum.Opportunity.getCode());
        this.followService.addFollow(payload);
        this.logService.saveNewLog(payload.getObjectId(), PrdSystemObjectEnum.Opportunity.getCode(), PrdSystemLogEnum.ADD.getDesc() + PrdSystemLogEnum.FOLLOW.getDesc());
    }

    public void updateFollow(CrmFollowPayload payload) {
        CrmActProjectVO project = this.dao.queryProjectBykey(payload.getObjectId());
        this.checkUpdate(project);
        payload.setFollowObject(CrmFollowObjectEnum.Opportunity.getCode());
        this.followService.updateFollow(payload);
        this.logService.saveNewLog(payload.getObjectId(), PrdSystemObjectEnum.Opportunity.getCode(), PrdSystemLogEnum.UPDATE.getDesc() + PrdSystemLogEnum.FOLLOW.getDesc());
    }

    public List<CrmFollowVO> queryListFollow(Long objectId) {
        return this.followService.queryFollowList(objectId, CrmFollowObjectEnum.Opportunity.name());
    }

    public PagingVO<PrdSystemLogVO> queryLogList(PrdSystemLogQuery query) {
        query.setLogObject(PrdSystemObjectEnum.Opportunity.getCode());
        return this.logService.pageLog(query);
    }

    void checkUpdate(CrmActProjectVO project) {
        if (project.getProjectStatus().equals(WorkFlowStatusEnum.PENDING_WORK.getCode())) {
            throw TwException.error("", "\u8be5\u6d3b\u52a8\u5df2\u6682\u6302");
        }
        if (project.getProjectStatus().equals(WorkFlowStatusEnum.CLOSED_WORK.getCode())) {
            throw TwException.error("", "\u6d3b\u52a8\u5df2\u5173\u95ed");
        }
    }

    private Map<String, List<Long>> getUserMangeIds(CrmOpportunityPayload payload, CrmActProjectVO project) {
        Long manageUserId = project.getManageUserId();
        Long preSaleUserId = project.getPreSaleUserId();
        Long deliUserId = project.getDeliUserId();
        Long coUserId = project.getCoUserId();
        Long codeliUserId = project.getCodeliUserId();
        List existGroupIds = Arrays.asList(manageUserId, preSaleUserId, deliUserId, coUserId, codeliUserId).stream().filter(e -> e != null).collect(Collectors.toList());
        Long manageUserIdNew = payload.getManageUserId();
        Long preSaleUserIdNew = payload.getPreSaleUserId();
        Long deliUserIdNew = payload.getDeliUserId();
        Long coUserIdNew = payload.getCoUserId();
        Long codeliUserIdNew = payload.getCodeliUserId();
        List newGroupIds = Arrays.asList(manageUserIdNew, preSaleUserIdNew, deliUserIdNew, coUserIdNew, codeliUserIdNew).stream().filter(e -> e != null).collect(Collectors.toList());
        List deleteIds = ListCompareUtil.getDeleteList(newGroupIds, existGroupIds);
        List addIds = ListCompareUtil.getInsertList(newGroupIds, existGroupIds);
        HashMap<String, List<Long>> result = new HashMap<String, List<Long>>();
        result.put("addIds", addIds);
        result.put("deleteIds", deleteIds);
        return result;
    }

    void transferOpportunityDatas(Map<Long, String> employeeMap, Map<Long, String> orgMap, Map<Long, String> bookMap, CrmOpportunityVO vo) {
        vo.setManageUserName(employeeMap.get(vo.getManageUserId()));
        vo.setPreSaleUserName(employeeMap.get(vo.getPreSaleUserId()));
        vo.setDeliUserName(employeeMap.get(vo.getDeliUserId()));
        vo.setCoUserName(employeeMap.get(vo.getCoUserId()));
        vo.setCodeliUserName(employeeMap.get(vo.getCodeliUserId()));
        vo.setInternalUserName(employeeMap.get(vo.getInternalUserId()));
        vo.setCreateUserName(employeeMap.get(vo.getCreateUserId()));
        vo.setOrgName(orgMap.get(vo.getOrgId()));
        vo.setPreSaleOrgName(orgMap.get(vo.getPreSaleOrgId()));
        vo.setDeliOrgName(orgMap.get(vo.getDeliOrgId()));
        vo.setCoOrgName(orgMap.get(vo.getCoOrgId()));
        vo.setCodeliOrgName(orgMap.get(vo.getCodeliOrgId()));
        vo.setInternalOrgName(orgMap.get(vo.getInternalOrgId()));
        if (vo.getIsOldCust() == 0 && !ObjectUtils.isEmpty((Object)vo.getCustBookId())) {
            vo.setCustBookName(bookMap.get(vo.getCustBookId()));
        }
        if (vo.getIsNeedPartner() == 0 && !ObjectUtils.isEmpty((Object)vo.getCoopBookId())) {
            vo.setCoopBookName(bookMap.get(vo.getCoopBookId()));
        }
    }

    void getIdDatas(Set<Long> userIds, Set<Long> orgIds, Set<Long> bookIds, CrmOpportunityVO vo) {
        HashSet<Long> users = new HashSet<Long>();
        users.add(vo.getManageUserId());
        users.add(vo.getPreSaleUserId());
        users.add(vo.getDeliUserId());
        users.add(vo.getCoUserId());
        users.add(vo.getCodeliUserId());
        users.add(vo.getInternalUserId());
        users.add(vo.getCreateUserId());
        userIds.addAll(users);
        HashSet<Long> orgs = new HashSet<Long>();
        orgs.add(vo.getOrgId());
        orgs.add(vo.getPreSaleOrgId());
        orgs.add(vo.getDeliOrgId());
        orgs.add(vo.getCoOrgId());
        orgs.add(vo.getCodeliOrgId());
        orgs.add(vo.getInternalOrgId());
        orgIds.addAll(orgs);
        HashSet<Long> books = new HashSet<Long>();
        if (vo.getIsOldCust() == 0 && !ObjectUtils.isEmpty((Object)vo.getCustBookId())) {
            books.add(vo.getCustBookId());
        }
        if (vo.getIsNeedPartner() == 0 && !ObjectUtils.isEmpty((Object)vo.getCoopBookId())) {
            books.add(vo.getCoopBookId());
        }
        bookIds.addAll(books);
    }

    void transferSystemSelection(CrmOpportunityVO vo) {
        vo.setProjectStatusName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.FlowStatus.getCode(), vo.getProjectStatus()));
        vo.setCustRegionName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmCustRegion.getCode(), vo.getCustRegion()));
        vo.setCustPropName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmCustProp.getCode(), vo.getCustProp()));
        vo.setCustIdstName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmCustomerIndustry.getCode(), vo.getCustIdst()));
        vo.setProbabilityName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmProbability.getCode(), vo.getProbability()));
        vo.setCurrCodeName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.SystemCurrCode.getCode(), vo.getCurrCode()));
        vo.setSalePhaseName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmSalePhase.getCode(), vo.getSalePhase()));
        vo.setOppoLevelName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmOppoLevel.getCode(), vo.getOppoLevel()));
        vo.setProjectDifficultName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmOppoDifficult.getCode(), vo.getProjectDifficult()));
        vo.setProjectImportanceName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmOppoImportance.getCode(), vo.getProjectImportance()));
        vo.setSolutionDifficultyName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmOppoDifficult.getCode(), vo.getSolutionDifficulty()));
        vo.setSolutionImportanceName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmOppoImportance.getCode(), vo.getSolutionImportance()));
        vo.setLoseReasonName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmOppoLoseReson.getCode(), vo.getLoseReason()));
        vo.setCloseReasonName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmOppoCloseReson.getCode(), vo.getCloseReason()));
    }

    public void downloadBatch(HttpServletResponse response, CrmOpportunityQuery query) throws IOException {
        if (query.getProjectStatusType() == null) {
            query.setProjectStatusType("0");
        }
        String sheetName = "\u5546\u673a\u6570\u636e";
        PagingVO<CrmOpportunityVO> paging = this.paging(query);
        List records = paging.getRecords();
        int order = 1;
        for (CrmOpportunityVO record : records) {
            record.setOrder(String.valueOf(order));
            record.setForecastWinDateStr(String.valueOf(record.getForecastWinDate()));
            Integer isNeedPartner = record.getIsNeedPartner();
            String isNeedPartnerStr = isNeedPartner == null ? "\u5426" : (isNeedPartner == 0 ? "\u662f" : "\u5426");
            record.setIsNeedPartnerStr(isNeedPartnerStr);
            record.setSourceType(record.getSourceType() == null ? null : (record.getSourceType().equals("inside") ? "\u5185\u90e8" : "\u5916\u90e8"));
            List memberVOS = record.getMemberVOS();
            if (memberVOS != null && !memberVOS.isEmpty()) {
                List collect = memberVOS.stream().map(e -> e.getEmployeeName()).collect(Collectors.toList());
                String members = String.join((CharSequence)",", collect);
                record.setMembers(members);
            }
            ++order;
        }
        List resultList = CrmOpportunityConvert.INSTANCE.voListVoExcelExport(records);
        resultList = this.udcUtil.translateList(resultList);
        String fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
        ExcelWriterSheetBuilder sheet = ((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), CrmOpportunityExcelExport.class).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).sheet(sheetName);
        com.elitesland.tw.tw5.server.common.excel.ExcelUtil.excelHelper(sheet, CrmOpportunityExcelExport.class, null);
        sheet.doWrite(resultList);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public Map<String, Object> bindCustomer(Long id) {
        Boolean isNewCust = false;
        CrmOpportunityVO crmOpportunityVO = this.dao.queryByKey(id);
        String customerName = crmOpportunityVO.getCustBookName();
        Long custBookId = crmOpportunityVO.getCustBookId();
        Integer isOldCust = crmOpportunityVO.getIsOldCust();
        int num = this.crmCustomerDAO.countByName(customerName);
        CrmOpportunityPayload opportunityPayload = new CrmOpportunityPayload();
        opportunityPayload.setId(id);
        if (num > 0 || isOldCust == 0) {
            List<CrmCustomerDO> customerDOS = this.crmCustomerDAO.findByName(customerName);
            if (num > 0) {
                opportunityPayload.setFormalCustomerId(customerDOS.get(0).getId());
            } else {
                Long customerId = this.crmCustomerDAO.queryIdByBookId(custBookId);
                opportunityPayload.setFormalCustomerId(customerId);
            }
        } else {
            CrmCustomerPayload customerPayload = new CrmCustomerPayload();
            customerPayload.setCustomerName(customerName);
            customerPayload.setCompanyIndustry(crmOpportunityVO.getCustIdst());
            customerPayload.setCompanyPhone(crmOpportunityVO.getContactPhone());
            customerPayload.setCustomerStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
            try {
                CrmCustomerVO insert = this.customerService.insert(customerPayload);
                opportunityPayload.setFormalCustomerId(insert.getId());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            isNewCust = true;
        }
        if (opportunityPayload.getFormalCustomerId() != null) {
            this.dao.updateByKeyDynamic(opportunityPayload);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("isNewCust", isNewCust);
        return result;
    }

    public Map<String, Object> bindCustomers() {
        List<Long> notBindOppos = this.dao.findNotBindOppos();
        int i = 0;
        for (Long notBindOppo : notBindOppos) {
            if (++i > 1000) break;
            this.bindCustomer(notBindOppo);
        }
        List<Long> notBindOppos1 = this.dao.findNotBindOppos();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("restNum", notBindOppos1 == null ? 0 : notBindOppos1.size());
        return new HashMap<String, Object>();
    }

    public Long getIdByV4(Long oppoIdV4) {
        return this.dao.getIdByV4(oppoIdV4);
    }

    @Transactional(rollbackFor={Exception.class})
    public String yeedocGetUri(Long id) {
        CrmOpportunityVO opportunityVO = this.dao.queryByKey(id);
        Assert.notNull((Object)opportunityVO.getId(), (String)"\u5546\u673a\u4e0d\u5b58\u5728\uff01");
        String itemIdDb = opportunityVO.getItemId();
        if (org.springframework.util.StringUtils.hasText((String)itemIdDb)) {
            String preViewItemStr = this.yeedocService.preViewItem(itemIdDb);
            if (StringUtils.isEmpty((CharSequence)preViewItemStr)) {
                log.error("\u6613\u9053\u58f3\u8fd4\u56de\u94fe\u63a5\u4e3a\u7a7a,docItemId:{}", (Object)itemIdDb);
                throw TwException.error("", "\u6613\u9053\u58f3\u8fd4\u56de\u94fe\u63a5\u4e3a\u7a7a\uff01");
            }
            JSONObject resultJson = JSONObject.parseObject((String)preViewItemStr);
            Object data = resultJson.get((Object)"value");
            if (ObjectUtils.isEmpty((Object)data)) {
                throw TwException.error("", "\u6613\u9053\u58f3\u8fd4\u56de\u94fe\u63a5\u4e3a\u7a7a\uff01");
            }
            String prewUri = (String)data;
            return prewUri;
        }
        String folderName = opportunityVO.getProjectName() + "+" + opportunityVO.getProjectNo();
        ArrayList<String> pathArr = new ArrayList<String>();
        pathArr.add("/" + folderName);
        CreateFolderDTO createFolderDTO = CreateFolderDTO.builder().libraryId(this.yeedocProperties.getOppoFolder().getLibraryId()).itemId(this.yeedocProperties.getOppoFolder().getItemId()).permissionLevel(this.yeedocProperties.getOppoFolder().getPermissionLevel()).pathArry(pathArr).isInheritance(false).build();
        String resultStr = this.yeedocService.createFolder(createFolderDTO);
        if (StringUtils.isEmpty((CharSequence)resultStr)) {
            throw TwException.error("", "\u6613\u9053\u58f3\u8fd4\u56de\u4e3a\u7a7a\uff01");
        }
        String itemId = this.getItemId(resultStr);
        if (!org.springframework.util.StringUtils.hasText((String)itemId)) {
            throw TwException.error("", "\u6613\u9053\u58f3\u521b\u5efa\u6587\u4ef6\u5939\u5931\u8d25\uff01");
        }
        String permissionsStr = this.yeedocService.setPermission(itemId, this.yeedocProperties.getOppoFolder().getPermissionLevel());
        if (StringUtils.isEmpty((CharSequence)permissionsStr)) {
            log.error("\u6613\u9053\u58f3\u8d4b\u6743\u5931\u8d25! permissionsStr:{} ;docItemId:{}", (Object)permissionsStr, (Object)itemId);
            throw TwException.error("", "\u6613\u9053\u58f3\u8d4b\u6743\u5931\u8d25\uff01");
        }
        if ((Integer)JSONObject.parseObject((String)permissionsStr).get((Object)"statusCode") != 200) {
            log.error("\u6613\u9053\u58f3\u8d4b\u6743\u5931\u8d25! permissionsStr:{} ;docItemId:{}", (Object)permissionsStr, (Object)itemId);
            throw TwException.error("", "\u6613\u9053\u58f3\u8d4b\u6743\u5931\u8d25\uff01");
        }
        String preViewItemStr = this.yeedocService.preViewItem(itemId);
        if (StringUtils.isEmpty((CharSequence)preViewItemStr)) {
            log.error("\u6613\u9053\u58f3\u8fd4\u56de\u94fe\u63a5\u4e3a\u7a7a,docItemId:{}", (Object)itemId);
            throw TwException.error("", "\u6613\u9053\u58f3\u8fd4\u56de\u94fe\u63a5\u4e3a\u7a7a\uff01");
        }
        JSONObject resultJson = JSONObject.parseObject((String)preViewItemStr);
        Object data = resultJson.get((Object)"value");
        if (ObjectUtils.isEmpty((Object)data)) {
            throw TwException.error("", "\u6613\u9053\u58f3\u8fd4\u56de\u94fe\u63a5\u4e3a\u7a7a\uff01");
        }
        String prewUri = (String)data;
        CrmOpportunityPayload opportunityPayload = new CrmOpportunityPayload();
        opportunityPayload.setId(opportunityVO.getId());
        opportunityPayload.setItemId(itemId);
        this.dao.updateByKeyDynamic(opportunityPayload);
        return prewUri;
    }

    private String getItemId(String resultStr) {
        Object data = null;
        try {
            JSONObject resultJson = JSONObject.parseObject((String)resultStr);
            data = resultJson.get((Object)"data");
        }
        catch (Exception e) {
            log.error("\u6613\u9053\u58f3\u521b\u5efa\u6587\u4ef6\u5939\u5931\u8d25!resultStr = {" + resultStr + "}", (Throwable)e);
        }
        if (ObjectUtils.isEmpty((Object)data)) {
            throw TwException.error("", "\u6613\u9053\u58f3\u521b\u5efa\u6587\u4ef6\u5939\u5931\u8d25\uff01");
        }
        JSONArray arrayDate = JSONArray.parseArray((String)data.toString());
        String itemId = "";
        for (int i = 0; i < arrayDate.size(); ++i) {
            JSONObject jsonObject = JSONObject.parseObject((String)arrayDate.get(i).toString());
            itemId = (String)jsonObject.get((Object)"itemId");
        }
        return itemId;
    }

    public void deleteSoft(Long id) {
        this.dao.deleteSoft(id);
    }

    public Map<Long, Long> getV4AndV5OppoIds() {
        HashMap<Long, Long> oppoMap = new HashMap<Long, Long>();
        List<Map<String, Object>> v4AndV5OppoIds = this.dao.getV4AndV5OppoIds();
        for (Map<String, Object> v4AndV5OppoId : v4AndV5OppoIds) {
            Long oppoId = (Long)v4AndV5OppoId.get("oppoId");
            Long oppoIdV4 = (Long)v4AndV5OppoId.get("oppoIdV4");
            oppoMap.put(oppoIdV4, oppoId);
        }
        return oppoMap;
    }

    public List<CrmActProjectVO> queryListByCustomId(Long customId) {
        return this.dao.queryListByCustomId(customId);
    }

    public CrmOpportunityServiceImpl(CacheUtil cacheUtil, PrjProjectDAO projectDAO, CrmOpportunityDAO dao, CrmOpportunityRepo repo, CrmActActivityDAO activityDAO, PrdOrgEmployeeDAO employeeDAO, PrdOrgOrganizationDAO orgOrganizationDAO, CrmFollowService followService, PrdSystemLogService logService, TransferUtilServiceImpl transferUtilService, HttpUtil httpUtil, ExcelUtil excelUtil, PrdSystemRoleDAO systemRoleDAO, CrmCustomerDAO crmCustomerDAO, CrmCustomerService customerService, PrdAbDAO abDAO, YeedocService yeedocService, YeedocProperties yeedocProperties, CrmLeadsDAO leadsDAO, UdcUtil udcUtil, ChangeFieldLogUtil changeFieldLogUtil) {
        this.cacheUtil = cacheUtil;
        this.projectDAO = projectDAO;
        this.dao = dao;
        this.repo = repo;
        this.activityDAO = activityDAO;
        this.employeeDAO = employeeDAO;
        this.orgOrganizationDAO = orgOrganizationDAO;
        this.followService = followService;
        this.logService = logService;
        this.transferUtilService = transferUtilService;
        this.httpUtil = httpUtil;
        this.excelUtil = excelUtil;
        this.systemRoleDAO = systemRoleDAO;
        this.crmCustomerDAO = crmCustomerDAO;
        this.customerService = customerService;
        this.abDAO = abDAO;
        this.yeedocService = yeedocService;
        this.yeedocProperties = yeedocProperties;
        this.leadsDAO = leadsDAO;
        this.udcUtil = udcUtil;
        this.changeFieldLogUtil = changeFieldLogUtil;
    }
}

