/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.service;

import com.elitescloud.cloudt.common.base.BaseModel;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.common.TwCommonPayload;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmPeoplePayload;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmPeopleWorkPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmCustomerOperationBusinessQuery;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmCustomerQuery;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmLeadsQuery;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOperationPlanDetailQuery;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmPeopleQuery;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmPeopleWorkQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmCustomerService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmLeadsService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmPeopleService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmPeopleWorkService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmFollowVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOperationPlanDetailVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmPeopleVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmPeopleWorkVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemLogVO;
import com.elitesland.tw.tw5.server.common.ExcelUtil;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.BusinessFollowServiceImpl;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.util.ChangeFieldLogUtil;
import com.elitesland.tw.tw5.server.common.util.DataUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemLogEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.SystemDefaultEnum;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmOperationPlanDetailConvert;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmPeopleConvert;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmCustomerOperationDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmPeopleDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmPeopleWorkDAO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmCustomerOperationDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmPeopleDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmCustomerOperationRepo;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmOperationPlanDetailRepo;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmPeopleRepo;
import com.elitesland.tw.tw5.server.prd.my.dao.PrdUserDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgOrganizationDO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import java.io.InputStream;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class CrmPeopleServiceImpl
implements CrmPeopleService {
    private static final Logger log = LoggerFactory.getLogger(CrmPeopleServiceImpl.class);
    private final CrmCustomerService customerService;
    private final CrmLeadsService leadsService;
    private final BusinessFollowServiceImpl globalUtilService;
    private final CrmPeopleRepo repo;
    private final CrmCustomerOperationRepo repoCustomerOperation;
    private final ChangeFieldLogUtil changeFieldLogUtil;
    private final CrmPeopleDAO dao;
    private final CrmPeopleWorkDAO peopleWorkDAO;
    private final CrmCustomerOperationDAO customerOperationDAO;
    private final CrmPeopleWorkService workService;
    private final PrdSystemLogService logService;
    private final CacheUtil cacheUtil;
    private final CrmOperationPlanDetailRepo repoOperationPlanDetail;
    private final TransactionUtilService transactionUtilService;
    private final ExcelUtil excelUtil;
    private final PrdUserDAO daoUser;
    private final PrdSystemRoleDAO systemRoleDAO;
    private final PrdOrgOrganizationDAO prdOrgOrganizationDAO;

    @Transactional(rollbackFor={Exception.class})
    public CrmPeopleVO insertOrUpdate(CrmPeoplePayload payload) {
        this.check(payload);
        CrmPeopleDO entityDo = CrmPeopleConvert.INSTANCE.toDo(payload);
        String name = PrdSystemLogEnum.UPDATE.getDesc();
        if (ObjectUtils.isEmpty((Object)payload.getId())) {
            name = PrdSystemLogEnum.CREATE.getDesc();
            entityDo.setLoveLevel(0);
            entityDo.setPeopleStatus(SystemDefaultEnum.DefaultHrStatus.getCode());
            entityDo = (CrmPeopleDO)((Object)this.repo.save((Object)entityDo));
            String fieldsCreateLog = this.changeFieldLogUtil.getFieldsCreateLog(entityDo);
            this.logService.saveNewLog(entityDo.getId(), PrdSystemObjectEnum.CUSTOMER_OPERATION_PEOPLE.getCode(), fieldsCreateLog);
            this.savePeople(entityDo);
        } else {
            CrmPeopleDO peopleDO = this.dao.findByIdAndDeleteFlag(payload.getId());
            if (!ObjectUtils.isEmpty((Object)((Object)peopleDO))) {
                CrmPeopleDO entityLog = new CrmPeopleDO();
                BeanUtils.copyProperties((Object)((Object)peopleDO), (Object)((Object)entityLog));
                peopleDO.copy(entityDo);
                StringBuilder fieldsUpdateLog = this.changeFieldLogUtil.nullFieldsProcess((TwCommonPayload)payload, entityLog, peopleDO);
                this.repo.save((Object)peopleDO);
                fieldsUpdateLog.append(this.changeFieldLogUtil.getFieldsUpdateLog(entityDo, entityLog));
                if (StringUtils.hasText((CharSequence)fieldsUpdateLog)) {
                    this.logService.saveNewLog(entityDo.getId(), PrdSystemObjectEnum.CUSTOMER_OPERATION_PEOPLE.getCode(), fieldsUpdateLog.toString());
                }
            } else {
                throw TwException.error("", "\u66f4\u65b0\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
        }
        if (!ObjectUtils.isEmpty((Object)payload.getOperId())) {
            this.logService.saveNewLog(entityDo.getOperId(), PrdSystemObjectEnum.CUSTOMER_OPERATION.getCode(), name + PrdSystemObjectEnum.CUSTOMER_OPERATION_PEOPLE.getDesc());
        }
        return CrmPeopleConvert.INSTANCE.toVo(entityDo);
    }

    public CrmPeopleVO queryByKey(Long key) {
        CrmPeopleVO crmPeopleVO = this.dao.queryByKey(key);
        this.transferData(crmPeopleVO);
        return crmPeopleVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateLoveLevel(Long key, Integer level) {
        if (level > 5) {
            throw TwException.error("", "\u63d0\u4ea4\u6570\u636e\u9519\u8bef\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        long loveLevel = this.dao.updateLoveLevel(key, level);
        if (loveLevel == 0L) {
            throw TwException.error("", "\u63d0\u4ea4\u6570\u636e\u9519\u8bef\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
    }

    public List<CrmPeopleVO> queryList(Long operId) {
        CrmCustomerOperationDO entity = this.repoCustomerOperation.findById(operId).orElseGet(CrmCustomerOperationDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        List<CrmPeopleVO> peopleVOS = this.dao.queryList(operId, entity.getCustomerId());
        peopleVOS.forEach(peopleVO -> this.transferData((CrmPeopleVO)peopleVO));
        return peopleVOS;
    }

    public PagingVO<CrmPeopleVO> paging(CrmPeopleQuery query) {
        if (!ObjectUtils.isEmpty((Object)query.getOperId())) {
            CrmCustomerOperationDO entity = this.repoCustomerOperation.findById(query.getOperId()).orElseGet(CrmCustomerOperationDO::new);
            Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
            query.setCustomerId(entity.getCustomerId());
        }
        Boolean rolePermission = false;
        if (ObjectUtils.isEmpty((Object)query.getOperId()) && ObjectUtils.isEmpty((Object)query.getCustomerId())) {
            rolePermission = this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.PLATFORM_RES.getCode(), RoleEnum.CUST_OPER_MANAGER.getCode()));
            if (!rolePermission.booleanValue()) {
                this.updateQuery(query);
            }
        } else {
            rolePermission = true;
        }
        query.setNoPermissionFlag(rolePermission);
        PagingVO<CrmPeopleVO> paging = this.dao.paging(query);
        paging.getRecords().forEach(peopleVO -> this.transferData((CrmPeopleVO)peopleVO));
        return paging;
    }

    public List<Long> queryPermitOperationIds(Long userId) {
        List<PrdOrgEmployeeRefVO> empRef = this.daoUser.queryLowListByKey(null, userId);
        Set<Long> empRefUserIdList = empRef.stream().map(prdOrgEmployeeRefVO -> prdOrgEmployeeRefVO.getUserId()).collect(Collectors.toSet());
        List<PrdOrgOrganizationDO> organizationDOList = this.prdOrgOrganizationDAO.queryByManagerId(userId);
        Set orgIdList = null;
        if (!CollectionUtils.isEmpty(organizationDOList)) {
            orgIdList = organizationDOList.stream().map(BaseModel::getId).collect(Collectors.toSet());
        }
        return this.dao.queryOperationIds(userId, empRefUserIdList, orgIdList);
    }

    void updateQuery(CrmPeopleQuery query) {
        Long userId = GlobalUtil.getLoginUserId();
        List<Long> operationIds = this.queryPermitOperationIds(userId);
        CrmCustomerQuery queryCustomer = new CrmCustomerQuery();
        this.customerService.operPermissionFlag(queryCustomer);
        List<Long> customerIds = this.dao.queryCustomerIds(queryCustomer);
        operationIds.removeAll(Collections.singleton(null));
        Set<Long> longs = this.repo.queryByOperIds(operationIds);
        longs.removeAll(Collections.singleton(null));
        longs.addAll(customerIds);
        query.setOperIds(operationIds);
        query.setCustomerIds(new ArrayList<Long>(longs));
        query.setCreateUserId(userId);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys, String type) {
        if (!keys.isEmpty()) {
            Long sourceId = null;
            String title = "";
            Optional optional = this.repo.findById(keys.get(0));
            if (!optional.isEmpty()) {
                CrmPeopleDO entity = (CrmPeopleDO)((Object)optional.get());
                if (!ObjectUtils.isEmpty((Object)entity.getCustomerId())) {
                    sourceId = entity.getCustomerId();
                    title = PrdSystemObjectEnum.Customer.getCode();
                }
                if (!ObjectUtils.isEmpty((Object)entity.getOperId())) {
                    sourceId = entity.getOperId();
                    title = PrdSystemObjectEnum.CUSTOMER_OPERATION.getCode();
                }
            }
            if (StringUtils.hasText((String)type) && "1".equals(type)) {
                this.dao.removeAllByIdIn(keys);
                this.peopleWorkDAO.updateWorkStatusByPeopleIds(keys);
            } else {
                this.dao.deleteByIdIn(keys);
            }
            if (sourceId != null) {
                this.logService.saveNewLog(sourceId, title, PrdSystemLogEnum.DELETE.getDesc() + PrdSystemObjectEnum.CUSTOMER_OPERATION_PEOPLE.getDesc());
            }
        }
    }

    public void deleteSoftByOperIds(List<Long> operIds) {
        List<CrmPeopleVO> crmPeopleVOS = this.dao.queryListByOperIds(operIds);
        if (crmPeopleVOS.size() > 0) {
            ArrayList<Long> delIds = new ArrayList<Long>();
            ArrayList<Long> removeIds = new ArrayList<Long>();
            for (CrmPeopleVO crmPeopleVO : crmPeopleVOS) {
                if (crmPeopleVO.getCustomerId() != null) {
                    removeIds.add(crmPeopleVO.getId());
                    continue;
                }
                delIds.add(crmPeopleVO.getId());
            }
            if (removeIds.size() > 0) {
                this.dao.removeOperByIdIn(removeIds);
            }
            if (delIds.size() > 0) {
                this.dao.removeAllByIdIn(delIds);
                this.peopleWorkDAO.updateWorkStatusByPeopleIds(delIds);
            }
        }
    }

    public List<CrmPeopleVO> queryRefPeopleList(Long key, String searchStr, String type) {
        CrmPeopleVO crmPeopleVO = this.dao.queryByKey(key);
        List<Object> vos = new ArrayList();
        if ("1".equals(type) && StringUtils.hasText((String)crmPeopleVO.getIndustry())) {
            vos = this.dao.queryPeopleVOType1(crmPeopleVO.getId(), crmPeopleVO.getIndustry(), searchStr);
        }
        if ("2".equals(type) && (crmPeopleVO.getOperId() != null || crmPeopleVO.getCustomerId() != null || StringUtils.hasText((String)crmPeopleVO.getCompanyName()))) {
            vos = this.dao.queryPeopleVOType2(crmPeopleVO.getId(), crmPeopleVO.getOperId(), crmPeopleVO.getCustomerId(), crmPeopleVO.getCompanyName(), searchStr);
        }
        if ("3".equals(type)) {
            ArrayList<Long> customerIds = new ArrayList<Long>();
            ArrayList<String> companyNames = new ArrayList<String>();
            this.queryOldWork(key, customerIds, companyNames);
            if (customerIds.size() > 0 || companyNames.size() > 0) {
                vos = this.dao.queryPeopleVOType3(crmPeopleVO.getId(), customerIds, companyNames, searchStr);
            }
        }
        vos.forEach(peopleVO -> this.transferData((CrmPeopleVO)peopleVO));
        return vos;
    }

    public List<CrmFollowVO> queryOperateFollowList(Long peopleId) {
        CrmPeopleVO crmPeopleVO = this.dao.queryByKey(peopleId);
        if (!ObjectUtils.isEmpty((Object)crmPeopleVO.getCustomerId())) {
            List crmFollowVOS = this.customerService.queryFollowList(crmPeopleVO.getCustomerId(), Boolean.valueOf(true));
            return crmFollowVOS;
        }
        return null;
    }

    public void relationCustomer(Long operId, Long customerId) {
        List<Long> peopleIds = this.dao.findByOperIdAndDeleteFlag(operId);
        this.dao.relationCustomer(peopleIds, customerId);
        this.peopleWorkDAO.updateCustomerIdByPeopleIds(peopleIds, customerId);
    }

    public Object queryBusinessFollowPaging(CrmCustomerOperationBusinessQuery query) {
        Map<String, Object> resultData = new Map<String, Object>();
        CrmPeopleVO crmPeopleVO = this.dao.queryByKey(query.getId());
        this.checkeRelation(crmPeopleVO);
        if ("1".equals(query.getBusinessType())) {
            resultData = this.globalUtilService.queryContractFollow((TwQueryParam)query, crmPeopleVO.getCustomerId());
        }
        if ("2".equals(query.getBusinessType())) {
            resultData = this.globalUtilService.queryOppoFollow((TwQueryParam)query, crmPeopleVO.getCustomerId());
        }
        if ("3".equals(query.getBusinessType())) {
            resultData = this.globalUtilService.queryLeadsFollow((TwQueryParam)query, crmPeopleVO.getCustomerId());
        }
        return resultData;
    }

    public List<PrdSystemLogVO> queryLogList(Long id) {
        return this.logService.queryLogList(id, PrdSystemObjectEnum.CUSTOMER_OPERATION_PEOPLE.getCode());
    }

    public Object queryPeopleView(Long peopleId) {
        CrmPeopleVO crmPeopleVO = this.dao.queryByKey(peopleId);
        if (crmPeopleVO == null) {
            throw TwException.error("", "\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        long peopleCount = this.queryPeopleCount(crmPeopleVO);
        Object contractCount = 0L;
        long opportunityCount = 0L;
        long leadsCount = 0L;
        if (crmPeopleVO.getCustomerId() != null) {
            CrmLeadsQuery leadsQuery = new CrmLeadsQuery();
            leadsQuery.setFormalCustomerId(crmPeopleVO.getCustomerId());
            leadsQuery.setIsPermission(Boolean.valueOf(false));
            PagingVO leadsPagingVO = this.leadsService.paging(leadsQuery);
            leadsCount = leadsPagingVO.getTotal();
            contractCount = this.globalUtilService.queryContractNum(crmPeopleVO.getCustomerId());
            opportunityCount = this.customerOperationDAO.queryOpportunityCount(crmPeopleVO.getCustomerId());
        }
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("contractCount", (Long)contractCount);
        map.put("leadsCount", leadsCount);
        map.put("opportunityCount", opportunityCount);
        map.put("peopleCount", peopleCount);
        return map;
    }

    public List<CrmOperationPlanDetailVO> queryOperationPlanDetailList(Long peopleId) {
        CrmOperationPlanDetailQuery query = new CrmOperationPlanDetailQuery();
        query.setExt1("" + peopleId);
        OrderItem orderItem = OrderItem.desc((String)"createTime");
        query.defaultOrder(orderItem);
        return CrmOperationPlanDetailConvert.INSTANCE.toVoList(this.repoOperationPlanDetail.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder)));
    }

    public void downloadBatch(HttpServletResponse response, CrmPeopleQuery query) {
        ClassPathResource classPathResource = new ClassPathResource("template/crmPeopleBatch.xlsx");
        List<CrmPeopleVO> vos = null;
        if (query.getPeopleIds() != null && query.getPeopleIds().length > 0) {
            vos = this.dao.queryListByKeys(Arrays.asList(query.getPeopleIds()));
            vos.forEach(peopleVO -> this.transferData((CrmPeopleVO)peopleVO));
        } else {
            vos = this.paging(query).getRecords();
        }
        try {
            InputStream inputStream = classPathResource.getInputStream();
            Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
            XSSFSheet batchProjectSheet = (XSSFSheet)workbook.getSheet("\u4eba\u8109\u6570\u636e");
            if (vos.size() > 0) {
                int nextRow = 1;
                for (CrmPeopleVO dataPayload : vos) {
                    XSSFRow row = batchProjectSheet.createRow(nextRow);
                    this.excelUtil.setCellValue((Row)row, 0, nextRow);
                    this.excelUtil.setCellValue((Row)row, 1, dataPayload.getPeopleName());
                    this.excelUtil.setCellValue((Row)row, 2, dataPayload.getCompanyName());
                    this.excelUtil.setCellValue((Row)row, 3, dataPayload.getJobs());
                    this.excelUtil.setCellValue((Row)row, 4, dataPayload.getSexName());
                    this.excelUtil.setCellValue((Row)row, 5, dataPayload.getEmail());
                    this.excelUtil.setCellValue((Row)row, 6, dataPayload.getMobile());
                    this.excelUtil.setCellValue((Row)row, 7, dataPayload.getWeChat());
                    this.excelUtil.setCellValue((Row)row, 8, dataPayload.getBirthplace());
                    this.excelUtil.setCellValue((Row)row, 9, dataPayload.getBirthday());
                    this.excelUtil.setCellValue((Row)row, 10, dataPayload.getLocationDetail());
                    this.excelUtil.setCellValue((Row)row, 11, dataPayload.getTags());
                    this.excelUtil.setCellValue((Row)row, 12, dataPayload.getSocialIdentity());
                    this.excelUtil.setCellValue((Row)row, 13, dataPayload.getMarital());
                    this.excelUtil.setCellValue((Row)row, 14, dataPayload.getBu());
                    this.excelUtil.setCellValue((Row)row, 15, dataPayload.getJobDetail());
                    this.excelUtil.setCellValue((Row)row, 16, dataPayload.getIndustryDesc());
                    this.excelUtil.setCellValue((Row)row, 17, dataPayload.getIndustryInfluence());
                    this.excelUtil.setCellValue((Row)row, 18, dataPayload.getSpouseJobs());
                    this.excelUtil.setCellValue((Row)row, 19, dataPayload.getChildAge());
                    this.excelUtil.setCellValue((Row)row, 20, dataPayload.getParentHealth());
                    this.excelUtil.setCellValue((Row)row, 21, dataPayload.getParentHabitation());
                    this.excelUtil.setCellValue((Row)row, 22, dataPayload.getPeopleStatusDesc());
                    this.excelUtil.setCellValue((Row)row, 23, dataPayload.getCreateTime());
                    ++nextRow;
                }
            }
            String fileName = "\u4eba\u8109\u6570\u636e-" + LocalDate.now();
            ExcelUtil.writeResponse(response, fileName, workbook);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    long queryPeopleCount(CrmPeopleVO crmPeopleVO) {
        List<Object> ids1 = new ArrayList();
        if (crmPeopleVO.getOperId() != null || crmPeopleVO.getCustomerId() != null || StringUtils.hasText((String)crmPeopleVO.getCompanyName()) || crmPeopleVO.getIndustry() != null) {
            ids1 = this.dao.queryPeopleIds1(crmPeopleVO.getId(), crmPeopleVO.getOperId(), crmPeopleVO.getCustomerId(), crmPeopleVO.getCompanyName(), crmPeopleVO.getIndustry());
        }
        ArrayList<Long> customerIds = new ArrayList<Long>();
        ArrayList<String> companyNames = new ArrayList<String>();
        this.queryOldWork(crmPeopleVO.getId(), customerIds, companyNames);
        List<Object> ids2 = new ArrayList();
        if (customerIds.size() > 0 || companyNames.size() > 0) {
            ids2 = this.dao.queryPeopleIds2(crmPeopleVO.getId(), customerIds, companyNames);
        }
        HashSet ids = new HashSet();
        ids.addAll(ids1);
        ids.addAll(ids2);
        return ids.size();
    }

    void queryOldWork(Long peopleId, List<Long> customerIds, List<String> companyNames) {
        CrmPeopleWorkQuery query = new CrmPeopleWorkQuery();
        query.setPeopleId(peopleId);
        query.setWorkStatus("0");
        List<CrmPeopleWorkVO> peopleWorkVOS = this.peopleWorkDAO.queryList(query);
        peopleWorkVOS.forEach(peopleWorkVO -> {
            if (!ObjectUtils.isEmpty((Object)peopleWorkVO.getCustomerId())) {
                customerIds.add(peopleWorkVO.getCustomerId());
            }
            if (StringUtils.hasText((String)peopleWorkVO.getCompanyName())) {
                companyNames.add(peopleWorkVO.getCompanyName());
            }
        });
    }

    private void check(CrmPeoplePayload payload) {
        if (null == payload.getPeopleName()) {
            throw TwException.error("", "\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
    }

    void savePeople(CrmPeopleDO entityDo) {
        Long id = entityDo.getId();
        this.transactionUtilService.executeWithCallable(() -> {
            CrmPeopleVO crmPeopleVO = this.dao.queryByKey(id);
            CrmPeopleWorkPayload workPayload = new CrmPeopleWorkPayload();
            workPayload.setCompanyName(crmPeopleVO.getCompanyName());
            if (StringUtils.hasText((String)crmPeopleVO.getOperationName())) {
                workPayload.setCompanyName(crmPeopleVO.getOperationName());
            }
            if (StringUtils.hasText((String)crmPeopleVO.getCustomerName())) {
                workPayload.setCompanyName(crmPeopleVO.getCustomerName());
            }
            String custType = "enterprise";
            if (StringUtils.hasText((String)crmPeopleVO.getCustType())) {
                custType = crmPeopleVO.getCustType();
            }
            workPayload.setPeopleId(id);
            workPayload.setCustomerId(crmPeopleVO.getCustomerId());
            workPayload.setCustType(custType);
            workPayload.setWorkStatus("1");
            workPayload.setJobs(crmPeopleVO.getJobs());
            workPayload.setIsInitia(Boolean.valueOf(true));
            this.workService.insertOrUpdate(workPayload);
            return null;
        });
    }

    void checkeRelation(CrmPeopleVO crmPeopleVO) {
        if (ObjectUtils.isEmpty((Object)crmPeopleVO)) {
            throw TwException.error("", "\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (crmPeopleVO.getCustomerId() == null) {
            throw TwException.error("", "\u6682\u672a\u5173\u8054\u5ba2\u6237\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
    }

    void transferData(CrmPeopleVO vo) {
        vo.setSexName(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.EmployeeSex.getCode(), vo.getSex()));
        Map<String, String> map = DataUtil.getConstellation(vo.getBirthday());
        vo.setAge(map.get("age"));
        vo.setCsonstel(map.get("csonste"));
        vo.setDayOfMonth(map.get("dayOfMonth"));
        vo.setIndustryDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmCustomerIndustry.getCode(), vo.getIndustry()));
        if (StringUtils.hasText((String)vo.getOperationName())) {
            vo.setCompanyName(vo.getOperationName());
        }
        if (StringUtils.hasText((String)vo.getCustomerName())) {
            vo.setCompanyName(vo.getCustomerName());
        }
        vo.setPeopleStatusDesc(this.cacheUtil.transferSystemSelection(FunctionSelectionEnum.SystemStatus.getCode(), vo.getPeopleStatus()));
    }

    public CrmPeopleServiceImpl(CrmCustomerService customerService, CrmLeadsService leadsService, BusinessFollowServiceImpl globalUtilService, CrmPeopleRepo repo, CrmCustomerOperationRepo repoCustomerOperation, ChangeFieldLogUtil changeFieldLogUtil, CrmPeopleDAO dao, CrmPeopleWorkDAO peopleWorkDAO, CrmCustomerOperationDAO customerOperationDAO, CrmPeopleWorkService workService, PrdSystemLogService logService, CacheUtil cacheUtil, CrmOperationPlanDetailRepo repoOperationPlanDetail, TransactionUtilService transactionUtilService, ExcelUtil excelUtil, PrdUserDAO daoUser, PrdSystemRoleDAO systemRoleDAO, PrdOrgOrganizationDAO prdOrgOrganizationDAO) {
        this.customerService = customerService;
        this.leadsService = leadsService;
        this.globalUtilService = globalUtilService;
        this.repo = repo;
        this.repoCustomerOperation = repoCustomerOperation;
        this.changeFieldLogUtil = changeFieldLogUtil;
        this.dao = dao;
        this.peopleWorkDAO = peopleWorkDAO;
        this.customerOperationDAO = customerOperationDAO;
        this.workService = workService;
        this.logService = logService;
        this.cacheUtil = cacheUtil;
        this.repoOperationPlanDetail = repoOperationPlanDetail;
        this.transactionUtilService = transactionUtilService;
        this.excelUtil = excelUtil;
        this.daoUser = daoUser;
        this.systemRoleDAO = systemRoleDAO;
        this.prdOrgOrganizationDAO = prdOrgOrganizationDAO;
    }
}

