/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.service;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmPeopleWorkPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmPeopleWorkQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmPeopleWorkService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmPeopleVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmPeopleWorkVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemLogEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5.server.prd.crm.convert.CrmPeopleWorkConvert;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmPeopleDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmPeopleWorkDAO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmPeopleWorkDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmPeopleWorkRepo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class CrmPeopleWorkServiceImpl
implements CrmPeopleWorkService {
    private static final Logger log = LoggerFactory.getLogger(CrmPeopleWorkServiceImpl.class);
    private final CrmPeopleWorkRepo repo;
    private final CrmPeopleWorkDAO dao;
    private final CrmPeopleDAO daoPeople;
    private final PrdSystemLogService logService;
    private final CacheUtil cacheUtil;

    @Transactional(rollbackFor={Exception.class})
    public CrmPeopleWorkVO insertOrUpdate(CrmPeopleWorkPayload payload) {
        this.check(payload);
        CrmPeopleWorkDO peopleWorkDO = CrmPeopleWorkConvert.INSTANCE.toDo(payload);
        String name = PrdSystemLogEnum.CREATE.getDesc();
        if (!ObjectUtils.isEmpty((Object)payload.getId())) {
            CrmPeopleWorkVO peopleWorkVO;
            name = PrdSystemLogEnum.UPDATE.getDesc();
            if (!"1".equals(peopleWorkDO.getWorkStatus()) && "1".equals((peopleWorkVO = this.dao.queryByKey(payload.getId())).getWorkStatus())) {
                this.repo.updataPeopleClearRefById(payload.getPeopleId());
            }
        }
        if ((ObjectUtils.isEmpty((Object)payload.getIsInitia()) || !payload.getIsInitia().booleanValue()) && "1".equals(peopleWorkDO.getWorkStatus())) {
            if (peopleWorkDO.getCustomerId() == null) {
                CrmPeopleVO peopleVO = this.daoPeople.queryByKey(payload.getPeopleId());
                Long operId = peopleVO.getOperId();
                if (peopleVO.getOperId() != null && !peopleVO.getOperationName().equals(peopleWorkDO.getCompanyName())) {
                    operId = null;
                }
                this.repo.updataPeopleCustomerAndOperById(payload.getPeopleId(), peopleWorkDO.getCustomerId(), operId, peopleWorkDO.getCompanyName(), peopleWorkDO.getJobs());
            }
            this.repo.updataPeopleCustomerById(payload.getPeopleId(), peopleWorkDO.getCustomerId(), peopleWorkDO.getCompanyName(), peopleWorkDO.getJobs());
        }
        peopleWorkDO = (CrmPeopleWorkDO)((Object)this.repo.save((Object)peopleWorkDO));
        this.logService.saveNewLog(peopleWorkDO.getPeopleId(), PrdSystemObjectEnum.CUSTOMER_OPERATION_PEOPLE.getCode(), name + PrdSystemObjectEnum.CRM_PEOPLE_WORK.getDesc());
        return null;
    }

    public CrmPeopleWorkVO queryByKey(Long key) {
        CrmPeopleWorkVO peopleWorkVO = this.dao.queryByKey(key);
        this.transferData(peopleWorkVO);
        return peopleWorkVO;
    }

    public List<CrmPeopleWorkVO> queryList(CrmPeopleWorkQuery query) {
        List<CrmPeopleWorkVO> peopleWorkVOS = this.dao.queryList(query);
        peopleWorkVOS.forEach(peopleWorkVO -> this.transferData((CrmPeopleWorkVO)peopleWorkVO));
        return peopleWorkVOS;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        CrmPeopleWorkVO educateVO = this.dao.queryByKey(keys.get(0));
        if (!ObjectUtils.isEmpty((Object)educateVO)) {
            if ("1".equals(educateVO.getWorkStatus())) {
                throw TwException.error("", "\u5728\u804c\u5de5\u4f5c\u4e0d\u53ef\u5220\u9664\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            this.dao.deleteSoft(keys);
            this.logService.saveNewLog(educateVO.getPeopleId(), PrdSystemObjectEnum.CUSTOMER_OPERATION_PEOPLE.getCode(), PrdSystemLogEnum.DELETE.getDesc() + PrdSystemObjectEnum.CRM_PEOPLE_WORK.getDesc());
        }
    }

    void transferData(CrmPeopleWorkVO vo) {
        if (StringUtils.hasText((String)vo.getCustomerName())) {
            vo.setCompanyName(vo.getCustomerName());
        }
    }

    void check(CrmPeopleWorkPayload payload) {
        if (ObjectUtils.isEmpty((Object)payload.getPeopleId())) {
            throw TwException.error("", "\u5173\u8054\u4eba\u8109\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)payload.getCustomerId()) && ObjectUtils.isEmpty((Object)payload.getCompanyName())) {
            throw TwException.error("", "\u5173\u8054\u5ba2\u6237\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)payload.getCustType())) {
            throw TwException.error("", "\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)payload.getJobs())) {
            throw TwException.error("", "\u804c\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)payload.getWorkStatus())) {
            throw TwException.error("", "\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        CrmPeopleWorkQuery workQuery = CrmPeopleWorkConvert.INSTANCE.toQuery(payload);
        workQuery.setWorkStatus(null);
        List<CrmPeopleWorkVO> peopleWorkVOS = this.dao.queryList(workQuery);
        if (!ObjectUtils.isEmpty(peopleWorkVOS)) {
            throw TwException.error("", "\u8be5\u5de5\u4f5c\u7ecf\u5386\u5df2\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if ("1".equals(payload.getWorkStatus())) {
            CrmPeopleWorkQuery workQuery0 = new CrmPeopleWorkQuery();
            workQuery0.setId(payload.getId());
            workQuery0.setPeopleId(payload.getPeopleId());
            workQuery0.setWorkStatus("1");
            List<CrmPeopleWorkVO> peopleWorkVOS0 = this.dao.queryList(workQuery0);
            if (!ObjectUtils.isEmpty(peopleWorkVOS0)) {
                throw TwException.error("", "\u5df2\u5b58\u5728\u5728\u804c\u5de5\u4f5c\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
        }
    }

    public CrmPeopleWorkServiceImpl(CrmPeopleWorkRepo repo, CrmPeopleWorkDAO dao, CrmPeopleDAO daoPeople, PrdSystemLogService logService, CacheUtil cacheUtil) {
        this.repo = repo;
        this.dao = dao;
        this.daoPeople = daoPeople;
        this.logService = logService;
        this.cacheUtil = cacheUtil;
    }
}

