/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.my.controller;

import com.elitesland.tw.tw5.api.prd.my.payload.TaskPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TaskQuery;
import com.elitesland.tw.tw5.api.prd.my.service.TaskService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/my/task"})
public class TaskController {
    private static final Logger log = LoggerFactory.getLogger(TaskController.class);
    private final TaskService taskService;

    @PostMapping
    public TwOutputUtil insert(@RequestBody TaskPayload payload) {
        return TwOutputUtil.ok(this.taskService.insert(payload));
    }

    @PutMapping
    public TwOutputUtil update(@RequestBody TaskPayload payload) {
        return TwOutputUtil.ok(this.taskService.update(payload));
    }

    @GetMapping(value={"/updateTaskStatus"})
    public TwOutputUtil updateTaskStatus(Long taskId, String status) {
        return TwOutputUtil.ok(this.taskService.updateTaskStatus(taskId, status));
    }

    @GetMapping(value={"/updateTaskReason"})
    public TwOutputUtil updateTaskReason(Long taskId, String reasonType, Long reasonId, Long expenseBuId) {
        return TwOutputUtil.ok(this.taskService.updateTaskReason(taskId, reasonType, reasonId, expenseBuId));
    }

    @GetMapping(value={"/{key}"})
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(this.taskService.queryByKey(key));
    }

    @GetMapping(value={"/paging"})
    public TwOutputUtil paging(TaskQuery query) {
        return TwOutputUtil.ok(this.taskService.paging(query));
    }

    @GetMapping(value={"/list"})
    public TwOutputUtil queryList(TaskQuery query) {
        return TwOutputUtil.ok(this.taskService.queryList(query));
    }

    @GetMapping(value={"/listFortimesheet"})
    public TwOutputUtil selectTaskForTimesheet(Long projIdV4, boolean test) {
        if (null == projIdV4) {
            return TwOutputUtil.error("999", "\u7f3a\u5c11\u53c2\u6570", null);
        }
        TaskQuery query = new TaskQuery();
        List timesheetViews = this.taskService.selectTaskForTimesheet(query, projIdV4, test);
        return TwOutputUtil.ok(timesheetViews);
    }

    @DeleteMapping(value={"/deleteSoft"})
    public TwOutputUtil deleteSoft(Long[] keys) {
        this.taskService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    public TaskController(TaskService taskService) {
        this.taskService = taskService;
    }
}

