/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.my.controller;

import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetBiweeklyPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetBiweeklyQuery;
import com.elitesland.tw.tw5.api.prd.my.service.TimesheetBiweeklyService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/my/timesheetBiweekly"})
public class TimesheetBiweeklyController {
    private static final Logger log = LoggerFactory.getLogger(TimesheetBiweeklyController.class);
    private final TimesheetBiweeklyService timesheetBiweeklyService;

    @PostMapping
    public TwOutputUtil insert(@RequestBody TimesheetBiweeklyPayload payload) {
        return TwOutputUtil.ok(this.timesheetBiweeklyService.insert(payload));
    }

    @PutMapping
    public TwOutputUtil update(@RequestBody TimesheetBiweeklyPayload payload) {
        return TwOutputUtil.ok(this.timesheetBiweeklyService.update(payload));
    }

    @GetMapping(value={"/{key}"})
    @UdcNameClass
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(this.timesheetBiweeklyService.queryByKey(key));
    }

    @GetMapping(value={"/paging"})
    @UdcNameClass
    public TwOutputUtil paging(TimesheetBiweeklyQuery query) {
        Long loginUserId = GlobalUtil.getLoginUserId();
        query.setUserId(loginUserId);
        return TwOutputUtil.ok(this.timesheetBiweeklyService.paging(query));
    }

    @GetMapping(value={"/paging/my"})
    @UdcNameClass
    public TwOutputUtil pagingMy(TimesheetBiweeklyQuery query) {
        query.setCreateUserId(GlobalUtil.getLoginUserId());
        return TwOutputUtil.ok(this.timesheetBiweeklyService.paging(query));
    }

    @GetMapping(value={"/list"})
    @UdcNameClass
    public TwOutputUtil queryList(TimesheetBiweeklyQuery query) {
        query.setReceiveUserIds("" + GlobalUtil.getLoginUserId());
        return TwOutputUtil.ok(this.timesheetBiweeklyService.queryList(query));
    }

    @GetMapping(value={"/list/my"})
    @UdcNameClass
    public TwOutputUtil queryListMy(TimesheetBiweeklyQuery query) {
        query.setCreateUserId(GlobalUtil.getLoginUserId());
        return TwOutputUtil.ok(this.timesheetBiweeklyService.queryList(query));
    }

    @DeleteMapping(value={"/deleteSoft"})
    public TwOutputUtil deleteSoft(Long[] keys) {
        this.timesheetBiweeklyService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    public TimesheetBiweeklyController(TimesheetBiweeklyService timesheetBiweeklyService) {
        this.timesheetBiweeklyService = timesheetBiweeklyService;
    }
}

