/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.my.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.my.query.PrdUserMessageQuery;
import com.elitesland.tw.tw5.api.prd.my.vo.PrdUserMessageVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.my.entity.QPrdUserMessageDO;
import com.elitesland.tw.tw5.server.prd.my.repo.PrdUserMessageRepo;
import com.elitesland.tw.tw5.server.prd.system.entity.QPrdMessageConfigDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

@Repository
public class PrdUserMessageDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PrdUserMessageRepo repo;
    private final QPrdUserMessageDO qdo = QPrdUserMessageDO.prdUserMessageDO;
    private final QPrdMessageConfigDO qdoConfig = QPrdMessageConfigDO.prdMessageConfigDO;

    public Long queryTotal(Long userId) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo).from((EntityPath)this.qdo);
        jpaQuery.where((Predicate)this.qdo.messageStatus.eq((Object)0));
        jpaQuery.where((Predicate)this.qdo.userId.eq((Object)userId));
        return jpaQuery.fetchCount();
    }

    public long deleteSoft(List<Long> keys, Long userId) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.userId.eq((Object)userId)}).where(new Predicate[]{this.qdo.id.in(keys)});
        return update.execute();
    }

    private JPAQuery<PrdUserMessageVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PrdUserMessageVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.messageStatus, this.qdo.messageId, this.qdo.createSource, this.qdo.messageTitle, this.qdo.messageContent, this.qdo.noticeScope, this.qdo.noticeSource, this.qdo.contentType, this.qdo.contentBigType, this.qdo.messageTag, this.qdo.remark, this.qdo.createUserId, this.qdo.createTime})).from((EntityPath)this.qdo);
    }

    private JPAQuery<PrdUserMessageVO> getJpaQueryWhere(PrdUserMessageQuery query, Long userId) {
        JPAQuery<PrdUserMessageVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.userId.eq((Object)userId));
        if (!ObjectUtils.isEmpty((Object)query.getContentBigType())) {
            jpaQuery.where((Predicate)this.qdo.contentBigType.eq((Object)query.getContentBigType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getMessageStatus())) {
            jpaQuery.where((Predicate)this.qdo.messageStatus.eq((Object)query.getMessageStatus()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getMessageTitle())) {
            jpaQuery.where((Predicate)this.qdo.messageTitle.like(SqlUtil.toSqlLikeString(query.getMessageTitle())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getMessageContent())) {
            jpaQuery.where((Predicate)this.qdo.messageContent.like(SqlUtil.toSqlLikeString(query.getMessageContent())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getContentType())) {
            jpaQuery.where((Predicate)this.qdo.contentType.eq((Object)query.getContentType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getMessageTag())) {
            jpaQuery.where((Predicate)this.qdo.messageTag.eq((Object)query.getMessageTag()));
        }
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        ArrayList<OrderItem> orderse = new ArrayList<OrderItem>();
        orderse.add(OrderItem.asc((String)"messageStatus"));
        orderse.add(OrderItem.asc((String)"sortIndex"));
        orderse.add(OrderItem.desc((String)"createTime"));
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, orderse));
        return jpaQuery;
    }

    public PrdUserMessageVO queryByKey(Long id) {
        JPAQuery<PrdUserMessageVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        return (PrdUserMessageVO)jpaQuery.fetchFirst();
    }

    public long updateStatus(List<Long> keys, Long userId) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.messageStatus, (Object)1).where(new Predicate[]{this.qdo.userId.eq((Object)userId)}).where(new Predicate[]{this.qdo.id.in(keys)});
        return update.execute();
    }

    public PagingVO<PrdUserMessageVO> queryPaging(PrdUserMessageQuery query, Long userId) {
        JPAQuery<PrdUserMessageVO> jpaQuery = this.getJpaQueryWhere(query, userId);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(jpaQuery.fetchCount()).build();
    }

    public PrdUserMessageDAO(JPAQueryFactory jpaQueryFactory, PrdUserMessageRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

