/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.my.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.ResActivityPayload;
import com.elitesland.tw.tw5.api.prd.my.query.ResActivityQuery;
import com.elitesland.tw.tw5.api.prd.my.service.ResActivityService;
import com.elitesland.tw.tw5.api.prd.my.vo.ResActivityVO;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.util.FileUtil;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.prd.my.convert.ResActivityConvert;
import com.elitesland.tw.tw5.server.prd.my.entity.ResActivityDO;
import com.elitesland.tw.tw5.server.prd.my.repo.ResActivityRepo;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class ResActivityServiceImpl
implements ResActivityService {
    private static final Logger log = LoggerFactory.getLogger(ResActivityServiceImpl.class);
    private final ResActivityRepo resActivityRepo;

    public PagingVO<ResActivityVO> paging(ResActivityQuery query) {
        Page page = this.resActivityRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), (Pageable)query.getPageRequest());
        return PageUtil.toPageVo(page.map(ResActivityConvert.INSTANCE::toVo));
    }

    public List<ResActivityVO> queryList(ResActivityQuery query) {
        return ResActivityConvert.INSTANCE.toVoList(this.resActivityRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder)));
    }

    public ResActivityVO queryByKey(Long key) {
        ResActivityDO entity = this.resActivityRepo.findById(key).orElseGet(ResActivityDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        ResActivityVO vo = ResActivityConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public ResActivityVO insert(ResActivityPayload payload) {
        ResActivityDO entityDo = ResActivityConvert.INSTANCE.toDo(payload);
        return ResActivityConvert.INSTANCE.toVo((ResActivityDO)((Object)this.resActivityRepo.save((Object)entityDo)));
    }

    @Transactional(rollbackFor={Exception.class})
    public ResActivityVO update(ResActivityPayload payload) {
        ResActivityDO entity = this.resActivityRepo.findById(payload.getId()).orElseGet(ResActivityDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        ResActivityDO entityDo = ResActivityConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return ResActivityConvert.INSTANCE.toVo((ResActivityDO)((Object)this.resActivityRepo.save((Object)entity)));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.resActivityRepo.findById(id);
                if (!optional.isEmpty()) {
                    ResActivityDO entity = (ResActivityDO)((Object)((Object)optional.get()));
                    entity.setDeleteFlag(1);
                    this.resActivityRepo.save((Object)entity);
                }
            });
        }
    }

    public void download(List<ResActivityVO> all, HttpServletResponse response) throws IOException {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (ResActivityVO resActivity : all) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("4.0\u6d3b\u52a8\u4e3b\u952e", resActivity.getActivityIdV4());
            map.put("\u6d3b\u52a8\u7f16\u53f7", resActivity.getActNo());
            map.put("\u6d3b\u52a8\u540d\u79f0", resActivity.getActName());
            map.put("\u6d3b\u52a8\u72b6\u6001", resActivity.getActStatus());
            map.put("\u6d3b\u52a8\u8d44\u6e90id", resActivity.getActResId());
            map.put("\u9879\u76ee\u6d3b\u52a8", resActivity.getProjAct());
            map.put("\u9884\u8ba1\u5f00\u59cb\u65e5\u671f", resActivity.getPlanStartDate());
            map.put("\u9884\u8ba1\u7ed3\u675f\u65e5\u671f", resActivity.getPlanEndDate());
            map.put("\u5b9e\u9645\u5f00\u59cb\u65e5\u671f", resActivity.getActualStartDate());
            map.put("\u6d3b\u52a8\u5f53\u91cf", resActivity.getEqvaQty());
            map.put("\u5df2\u7ed3\u7b97\u5f53\u91cf", resActivity.getSettledEqva());
            map.put("\u662f\u5426\u91cc\u7a0b\u7891", resActivity.getMilestoneFlag());
            map.put("\u5b8c\u5de5\u65e5\u671f", resActivity.getFinishDate());
            map.put("\u5b8c\u5de5\u8bf4\u660e", resActivity.getFinishDesc());
            map.put("\u5b8c\u5de5\u767e\u5206\u6bd4", resActivity.getFinishRate());
            map.put("\u8981\u6c42\u6587\u6863\u6e05\u5355", resActivity.getRequiredDocList());
            map.put("\u4efb\u52a1id 4.0", resActivity.getTaskId());
            map.put("\u9879\u76ee\u6d3b\u52a8id", resActivity.getProjActivityId());
            map.put("\u8d44\u6e90\u6d3b\u52a8\u7236id", resActivity.getResActivityPid());
            map.put("\u89c4\u5212\u5f53\u91cf", resActivity.getPlanEqva());
            map.put("\u7ed3\u7b97\u72b6\u6001", resActivity.getSettleStatus());
            map.put("\u5ba1\u6279\u72b6\u6001", resActivity.getApprStatus());
            map.put("\u62d3\u5c551", resActivity.getExt1());
            map.put("\u62d3\u5c552", resActivity.getExt2());
            map.put("\u62d3\u5c553", resActivity.getExt3());
            map.put("\u62d3\u5c554", resActivity.getExt4());
            map.put("\u62d3\u5c555", resActivity.getExt5());
            list.add(map);
        }
        FileUtil.downloadExcel(list, response);
    }

    public Map<Long, Long> getV4AndV5ActivityIds() {
        HashMap<Long, Long> result = new HashMap<Long, Long>();
        ResActivityQuery query = new ResActivityQuery();
        List<ResActivityVO> resActivityVOS = this.queryList(query);
        for (ResActivityVO resActivityVO : resActivityVOS) {
            result.put(resActivityVO.getActivityIdV4(), resActivityVO.getId());
        }
        return result;
    }

    public ResActivityVO queryByActivityIdV4(Long actId) {
        ResActivityDO entity = this.resActivityRepo.getByActivityIdV4(actId);
        Assert.notNull((Object)((Object)entity), (String)"\u6d3b\u52a8\u4e0d\u5b58\u5728");
        ResActivityVO vo = ResActivityConvert.INSTANCE.toVo(entity);
        return vo;
    }

    public ResActivityServiceImpl(ResActivityRepo resActivityRepo) {
        this.resActivityRepo = resActivityRepo;
    }
}

