/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.my.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TaskAuthorizedPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TaskAuthorizedQuery;
import com.elitesland.tw.tw5.api.prd.my.service.TaskAuthorizedService;
import com.elitesland.tw.tw5.api.prd.my.vo.TaskAuthorizedVO;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.util.FileUtil;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.prd.my.convert.TaskAuthorizedConvert;
import com.elitesland.tw.tw5.server.prd.my.entity.TaskAuthorizedDO;
import com.elitesland.tw.tw5.server.prd.my.repo.TaskAuthorizedRepo;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class TaskAuthorizedServiceImpl
implements TaskAuthorizedService {
    private static final Logger log = LoggerFactory.getLogger(TaskAuthorizedServiceImpl.class);
    private final TaskAuthorizedRepo taskAuthorizedRepo;

    public PagingVO<TaskAuthorizedVO> paging(TaskAuthorizedQuery query) {
        Page page = this.taskAuthorizedRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), (Pageable)query.getPageRequest());
        return PageUtil.toPageVo(page.map(TaskAuthorizedConvert.INSTANCE::toVo));
    }

    public List<TaskAuthorizedVO> queryList(TaskAuthorizedQuery query) {
        return TaskAuthorizedConvert.INSTANCE.toVoList(this.taskAuthorizedRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder)));
    }

    public TaskAuthorizedVO queryByKey(Long key) {
        TaskAuthorizedDO entity = this.taskAuthorizedRepo.findById(key).orElseGet(TaskAuthorizedDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        TaskAuthorizedVO vo = TaskAuthorizedConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public TaskAuthorizedVO insert(TaskAuthorizedPayload payload) {
        TaskAuthorizedDO entityDo = TaskAuthorizedConvert.INSTANCE.toDo(payload);
        return TaskAuthorizedConvert.INSTANCE.toVo((TaskAuthorizedDO)((Object)this.taskAuthorizedRepo.save((Object)entityDo)));
    }

    @Transactional(rollbackFor={Exception.class})
    public TaskAuthorizedVO update(TaskAuthorizedPayload payload) {
        TaskAuthorizedDO entity = this.taskAuthorizedRepo.findById(payload.getId()).orElseGet(TaskAuthorizedDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        TaskAuthorizedDO entityDo = TaskAuthorizedConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return TaskAuthorizedConvert.INSTANCE.toVo((TaskAuthorizedDO)((Object)this.taskAuthorizedRepo.save((Object)entity)));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.taskAuthorizedRepo.findById(id);
                if (!optional.isEmpty()) {
                    TaskAuthorizedDO entity = (TaskAuthorizedDO)((Object)((Object)optional.get()));
                    entity.setDeleteFlag(1);
                    this.taskAuthorizedRepo.save((Object)entity);
                }
            });
        }
    }

    public void download(List<TaskAuthorizedVO> all, HttpServletResponse response) throws IOException {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (TaskAuthorizedVO taskAuthorized : all) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("\u540d\u79f0", taskAuthorized.getName());
            map.put("\u7f16\u53f7", taskAuthorized.getAuthorizedNo());
            map.put("\u6d3e\u53d1\u8d44\u6e90resid", taskAuthorized.getDisterResId());
            map.put("\u6d3e\u53d1\u8d44\u6e90userId v5", taskAuthorized.getDisterUserId());
            map.put("\u63a5\u6536\u8d44\u6e90resid", taskAuthorized.getReceiverResId());
            map.put("\u63a5\u6536\u8d44\u6e90userId v5", taskAuthorized.getReceiverUserId());
            map.put("\u63a5\u6536\u8d44\u6e90buid", taskAuthorized.getReceiverBuId());
            map.put("\u63a5\u6536\u8d44\u6e90\u7ec4\u7ec7id v5", taskAuthorized.getReceiverOrgId());
            map.put("\u8d44\u6e90\u6765\u6e90\u7c7b\u578b(\u5408\u4f5c\u7c7b\u578b)", taskAuthorized.getResSourceType());
            map.put("\u9a8c\u6536\u65b9\u5f0f", taskAuthorized.getAcceptMethod());
            map.put("\u8ba1\u4ef7\u65b9\u5f0f", taskAuthorized.getPricingMethod());
            map.put("\u4e8b\u7531\u7c7b\u578b", taskAuthorized.getReasonType());
            map.put("\u4e8b\u7531\u53f7", taskAuthorized.getReasonId());
            map.put("\u4e8b\u7531\u53f75.0\u4e3b\u952e", taskAuthorized.getReasonIdV5());
            map.put("\u8d39\u7528\u627f\u62c5bu", taskAuthorized.getExpenseBuId());
            map.put("\u8d39\u7528\u627f\u62c5\u7ec4\u7ec7id v5", taskAuthorized.getExpenseOrgId());
            map.put("\u6388\u6743\u603b\u5f53\u91cf", taskAuthorized.getAuthEqva());
            map.put("\u5df2\u53d1\u5f53\u91cf", taskAuthorized.getUseEqva());
            map.put("\u5df2\u53d1\u4efb\u52a1\u5305\u6570", taskAuthorized.getUseCount());
            map.put("\u5de5\u65f6\u3001\u7ed3\u7b97\u5ba1\u6279\u4eba\u662f\u9879\u76ee\u7ecf\u7406[pm]or\u6388\u6743\u8d44\u6e90[pl]", taskAuthorized.getApprovedType());
            map.put("\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4", taskAuthorized.getPlanStartDate());
            map.put("\u8ba1\u5212\u7ed3\u675f\u65f6\u95f4", taskAuthorized.getPlanEndDate());
            map.put("\u5b8c\u5de5\u9644\u4ef6\u4e0a\u4f20\u65b9\u6cd5", taskAuthorized.getAttachuploadMethod());
            map.put("\u5ba1\u6279\u72b6\u6001", taskAuthorized.getApprStatus());
            map.put("\u7533\u8bf7\u72b6\u6001", taskAuthorized.getApplyStatus());
            map.put("\u662f\u5426\u6388\u6743\u63a5\u6536\u4eba\u64cd\u4f5c\u8d44\u6e90\u89c4\u5212\u6807\u5fd7 0:\u4e0d\u53ef\u64cd\u4f5c,1:\u53ef\u64cd\u4f5c", taskAuthorized.getAuthResPlanFlag());
            list.add(map);
        }
        FileUtil.downloadExcel(list, response);
    }

    public Map<Long, Long> getV4AndV5AuthIds() {
        HashMap<Long, Long> authMap = new HashMap<Long, Long>();
        List<Map<String, Object>> v4AndV5AuthIds = this.taskAuthorizedRepo.getV4AndV5AuthIds();
        for (Map<String, Object> v4AndV5AuthId : v4AndV5AuthIds) {
            Long authId = (Long)v4AndV5AuthId.get("authId");
            Long authIdV4 = (Long)v4AndV5AuthId.get("authIdV4");
            authMap.put(authIdV4, authId);
        }
        return authMap;
    }

    public TaskAuthorizedServiceImpl(TaskAuthorizedRepo taskAuthorizedRepo) {
        this.taskAuthorizedRepo = taskAuthorizedRepo;
    }
}

