/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.my.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TaskPayload;
import com.elitesland.tw.tw5.api.prd.my.query.ResActivityQuery;
import com.elitesland.tw.tw5.api.prd.my.query.TaskAuthorizedDetailsQuery;
import com.elitesland.tw.tw5.api.prd.my.query.TaskQuery;
import com.elitesland.tw.tw5.api.prd.my.service.ResActivityService;
import com.elitesland.tw.tw5.api.prd.my.service.TaskAuthorizedDetailsService;
import com.elitesland.tw.tw5.api.prd.my.service.TaskAuthorizedService;
import com.elitesland.tw.tw5.api.prd.my.service.TaskService;
import com.elitesland.tw.tw5.api.prd.my.vo.ProjectAndTaskVO;
import com.elitesland.tw.tw5.api.prd.my.vo.TaskAuthorizedDetailsVO;
import com.elitesland.tw.tw5.api.prd.my.vo.TaskAuthorizedVO;
import com.elitesland.tw.tw5.api.prd.my.vo.TaskVO;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.my.constant.TaskStatusEnum;
import com.elitesland.tw.tw5.server.prd.my.convert.TaskConvert;
import com.elitesland.tw.tw5.server.prd.my.entity.TaskDO;
import com.elitesland.tw.tw5.server.prd.my.repo.ProjectRepo;
import com.elitesland.tw.tw5.server.prd.my.repo.TaskRepo;
import com.elitesland.tw.tw5.server.prd.my.repo.TimesheetPlanRepo;
import com.elitesland.tw.tw5.server.prd.my.repo.TimesheetPlanTempRepo;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class TaskServiceImpl
implements TaskService {
    private static final Logger log = LoggerFactory.getLogger(TaskServiceImpl.class);
    private final TaskRepo taskRepo;
    private final HttpUtil httpUtil;
    private final PrdOrgEmployeeDAO employeeDAO;
    private final ProjectRepo projectRepo;
    private final ResActivityService resActivityService;
    private final TaskAuthorizedService taskAuthorizedService;
    private final TaskAuthorizedDetailsService taskAuthorizedDetailsService;
    private final TimesheetPlanRepo timesheetPlanRepo;
    private final TimesheetPlanTempRepo timesheetPlanTempRepo;
    @Value(value="${tw4.timesheet.task:api/openReport/v1/sync/taskApply}")
    private String timesheet_task;
    @Value(value="${tw4.url}")
    private String tw4_url;

    public PagingVO<TaskVO> paging(TaskQuery query) {
        Page page = this.taskRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), (Pageable)query.getPageRequest());
        return PageUtil.toPageVo(page.map(TaskConvert.INSTANCE::toVo));
    }

    public List<TaskVO> queryList(TaskQuery query) {
        Sort sort = Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"effectiveEqva"});
        return TaskConvert.INSTANCE.toVoList(this.taskRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), sort));
    }

    public List<ProjectAndTaskVO> queryListForSelect(TaskQuery query) {
        return TaskConvert.INSTANCE.toSelectVoList(this.taskRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder)));
    }

    public TaskVO queryByKey(Long key) {
        TaskDO entity = this.taskRepo.findById(key).orElseGet(TaskDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        TaskVO vo = TaskConvert.INSTANCE.toVo(entity);
        return vo;
    }

    public TaskVO queryByTaskIdV4(Long taskIdV4) {
        TaskDO entity = this.taskRepo.getByTaskIdV4(taskIdV4);
        Assert.notNull((Object)((Object)entity), (String)"\u4efb\u52a1\u4e0d\u5b58\u5728");
        TaskVO vo = TaskConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public TaskVO insert(TaskPayload payload) {
        TaskPayload taskCopyPayload = new TaskPayload();
        BeanUtils.copyProperties((Object)payload, (Object)taskCopyPayload);
        if (null != payload.getReceiverUserId()) {
            taskCopyPayload.setReceiverUserId(this.employeeDAO.getV4UserId(taskCopyPayload.getReceiverUserId()));
        }
        if (null != payload.getDisterUserId()) {
            taskCopyPayload.setDisterUserId(this.employeeDAO.getV4UserId(taskCopyPayload.getDisterUserId()));
        }
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public TaskVO update(TaskPayload payload) {
        TaskDO entity = this.taskRepo.findById(payload.getId()).orElseGet(TaskDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        TaskDO entityDo = TaskConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return TaskConvert.INSTANCE.toVo((TaskDO)((Object)this.taskRepo.save((Object)entity)));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.taskRepo.findById(id);
                if (!optional.isEmpty()) {
                    TaskDO entity = (TaskDO)((Object)((Object)optional.get()));
                    entity.setDeleteFlag(1);
                    this.taskRepo.save((Object)entity);
                }
            });
        }
    }

    public List<TaskVO> selectTaskForTimesheet(TaskQuery query, Long projIdV4, boolean test) {
        if (null == query.getEffectiveEqva()) {
            query.setEffectiveEqva(new BigDecimal("0.05"));
        }
        if (projIdV4 == 0L) {
            List<TaskVO> taskVOS;
            query.setTaskStatus(TaskStatusEnum.ACTIVE.getCode());
            query.setNotEqualReasonType("01");
            if (!test) {
                query.setReceiverUserId(GlobalUtil.getLoginUserId());
            }
            if (!CollectionUtils.isEmpty(taskVOS = this.queryList(query))) {
                taskVOS.forEach(taskVO -> {
                    ResActivityQuery resActivityQuery = new ResActivityQuery();
                    resActivityQuery.setTaskId(taskVO.getTaskIdV4());
                    List resActivityVOS = this.resActivityService.queryList(resActivityQuery);
                    taskVO.setActivityList(resActivityVOS);
                });
            }
            return taskVOS;
        }
        ArrayList<String> taskStatusList = new ArrayList<String>();
        taskStatusList.add(TaskStatusEnum.ACTIVE.getCode());
        query.setTaskStatusList(taskStatusList);
        query.setReasonType("01");
        if (!test) {
            query.setReceiverUserId(GlobalUtil.getLoginUserId());
        }
        query.setReasonIdv4(projIdV4);
        List<TaskVO> taskVOS = this.queryList(query);
        if (!CollectionUtils.isEmpty(taskVOS)) {
            taskVOS.forEach(taskVO -> {
                ResActivityQuery resActivityQuery = new ResActivityQuery();
                resActivityQuery.setTaskId(taskVO.getTaskIdV4());
                List resActivityVOS = this.resActivityService.queryList(resActivityQuery);
                taskVO.setActivityList(resActivityVOS);
            });
        }
        return taskVOS;
    }

    public Map<Long, Long> getV4AndV5TaskIds() {
        HashMap<Long, Long> taskMap = new HashMap<Long, Long>();
        List<Map<String, Object>> v4AndV5TaskIds = this.taskRepo.getV4AndV5TaskIds();
        for (Map<String, Object> v4AndV5TaskId : v4AndV5TaskIds) {
            Long taskId = (Long)v4AndV5TaskId.get("taskId");
            Long taskIdV4 = (Long)v4AndV5TaskId.get("taskIdV4");
            taskMap.put(taskIdV4, taskId);
        }
        return taskMap;
    }

    @Transactional
    public String updateTaskStatus(Long idV4, String status) {
        this.taskRepo.updateTaskStatus(idV4, status);
        List<TaskDO> taskDOS = this.taskRepo.queryByTaskIdV4In(Collections.singletonList(idV4));
        TaskDO taskDO = taskDOS.get(0);
        this.timesheetPlanRepo.updateByTaskId(taskDO.getTaskIdV4(), taskDO.getTaskName(), status, taskDO.getEqvaQty());
        this.timesheetPlanTempRepo.updateByTaskId(taskDO.getTaskIdV4(), taskDO.getTaskName(), status, taskDO.getEqvaQty());
        return null;
    }

    @Transactional
    public String updateTaskReason(Long taskIdV4, String reasonType, Long reasonId, Long expenseBuId) {
        this.taskRepo.updateTaskMess(taskIdV4, reasonId, expenseBuId);
        return null;
    }

    public Long getApprResIdByAuthInfo(Long taskId) {
        Long authId;
        TaskAuthorizedVO taskAuthorizedVO;
        TaskAuthorizedDetailsQuery authorizedDetailsQuery = new TaskAuthorizedDetailsQuery();
        authorizedDetailsQuery.setTaskId(taskId);
        List taskAuthorizedDetailsVOS = this.taskAuthorizedDetailsService.queryList(authorizedDetailsQuery);
        if (!CollectionUtils.isEmpty((Collection)taskAuthorizedDetailsVOS) && null != (taskAuthorizedVO = this.taskAuthorizedService.queryByKey(authId = ((TaskAuthorizedDetailsVO)taskAuthorizedDetailsVOS.get(0)).getAuthIdV5()))) {
            String approvedType = taskAuthorizedVO.getApprovedType();
            if (StringUtils.hasText((String)approvedType)) {
                if (approvedType.equals("PM")) {
                    return taskAuthorizedVO.getDisterUserId();
                }
                if (approvedType.equals("PL")) {
                    return taskAuthorizedVO.getReceiverUserId();
                }
                log.info("===================>\u57fa\u4e8e\u6388\u6743\u53d1\u653e\u7684\u4efb\u52a1\u5305;\u6388\u6743\u914d\u7f6eAPPROVED_TYPE[" + approvedType + "]\u5f02\u5e38\uff1a\u6388\u6743\u4e3b\u952e=" + authId + ";");
            } else {
                log.info("===================>\u57fa\u4e8e\u6388\u6743\u53d1\u653e\u7684\u4efb\u52a1\u5305;\u6388\u6743\u914d\u7f6e\u5f02\u5e38\uff1a\u6388\u6743\u4e3b\u952e=" + authId + ";");
            }
        }
        return null;
    }

    public TaskServiceImpl(TaskRepo taskRepo, HttpUtil httpUtil, PrdOrgEmployeeDAO employeeDAO, ProjectRepo projectRepo, ResActivityService resActivityService, TaskAuthorizedService taskAuthorizedService, TaskAuthorizedDetailsService taskAuthorizedDetailsService, TimesheetPlanRepo timesheetPlanRepo, TimesheetPlanTempRepo timesheetPlanTempRepo) {
        this.taskRepo = taskRepo;
        this.httpUtil = httpUtil;
        this.employeeDAO = employeeDAO;
        this.projectRepo = projectRepo;
        this.resActivityService = resActivityService;
        this.taskAuthorizedService = taskAuthorizedService;
        this.taskAuthorizedDetailsService = taskAuthorizedDetailsService;
        this.timesheetPlanRepo = timesheetPlanRepo;
        this.timesheetPlanTempRepo = timesheetPlanTempRepo;
    }
}

