/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.my.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetBiweeklyDetailPayload;
import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetBiweeklyPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetBiweeklyDetailQuery;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetBiweeklyQuery;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetPlanQuery;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetQuery;
import com.elitesland.tw.tw5.api.prd.my.service.PrdUserService;
import com.elitesland.tw.tw5.api.prd.my.service.TimesheetBiweeklyDetailService;
import com.elitesland.tw.tw5.api.prd.my.service.TimesheetBiweeklyService;
import com.elitesland.tw.tw5.api.prd.my.service.TimesheetPlanService;
import com.elitesland.tw.tw5.api.prd.my.service.TimesheetService;
import com.elitesland.tw.tw5.api.prd.my.vo.TimesheetBiweeklyVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgDataRefVO;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.DateUtil;
import com.elitesland.tw.tw5.server.common.util.FileUtil;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.my.constant.TimesheetBiweeklyDetailTypeEnum;
import com.elitesland.tw.tw5.server.prd.my.constant.TimesheetStatus;
import com.elitesland.tw.tw5.server.prd.my.convert.TimesheetBiweeklyConvert;
import com.elitesland.tw.tw5.server.prd.my.entity.TimesheetBiweeklyDO;
import com.elitesland.tw.tw5.server.prd.my.repo.TimesheetBiweeklyRepo;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class TimesheetBiweeklyServiceImpl
implements TimesheetBiweeklyService {
    private static final Logger log = LoggerFactory.getLogger(TimesheetBiweeklyServiceImpl.class);
    private final TimesheetBiweeklyRepo timesheetBiweeklyRepo;
    private final PrdUserService prdUserService;
    private final TimesheetService timesheetService;
    private final TimesheetPlanService timesheetPlanService;
    private final TimesheetBiweeklyDetailService timesheetBiweeklyDetailService;
    private final PrdOrgEmployeeService prdOrgEmployeeService;
    private final PrdSystemRoleDAO systemRoleDAO;

    public PagingVO<TimesheetBiweeklyVO> paging(TimesheetBiweeklyQuery query) {
        Specification & Serializable spec = (Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> {
            Predicate predicate = QueryHelp.getPredicate(root, query, criteriaBuilder);
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            predicates.add(predicate);
            criteriaQuery.distinct(true);
            ArrayList<Predicate> dataFilterQuery = new ArrayList<Predicate>();
            List<Long> userIdsByPlatRole = this.systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SYS.getCode()));
            if (CollectionUtils.isEmpty(userIdsByPlatRole) || !userIdsByPlatRole.contains(query.getUserId())) {
                if (null != query.getUserId() && null == query.getCreateUserId()) {
                    Predicate tsUserId = criteriaBuilder.equal((Expression)root.get("tsUserId"), (Object)query.getUserId());
                    Predicate receiveUserIds = criteriaBuilder.like((Expression)root.get("receiveUserIds"), SqlUtil.toSqlLikeString("" + query.getUserId()));
                    dataFilterQuery.add(tsUserId);
                    dataFilterQuery.add(receiveUserIds);
                }
                if (!CollectionUtils.isEmpty(dataFilterQuery)) {
                    Predicate[] predicatesListResult = dataFilterQuery.toArray(new Predicate[dataFilterQuery.size()]);
                    predicates.add(criteriaBuilder.or(predicatesListResult));
                }
            }
            return criteriaBuilder.and(predicates.toArray(new Predicate[predicates.size()]));
        };
        Page page = this.timesheetBiweeklyRepo.findAll(spec, (Pageable)query.getPageRequest());
        return PageUtil.toPageVo(page.map(TimesheetBiweeklyConvert.INSTANCE::toVo));
    }

    public List<TimesheetBiweeklyVO> queryList(TimesheetBiweeklyQuery query) {
        return TimesheetBiweeklyConvert.INSTANCE.toVoList(this.timesheetBiweeklyRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder)));
    }

    @Transactional(rollbackFor={Exception.class})
    public TimesheetBiweeklyVO queryByKey(Long key) {
        TimesheetBiweeklyDO entity = this.timesheetBiweeklyRepo.findById(key).orElseGet(TimesheetBiweeklyDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        TimesheetBiweeklyVO vo = TimesheetBiweeklyConvert.INSTANCE.toVo(entity);
        TimesheetBiweeklyDetailQuery query = new TimesheetBiweeklyDetailQuery();
        query.setTsbId(vo.getId());
        List timesheetBiweeklyDetailVOS = this.timesheetBiweeklyDetailService.queryList(query);
        vo.setDetailList(timesheetBiweeklyDetailVOS);
        if (entity.getReceiveUserIds().contains("" + GlobalUtil.getLoginUserId())) {
            TimesheetBiweeklyPayload update = new TimesheetBiweeklyPayload();
            update.setId(key);
            update.setIsRead(Integer.valueOf(1));
            this.update(update);
        }
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public TimesheetBiweeklyVO insert(TimesheetBiweeklyPayload payload) {
        TimesheetBiweeklyVO timesheetBiweeklyVOResult;
        if (payload.getGenerateDate() == null) {
            payload.setGenerateDate(LocalDate.now());
        }
        Long userId = GlobalUtil.getLoginUserId();
        LocalDate startWeekDay = DateUtil.getStartWeekDay(payload.getGenerateDate());
        LocalDate endWeekDay = DateUtil.getEndWeekDay(payload.getGenerateDate());
        endWeekDay = endWeekDay.plusDays(2L);
        TimesheetPlanQuery timesheetPlanQuery = new TimesheetPlanQuery();
        ArrayList<LocalDate> workDatePlanList = new ArrayList<LocalDate>();
        workDatePlanList.add(startWeekDay);
        workDatePlanList.add(endWeekDay);
        timesheetPlanQuery.setWorkDate(workDatePlanList);
        timesheetPlanQuery.setTsUserId(userId);
        timesheetPlanQuery.setWorkDescNotNull("null");
        List timesheetPlanVOList = this.timesheetPlanService.queryList(timesheetPlanQuery);
        TimesheetQuery timesheetQuery = new TimesheetQuery();
        ArrayList<LocalDate> workDateList = new ArrayList<LocalDate>();
        workDateList.add(startWeekDay);
        workDateList.add(endWeekDay);
        timesheetQuery.setWorkDate(workDateList);
        timesheetQuery.setTsUserId(userId);
        ArrayList<String> tsStatusList = new ArrayList<String>();
        tsStatusList.add(TimesheetStatus.APPROVING.getCode());
        tsStatusList.add(TimesheetStatus.APPROVED.getCode());
        tsStatusList.add(TimesheetStatus.SETTLED.getCode());
        timesheetQuery.setTsStatusList(tsStatusList);
        List timesheetVOList = this.timesheetService.queryList(timesheetQuery);
        if (CollectionUtils.isEmpty((Collection)timesheetVOList)) {
            throw TwException.error("", "\u8bf7\u586b\u5199\u672c\u5468\u5de5\u4f5c\u65e5\u5fd7\uff0c\u786e\u4fdd\u5de5\u65f6\u72b6\u6001\u4e3a\u5ba1\u6279\u4e2d\u3001\u5df2\u5ba1\u6279");
        }
        LocalDate nextStartWeekDay = startWeekDay.plusDays(7L);
        LocalDate nextEndWeekDay = endWeekDay.plusDays(7L);
        TimesheetPlanQuery timesheetPlanNextQuery = new TimesheetPlanQuery();
        ArrayList<LocalDate> workDatePlanNextList = new ArrayList<LocalDate>();
        workDatePlanNextList.add(nextStartWeekDay);
        workDatePlanNextList.add(nextEndWeekDay);
        timesheetPlanNextQuery.setWorkDate(workDatePlanNextList);
        timesheetPlanNextQuery.setTsUserId(userId);
        timesheetPlanNextQuery.setWorkDescNotNull("null");
        List timesheetPlanVONextList = this.timesheetPlanService.queryList(timesheetPlanNextQuery);
        this.initData(payload);
        TimesheetBiweeklyQuery timesheetBiweeklyQuery = new TimesheetBiweeklyQuery();
        timesheetBiweeklyQuery.setStartWeekDateQuery(startWeekDay);
        timesheetBiweeklyQuery.setTsUserId(userId);
        List<TimesheetBiweeklyVO> timesheetBiweeklyVOS = this.queryList(timesheetBiweeklyQuery);
        ArrayList timesheetBiweeklyDetailPayloadList = new ArrayList();
        if (!CollectionUtils.isEmpty(timesheetBiweeklyVOS)) {
            timesheetBiweeklyVOResult = timesheetBiweeklyVOS.get(0);
            List delIdArr = timesheetBiweeklyVOS.stream().map(timesheetBiweeklyVO -> timesheetBiweeklyVO.getId()).collect(Collectors.toList());
            this.timesheetBiweeklyDetailService.deleteSoftByTsbIds(delIdArr, TimesheetBiweeklyDetailTypeEnum.TIMESHEET.getCode());
            timesheetVOList.forEach(timesheetVO -> {
                TimesheetBiweeklyDetailPayload week = new TimesheetBiweeklyDetailPayload();
                week.setTsbId(timesheetBiweeklyVOResult.getId());
                week.setExt1(StringUtils.hasText((String)timesheetVO.getType()) ? timesheetVO.getType() : "PROJ");
                week.setType(TimesheetBiweeklyDetailTypeEnum.TIMESHEET.getCode());
                week.setYearWeek(timesheetVO.getYearWeek());
                week.setProjId(timesheetVO.getProjId());
                week.setProjectName(timesheetVO.getProjName());
                week.setTaskId(timesheetVO.getTaskId());
                week.setTaskName(timesheetVO.getTaskName());
                week.setActId(timesheetVO.getActId());
                week.setActName(timesheetVO.getActName());
                week.setTsbDate(timesheetVO.getWorkDate());
                week.setWorkDesc(timesheetVO.getWorkDesc());
                timesheetBiweeklyDetailPayloadList.add(week);
            });
        } else {
            TimesheetBiweeklyVO timesheetBiweeklyVO2;
            TimesheetBiweeklyDO entityDo = TimesheetBiweeklyConvert.INSTANCE.toDo(payload);
            timesheetBiweeklyVOResult = timesheetBiweeklyVO2 = TimesheetBiweeklyConvert.INSTANCE.toVo((TimesheetBiweeklyDO)((Object)this.timesheetBiweeklyRepo.save((Object)entityDo)));
            timesheetPlanVOList.forEach(timesheetPlanVO -> {
                TimesheetBiweeklyDetailPayload week = new TimesheetBiweeklyDetailPayload();
                week.setTsbId(timesheetBiweeklyVO2.getId());
                week.setType(TimesheetBiweeklyDetailTypeEnum.TIMESHEET_PLAN.getCode());
                week.setExt1(StringUtils.hasText((String)timesheetPlanVO.getType()) ? timesheetPlanVO.getType() : "PROJ");
                week.setYearWeek(timesheetPlanVO.getYearWeek());
                week.setProjId(timesheetPlanVO.getProjId());
                week.setProjectName(timesheetPlanVO.getProjName());
                week.setTaskId(timesheetPlanVO.getTaskId());
                week.setTaskName(timesheetPlanVO.getTaskName());
                week.setActId(timesheetPlanVO.getActId());
                week.setActName(timesheetPlanVO.getActName());
                week.setTsbDate(timesheetPlanVO.getWorkDate());
                week.setWorkDesc(timesheetPlanVO.getWorkDesc());
                timesheetBiweeklyDetailPayloadList.add(week);
            });
            timesheetPlanVONextList.forEach(timesheetPlanVO -> {
                TimesheetBiweeklyDetailPayload week = new TimesheetBiweeklyDetailPayload();
                week.setTsbId(timesheetBiweeklyVO2.getId());
                week.setType(TimesheetBiweeklyDetailTypeEnum.TIMESHEET_PLAN_NEXT_WEEK.getCode());
                week.setExt1(StringUtils.hasText((String)timesheetPlanVO.getType()) ? timesheetPlanVO.getType() : "PROJ");
                week.setYearWeek(timesheetPlanVO.getYearWeek());
                week.setProjId(timesheetPlanVO.getProjId());
                week.setProjectName(timesheetPlanVO.getProjName());
                week.setTaskId(timesheetPlanVO.getTaskId());
                week.setTaskName(timesheetPlanVO.getTaskName());
                week.setActId(timesheetPlanVO.getActId());
                week.setActName(timesheetPlanVO.getActName());
                week.setTsbDate(timesheetPlanVO.getWorkDate());
                week.setWorkDesc(timesheetPlanVO.getWorkDesc());
                timesheetBiweeklyDetailPayloadList.add(week);
            });
            timesheetVOList.forEach(timesheetVO -> {
                TimesheetBiweeklyDetailPayload week = new TimesheetBiweeklyDetailPayload();
                week.setTsbId(timesheetBiweeklyVO2.getId());
                week.setExt1(StringUtils.hasText((String)timesheetVO.getType()) ? timesheetVO.getType() : "PROJ");
                week.setType(TimesheetBiweeklyDetailTypeEnum.TIMESHEET.getCode());
                week.setYearWeek(timesheetVO.getYearWeek());
                week.setProjId(timesheetVO.getProjId());
                week.setProjectName(timesheetVO.getProjName());
                week.setTaskId(timesheetVO.getTaskId());
                week.setTaskName(timesheetVO.getTaskName());
                week.setActId(timesheetVO.getActId());
                week.setActName(timesheetVO.getActName());
                week.setTsbDate(timesheetVO.getWorkDate());
                week.setWorkDesc(timesheetVO.getWorkDesc());
                timesheetBiweeklyDetailPayloadList.add(week);
            });
        }
        timesheetBiweeklyDetailPayloadList.forEach(timesheetBiweeklyDetailPayload -> this.timesheetBiweeklyDetailService.insert(timesheetBiweeklyDetailPayload));
        return timesheetBiweeklyVOResult;
    }

    private void initData(TimesheetBiweeklyPayload payload) {
        List list;
        List prdOrgDataRefVOS;
        Long loginUserId = GlobalUtil.getLoginUserId();
        payload.setTsUserId(loginUserId);
        Set parentIdsByUserId = this.prdOrgEmployeeService.queryParentIdsByUserId(loginUserId);
        String receiveUserIds = org.apache.commons.lang3.StringUtils.join((Object[])parentIdsByUserId.toArray(), (String)",");
        payload.setReceiveUserIds(receiveUserIds);
        if (!StringUtils.hasText((String)payload.getTsbType())) {
            payload.setTsbType("week");
        }
        if (!StringUtils.hasText((String)payload.getTitle())) {
            String title = "";
            if (payload.getTsbType().equals("week")) {
                title = "\u5468\u62a5";
            }
            payload.setTitle(GlobalUtil.getLoginUserName() + title);
        }
        if (null == payload.getIsRead()) {
            payload.setIsRead(Integer.valueOf(0));
        }
        if (null == payload.getStartWeekDate()) {
            LocalDate startWeekDay = DateUtil.getStartWeekDay(payload.getGenerateDate());
            if (null == startWeekDay) {
                throw TwException.error("", "\u53c2\u6570\u5f02\u5e38\uff0c\u8bf7\u6307\u5b9a\u751f\u6210\u5468\u62a5\u65e5\u671f");
            }
            payload.setStartWeekDate(startWeekDay);
            payload.setEndWeekDate(startWeekDay.plusDays(7L));
            payload.setYearWeek(Integer.valueOf(Integer.parseInt(DateUtil.getYearWeek(startWeekDay))));
        }
        if (!CollectionUtils.isEmpty((Collection)(prdOrgDataRefVOS = this.prdUserService.queryOrgList())) && !CollectionUtils.isEmpty(list = prdOrgDataRefVOS.stream().filter(prdOrgDataRefVO -> prdOrgDataRefVO.getIsDefault().equals(0)).collect(Collectors.toList()))) {
            Long orgId = ((PrdOrgDataRefVO)list.get(0)).getOrgId();
            payload.setTsbBuId(orgId);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public TimesheetBiweeklyVO update(TimesheetBiweeklyPayload payload) {
        TimesheetBiweeklyDO entity = this.timesheetBiweeklyRepo.findById(payload.getId()).orElseGet(TimesheetBiweeklyDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        TimesheetBiweeklyDO entityDo = TimesheetBiweeklyConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return TimesheetBiweeklyConvert.INSTANCE.toVo((TimesheetBiweeklyDO)((Object)this.timesheetBiweeklyRepo.save((Object)entity)));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.timesheetBiweeklyRepo.findById(id);
                if (!optional.isEmpty()) {
                    TimesheetBiweeklyDO entity = (TimesheetBiweeklyDO)((Object)((Object)optional.get()));
                    entity.setDeleteFlag(1);
                    this.timesheetBiweeklyRepo.save((Object)entity);
                }
            });
        }
    }

    public void download(List<TimesheetBiweeklyVO> all, HttpServletResponse response) throws IOException {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (TimesheetBiweeklyVO timesheetBiweekly : all) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("\u6807\u9898", timesheetBiweekly.getTitle());
            map.put("\u53cc\u5468\u8ba1\u5212\u7c7b\u578b", timesheetBiweekly.getTsbType());
            map.put("\u53cc\u5468\u8ba1\u5212Buid", timesheetBiweekly.getTsbBuId());
            map.put("\u53d1\u9001\u5bf9\u8c61", timesheetBiweekly.getReceiveUserIds());
            map.put("\u662f\u5426\u5df2\u8bfb", timesheetBiweekly.getIsRead());
            map.put("\u62d3\u5c551", timesheetBiweekly.getExt1());
            map.put("\u62d3\u5c552", timesheetBiweekly.getExt2());
            map.put("\u62d3\u5c553", timesheetBiweekly.getExt3());
            map.put("\u672c\u5468\u5f00\u59cb\u65e5\u671f", timesheetBiweekly.getStartWeekDate());
            list.add(map);
        }
        FileUtil.downloadExcel(list, response);
    }

    public TimesheetBiweeklyServiceImpl(TimesheetBiweeklyRepo timesheetBiweeklyRepo, PrdUserService prdUserService, TimesheetService timesheetService, TimesheetPlanService timesheetPlanService, TimesheetBiweeklyDetailService timesheetBiweeklyDetailService, PrdOrgEmployeeService prdOrgEmployeeService, PrdSystemRoleDAO systemRoleDAO) {
        this.timesheetBiweeklyRepo = timesheetBiweeklyRepo;
        this.prdUserService = prdUserService;
        this.timesheetService = timesheetService;
        this.timesheetPlanService = timesheetPlanService;
        this.timesheetBiweeklyDetailService = timesheetBiweeklyDetailService;
        this.prdOrgEmployeeService = prdOrgEmployeeService;
        this.systemRoleDAO = systemRoleDAO;
    }
}

