/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.my.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetPlanTempListPayload;
import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetPlanTempPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetPlanTempQuery;
import com.elitesland.tw.tw5.api.prd.my.service.ProjectService;
import com.elitesland.tw.tw5.api.prd.my.service.ResActivityService;
import com.elitesland.tw.tw5.api.prd.my.service.TaskService;
import com.elitesland.tw.tw5.api.prd.my.service.TimesheetPlanTempService;
import com.elitesland.tw.tw5.api.prd.my.vo.ProjectVO;
import com.elitesland.tw.tw5.api.prd.my.vo.ResActivityVO;
import com.elitesland.tw.tw5.api.prd.my.vo.TaskVO;
import com.elitesland.tw.tw5.api.prd.my.vo.TimesheetPlanTempVO;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.FileUtil;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.my.constant.ProjectEnum;
import com.elitesland.tw.tw5.server.prd.my.constant.TaskStatusEnum;
import com.elitesland.tw.tw5.server.prd.my.convert.TimesheetPlanTempConvert;
import com.elitesland.tw.tw5.server.prd.my.entity.TimesheetPlanTempDO;
import com.elitesland.tw.tw5.server.prd.my.repo.TimesheetPlanTempRepo;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class TimesheetPlanTempServiceImpl
implements TimesheetPlanTempService {
    private static final Logger log = LoggerFactory.getLogger(TimesheetPlanTempServiceImpl.class);
    private final TimesheetPlanTempRepo timesheetPlanTempRepo;
    private final ProjectService projectService;
    private final TaskService taskService;
    private final ResActivityService resActivityService;

    public PagingVO<TimesheetPlanTempVO> paging(TimesheetPlanTempQuery query) {
        Page page = this.timesheetPlanTempRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), (Pageable)query.getPageRequest());
        return PageUtil.toPageVo(page.map(TimesheetPlanTempConvert.INSTANCE::toVo));
    }

    public List<TimesheetPlanTempVO> queryList(TimesheetPlanTempQuery query) {
        return TimesheetPlanTempConvert.INSTANCE.toVoList(this.timesheetPlanTempRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder)));
    }

    public long count(TimesheetPlanTempQuery query) {
        return this.timesheetPlanTempRepo.count((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder));
    }

    public TimesheetPlanTempVO queryByKey(Long key) {
        TimesheetPlanTempDO entity = this.timesheetPlanTempRepo.findById(key).orElseGet(TimesheetPlanTempDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        TimesheetPlanTempVO vo = TimesheetPlanTempConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public TimesheetPlanTempVO insert(TimesheetPlanTempPayload payload) {
        this.check(payload);
        this.initData(payload);
        TimesheetPlanTempDO entityDo = TimesheetPlanTempConvert.INSTANCE.toDo(payload);
        return TimesheetPlanTempConvert.INSTANCE.toVo((TimesheetPlanTempDO)((Object)this.timesheetPlanTempRepo.save((Object)entityDo)));
    }

    private void check(TimesheetPlanTempPayload payload) {
        Long loginUserId = GlobalUtil.getLoginUserId();
        if (null == payload.getProjId()) {
            throw TwException.error("", "\u53c2\u6570\u5f02\u5e38\uff1aprojId");
        }
        if (null == payload.getTaskId()) {
            throw TwException.error("", "\u53c2\u6570\u5f02\u5e38\uff1ataskId");
        }
        if (!StringUtils.hasText((String)payload.getType())) {
            throw TwException.error("", "\u53c2\u6570\u5f02\u5e38\uff1atype");
        }
        if (payload.getType().equals(ProjectEnum.OPER.getCode()) || payload.getType().equals(ProjectEnum.DEV_OPS.getCode())) {
            long countOper;
            TimesheetPlanTempQuery queryOper = new TimesheetPlanTempQuery();
            queryOper.setProjId(payload.getProjId());
            queryOper.setCreateUserId(loginUserId);
            if (null != payload.getId() && payload.getId() > 0L) {
                queryOper.setIdNotEqual(payload.getId());
            }
            if ((countOper = this.count(queryOper)) > 0L) {
                throw TwException.error("", "\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0\uff01");
            }
        } else {
            long count;
            TimesheetPlanTempQuery query = new TimesheetPlanTempQuery();
            query.setTaskId(payload.getTaskId());
            query.setCreateUserId(loginUserId);
            if (null != payload.getId() && payload.getId() > 0L) {
                query.setIdNotEqual(payload.getId());
            }
            if ((count = this.count(query)) > 0L) {
                throw TwException.error("", "\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0\uff01");
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public List<TimesheetPlanTempVO> batchInsert(TimesheetPlanTempListPayload payload) {
        List timesheetPlanTempList = payload.getTimesheetPlanTempList();
        ArrayList<TimesheetPlanTempVO> list = new ArrayList<TimesheetPlanTempVO>();
        if (!CollectionUtils.isEmpty((Collection)timesheetPlanTempList)) {
            timesheetPlanTempList.forEach(timesheetPlanTempPayload -> list.add(this.insert((TimesheetPlanTempPayload)timesheetPlanTempPayload)));
        }
        return list;
    }

    private void initData(TimesheetPlanTempPayload payload) {
        if (null != payload.getProjId()) {
            ProjectVO projectVO = this.projectService.queryByProjIdV4(payload.getProjId());
            if (!StringUtils.hasText((String)payload.getProjNo())) {
                payload.setProjNo(null != projectVO ? projectVO.getProjNo() : "");
            }
            if (!StringUtils.hasText((String)payload.getProjName())) {
                payload.setProjName(null != projectVO ? projectVO.getProjName() : "");
            }
        }
        if (null != payload.getTaskId()) {
            TaskVO taskVO = this.taskService.queryByTaskIdV4(payload.getTaskId());
            if (!StringUtils.hasText((String)payload.getTaskNo())) {
                payload.setTaskNo(null != taskVO ? taskVO.getTaskNo() : "");
            }
            if (!StringUtils.hasText((String)payload.getTaskName())) {
                payload.setTaskName(null != taskVO ? taskVO.getTaskName() : "");
            }
            if (null == payload.getEqvaQty()) {
                payload.setEqvaQty(null != taskVO ? taskVO.getEqvaQty() : null);
            }
        }
        if (null != payload.getActId()) {
            ResActivityVO resActivityVO = this.resActivityService.queryByActivityIdV4(payload.getActId());
            if (!StringUtils.hasText((String)payload.getActNo())) {
                payload.setActNo(null != resActivityVO ? resActivityVO.getActNo() : "");
            }
            if (!StringUtils.hasText((String)payload.getActName())) {
                payload.setActName(null != resActivityVO ? resActivityVO.getActName() : "");
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public TimesheetPlanTempVO update(TimesheetPlanTempPayload payload) {
        TimesheetPlanTempDO entity = this.timesheetPlanTempRepo.findById(payload.getId()).orElseGet(TimesheetPlanTempDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        this.initData(payload);
        TimesheetPlanTempDO entityDo = TimesheetPlanTempConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return TimesheetPlanTempConvert.INSTANCE.toVo((TimesheetPlanTempDO)((Object)this.timesheetPlanTempRepo.save((Object)entity)));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.timesheetPlanTempRepo.findById(id);
                if (!optional.isEmpty()) {
                    TimesheetPlanTempDO entity = (TimesheetPlanTempDO)((Object)((Object)optional.get()));
                    String taskApplyStatus = entity.getTaskApplyStatus();
                    if (StringUtils.hasText((String)taskApplyStatus) && taskApplyStatus.equals(TaskStatusEnum.DISPATCH.getCode())) {
                        throw TwException.error("", "\u5ba1\u6279\u4e2d\u4e0d\u53ef\u4ee5\u5220\u9664\u6570\u636e\uff0c\u5fc5\u987b\u8981\u57284.0\u4e2d\u3010\u6211\u63d0\u4ea4\u7684\u6d41\u7a0b\u4e2d\u3011\u8fdb\u884c\u64a4\u56de\uff0c\u5220\u9664\u4ee5\u540e\u624d\u53ef\u4ee5\u57285.0\u4e2d\u5220\u9664");
                    }
                    entity.setDeleteFlag(1);
                    this.timesheetPlanTempRepo.save((Object)entity);
                }
            });
        }
    }

    public void download(List<TimesheetPlanTempVO> all, HttpServletResponse response) throws IOException {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (TimesheetPlanTempVO timesheetPlanTemp : all) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("\u4efb\u52a1id", timesheetPlanTemp.getTaskId());
            map.put("\u5de5\u4f5c\u8ba1\u5212\u4e3b\u952e", timesheetPlanTemp.getPlanId());
            map.put("\u72b6\u6001", timesheetPlanTemp.getStatus());
            map.put("\u62d3\u5c551", timesheetPlanTemp.getExt1());
            map.put("\u62d3\u5c552", timesheetPlanTemp.getExt2());
            map.put("\u62d3\u5c553", timesheetPlanTemp.getExt3());
            map.put("\u62d3\u5c554", timesheetPlanTemp.getExt4());
            map.put("\u62d3\u5c555", timesheetPlanTemp.getExt5());
            list.add(map);
        }
        FileUtil.downloadExcel(list, response);
    }

    public TimesheetPlanTempServiceImpl(TimesheetPlanTempRepo timesheetPlanTempRepo, ProjectService projectService, TaskService taskService, ResActivityService resActivityService) {
        this.timesheetPlanTempRepo = timesheetPlanTempRepo;
        this.projectService = projectService;
        this.taskService = taskService;
        this.resActivityService = resActivityService;
    }
}

