/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.my.service;

import com.elitescloud.cloudt.common.base.BaseModel;
import com.elitescloud.cloudt.common.base.BaseViewModel;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOperationPlanDetailService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOperationPlanDetailVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetListPayload;
import com.elitesland.tw.tw5.api.prd.my.payload.TimesheetPayload;
import com.elitesland.tw.tw5.api.prd.my.query.ProjectQuery;
import com.elitesland.tw.tw5.api.prd.my.query.TaskQuery;
import com.elitesland.tw.tw5.api.prd.my.query.TimesheetQuery;
import com.elitesland.tw.tw5.api.prd.my.service.PrdUserService;
import com.elitesland.tw.tw5.api.prd.my.service.ProjectService;
import com.elitesland.tw.tw5.api.prd.my.service.ResActivityService;
import com.elitesland.tw.tw5.api.prd.my.service.TaskService;
import com.elitesland.tw.tw5.api.prd.my.service.TimesheetService;
import com.elitesland.tw.tw5.api.prd.my.vo.ProjectVO;
import com.elitesland.tw.tw5.api.prd.my.vo.ResActivityVO;
import com.elitesland.tw.tw5.api.prd.my.vo.TaskVO;
import com.elitesland.tw.tw5.api.prd.my.vo.TimesheetSyncDataVO;
import com.elitesland.tw.tw5.api.prd.my.vo.TimesheetVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgDataRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.DateUtil;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.my.constant.ProjectEnum;
import com.elitesland.tw.tw5.server.prd.my.constant.TimesheetStatus;
import com.elitesland.tw.tw5.server.prd.my.convert.TimesheetConvert;
import com.elitesland.tw.tw5.server.prd.my.dao.PrdUserDAO;
import com.elitesland.tw.tw5.server.prd.my.dao.TimesheetDAO;
import com.elitesland.tw.tw5.server.prd.my.entity.QTimesheetDO;
import com.elitesland.tw.tw5.server.prd.my.entity.TimesheetDO;
import com.elitesland.tw.tw5.server.prd.my.repo.TaskRepo;
import com.elitesland.tw.tw5.server.prd.my.repo.TimesheetRepo;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgSyncLogDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgOrganizationDO;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class TimesheetServiceImpl
implements TimesheetService {
    private static final Logger log = LoggerFactory.getLogger(TimesheetServiceImpl.class);
    private final TimesheetRepo timesheetRepo;
    private final TaskService taskService;
    private final TaskRepo taskRepo;
    private final ResActivityService resActivityService;
    private final CrmOperationPlanDetailService crmOperationPlanDetailService;
    private final ProjectService projectService;
    private final PrdOrgEmployeeDAO employeeDAO;
    private final JPAQueryFactory jpaQueryFactory;
    private final PrdUserService prdUserService;
    private final HttpUtil httpUtil;
    private final PrdOrgSyncLogDAO daoLog;
    private final PrdSystemRoleDAO systemRoleDAO;
    private final PrdUserDAO daoUser;
    private final PrdOrgOrganizationDAO prdOrgOrganizationDAO;
    private final TimesheetDAO timesheetDAO;
    @Value(value="${tw4.url}")
    private String tw4_url;
    @Value(value="${tw4.sync.getProjectEqvaInfo:api/openReport/v1/sync/getProjectEqvaInfo}")
    private String getProjectEqvaInfo;

    public PagingVO<TimesheetVO> paging(TimesheetQuery query) {
        this.getPermissionParams(query);
        return this.timesheetDAO.queryPaging(query);
    }

    private void getPermissionParams(TimesheetQuery query) {
        if (query.getIsPermission().booleanValue()) {
            Long loginUserId = GlobalUtil.getLoginUserId();
            boolean isSystemAdmin = GlobalUtil.getLoginGeneralUser().isSystemAdmin();
            if (!isSystemAdmin) {
                List<Long> userIdsByPlatRole = this.systemRoleDAO.queryUserIdByRoleCodes(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.TIME_SHEET_MANAGER.getCode()));
                List<PrdOrgOrganizationDO> organizationDOList = this.prdOrgOrganizationDAO.queryByManagerId(loginUserId);
                Set<Long> orgIdList = null;
                if (!CollectionUtils.isEmpty(organizationDOList)) {
                    orgIdList = organizationDOList.stream().map(BaseModel::getId).collect(Collectors.toSet());
                }
                List<PrdOrgEmployeeRefVO> empRef = this.daoUser.queryLowListByKey(null, loginUserId);
                Set empRefUserIdList = empRef.stream().map(prdOrgEmployeeRefVO -> prdOrgEmployeeRefVO.getUserId()).collect(Collectors.toSet());
                if (CollectionUtils.isEmpty(userIdsByPlatRole) || !userIdsByPlatRole.contains(loginUserId)) {
                    HashSet<Long> queryUserIds = new HashSet<Long>();
                    queryUserIds.add(loginUserId);
                    if (orgIdList != null && !orgIdList.isEmpty()) {
                        List<PrdOrgEmployeeRefVO> prdOrgEmployeeRefVOS = this.prdOrgOrganizationDAO.queryEmployeeList(orgIdList);
                        Set collect = prdOrgEmployeeRefVOS.stream().map(e -> e.getUserId()).collect(Collectors.toSet());
                        queryUserIds.addAll(collect);
                    }
                    if (empRefUserIdList != null && empRefUserIdList.isEmpty()) {
                        queryUserIds.addAll(empRefUserIdList);
                    }
                    query.setTsUserIdList(queryUserIds);
                }
            }
        }
    }

    public PagingVO<TimesheetVO> pagingSingle(TimesheetQuery query) {
        Page page = this.timesheetRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), (Pageable)query.getPageRequest());
        return PageUtil.toPageVo(page.map(TimesheetConvert.INSTANCE::toVo));
    }

    public PagingVO pagingGroup(TimesheetQuery query) {
        query.setOrders(null);
        Page<Object[]> page = this.timesheetRepo.pagingGroup(query.getTsUserId(), query.getApprUserId(), query.getTsStatus(), query.getTsUserBuId(), query.getTimesheetIdV4IsNull(), (Pageable)query.getPageRequest());
        List content = page.getContent();
        List<TimesheetVO> all = this.getAll(content);
        this.setTheoryGetEqva(all);
        return PagingVO.builder().records(all).total(page.getTotalElements()).build();
    }

    public void setTheoryGetEqva(List<TimesheetVO> list) {
        if (list != null && list.size() > 0) {
            for (TimesheetVO timeView : list) {
                String[] groupIdsArr = timeView.getGroupIds().split(",");
                BigDecimal bd = new BigDecimal("0");
                for (int i = 0; i < groupIdsArr.length; ++i) {
                    TaskVO task;
                    TimesheetVO data = this.queryByKey(Long.valueOf(groupIdsArr[i]));
                    if (data.getTaskId() == null || data.getTaskId() <= 0L || (task = this.taskService.queryByTaskIdV4(data.getTaskId())) == null || !"04".equals(task.getAcceptMethod())) continue;
                    bd = bd.add(data.getWorkHour().divide(new BigDecimal("8"), 1, RoundingMode.UP).multiply(task.getEqvaRatio()));
                }
                timeView.setTheoryGetEqva(bd);
            }
        }
    }

    public List<TimesheetVO> getAll(List<Object[]> objects) {
        ArrayList<TimesheetVO> list = new ArrayList<TimesheetVO>();
        for (Object[] obj : objects) {
            TimesheetVO timesheetVO = new TimesheetVO();
            timesheetVO.setGroupIds(String.valueOf(obj[0]));
            timesheetVO.setWorkHour(BigDecimal.valueOf(Double.parseDouble(String.valueOf(obj[1]))));
            timesheetVO.setProjId(obj[2] != null ? Long.valueOf(String.valueOf(obj[2])) : null);
            timesheetVO.setProjNo(String.valueOf(obj[3]));
            timesheetVO.setProjName(String.valueOf(obj[4]));
            timesheetVO.setTsStatus(String.valueOf(obj[5]));
            timesheetVO.setApprUserId(obj[6] != null ? Long.valueOf(String.valueOf(obj[6])) : null);
            timesheetVO.setWeekStartDate(obj[7] != null ? LocalDate.parse(String.valueOf(obj[7])) : null);
            timesheetVO.setTaskId(obj[8] != null ? Long.valueOf(String.valueOf(obj[8])) : null);
            timesheetVO.setTaskNo(String.valueOf(obj[9]));
            timesheetVO.setTaskName(String.valueOf(obj[10]));
            timesheetVO.setTsUserId(obj[11] != null ? Long.valueOf(String.valueOf(obj[11])) : null);
            timesheetVO.setTsUserBuId(obj[12] != null ? Long.valueOf(String.valueOf(obj[12])) : null);
            timesheetVO.setTsUserBuName(obj[13] != null ? String.valueOf(obj[13]) : "");
            list.add(timesheetVO);
        }
        return list;
    }

    public List<TimesheetVO> listGroup(TimesheetQuery query) {
        QTimesheetDO qTimesheetDO = QTimesheetDO.timesheetDO;
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)qTimesheetDO).from((EntityPath)qTimesheetDO)).where((Predicate)qTimesheetDO.deleteFlag.eq((Object)0));
        if (null != query.getTsUserId()) {
            jpaQuery.where((Predicate)qTimesheetDO.tsUserId.eq((Object)query.getTsUserId()));
        }
        if (null != query.getApprUserId()) {
            jpaQuery.where((Predicate)qTimesheetDO.apprUserId.eq((Object)query.getApprUserId()));
        }
        if (StringUtils.hasText((String)query.getTsStatus())) {
            jpaQuery.where((Predicate)qTimesheetDO.tsStatus.eq((Object)query.getTsStatus()));
        }
        QueryResults queryResults = ((JPAQuery)((JPAQuery)jpaQuery.groupBy(new Expression[]{qTimesheetDO.projId, qTimesheetDO.yearWeek, qTimesheetDO.tsUserId})).orderBy(new OrderSpecifier[]{qTimesheetDO.yearWeek.desc(), qTimesheetDO.tsUserId.desc()})).fetchResults();
        List<TimesheetVO> timesheetVOList = TimesheetConvert.INSTANCE.toVoList(queryResults.getResults());
        return timesheetVOList;
    }

    public List<TimesheetVO> queryList(TimesheetQuery query) {
        return TimesheetConvert.INSTANCE.toVoList(this.timesheetRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder)));
    }

    public List<TimesheetSyncDataVO> querySyncDataList(TimesheetQuery query) {
        return TimesheetConvert.INSTANCE.doListToSyncVo(this.timesheetRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder)));
    }

    public long count(TimesheetQuery query) {
        return this.timesheetRepo.count((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder));
    }

    public TimesheetVO queryByKey(Long key) {
        TimesheetDO entity = this.timesheetRepo.findById(key).orElseGet(TimesheetDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u5de5\u65f6\u4e0d\u5b58\u5728");
        TimesheetVO vo = TimesheetConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public TimesheetVO insert(TimesheetPayload payload) {
        this.check(payload);
        this.initData(payload);
        TimesheetDO entityDo = TimesheetConvert.INSTANCE.toDo(payload);
        return TimesheetConvert.INSTANCE.toVo((TimesheetDO)((Object)this.timesheetRepo.save((Object)entityDo)));
    }

    private void check(TimesheetPayload payload) {
        if (payload.isSubmitted()) {
            if (payload.getId() != null && payload.getId() > 0L) {
                TimesheetVO timesheetVO = this.queryByKey(payload.getId());
                if (!TimesheetStatus.CREATE.getCode().equals(timesheetVO.getTsStatus()) && !TimesheetStatus.REJECTED.getCode().equals(timesheetVO.getTsStatus())) {
                    throw TwException.error("", "\u53ea\u80fd\u63d0\u4ea4\u65b0\u5efa\u6216\u5df2\u9000\u56de\u7684\u5355\u636e");
                }
            } else {
                payload.setSubmitTime(LocalDateTime.now());
            }
            if (null == payload.getProjId()) {
                throw TwException.error("", "\u8bf7\u9009\u62e9\u9879\u76ee");
            }
            if (null == payload.getWorkDate()) {
                throw TwException.error("", "\u8bf7\u9009\u62e9\u5de5\u4f5c\u65e5\u671f");
            }
            if (!StringUtils.hasText((String)payload.getWorkDesc())) {
                throw TwException.error("", "\u8bf7\u8f93\u5165\u5de5\u4f5c\u65e5\u5fd7");
            }
            if (null == payload.getWorkHour()) {
                throw TwException.error("", "\u8bf7\u586b\u5199\u5de5\u65f6");
            }
            if (null != payload.getTaskId()) {
                TaskVO taskVO = this.taskService.queryByTaskIdV4(payload.getTaskId());
                if (null == taskVO) {
                    throw TwException.error("", "\u4efb\u52a1\u5305\u4e0d\u5b58\u5728");
                }
                if (!taskVO.getTaskStatus().equals("IN PROCESS") && !taskVO.getTaskIdV4().equals(0L)) {
                    throw TwException.error("", "\u8bf7\u9009\u62e9\u3010\u6fc0\u6d3b\u3011\u72b6\u6001\u7684\u4efb\u52a1\u5305");
                }
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public List<TimesheetVO> batchInsert(TimesheetListPayload payload) {
        List deleteIdList;
        ArrayList<TimesheetVO> timesheetVOList = new ArrayList<TimesheetVO>();
        List timesheetList = payload.getTimesheetList();
        if (!CollectionUtils.isEmpty((Collection)timesheetList)) {
            HashMap<Long, BigDecimal> taskUpdateEffectiveEqvaMap = new HashMap<Long, BigDecimal>();
            HashMap<Long, BigDecimal> taskUpdateUsedEqvaMap = new HashMap<Long, BigDecimal>();
            Set<Long> taskIdUpdateList = null;
            timesheetList.forEach(timesheetPayload -> {
                Long taskId = timesheetPayload.getTaskId();
                if (taskId != null && taskId.equals(0L)) {
                    timesheetPayload.setTaskId(null);
                }
            });
            if (payload.isSubmitted()) {
                this.checkWorkDate(payload);
                if (!this.workHourValidate(payload)) {
                    throw TwException.error("", "\u540c\u4e00\u5929\u7684\u5de5\u4f5c\u5c0f\u65f6\u5c0f\u4e8e\u7b49\u4e8e8");
                }
                String msgDevOps = this.validateDevOpsEqva(payload);
                if (StringUtils.hasText((String)msgDevOps)) {
                    throw TwException.error("", msgDevOps);
                }
                String msg = this.validateEqvaPro(payload, taskUpdateEffectiveEqvaMap, taskUpdateUsedEqvaMap);
                if (StringUtils.hasText((String)msg)) {
                    throw TwException.error("", msg);
                }
                taskIdUpdateList = timesheetList.stream().filter(ts -> ts.getTaskId() != null && ts.getTaskId() > 0L).map(TimesheetPayload::getTaskId).collect(Collectors.toSet());
            }
            timesheetList.forEach(timesheetPayload -> timesheetVOList.add(this.insert((TimesheetPayload)timesheetPayload)));
            if (!CollectionUtils.isEmpty(taskIdUpdateList)) {
                taskIdUpdateList.forEach(taskId -> this.updateTaskEffectiveEqvaAndUsedEqva((Map<Long, BigDecimal>)taskUpdateUsedEqvaMap, (Map<Long, BigDecimal>)taskUpdateEffectiveEqvaMap, (Long)taskId));
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(deleteIdList = payload.getDeleteIdList()))) {
            this.deleteSoft(deleteIdList);
        }
        return timesheetVOList;
    }

    private void checkWorkDate(TimesheetListPayload payload) {
        long count;
        LocalDate now = LocalDate.now();
        List timesheetList = payload.getTimesheetList();
        if (!CollectionUtils.isEmpty((Collection)timesheetList) && (count = timesheetList.stream().filter(timesheetPayload -> timesheetPayload.getWorkDate().isAfter(now)).count()) > 0L) {
            throw TwException.error("", "\u4e0d\u5141\u8bb8\u63d0\u524d\u63d0\u4ea4\u5de5\u65f6");
        }
    }

    private String validateDevOpsEqva(TimesheetListPayload payload) {
        Long loginUserId = GlobalUtil.getLoginUserId();
        List timesheetPayloadList = payload.getTimesheetList().stream().filter(timesheetPayload -> this.tsStatusCheck((TimesheetPayload)timesheetPayload) && timesheetPayload.getProjId() > 0L && StringUtils.hasText((String)timesheetPayload.getType()) && timesheetPayload.getType().equals(ProjectEnum.DEV_OPS.getCode())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(timesheetPayloadList)) {
            return null;
        }
        PrdOrgEmployeeDO prdOrgEmployeeDO = this.employeeDAO.queryByUserId(loginUserId);
        BigDecimal eqvaRatio = prdOrgEmployeeDO.getEqvaRatio();
        HashMap<Long, BigDecimal> tsEqvaMap = null;
        if (!CollectionUtils.isEmpty(timesheetPayloadList)) {
            if (tsEqvaMap == null) {
                tsEqvaMap = new HashMap<Long, BigDecimal>();
            }
            for (TimesheetPayload ts : timesheetPayloadList) {
                BigDecimal eqva = this.calProjTsUsedEqvasByTsDetail(ts.getWorkDate(), eqvaRatio, ts.getProjId(), ts.getWorkHour());
                tsEqvaMap.put(ts.getProjId(), eqva);
            }
        }
        HashMap<Long, BigDecimal> tsEqvaMapTemp = tsEqvaMap;
        Map<Long, List<TimesheetPayload>> taskTsMap = timesheetPayloadList.stream().collect(Collectors.groupingBy(TimesheetPayload::getProjId));
        Set<Long> projIdSet = taskTsMap.keySet();
        return null;
    }

    private String validateEqva(TimesheetListPayload payload) {
        List timesheetPayloadList = payload.getTimesheetList().stream().filter(timesheetPayload -> this.tsStatusCheck((TimesheetPayload)timesheetPayload)).collect(Collectors.toList());
        List tsListTmp = timesheetPayloadList.stream().filter(ts -> ts.getTaskId() != null && ts.getTaskId() > 0L).collect(Collectors.toList());
        if (tsListTmp == null || tsListTmp.size() == 0) {
            return null;
        }
        List<Long> taskIdList = tsListTmp.stream().map(t -> t.getTaskId()).collect(Collectors.toList());
        TaskQuery taskQuery = new TaskQuery();
        taskQuery.setTaskIdV4List(taskIdList);
        List taskVOList = this.taskService.queryList(taskQuery);
        Map<Long, BigDecimal> tsUsedEqvaMap = this.calTsUsedEqvasByIds(taskIdList);
        Map<Long, BigDecimal> tsEffectiveEqva = taskVOList.stream().map(t -> {
            if (tsUsedEqvaMap != null) {
                t.setTsUsedEqva((BigDecimal)tsUsedEqvaMap.get(t.getTaskIdV4()));
            }
            return t;
        }).collect(Collectors.toMap(TaskVO::getTaskIdV4, TaskVO::getTsEffectiveEqva));
        tsListTmp.stream().forEach(ts -> {
            if (ts.getId() == null) {
                ts.setId(Long.valueOf(Math.round(Math.random() * 1.0E8) * -1L));
            }
        });
        List<Long> tsIds = tsListTmp.stream().map(ts -> ts.getId()).collect(Collectors.toList());
        Map<Long, BigDecimal> tsEqvaMap = this.calTsUsedEqvasByTsIds(tsIds);
        List tsTemp = tsListTmp.stream().filter(ts -> ts.getId() < 0L).collect(Collectors.toList());
        if (tsTemp != null || tsTemp.size() > 0) {
            if (tsEqvaMap == null) {
                tsEqvaMap = new HashMap<Long, BigDecimal>();
            }
            for (TimesheetPayload ts2 : tsTemp) {
                BigDecimal eqva = this.calTsUsedEqvasByTsDetail(ts2.getWorkDate(), ts2.getTsUserId(), ts2.getTaskId(), ts2.getWorkHour());
                tsEqvaMap.put(ts2.getId(), eqva);
            }
        }
        Map<Long, BigDecimal> tsEqvaMapTemp = tsEqvaMap;
        Map<Long, List<TimesheetPayload>> taskTsMap = tsListTmp.stream().collect(Collectors.groupingBy(TimesheetPayload::getTaskId));
        Set<Long> taskIdSet = taskTsMap.keySet();
        for (Long taskId : taskIdSet) {
            BigDecimal tsSubmitEqva = taskTsMap.get(taskId).stream().map(ts -> tsEqvaMapTemp.get(ts.getId()) == null ? BigDecimal.ZERO : (BigDecimal)tsEqvaMapTemp.get(ts.getId())).reduce(BigDecimal::add).get();
            BigDecimal tsEffecttiveEqva = tsEffectiveEqva.get(taskId);
            System.out.println("\u5f53\u524d\u4efb\u52a1\u5305\u4e0b\u6240\u6709\u5de5\u65f6\u4e0a\u62a5\u7684\u603b\u5f53\u91cf:" + tsSubmitEqva);
            System.out.println("\u8ba1\u7b97\u4efb\u52a1\u5305\u5269\u4f59\u53ef\u7528\u4e8e\u586b\u62a5\u5de5\u65f6\u7684\u5f53\u91cf:" + tsEffecttiveEqva);
            if (tsSubmitEqva == null || tsEffecttiveEqva == null || !(tsSubmitEqva.doubleValue() > tsEffecttiveEqva.doubleValue())) continue;
            String taskName = taskVOList.stream().filter(t -> t.getTaskIdV4().longValue() == taskId.longValue()).map(t -> t.getTaskName()).findAny().get();
            return "\u4efb\u52a1\u5305\u5f53\u91cf\u4e0d\u8db3\uff01\u672c\u6b21\u586b\u62a5\u7684\u4efb\u52a1\u5305\u3010" + taskName + "\u3011\u603b\u7684\u5de5\u65f6\u5f53\u91cf\u3010" + tsSubmitEqva + "\u3011\u5927\u4e8e\u4efb\u52a1\u5305\u5269\u4f59\u53ef\u7528\u4e8e\u5de5\u65f6\u586b\u62a5\u7684\u5f53\u91cf\u3010" + tsEffecttiveEqva + "\u3011\uff0c\u8bf7\u586b\u62a5\u5176\u4ed6\u4efb\u52a1\u5305\u6216\u5411\u53d1\u5305\u4eba\u7533\u8bf7\u7ed9\u4efb\u52a1\u5305\u8ffd\u52a0\u5f53\u91cf";
        }
        return null;
    }

    private String validateEqvaPro(TimesheetListPayload payload, Map<Long, BigDecimal> taskUpdateMap, Map<Long, BigDecimal> taskUpdateUsedEqvaMap) {
        List timesheetPayloadList = payload.getTimesheetList().stream().filter(timesheetPayload -> this.tsStatusCheck((TimesheetPayload)timesheetPayload)).collect(Collectors.toList());
        List tsListTmp = timesheetPayloadList.stream().filter(ts -> ts.getTaskId() != null && ts.getTaskId() > 0L).collect(Collectors.toList());
        if (tsListTmp == null || tsListTmp.size() == 0) {
            return null;
        }
        List taskIdList = tsListTmp.stream().map(t -> t.getTaskId()).collect(Collectors.toList());
        TaskQuery taskQuery = new TaskQuery();
        taskQuery.setTaskIdV4List(taskIdList);
        List taskVOList = this.taskService.queryList(taskQuery);
        Map<Long, BigDecimal> tsEffectiveEqva = taskVOList.stream().collect(Collectors.toMap(TaskVO::getTaskIdV4, TaskVO::getEffectiveEqva));
        tsListTmp.stream().forEach(ts -> {
            if (ts.getId() == null) {
                ts.setId(Long.valueOf(Math.round(Math.random() * 1.0E8) * -1L));
            }
        });
        List<Long> tsIds = tsListTmp.stream().map(ts -> ts.getId()).collect(Collectors.toList());
        Map<Long, BigDecimal> tsEqvaMap = this.calTsUsedEqvasByTsIds(tsIds);
        List tsTemp = tsListTmp.stream().filter(ts -> ts.getId() < 0L).collect(Collectors.toList());
        if (tsTemp != null || tsTemp.size() > 0) {
            if (tsEqvaMap == null) {
                tsEqvaMap = new HashMap<Long, BigDecimal>();
            }
            for (TimesheetPayload ts2 : tsTemp) {
                BigDecimal eqva = this.calTsUsedEqvasByTsDetail(ts2.getWorkDate(), ts2.getTsUserId(), ts2.getTaskId(), ts2.getWorkHour());
                tsEqvaMap.put(ts2.getId(), eqva);
            }
        }
        Map<Long, BigDecimal> tsEqvaMapTemp = tsEqvaMap;
        Map<Long, List<TimesheetPayload>> taskTsMap = tsListTmp.stream().collect(Collectors.groupingBy(TimesheetPayload::getTaskId));
        Set<Long> taskIdSet = taskTsMap.keySet();
        for (Long taskId : taskIdSet) {
            BigDecimal tsSubmitEqva = taskTsMap.get(taskId).stream().map(ts -> tsEqvaMapTemp.get(ts.getId()) == null ? BigDecimal.ZERO : (BigDecimal)tsEqvaMapTemp.get(ts.getId())).reduce(BigDecimal::add).get();
            BigDecimal tsEffecttiveEqva = tsEffectiveEqva.get(taskId);
            log.info("\u5f53\u524d\u4efb\u52a1\u5305\u4e0b\u6240\u6709\u5de5\u65f6\u4e0a\u62a5\u7684\u603b\u5f53\u91cf:" + tsSubmitEqva);
            log.info("\u8ba1\u7b97\u4efb\u52a1\u5305\u5269\u4f59\u53ef\u7528\u4e8e\u586b\u62a5\u5de5\u65f6\u7684\u5f53\u91cf:" + tsEffecttiveEqva);
            if (tsSubmitEqva != null && tsEffecttiveEqva != null && tsSubmitEqva.doubleValue() > tsEffecttiveEqva.doubleValue()) {
                String taskName = taskVOList.stream().filter(t -> t.getTaskIdV4().longValue() == taskId.longValue()).map(t -> t.getTaskName()).findAny().get();
                return "\u4efb\u52a1\u5305\u5f53\u91cf\u4e0d\u8db3\uff01\u672c\u6b21\u586b\u62a5\u7684\u4efb\u52a1\u5305\u3010" + taskName + "\u3011\u603b\u7684\u5de5\u65f6\u5f53\u91cf\u3010" + tsSubmitEqva + "\u3011\u5927\u4e8e\u4efb\u52a1\u5305\u5269\u4f59\u53ef\u7528\u4e8e\u5de5\u65f6\u586b\u62a5\u7684\u5f53\u91cf\u3010" + tsEffecttiveEqva + "\u3011\uff0c\u8bf7\u586b\u62a5\u5176\u4ed6\u4efb\u52a1\u5305\u6216\u5411\u53d1\u5305\u4eba\u7533\u8bf7\u7ed9\u4efb\u52a1\u5305\u8ffd\u52a0\u5f53\u91cf";
            }
            taskUpdateMap.put(taskId, tsEffecttiveEqva.subtract(tsSubmitEqva));
            taskUpdateUsedEqvaMap.put(taskId, tsSubmitEqva == null ? BigDecimal.ZERO : tsSubmitEqva);
        }
        return null;
    }

    private void updateTaskEffectiveEqvaAndUsedEqva(Map<Long, BigDecimal> taskUpdateUsedEqvaMap, Map<Long, BigDecimal> taskUpdateMap, Long taskId) {
        if (null != taskId && taskId > 0L && null != taskUpdateMap.get(taskId)) {
            this.taskRepo.updateTaskEffectiveEqvaAndUsedEqva(taskId, taskUpdateUsedEqvaMap.get(taskId), taskUpdateMap.get(taskId));
        }
    }

    private boolean tsStatusCheck(TimesheetPayload timesheetPayload) {
        timesheetPayload.setTsUserId(GlobalUtil.getLoginUserId());
        boolean flag = timesheetPayload.getTsStatus() != null && (timesheetPayload.getTsStatus().equals(TimesheetStatus.CREATE.getCode()) || timesheetPayload.getTsStatus().equals(TimesheetStatus.REJECTED.getCode()));
        return flag;
    }

    private BigDecimal calTsUsedEqvasByTsDetail(LocalDate workDate, Long tsUserId, Long taskId, BigDecimal workHour) {
        TaskVO task;
        if (workDate == null || taskId == null) {
            return null;
        }
        if (tsUserId == null) {
            tsUserId = GlobalUtil.getLoginUserId();
        }
        if ((task = this.taskService.queryByTaskIdV4(taskId)) == null) {
            return null;
        }
        BigDecimal eqvaRatio = null;
        if ("04".equals(task.getAcceptMethod()) && task.getEqvaRatio() != null) {
            eqvaRatio = task.getEqvaRatio();
        } else {
            PrdOrgEmployeeDO prdOrgEmployeeDO = this.employeeDAO.queryByUserId(tsUserId);
            BigDecimal bigDecimal = eqvaRatio = null != prdOrgEmployeeDO ? prdOrgEmployeeDO.getEqvaRatio() : null;
        }
        if (eqvaRatio == null) {
            return null;
        }
        if (workHour == null) {
            workHour = BigDecimal.valueOf(8L);
        }
        return eqvaRatio.multiply(workHour).divide(BigDecimal.valueOf(8L), 2, RoundingMode.DOWN);
    }

    private BigDecimal calProjTsUsedEqvasByTsDetail(LocalDate workDate, BigDecimal eqvaRatio, Long projId, BigDecimal workHour) {
        if (workDate == null || projId == null) {
            return null;
        }
        if (eqvaRatio == null) {
            return null;
        }
        if (workHour == null) {
            workHour = BigDecimal.valueOf(8L);
        }
        return eqvaRatio.multiply(workHour).divide(BigDecimal.valueOf(8L), 2, RoundingMode.DOWN);
    }

    private Map<Long, BigDecimal> calTsUsedEqvasByIds(List<Long> taskIdList) {
        TimesheetQuery timesheetQuery = new TimesheetQuery();
        timesheetQuery.setTaskIdList(taskIdList);
        ArrayList<String> tsStatusList = new ArrayList<String>();
        tsStatusList.add(TimesheetStatus.APPROVED.getCode());
        tsStatusList.add(TimesheetStatus.APPROVING.getCode());
        timesheetQuery.setTsStatusList(tsStatusList);
        List<Object> tsViews = this.queryList(timesheetQuery);
        if (tsViews == null || tsViews.size() == 0) {
            return null;
        }
        Map<Long, BigDecimal> tsEqvaMap = this.calTsUsedEqvasByTsIds(tsViews.stream().map(ts -> ts.getId()).collect(Collectors.toList()));
        tsViews = tsViews.stream().map(ts -> {
            ts.setEqvaTimeSheet((BigDecimal)tsEqvaMap.get(ts.getId()));
            return ts;
        }).collect(Collectors.toList());
        HashMap<Long, BigDecimal> returnMap = new HashMap<Long, BigDecimal>();
        Map<Long, List<TimesheetVO>> taskTsMap = tsViews.stream().collect(Collectors.groupingBy(TimesheetVO::getTaskId));
        Set<Long> taskIdSet = taskTsMap.keySet();
        for (Long taskId : taskIdSet) {
            returnMap.put(taskId, taskTsMap.get(taskId).stream().map(ts -> ts.getEqvaTimeSheet() == null ? BigDecimal.ZERO : ts.getEqvaTimeSheet()).reduce(BigDecimal::add).get());
        }
        return returnMap;
    }

    private Map<Long, BigDecimal> calTsUsedEqvasByTsIds(List<Long> timeSheetIds) {
        TimesheetQuery timesheetQuery = new TimesheetQuery();
        timesheetQuery.setIdList(timeSheetIds);
        List<TimesheetVO> tsViews = this.queryList(timesheetQuery);
        List tsUserIdList = tsViews.stream().map(v -> v.getTsUserId()).collect(Collectors.toList());
        List<PrdOrgEmployeeDO> prdOrgEmployeeDOS = this.employeeDAO.queryListByUserIdList(tsUserIdList);
        Map<Long, BigDecimal> eqvaRatioMap = prdOrgEmployeeDOS.stream().collect(Collectors.toMap(PrdOrgEmployeeDO::getUserId, PrdOrgEmployeeDO::getEqvaRatio));
        log.warn("debug::::\u5f00\u59cb\u8ba1\u7b97\u5f53\u91cf\u7cfb\u6570\uff1a\uff1a\uff1a" + eqvaRatioMap.toString());
        for (TimesheetVO v2 : tsViews) {
            TaskVO taskVO = this.taskService.queryByTaskIdV4(v2.getTaskId());
            if ("04".equals(taskVO.getAcceptMethod()) && taskVO.getEqvaRatio() != null) continue;
            v2.setEqvaRatio(null);
            BigDecimal eqvaRatio = eqvaRatioMap.get(v2.getTsUserId());
            v2.setEqvaRatio(eqvaRatio);
        }
        return tsViews.stream().collect(Collectors.toMap(BaseViewModel::getId, TimesheetVO::getEqvaTimeSheet));
    }

    private boolean workHourValidate(TimesheetListPayload payload) {
        Map<LocalDate, Double> resultMap = payload.getTimesheetList().stream().filter(timesheetPayload -> timesheetPayload.getTsStatus() != null && (timesheetPayload.getTsStatus().equals(TimesheetStatus.CREATE.getCode()) || timesheetPayload.getTsStatus().equals(TimesheetStatus.REJECTED.getCode()))).collect(Collectors.groupingBy(TimesheetPayload::getWorkDate, Collectors.summingDouble(TimesheetPayload::getDoubleWorkHour)));
        ArrayList isValid = new ArrayList();
        resultMap.forEach((date, workHour) -> {
            TimesheetQuery query = new TimesheetQuery();
            query.setTsStatusList(Arrays.asList(TimesheetStatus.APPROVED.getCode(), TimesheetStatus.APPROVING.getCode(), TimesheetStatus.SETTLED.getCode()));
            query.setTsUserId(GlobalUtil.getLoginUserId());
            query.setWorkDateQuery(date);
            List<TimesheetVO> timesheetVOList = this.queryList(query);
            Double wh = timesheetVOList.stream().collect(Collectors.summingDouble(t -> t.getWorkHour().doubleValue()));
            if (workHour + wh > 8.0) {
                isValid.add(false);
            }
        });
        return !isValid.contains(false);
    }

    private void initData(TimesheetPayload payload) {
        List list;
        payload.setWorkDayOffStatus("UNGEN");
        payload.setWorkFlag("NO");
        payload.setSettleStatus("NONE");
        payload.setAutoSaveFlag(Integer.valueOf(0));
        payload.setTsUserId(GlobalUtil.getLoginUserId());
        List prdOrgDataRefVOS = this.prdUserService.queryOrgList();
        if (!CollectionUtils.isEmpty((Collection)prdOrgDataRefVOS) && !CollectionUtils.isEmpty(list = prdOrgDataRefVOS.stream().filter(prdOrgDataRefVO -> prdOrgDataRefVO.getIsDefault().equals(0)).collect(Collectors.toList()))) {
            Long orgId = ((PrdOrgDataRefVO)list.get(0)).getOrgId();
            String orgName = ((PrdOrgDataRefVO)list.get(0)).getOrgName();
            payload.setTsUserBuId(orgId);
            payload.setTsUserBuName(orgName);
        }
        if (null != payload.getProjId()) {
            ProjectVO projectVO = this.projectService.queryByProjIdV4(payload.getProjId());
            if (!StringUtils.hasText((String)payload.getProjNo())) {
                payload.setProjNo(null != projectVO ? projectVO.getProjNo() : "");
            }
            if (!StringUtils.hasText((String)payload.getProjName())) {
                payload.setProjName(null != projectVO ? projectVO.getProjName() : "");
            }
        }
        if (null != payload.getTaskId()) {
            TaskVO taskVO = this.taskService.queryByTaskIdV4(payload.getTaskId());
            if (!StringUtils.hasText((String)payload.getTaskNo())) {
                payload.setTaskNo(null != taskVO ? taskVO.getTaskNo() : "");
            }
            if (!StringUtils.hasText((String)payload.getTaskName())) {
                payload.setTaskName(null != taskVO ? taskVO.getTaskName() : "");
            }
            if (null == payload.getEqva()) {
                payload.setEqva(null != taskVO ? taskVO.getEqvaQty() : null);
            }
        }
        if (null != payload.getActId()) {
            ResActivityVO resActivityVO = this.resActivityService.queryByActivityIdV4(payload.getActId());
            if (!StringUtils.hasText((String)payload.getActNo())) {
                payload.setActNo(null != resActivityVO ? resActivityVO.getActNo() : "");
            }
            if (!StringUtils.hasText((String)payload.getActName())) {
                payload.setActName(null != resActivityVO ? resActivityVO.getActName() : "");
            }
        }
        if (null != payload.getOperPlanId()) {
            CrmOperationPlanDetailVO planDetailVO = this.crmOperationPlanDetailService.queryByKey(payload.getOperPlanId());
            if (!StringUtils.hasText((String)payload.getOperPlanName())) {
                payload.setOperPlanName(null != planDetailVO ? planDetailVO.getPlanName() : "");
            }
        }
        payload.setApprResult(null);
        if (payload.isSubmitted()) {
            payload.setTsStatus(TimesheetStatus.APPROVING.getCode());
            payload.setApprUserId(this.findApprUserId(payload));
            if (payload.getId() != null && payload.getId() > 0L) {
                entity = this.timesheetRepo.findById(payload.getId()).orElseGet(TimesheetDO::new);
                Assert.notNull((Object)entity.getId(), (String)"\u5de5\u65f6\u4e0d\u5b58\u5728");
                payload.setSubmitTime(entity.getSubmitTime());
            } else {
                payload.setSubmitTime(LocalDateTime.now());
            }
        } else if (payload.getId() != null && payload.getId() > 0L) {
            entity = this.timesheetRepo.findById(payload.getId()).orElseGet(TimesheetDO::new);
            Assert.notNull((Object)entity.getId(), (String)"\u5de5\u65f6\u4e0d\u5b58\u5728");
            payload.setSubmitTime(entity.getSubmitTime());
            payload.setTsStatus(entity.getTsStatus());
        } else {
            payload.setTsStatus(TimesheetStatus.CREATE.getCode());
        }
        if (payload.getWorkDate() != null) {
            payload.setYearWeek(Integer.valueOf(Integer.parseInt(DateUtil.getYearWeek(payload.getWorkDate()))));
            payload.setWeekStartDate(DateUtil.getStartWeekDay(payload.getWorkDate()));
        }
    }

    private Long findApprUserId(TimesheetPayload payload) {
        PrdOrgEmployeeRefVO prdOrgEmployeeRefVO;
        if (payload.getTaskId() != null) {
            Long apprResIdByAuthInfo = this.taskService.getApprResIdByAuthInfo(payload.getTaskId());
            if (null != apprResIdByAuthInfo) {
                return apprResIdByAuthInfo;
            }
            Long taskDister = this.taskService.queryByTaskIdV4(payload.getTaskId()).getDisterUserId();
            if (taskDister != null && taskDister >= 0L) {
                return taskDister;
            }
        }
        if (payload.getProjId() != null) {
            Long pmId;
            ProjectQuery twProjectQuery = new ProjectQuery();
            twProjectQuery.setProjIdV4(payload.getProjId());
            List projects = this.projectService.queryList(twProjectQuery);
            if (projects != null && projects.size() > 0 && (pmId = ((ProjectVO)projects.get(0)).getPmUserId()) != null && pmId > 0L) {
                return pmId;
            }
        }
        if (null == (prdOrgEmployeeRefVO = this.employeeDAO.queryUserOrgData(payload.getTsUserId()))) {
            log.error("\u3010\u5339\u914d\u4e0d\u5230\u5ba1\u6279\u4eba\u3011\uff1a\u5de5\u65f6\u586b\u62a5\u7528\u6237\u4e3b\u952e\uff1a{} ; \u5de5\u65f6\u6570\u636e\uff1a{}", (Object)payload.getTsUserId(), (Object)payload);
            throw TwException.error("", "\u5339\u914d\u4e0d\u5230\u5ba1\u6279\u4eba\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        Long parentId = prdOrgEmployeeRefVO.getParentId();
        return parentId;
    }

    @Transactional(rollbackFor={Exception.class})
    public TimesheetVO update(TimesheetPayload payload) {
        if (payload.getProjId() != null) {
            ProjectVO projectVO = this.projectService.queryByProjIdV4(payload.getProjId());
            if (StringUtils.hasText((String)payload.getProjNo())) {
                payload.setProjNo(null != projectVO ? projectVO.getProjNo() : "");
            }
            if (StringUtils.hasText((String)payload.getProjName())) {
                payload.setProjName(null != projectVO ? projectVO.getProjName() : "");
            }
        }
        if (payload.getTaskId() != null) {
            TaskVO taskVO = this.taskService.queryByTaskIdV4(payload.getTaskId());
            if (StringUtils.hasText((String)payload.getTaskNo())) {
                payload.setTaskNo(null != taskVO ? taskVO.getTaskNo() : "");
            }
            if (StringUtils.hasText((String)payload.getTaskName())) {
                payload.setTaskName(null != taskVO ? taskVO.getTaskName() : "");
            }
            if (null == payload.getEqva()) {
                payload.setEqva(null != taskVO ? taskVO.getEqvaQty() : null);
            }
        }
        TimesheetDO entity = this.timesheetRepo.findById(payload.getId()).orElseGet(TimesheetDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u5de5\u65f6\u4e0d\u5b58\u5728");
        TimesheetDO entityDo = TimesheetConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return TimesheetConvert.INSTANCE.toVo((TimesheetDO)((Object)this.timesheetRepo.save((Object)entity)));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.timesheetRepo.findById(id);
                if (!optional.isEmpty()) {
                    TimesheetDO entity = (TimesheetDO)((Object)((Object)optional.get()));
                    if (!TimesheetStatus.CREATE.getCode().equals(entity.getTsStatus()) && !TimesheetStatus.REJECTED.getCode().equals(entity.getTsStatus())) {
                        throw TwException.error("", "\u53ea\u80fd\u5220\u9664\u72b6\u6001\u4e3a\u521b\u5efa\u6216\u8005\u9000\u56de\u7684\u5de5\u65f6");
                    }
                    entity.setDeleteFlag(1);
                    this.timesheetRepo.save((Object)entity);
                }
            });
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void toApproved(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.timesheetRepo.findById(id);
                if (!optional.isEmpty()) {
                    TimesheetDO entity = (TimesheetDO)((Object)((Object)optional.get()));
                    if (!TimesheetStatus.APPROVING.getCode().equals(entity.getTsStatus())) {
                        throw TwException.error("", "\u53ea\u6709\u5ba1\u6279\u4e2d\u7684\u5355\u636e\u624d\u5141\u8bb8\u5ba1\u6279\u901a\u8fc7");
                    }
                    if (!GlobalUtil.getLoginUserId().equals(entity.getApprUserId())) {
                        throw TwException.error("", "\u5ba1\u6279\u4eba\u9519\u8bef");
                    }
                    entity.setTsStatus(TimesheetStatus.APPROVED.getCode());
                    entity.setApprResult("\u5ba1\u6279\u901a\u8fc7");
                    this.timesheetRepo.save((Object)entity);
                }
            });
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void toAdvanced(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.timesheetRepo.findById(id);
                if (!optional.isEmpty()) {
                    TimesheetDO entity = (TimesheetDO)((Object)((Object)optional.get()));
                    if (!TimesheetStatus.APPROVING.getCode().equals(entity.getTsStatus()) && !TimesheetStatus.CREATE.getCode().equals(entity.getTsStatus())) {
                        throw TwException.error("", "\u53ea\u6709\u5ba1\u6279\u4e2d\u6216\u65b0\u5efa\u7684\u5355\u636e\u624d\u5141\u8bb8\u5ba1\u6279\u901a\u8fc7");
                    }
                    entity.setTsStatus(TimesheetStatus.APPROVED.getCode());
                    entity.setApprResult("\u5ba1\u6279\u901a\u8fc7");
                    this.timesheetRepo.save((Object)entity);
                }
            });
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void rejected(List<Long> keys, String apprResult) {
        if (!keys.isEmpty()) {
            ArrayList<Long> taskIdList = new ArrayList<Long>();
            keys.stream().forEach(id -> {
                Optional optional = this.timesheetRepo.findById(id);
                if (!optional.isEmpty()) {
                    TimesheetDO entity = (TimesheetDO)((Object)((Object)optional.get()));
                    if (!TimesheetStatus.APPROVING.getCode().equals(entity.getTsStatus())) {
                        throw TwException.error("", "\u53ea\u6709\u5ba1\u6279\u4e2d\u7684\u5355\u636e\u624d\u5141\u8bb8\u5ba1\u6279\u62d2\u7edd");
                    }
                    if (!GlobalUtil.getLoginUserId().equals(entity.getApprUserId())) {
                        throw TwException.error("", "\u5ba1\u6279\u4eba\u9519\u8bef");
                    }
                    entity.setTsStatus(TimesheetStatus.REJECTED.getCode());
                    entity.setApprResult(apprResult);
                    this.timesheetRepo.save((Object)entity);
                    Long taskId = entity.getTaskId();
                    if (null != taskId && taskId > 0L) {
                        taskIdList.add(taskId);
                    }
                }
            });
            if (!CollectionUtils.isEmpty(taskIdList)) {
                this.updateTaskTimesheetEqva(taskIdList);
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void revoked(List<Long> keys) {
        if (!keys.isEmpty()) {
            ArrayList<Long> taskIdList = new ArrayList<Long>();
            keys.stream().forEach(id -> {
                Optional optional = this.timesheetRepo.findById(id);
                if (!optional.isEmpty()) {
                    TimesheetDO entity = (TimesheetDO)((Object)((Object)optional.get()));
                    if (!TimesheetStatus.APPROVING.getCode().equals(entity.getTsStatus())) {
                        throw TwException.error("", "\u53ea\u6709\u5ba1\u6279\u4e2d\u7684\u5355\u636e\u624d\u5141\u8bb8\u64a4\u56de");
                    }
                    entity.setTsStatus(TimesheetStatus.CREATE.getCode());
                    entity.setApprUserId(null);
                    entity.setApprResult("\u5ba1\u6279\u64a4\u56de");
                    this.timesheetRepo.save((Object)entity);
                    Long taskId = entity.getTaskId();
                    if (null != taskId && taskId > 0L) {
                        taskIdList.add(taskId);
                    }
                }
            });
            if (!CollectionUtils.isEmpty(taskIdList)) {
                this.updateTaskTimesheetEqva(taskIdList);
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateTaskTimesheetEqva(List<Long> taskIdList) {
        if (!CollectionUtils.isEmpty(taskIdList)) {
            TaskQuery query = new TaskQuery();
            query.setTaskIdV4List(taskIdList);
            List taskList = this.taskService.queryList(query);
            Map<Long, BigDecimal> tsUsedEqvaMap = this.calTsUsedEqvasByIds(taskIdList);
            Map<Long, BigDecimal> tsEffectiveEqva = taskList.stream().map(t -> {
                if (tsUsedEqvaMap != null) {
                    t.setTsUsedEqva((BigDecimal)tsUsedEqvaMap.get(t.getTaskIdV4()));
                }
                return t;
            }).collect(Collectors.toMap(TaskVO::getTaskIdV4, TaskVO::getTsEffectiveEqva));
            HashSet<Long> taskIdsSet = new HashSet<Long>();
            taskIdsSet.addAll(taskIdList);
            for (Long taskId : taskIdsSet) {
                BigDecimal tsEffecttiveEqva = tsEffectiveEqva.get(taskId);
                if (null != tsEffecttiveEqva) {
                    this.taskRepo.updateTaskEffectiveEqva(taskId, tsEffecttiveEqva);
                }
                BigDecimal usedEqva = BigDecimal.ZERO;
                if (null != tsUsedEqvaMap) {
                    usedEqva = tsUsedEqvaMap.get(taskId) != null ? tsUsedEqvaMap.get(taskId) : BigDecimal.ZERO;
                }
                this.taskRepo.updateUsedEqva(taskId, usedEqva);
            }
        }
    }

    public Map<Long, Long> getTimesheetAndPlanIds() {
        HashMap<Long, Long> orgMap = new HashMap<Long, Long>();
        List<Map<String, Object>> timeSheetAndPlanIds = this.timesheetRepo.getTimesheetAndPlanIds();
        for (Map<String, Object> timesheetAndPlanId : timeSheetAndPlanIds) {
            Long timesheetId = (Long)timesheetAndPlanId.get("timesheetId");
            Long workPlanId = (Long)timesheetAndPlanId.get("workPlanId");
            if (timesheetId == null || workPlanId == null) continue;
            orgMap.put(timesheetId, workPlanId);
        }
        return orgMap;
    }

    public Map<Long, Long> getV4AndV5TimesheetIds() {
        HashMap<Long, Long> timesheetMap = new HashMap<Long, Long>();
        List<Map<String, Object>> v4AndV5TimesheetIds = this.timesheetRepo.getV4AndV5TimesheetIds();
        for (Map<String, Object> v4AndV5TimesheetId : v4AndV5TimesheetIds) {
            Long timesheetId = (Long)v4AndV5TimesheetId.get("timesheetId");
            Long timesheetIdV4 = (Long)v4AndV5TimesheetId.get("timesheetIdV4");
            if (timesheetId == null || timesheetIdV4 == null) continue;
            timesheetMap.put(timesheetIdV4, timesheetId);
        }
        return timesheetMap;
    }

    public TimesheetServiceImpl(TimesheetRepo timesheetRepo, TaskService taskService, TaskRepo taskRepo, ResActivityService resActivityService, CrmOperationPlanDetailService crmOperationPlanDetailService, ProjectService projectService, PrdOrgEmployeeDAO employeeDAO, JPAQueryFactory jpaQueryFactory, PrdUserService prdUserService, HttpUtil httpUtil, PrdOrgSyncLogDAO daoLog, PrdSystemRoleDAO systemRoleDAO, PrdUserDAO daoUser, PrdOrgOrganizationDAO prdOrgOrganizationDAO, TimesheetDAO timesheetDAO) {
        this.timesheetRepo = timesheetRepo;
        this.taskService = taskService;
        this.taskRepo = taskRepo;
        this.resActivityService = resActivityService;
        this.crmOperationPlanDetailService = crmOperationPlanDetailService;
        this.projectService = projectService;
        this.employeeDAO = employeeDAO;
        this.jpaQueryFactory = jpaQueryFactory;
        this.prdUserService = prdUserService;
        this.httpUtil = httpUtil;
        this.daoLog = daoLog;
        this.systemRoleDAO = systemRoleDAO;
        this.daoUser = daoUser;
        this.prdOrgOrganizationDAO = prdOrgOrganizationDAO;
        this.timesheetDAO = timesheetDAO;
    }
}

