/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.sale.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.sale.payload.SaleContractTempPayload;
import com.elitesland.tw.tw5.api.prd.sale.query.SaleContractTempQuery;
import com.elitesland.tw.tw5.api.prd.sale.service.SaleContractTempService;
import com.elitesland.tw.tw5.api.prd.sale.vo.SaleContractTempVO;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.prd.sale.convert.SaleContractTempConvert;
import com.elitesland.tw.tw5.server.prd.sale.entity.SaleContractTempDO;
import com.elitesland.tw.tw5.server.prd.sale.repo.SaleContractTempRepo;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class SaleContractTempServiceImpl
implements SaleContractTempService {
    private static final Logger log = LoggerFactory.getLogger(SaleContractTempServiceImpl.class);
    private final SaleContractTempRepo saleContractTempRepo;

    @Transactional(rollbackFor={Exception.class})
    public SaleContractTempVO insert(SaleContractTempPayload payload) {
        SaleContractTempDO entityDo = SaleContractTempConvert.INSTANCE.toDo(payload);
        this.saleContractTempRepo.save(entityDo);
        return SaleContractTempConvert.INSTANCE.toVo(entityDo);
    }

    @Transactional(rollbackFor={Exception.class})
    public SaleContractTempVO update(SaleContractTempPayload payload) {
        SaleContractTempDO entity = this.saleContractTempRepo.findById(payload.getId()).orElseGet(SaleContractTempDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u5408\u540c\u6a21\u677f\u4e0d\u5b58\u5728");
        SaleContractTempDO entityDo = SaleContractTempConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return SaleContractTempConvert.INSTANCE.toVo((SaleContractTempDO)this.saleContractTempRepo.save(entity));
    }

    public SaleContractTempVO queryByKey(Long key) {
        SaleContractTempDO entity = this.saleContractTempRepo.findById(key).orElseGet(SaleContractTempDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u5408\u540c\u6a21\u677f\u4e0d\u5b58\u5728");
        return SaleContractTempConvert.INSTANCE.toVo(entity);
    }

    public List<SaleContractTempVO> queryList(SaleContractTempQuery query) {
        return SaleContractTempConvert.INSTANCE.toVoList(this.saleContractTempRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder)));
    }

    public PagingVO<SaleContractTempVO> paging(SaleContractTempQuery query) {
        Page page = this.saleContractTempRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), (Pageable)query.getPageRequest());
        return PageUtil.toPageVo(page.map(SaleContractTempConvert.INSTANCE::toVo));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.saleContractTempRepo.findById(id);
                if (!optional.isEmpty()) {
                    SaleContractTempDO entity = (SaleContractTempDO)optional.get();
                    entity.setDeleteFlag(1);
                    this.saleContractTempRepo.save(entity);
                }
            });
        }
    }

    public SaleContractTempServiceImpl(SaleContractTempRepo saleContractTempRepo) {
        this.saleContractTempRepo = saleContractTempRepo;
    }
}

