/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.system.controller;

import com.elitesland.tw.tw5.api.prd.system.payload.PrdMessageConfigPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdMessageConfigQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdMessageConfigService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdMessageConfigVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u6d88\u606f\u914d\u7f6e\u7ba1\u7406")
@RestController
@RequestMapping(value={"/api/system"})
public class PrdMessageConfigController {
    private static final Logger log = LoggerFactory.getLogger(PrdMessageConfigController.class);
    private final PrdMessageConfigService service;

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/message/insert"})
    public TwOutputUtil insert(PrdMessageConfigPayload entity) {
        PrdMessageConfigVO vo = this.service.insert(entity);
        return TwOutputUtil.ok(vo);
    }

    @ApiOperation(value="\u64a4\u56de")
    @PutMapping(value={"/message/recall"})
    public TwOutputUtil recall(Long[] keys) {
        this.service.recall(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="\u4fee\u6539")
    @PutMapping(value={"/message/update"})
    public TwOutputUtil update(PrdMessageConfigPayload entity) {
        this.service.update(entity);
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="\u903b\u8f91\u5220\u9664")
    @DeleteMapping(value={"/message/deleteSoft"})
    public TwOutputUtil deleteSoft(Long[] keys) {
        this.service.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="\u901a\u8fc7\u901a\u77e5\u8303\u56f4\u67e5\u8be2\u901a\u77e5\u6570\u636e")
    @GetMapping(value={"/message/queryDatas"})
    public TwOutputUtil queryDatas(String noticeScope) {
        return TwOutputUtil.ok(this.service.queryDatas(noticeScope));
    }

    @ApiOperation(value="\u67e5\u8be2\u53d1\u5e03\u6765\u6e90\u6570\u636e")
    @GetMapping(value={"/message/queryMyDatas"})
    public TwOutputUtil queryMyDatas(String releaseSource) {
        return TwOutputUtil.ok(this.service.queryMyDatas(releaseSource));
    }

    @ApiOperation(value="\u7269\u7406\u5220\u9664")
    @DeleteMapping(value={"/message/delete"})
    public TwOutputUtil delete(Long[] keys) {
        this.service.delete(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="\u4e3b\u952e\u67e5\u8be2")
    @GetMapping(value={"/message/{key}"})
    public TwOutputUtil findByKey(@PathVariable Long key) {
        PrdMessageConfigVO vo = this.service.queryByKey(key);
        return TwOutputUtil.ok(vo);
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    @GetMapping(value={"/message/paging"})
    public TwOutputUtil paging(PrdMessageConfigQuery query) {
        return TwOutputUtil.ok(this.service.paging(query));
    }

    @ApiOperation(value="\u4e00\u952e\u53d1\u5e03")
    @PutMapping(value={"/message/onKeyRelease"})
    public TwOutputUtil onKeyRelease(Long[] keys) {
        this.service.onKeyRelease(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    public PrdMessageConfigController(PrdMessageConfigService service) {
        this.service = service;
    }
}

