/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.system.service;

import cn.hutool.core.thread.ThreadUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOperationPlanDetailService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerOperationChanceVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerOperationVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOperationPlanDetailVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdCommentPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdCommentQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdCommentService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdCommentVO;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.QyWx.service.QyWxCommunicationService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmCustomerOperationChanceDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmCustomerOperationDAO;
import com.elitesland.tw.tw5.server.prd.system.constant.PrdCommentObjTypeEnum;
import com.elitesland.tw.tw5.server.prd.system.convert.PrdCommentConvert;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdCommentDO;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdCommentRepo;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
public class PrdCommentServiceImpl
implements PrdCommentService {
    private static final Logger log = LoggerFactory.getLogger(PrdCommentServiceImpl.class);
    private final PrdCommentRepo repo;
    private final QyWxCommunicationService qyWxCommunicationService;
    private final CrmOperationPlanDetailService crmOperationPlanDetailService;
    private final CrmCustomerOperationChanceDAO customerOperationChanceDAO;
    private final CrmCustomerOperationDAO crmCustomerOperationDAO;
    private final CacheUtil cacheUtil;
    private static final Long REPLY_ID_DEFAULT = 0L;

    @Transactional(rollbackFor={Exception.class})
    public PrdCommentVO insert(PrdCommentPayload payload) {
        this.check(payload);
        if (StringUtils.hasText((String)payload.getContent())) {
            this.dataProcess(payload);
            PrdCommentDO entityDo = PrdCommentConvert.INSTANCE.toDo(payload);
            this.repo.save((Object)entityDo);
            String loginUserName = GlobalUtil.getLoginUserName();
            if (StringUtils.hasText((String)payload.getAnnUserIds())) {
                ThreadUtil.execute(() -> {
                    if (payload.getObjType().equals(PrdCommentObjTypeEnum.OPER_PLAN.getCode())) {
                        this.sendMessageOperPlan(payload, loginUserName);
                    }
                    if (payload.getObjType().equals(PrdCommentObjTypeEnum.OPER_CHANCE.getCode())) {
                        this.sendMessageOperChange(payload, loginUserName);
                    }
                });
            }
            return PrdCommentConvert.INSTANCE.toVo(entityDo);
        }
        return PrdCommentConvert.INSTANCE.payloadToVo(payload);
    }

    private void sendMessageOperChange(PrdCommentPayload payload, String currentUserName) {
        if (StringUtils.hasText((String)payload.getAnnUserIds())) {
            List<Long> annUserIdsList = Arrays.stream(payload.getAnnUserIds().split(",")).map(s -> Long.valueOf(s)).collect(Collectors.toList());
            CrmCustomerOperationChanceVO changeVo = this.customerOperationChanceDAO.queryByKey(payload.getObjId());
            Long operId = changeVo.getOperId();
            CrmCustomerOperationVO customerOperationVO = this.crmCustomerOperationDAO.queryById(operId);
            String custName = customerOperationVO.getCustName();
            String planName = changeVo.getTitle();
            String temp = custName + "-" + planName;
            String content = currentUserName + "\u5728\u201c" + temp + "\u201d\u4e2d@\u4e86\u4f60";
            this.qyWxCommunicationService.sendMessageToUser(annUserIdsList, content);
        }
    }

    private void sendMessageOperPlan(PrdCommentPayload payload, String currentUserName) {
        if (StringUtils.hasText((String)payload.getAnnUserIds())) {
            List<Long> annUserIdsList = Arrays.stream(payload.getAnnUserIds().split(",")).map(s -> Long.valueOf(s)).collect(Collectors.toList());
            CrmOperationPlanDetailVO detailVO = this.crmOperationPlanDetailService.queryByKey(payload.getObjId());
            Long operId = detailVO.getOperId();
            CrmCustomerOperationVO customerOperationVO = this.crmCustomerOperationDAO.queryById(operId);
            String custName = customerOperationVO.getCustName();
            String planName = detailVO.getPlanName();
            String temp = custName + "-" + planName;
            String content = currentUserName + "\u5728\u201c" + temp + "\u201d\u4e2d@\u4e86\u4f60";
            this.qyWxCommunicationService.sendMessageToUser(annUserIdsList, content);
        }
    }

    private void dataProcess(PrdCommentPayload payload) {
        if (null == payload.getUserId()) {
            payload.setUserId(GlobalUtil.getLoginUserId());
            payload.setUserName(GlobalUtil.getLoginUserName());
        }
        if (!StringUtils.hasText((String)payload.getUserName())) {
            payload.setUserName(this.cacheUtil.getUserName(payload.getUserId()));
        }
        if (null == payload.getReplyId()) {
            payload.setReplyId(REPLY_ID_DEFAULT);
        } else {
            PrdCommentVO commentVO = this.queryByKey(payload.getReplyId());
            if (null == payload.getReplyUserId()) {
                payload.setReplyUserId(commentVO.getUserId());
                payload.setReplyUserName(commentVO.getUserName());
                payload.setReplyUserLogo(commentVO.getUserLogo());
            }
            if (!StringUtils.hasText((String)payload.getReplyUserName())) {
                payload.setReplyUserName(this.cacheUtil.getUserName(payload.getReplyUserId()));
            }
        }
    }

    private void check(PrdCommentPayload payload) {
        if (!StringUtils.hasText((String)payload.getObjType())) {
            throw TwException.error("", "objType\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == payload.getObjId()) {
            throw TwException.error("", "objId\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public PrdCommentVO update(PrdCommentPayload payload) {
        PrdCommentDO entity = this.repo.findById(payload.getId()).orElseGet(PrdCommentDO::new);
        Long tempId = entity.getId();
        Assert.notNull((Object)tempId, (String)"\u4e0d\u5b58\u5728");
        PrdCommentDO entityDo = PrdCommentConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        PrdCommentDO save = (PrdCommentDO)((Object)this.repo.save((Object)entity));
        return PrdCommentConvert.INSTANCE.toVo(save);
    }

    public PrdCommentVO queryByKey(Long key) {
        PrdCommentDO entity = this.repo.findById(key).orElseGet(PrdCommentDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PrdCommentVO crmCustomerOperationVO = PrdCommentConvert.INSTANCE.toVo(entity);
        return crmCustomerOperationVO;
    }

    public List<PrdCommentVO> queryList(PrdCommentQuery query) {
        this.checkQuery(query);
        return PrdCommentConvert.INSTANCE.toVoList(this.repo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder)));
    }

    public long count(PrdCommentQuery query) {
        this.checkQuery(query);
        long count = this.repo.count((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder));
        return count;
    }

    public long count(String objTypeEnum, Long objId) {
        PrdCommentQuery query = new PrdCommentQuery();
        query.setObjType(objTypeEnum);
        query.setObjId(objId);
        return this.count(query);
    }

    public PagingVO<PrdCommentVO> paging(PrdCommentQuery query) {
        this.checkQuery(query);
        Page page = this.repo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), (Pageable)query.getPageRequest());
        return PageUtil.toPageVo(page.map(PrdCommentConvert.INSTANCE::toVo));
    }

    private void checkQuery(PrdCommentQuery query) {
        if (!StringUtils.hasText((String)query.getObjType())) {
            throw TwException.error("", "objType\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == query.getObjId()) {
            throw TwException.error("", "objId\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public PagingVO<PrdCommentVO> pagingPro(PrdCommentQuery query) {
        this.checkQuery(query);
        if (null == query.getReplyId()) {
            query.setReplyId(REPLY_ID_DEFAULT);
        }
        Page pageDo = this.repo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), (Pageable)query.getPageRequest());
        Page pageVo = pageDo.map(PrdCommentConvert.INSTANCE::toVo);
        List content = pageVo.getContent();
        content.forEach(commentVO -> {
            PrdCommentQuery commentQuery = new PrdCommentQuery();
            commentQuery.setObjId(query.getObjId());
            commentQuery.setObjType(query.getObjType());
            commentQuery.setReplyId(commentVO.getId());
            List<PrdCommentVO> prdCommentVOS = this.queryList(commentQuery);
            commentVO.setChildren(prdCommentVOS);
        });
        return PageUtil.toPageVo(pageVo);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.repo.findById(id);
                if (!optional.isEmpty()) {
                    PrdCommentDO entity = (PrdCommentDO)((Object)((Object)optional.get()));
                    entity.setDeleteFlag(1);
                    this.repo.save((Object)entity);
                }
            });
        }
    }

    public List<PrdCommentVO> queryListPro(PrdCommentQuery query) {
        if (null == query.getReplyId()) {
            query.setReplyId(REPLY_ID_DEFAULT);
        }
        List<PrdCommentVO> prdCommentVOList = this.queryList(query);
        prdCommentVOList.forEach(commentVO -> {
            PrdCommentQuery commentQuery = new PrdCommentQuery();
            commentQuery.setObjId(query.getObjId());
            commentQuery.setObjType(query.getObjType());
            commentQuery.setReplyId(commentVO.getId());
            List<PrdCommentVO> prdCommentVOS = this.queryList(commentQuery);
            commentVO.setChildren(prdCommentVOS);
        });
        return prdCommentVOList;
    }

    public PrdCommentServiceImpl(PrdCommentRepo repo, QyWxCommunicationService qyWxCommunicationService, CrmOperationPlanDetailService crmOperationPlanDetailService, CrmCustomerOperationChanceDAO customerOperationChanceDAO, CrmCustomerOperationDAO crmCustomerOperationDAO, CacheUtil cacheUtil) {
        this.repo = repo;
        this.qyWxCommunicationService = qyWxCommunicationService;
        this.crmOperationPlanDetailService = crmOperationPlanDetailService;
        this.customerOperationChanceDAO = customerOperationChanceDAO;
        this.crmCustomerOperationDAO = crmCustomerOperationDAO;
        this.cacheUtil = cacheUtil;
    }
}

