/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.workflow;

import com.elitesland.tw.tw5.api.demo.payload.DemoSimplePayload;
import com.elitesland.tw.tw5.api.demo.service.DemoSimpleService;
import com.elitesland.tw.tw5.api.demo.vo.DemoSimpleVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.server.demo.dao.DemoSimpleDAO;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/workflow/FLOW_DEMO/callBack"})
@Transactional
public class DemoWorkflowCallBackController
implements WorkflowCallBack {
    private static final Logger log = LoggerFactory.getLogger(DemoWorkflowCallBackController.class);
    private final DemoSimpleService demoSimpleService;
    private final DemoSimpleDAO demoSimpleDAO;
    private final PrdOrgEmployeeDAO employeeDAO;
    @Value(value="${tw5.user_default.user_id}")
    private Long default_role_id;

    @PostMapping(value={"/taskAssignee"})
    public ArrayList<String> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        String taskKey = payload.getTaskKey();
        String procDefKey = payload.getProcDefKey();
        String businessKey = payload.getBusinessKey();
        String customParams = payload.getCustomParams();
        log.info("====taskAssignee\uff1a\u4efb\u52a1\u8282\u70b9\uff1a" + taskKey);
        ArrayList<String> userIds = this.taskAssigneeDemo(taskKey, businessKey, customParams);
        return userIds;
    }

    @PostMapping(value={"/taskCreated"})
    public void taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("\u4efb\u52a1\u521b\u5efa\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
    }

    @PostMapping(value={"/taskCompleted"})
    public void taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("\u4efb\u52a1\u5b8c\u6210\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
    }

    private ArrayList<String> taskAssigneeDemo(String taskKey, String businessKey, String customParams) {
        DemoSimpleVO demoSimpleVO = this.demoSimpleService.queryByKey(Long.valueOf(businessKey));
        ArrayList<String> list = new ArrayList<String>();
        if (demoSimpleVO != null) {
            if (taskKey.equals("Activity_1gfnttf")) {
                Long createUserId = demoSimpleVO.getCreateUserId();
                PrdOrgEmployeeRefVO prdOrgEmployeeRefVO = this.employeeDAO.queryUserOrgData(createUserId);
                Long parentId = prdOrgEmployeeRefVO.getParentId();
                if (parentId != null) {
                    list.add(parentId.toString());
                } else {
                    list.add("" + this.default_role_id);
                }
            }
            if (taskKey.equals("Activity_14qkle1")) {
                list.add("579786202115344318");
            }
        }
        return list;
    }

    @PostMapping(value={"/processStatusChange"})
    public void processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("\u6d41\u7a0b\u72b6\u6001\u53d8\u5316\u56de\u8c03\u53c2\u6570:{}", (Object)payload);
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        DemoSimplePayload demoSimplePayload = new DemoSimplePayload();
        demoSimplePayload.setId(Long.valueOf(Long.parseLong(businessKey)));
        DemoSimpleVO demoSimpleVO = this.demoSimpleService.queryByKey(Long.valueOf(businessKey));
        if (demoSimpleVO != null) {
            switch (procInstStatus) {
                case NOTSUBMIT: {
                    demoSimplePayload.setObjectStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    demoSimplePayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                    break;
                }
                case INTERRUPT: {
                    demoSimplePayload.setObjectStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    demoSimplePayload.setNullFields(Arrays.asList("procInstStatus", "procInstId", "submitTime"));
                    break;
                }
                case INVALID: {
                    demoSimplePayload.setObjectStatus(WorkFlowStatusEnum.INVALID.getCode());
                    demoSimplePayload.setDeleteFlag(Integer.valueOf(1));
                    demoSimplePayload.setProcInstStatus(ProcInstStatus.INVALID);
                    break;
                }
                case REJECTED: {
                    demoSimplePayload.setObjectStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    demoSimplePayload.setProcInstStatus(ProcInstStatus.REJECTED);
                    break;
                }
                case APPROVED: {
                    demoSimplePayload.setObjectStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
                    demoSimplePayload.setProcInstStatus(ProcInstStatus.APPROVED);
                    demoSimplePayload.setApprovedTime(LocalDateTime.now());
                    break;
                }
                case APPROVING: {
                    demoSimplePayload.setProcInstStatus(ProcInstStatus.APPROVING);
                    demoSimplePayload.setObjectStatus(WorkFlowStatusEnum.APPROVING_WORK.getCode());
                }
            }
            this.demoSimpleDAO.updateByKeyDynamic(demoSimplePayload);
        }
    }

    public DemoWorkflowCallBackController(DemoSimpleService demoSimpleService, DemoSimpleDAO demoSimpleDAO, PrdOrgEmployeeDAO employeeDAO) {
        this.demoSimpleService = demoSimpleService;
        this.demoSimpleDAO = demoSimpleDAO;
        this.employeeDAO = employeeDAO;
    }
}

