/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.workflow;

import com.elitescloud.cloudt.common.base.BaseViewModel;
import com.elitesland.tw.tw5.api.common.change.service.PrdSystemBusinessChangeService;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmActActivityPayload;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmActActivityService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmActActivityVO;
import com.elitesland.tw.tw5.server.common.change.changeEnum.ChangeTypeEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmActActivityDAO;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/workflow/MARKET_ACTIVITY/callBack"})
@Transactional
public class MarketActivityWorkflowCallBackController
implements WorkflowCallBack {
    private static final Logger log = LoggerFactory.getLogger(MarketActivityWorkflowCallBackController.class);
    private final CrmActActivityService actActivityService;
    private final CrmActActivityDAO actActivityDAO;
    private final PrdSystemBusinessChangeService changeService;

    @PostMapping(value={"/taskAssignee"})
    public ArrayList<String> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        log.info("\u52a8\u6001\u6307\u5b9a\u4efb\u52a1\u8d1f\u8d23\u4eba\u53c2\u6570: {}", (Object)payload);
        return null;
    }

    @PostMapping(value={"/taskCreated"})
    public void taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("\u4efb\u52a1\u521b\u5efa\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
    }

    @PostMapping(value={"/taskCompleted"})
    public void taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("\u4efb\u52a1\u5b8c\u6210\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
    }

    @PostMapping(value={"/processStatusChange"})
    public void processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("\u6d41\u7a0b\u72b6\u6001\u53d8\u5316\u56de\u8c03\u53c2\u6570:{}", (Object)payload);
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        CrmActActivityPayload activityPayload = new CrmActActivityPayload();
        activityPayload.setId(Long.valueOf(Long.parseLong(businessKey)));
        CrmActActivityVO crmActActivityVO = this.actActivityService.queryByKey(Long.valueOf(businessKey));
        if (crmActActivityVO != null) {
            switch (procInstStatus) {
                case NOTSUBMIT: {
                    activityPayload.setProjectStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    activityPayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                    break;
                }
                case INTERRUPT: {
                    activityPayload.setProjectStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    activityPayload.setNullFields(Arrays.asList("procInstStatus", "procInstId", "submitTime"));
                    break;
                }
                case INVALID: {
                    activityPayload.setProjectStatus(WorkFlowStatusEnum.INVALID.getCode());
                    activityPayload.setDeleteFlag(Integer.valueOf(1));
                    activityPayload.setProcInstStatus(ProcInstStatus.INVALID);
                    break;
                }
                case REJECTED: {
                    activityPayload.setProjectStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    activityPayload.setProcInstStatus(ProcInstStatus.REJECTED);
                    break;
                }
                case APPROVED: {
                    activityPayload.setProcInstStatus(ProcInstStatus.APPROVED);
                    activityPayload.setApprovedTime(LocalDateTime.now());
                    activityPayload.setIsRelease(Integer.valueOf(0));
                    this.actActivityDAO.updateActivityByKeyDynamic(activityPayload);
                    this.actActivityService.updateWorkFlowStatus(crmActActivityVO.getProjectId(), WorkFlowStatusEnum.APPROVED_WORK.getCode(), "");
                    crmActActivityVO = this.actActivityService.queryByKey(Long.valueOf(businessKey));
                    this.changeService.saveNewLog(ChangeTypeEnum.MARKET_ACTIVITY.getCode(), (BaseViewModel)crmActActivityVO, null, null, Integer.valueOf(1));
                    break;
                }
                case APPROVING: {
                    activityPayload.setProcInstStatus(ProcInstStatus.APPROVING);
                    activityPayload.setProjectStatus(WorkFlowStatusEnum.APPROVING_WORK.getCode());
                }
            }
            this.actActivityDAO.updateActivityByKeyDynamic(activityPayload);
        }
    }

    public MarketActivityWorkflowCallBackController(CrmActActivityService actActivityService, CrmActActivityDAO actActivityDAO, PrdSystemBusinessChangeService changeService) {
        this.actActivityService = actActivityService;
        this.actActivityDAO = actActivityDAO;
        this.changeService = changeService;
    }
}

