/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.workflow;

import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpportunityOutCostPayload;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityOutCostService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityOutCostVO;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.service.TransferUtilServiceImpl;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmOpportunityOutCostDAO;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/workflow/OPPO_OUT_COST/callBack"})
@Transactional
public class OppoOutCostWorkflowCallBackController
implements WorkflowCallBack {
    private static final Logger log = LoggerFactory.getLogger(OppoOutCostWorkflowCallBackController.class);
    private final CrmOpportunityOutCostService opportunityOutCostService;
    private final CrmOpportunityOutCostDAO opportunityOutCostDAO;
    private final HttpUtil httpUtil;
    private final TransferUtilServiceImpl transferUtilService;
    @Value(value="${tw4.opportunity.outCost_operation}")
    private String outCost_operation;

    @PostMapping(value={"/taskAssignee"})
    public ArrayList<String> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        log.info("\u52a8\u6001\u6307\u5b9a\u4efb\u52a1\u8d1f\u8d23\u4eba\u53c2\u6570: {}", (Object)payload);
        return null;
    }

    @PostMapping(value={"/taskCreated"})
    public void taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("\u4efb\u52a1\u521b\u5efa\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
    }

    @PostMapping(value={"/taskCompleted"})
    public void taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("\u4efb\u52a1\u5b8c\u6210\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
    }

    @PostMapping(value={"/processStatusChange"})
    public void processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("\u6d41\u7a0b\u72b6\u6001\u53d8\u5316\u56de\u8c03\u53c2\u6570:{}", (Object)payload);
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        CrmOpportunityOutCostPayload outCostPayload = new CrmOpportunityOutCostPayload();
        long id = Long.parseLong(businessKey);
        outCostPayload.setId(Long.valueOf(id));
        CrmOpportunityOutCostVO crmOpportunityOutCostVO = this.opportunityOutCostService.queryById(Long.valueOf(id));
        if (crmOpportunityOutCostVO != null) {
            switch (procInstStatus) {
                case NOTSUBMIT: {
                    outCostPayload.setActivataStatus("1");
                    crmOpportunityOutCostVO.setActivataStatus("1");
                    outCostPayload.setApprovalStatus(WorkFlowStatusEnum.NOTSUBMIT.getCode());
                    crmOpportunityOutCostVO.setApprovalStatus(WorkFlowStatusEnum.NOTSUBMIT.getCode());
                    outCostPayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                    break;
                }
                case INTERRUPT: {
                    outCostPayload.setActivataStatus("1");
                    crmOpportunityOutCostVO.setActivataStatus("1");
                    outCostPayload.setApprovalStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    crmOpportunityOutCostVO.setApprovalStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    outCostPayload.setNullFields(Arrays.asList("procInstStatus", "procInstId", "submitTime"));
                    outCostPayload.setProcInstStatus(ProcInstStatus.INTERRUPT);
                    break;
                }
                case INVALID: {
                    outCostPayload.setActivataStatus("1");
                    crmOpportunityOutCostVO.setActivataStatus("1");
                    outCostPayload.setDeleteFlag(Integer.valueOf(1));
                    outCostPayload.setProcInstStatus(ProcInstStatus.INVALID);
                    outCostPayload.setApprovalStatus(WorkFlowStatusEnum.INVALID.getCode());
                    crmOpportunityOutCostVO.setApprovalStatus(WorkFlowStatusEnum.INVALID.getCode());
                    break;
                }
                case REJECTED: {
                    outCostPayload.setActivataStatus("1");
                    crmOpportunityOutCostVO.setActivataStatus("1");
                    outCostPayload.setProcInstStatus(ProcInstStatus.REJECTED);
                    outCostPayload.setApprovalStatus(WorkFlowStatusEnum.REJECTED_WORK.getCode());
                    crmOpportunityOutCostVO.setApprovalStatus(WorkFlowStatusEnum.REJECTED_WORK.getCode());
                    break;
                }
                case APPROVED: {
                    outCostPayload.setActivataStatus("0");
                    crmOpportunityOutCostVO.setActivataStatus("0");
                    outCostPayload.setProcInstStatus(ProcInstStatus.APPROVED);
                    outCostPayload.setApprovalStatus(WorkFlowStatusEnum.APPROVED.getCode());
                    outCostPayload.setApprovedTime(LocalDateTime.now());
                    break;
                }
                case APPROVING: {
                    outCostPayload.setActivataStatus("1");
                    outCostPayload.setProcInstStatus(ProcInstStatus.APPROVING);
                    outCostPayload.setApprovalStatus(WorkFlowStatusEnum.APPROVING_WORK.getCode());
                    crmOpportunityOutCostVO.setApprovalStatus(WorkFlowStatusEnum.APPROVING_WORK.getCode());
                }
            }
            this.opportunityOutCostDAO.updateByKeyDynamic(outCostPayload);
        }
    }

    public OppoOutCostWorkflowCallBackController(CrmOpportunityOutCostService opportunityOutCostService, CrmOpportunityOutCostDAO opportunityOutCostDAO, HttpUtil httpUtil, TransferUtilServiceImpl transferUtilService) {
        this.opportunityOutCostService = opportunityOutCostService;
        this.opportunityOutCostDAO = opportunityOutCostDAO;
        this.httpUtil = httpUtil;
        this.transferUtilService = transferUtilService;
    }
}

