/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.common.change.dao;

import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5crm.api.common.change.payload.ComBusinessChangePayload;
import com.elitesland.tw.tw5crm.api.common.change.query.ComBusinessChangeQuery;
import com.elitesland.tw.tw5crm.api.common.change.vo.ComBusinessChangeVO;
import com.elitesland.tw.tw5crm.server.common.change.entity.QComBusinessChangeDO;
import com.elitesland.tw.tw5crm.server.common.change.repo.ComBusinessChangeRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

@Repository
public class ComBusinessChangeDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final ComBusinessChangeRepo repo;
    private final QComBusinessChangeDO qdo = QComBusinessChangeDO.comBusinessChangeDO;

    private JPAQuery<ComBusinessChangeVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ComBusinessChangeVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.createTime, this.qdo.changeContent, this.qdo.versionNo, this.qdo.createUserId, this.qdo.changeDocId, this.qdo.apprStatus, this.qdo.apprProcInstId, this.qdo.apprStatus, this.qdo.changeStatus, this.qdo.changeType})).from((EntityPath)this.qdo);
    }

    private JPAQuery<ComBusinessChangeVO> getJpaQueryWhere(ComBusinessChangeQuery query) {
        JPAQuery<ComBusinessChangeVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery;
    }

    private Predicate where(ComBusinessChangeQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getChangeDocId())) {
            list.add(this.qdo.changeDocId.eq((Object)query.getChangeDocId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getChangeType())) {
            list.add(this.qdo.changeType.eq((Object)query.getChangeType()));
        }
        return ExpressionUtils.allOf(list);
    }

    public long updateWorkFlow(ComBusinessChangePayload payload) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (!ObjectUtils.isEmpty((Object)payload.getApprProcInstId())) {
            update.set((Path)this.qdo.apprProcInstId, (Object)payload.getApprProcInstId());
        } else {
            update.setNull((Path)this.qdo.apprProcInstId);
        }
        if (!ObjectUtils.isEmpty((Object)payload.getApprStatus())) {
            update.set((Path)this.qdo.apprStatus, (Object)payload.getApprStatus());
        } else {
            update.setNull((Path)this.qdo.apprStatus);
        }
        if (!ObjectUtils.isEmpty((Object)payload.getChangeStatus())) {
            update.set((Path)this.qdo.changeStatus, (Object)payload.getChangeStatus());
        } else {
            update.setNull((Path)this.qdo.changeStatus);
        }
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public List<ComBusinessChangeVO> queryListDynamic(ComBusinessChangeQuery query) {
        JPAQuery<ComBusinessChangeVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public ComBusinessChangeVO queryByKey(Long id) {
        JPAQuery<ComBusinessChangeVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (ComBusinessChangeVO)jpaQuery.fetchFirst();
    }

    public ComBusinessChangeDAO(JPAQueryFactory jpaQueryFactory, ComBusinessChangeRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

