/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.common.util;

import com.elitesland.tw.tw5.server.common.HttpUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gavaghan.geodesy.Ellipsoid;
import org.gavaghan.geodesy.GeodeticCalculator;
import org.gavaghan.geodesy.GlobalCoordinates;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Component
public class GeodesyUtil {
    @Value(value="${tw5crm.gps.web_key}")
    private String web_key;
    private final HttpUtil httpUtil;

    public double getDistance(double longitudeFrom, double latitudeFrom, double longitudeTo, double latitudeTo) {
        GlobalCoordinates source = new GlobalCoordinates(latitudeFrom, longitudeFrom);
        GlobalCoordinates target = new GlobalCoordinates(latitudeTo, longitudeTo);
        double ellipsoidalDistance = new GeodeticCalculator().calculateGeodeticCurve(Ellipsoid.WGS84, source, target).getEllipsoidalDistance();
        return (double)Math.round(ellipsoidalDistance) / 1000.0;
    }

    public String getLongitudeAndLatitudeByAddress(String address) {
        List geocodes;
        String url = "https://restapi.amap.com/v3/geocode/geo";
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("address", address);
        map.put("key", this.web_key);
        map.put("output", "JSON");
        Map result = this.httpUtil.sendGetCallMap(url, map);
        if (result.get("status").toString().equals("1") && (geocodes = (List)result.get("geocodes")).size() > 0) {
            return ((Map)geocodes.get(0)).get("location").toString();
        }
        return "";
    }

    public String getAddressByLocation(String location) {
        List formatted_address;
        Map regeocode;
        String url = "https://restapi.amap.com/v3/geocode/regeo";
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("location", location);
        map.put("key", this.web_key);
        map.put("output", "JSON");
        map.put("radius", 1000);
        map.put("extensions", "base");
        map.put("batch", "false");
        map.put("roadlevel", 1);
        Map result = this.httpUtil.sendGetCallMap(url, map);
        if (result.get("status").toString().equals("1") && !ObjectUtils.isEmpty((Object)(regeocode = (Map)result.get("regeocode"))) && !CollectionUtils.isEmpty((Collection)(formatted_address = (List)regeocode.get("formatted_address")))) {
            return formatted_address.toString();
        }
        return "";
    }

    public GeodesyUtil(HttpUtil httpUtil) {
        this.httpUtil = httpUtil;
    }
}

