/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.oppo.service;

import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.common.TwWorkFlowCommonVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.common.workFlow.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import com.elitesland.tw.tw5crm.api.common.change.payload.ComBusinessChangePayload;
import com.elitesland.tw.tw5crm.api.common.change.service.ComBusinessChangeService;
import com.elitesland.tw.tw5crm.api.common.change.vo.ComBusinessChangeVO;
import com.elitesland.tw.tw5crm.api.oppo.payload.OpportunityCostEstimateDetailsPayload;
import com.elitesland.tw.tw5crm.api.oppo.payload.OpportunityCostEstimatePayload;
import com.elitesland.tw.tw5crm.api.oppo.query.OpportunityCostEstimateDetailsQuery;
import com.elitesland.tw.tw5crm.api.oppo.query.OpportunityCostEstimateQuery;
import com.elitesland.tw.tw5crm.api.oppo.service.OpportunityCostEstimateDetailsService;
import com.elitesland.tw.tw5crm.api.oppo.service.OpportunityCostEstimateService;
import com.elitesland.tw.tw5crm.api.oppo.vo.OpportunityCostEstimateDetailsVO;
import com.elitesland.tw.tw5crm.api.oppo.vo.OpportunityCostEstimateVO;
import com.elitesland.tw.tw5crm.server.common.change.changeTypeEnum.ChangeTypeEnum;
import com.elitesland.tw.tw5crm.server.common.change.dao.ComBusinessChangeDAO;
import com.elitesland.tw.tw5crm.server.oppo.convert.OpportunityCostEstimateConvert;
import com.elitesland.tw.tw5crm.server.oppo.dao.OpportunityCostEstimateDAO;
import com.elitesland.tw.tw5crm.server.oppo.entity.OpportunityCostEstimateDO;
import com.elitesland.tw.tw5crm.server.oppo.repo.OpportunityCostEstimateRepo;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.TaskInfo;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.WorkflowService;
import com.elitesland.workflow.payload.CurrentTaskInfosPayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class OpportunityCostEstimateServiceImpl
extends BaseServiceImpl
implements OpportunityCostEstimateService {
    private static final Logger log = LoggerFactory.getLogger(OpportunityCostEstimateServiceImpl.class);
    private final OpportunityCostEstimateRepo opportunityCostEstimateRepo;
    private final OpportunityCostEstimateDAO opportunityCostEstimateDAO;
    private final OpportunityCostEstimateDetailsService opportunityCostEstimateDetailsService;
    private final CacheUtil cacheUtil;
    private final WorkflowUtil workflowUtil;
    private final ComBusinessChangeService businessChangeService;
    private final ComBusinessChangeDAO businessChangeDao;
    private final WorkflowService workflowService;
    private final UdcUtil udcUtil;
    private final TransactionUtilService transactionUtilService;
    @Value(value="${tw5.workflow.enabled:false}")
    private Boolean workflow_enabled;
    private final String FLOW_BU_MANAGER_NODE_ID = "Activity_02uvbcr";
    private final String FLOW_BU_MANAGER_CHANGE_NODE_ID = "Activity_0mln9fy";

    public PagingVO<OpportunityCostEstimateVO> queryPaging(OpportunityCostEstimateQuery query) {
        PagingVO<OpportunityCostEstimateVO> pagingVO = this.opportunityCostEstimateDAO.queryPaging(query);
        List voList = pagingVO.getRecords();
        this.getTaskInfo(voList);
        voList.stream().forEach(opportunityCostEstimateVO -> {
            this.getDetails(opportunityCostEstimateVO.getId(), (OpportunityCostEstimateVO)opportunityCostEstimateVO);
            this.translation(opportunityCostEstimateVO.getDetails());
        });
        return pagingVO;
    }

    private void getTaskInfo(List<OpportunityCostEstimateVO> voList) {
        Map map;
        if (!CollectionUtils.isEmpty(voList) && null != (map = voList.stream().filter(vo -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{vo.getProcInstId()})).collect(Collectors.toMap(TwWorkFlowCommonVO::getProcInstId, Function.identity()))) && !map.isEmpty()) {
            Set<String> procInstIds = map.keySet();
            HashSet<String> hashSet = new HashSet<String>(procInstIds);
            CurrentTaskInfosPayload currentTaskInfosPayload = new CurrentTaskInfosPayload();
            currentTaskInfosPayload.setProcInstIds(hashSet);
            WorkflowResult workflowResult = this.workflowService.currentTaskInfos(currentTaskInfosPayload);
            if (workflowResult.isSuccess()) {
                HashMap currentTaskNames = (HashMap)workflowResult.getData();
                currentTaskNames.forEach((key, value) -> {
                    TwWorkFlowCommonVO vo = (TwWorkFlowCommonVO)map.get(key);
                    vo.setTaskInfo(value);
                });
            }
        }
    }

    private void translation(List<OpportunityCostEstimateDetailsVO> voList) {
        voList.stream().forEach(detailsVO -> {
            PrdSystemSelectionVO prdSystemSelectionVO = this.cacheUtil.transferSystemSelectionObj("crm:product:spu_type", detailsVO.getSpuType());
            detailsVO.setTaxRate(null != prdSystemSelectionVO ? prdSystemSelectionVO.getExtString1() : "");
        });
    }

    public List<OpportunityCostEstimateVO> queryListDynamic(OpportunityCostEstimateQuery query) {
        List<OpportunityCostEstimateVO> voList = this.opportunityCostEstimateDAO.queryListDynamic(query);
        return voList;
    }

    public OpportunityCostEstimateVO queryByKey(Long key) {
        OpportunityCostEstimateDO entity = this.opportunityCostEstimateRepo.findById(key).orElseGet(OpportunityCostEstimateDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u5546\u673a\u6210\u672c\u4f30\u7b97\u4e0d\u5b58\u5728");
        OpportunityCostEstimateVO vo = OpportunityCostEstimateConvert.INSTANCE.toVo(entity);
        WorkflowResult workflowResult = this.workflowService.currentTaskInfo(vo.getProcInstId());
        if (workflowResult.isSuccess()) {
            TaskInfo taskInfo = (TaskInfo)workflowResult.getData();
            vo.setTaskInfo(taskInfo);
        }
        this.getDetails(key, vo);
        return vo;
    }

    private void getDetails(Long key, OpportunityCostEstimateVO vo) {
        OpportunityCostEstimateDetailsQuery detailsQuery = new OpportunityCostEstimateDetailsQuery();
        detailsQuery.setEstimateId(key);
        List detailsVOList = this.opportunityCostEstimateDetailsService.queryListDynamic(detailsQuery);
        vo.setDetails(detailsVOList);
    }

    @Transactional(rollbackFor={Exception.class})
    public OpportunityCostEstimateVO insert(OpportunityCostEstimatePayload payload) {
        this.check(payload);
        this.dataProcess(payload);
        OpportunityCostEstimateDO entityDo = OpportunityCostEstimateConvert.INSTANCE.toDo(payload);
        OpportunityCostEstimateDO save = (OpportunityCostEstimateDO)this.opportunityCostEstimateRepo.save(entityDo);
        this.saveDetails(save, payload.getDetails());
        if (payload.getSubmit().booleanValue()) {
            payload.setId(save.getId());
            this.submitProc(payload);
        }
        return OpportunityCostEstimateConvert.INSTANCE.toVo(save);
    }

    private void saveDetails(OpportunityCostEstimateDO entity, List<OpportunityCostEstimateDetailsPayload> details) {
        Long estimateId = entity.getId();
        this.opportunityCostEstimateDetailsService.deleteSoftByEstimateId(estimateId);
        if (!CollectionUtils.isEmpty(details)) {
            for (OpportunityCostEstimateDetailsPayload detail : details) {
                detail.setEstimateId(estimateId);
                detail.setOppoId(entity.getOppoId());
                this.opportunityCostEstimateDetailsService.insert(detail);
            }
        }
    }

    private void dataProcess(OpportunityCostEstimatePayload payload) {
        if (ObjectUtils.isEmpty((Object)payload.getCode())) {
            String code = this.generateSeqNum("CRM_OPPO_COST_ESTIMATE", new String[0]);
            payload.setCode(code);
        }
        if (ObjectUtils.isEmpty((Object)payload.getApprStatus())) {
            payload.setApprStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
        }
        if (ObjectUtils.isEmpty((Object)payload.getVersion())) {
            payload.setVersion("v0");
        }
    }

    private void check(OpportunityCostEstimatePayload payload) {
        if (payload.getOppoId() == null) {
            throw TwException.error("", "oppoId\u53c2\u6570\u7f3a\u5931");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public OpportunityCostEstimateVO update(OpportunityCostEstimatePayload payload) {
        OpportunityCostEstimateVO vo = this.queryByKey(payload.getId());
        String apprStatus = vo.getApprStatus();
        if (apprStatus.equals(WorkFlowStatusEnum.CREATE_WORK.getCode())) {
            OpportunityCostEstimateVO result = this.updatePro(payload);
            if (payload.getSubmit().booleanValue()) {
                this.submitProc(payload);
            }
            return result;
        }
        if (apprStatus.equals(WorkFlowStatusEnum.APPROVED_WORK.getCode())) {
            ComBusinessChangeVO comBusinessChangeVO;
            Long saveId = this.businessChangeService.save(ChangeTypeEnum.OPPO_COST_ESTIMATE.getCode(), (Object)vo, (Object)payload, "" + payload.getId());
            ProcessInfo processInfo = new ProcessInfo();
            String apprStatusTemp = WorkFlowStatusEnum.APPROVED_WORK.getCode();
            String changeApprStatusTemp = WorkFlowStatusEnum.APPROVED_WORK.getCode();
            String changeStatusTemp = WorkFlowStatusEnum.APPROVED_WORK.getCode();
            if (this.workflow_enabled.booleanValue()) {
                apprStatusTemp = WorkFlowStatusEnum.CHANGING_WORK.getCode();
                changeApprStatusTemp = WorkFlowStatusEnum.APPROVING_WORK.getCode();
                changeStatusTemp = WorkFlowStatusEnum.CHANGING_WORK.getCode();
                Long orgManageUserId = this.cacheUtil.getOrgManageUserId(vo.getOrgId());
                HashMap<String, ArrayList> batchMap = new HashMap<String, ArrayList>();
                batchMap.put("Activity_02uvbcr", Lists.newArrayList((Object[])new String[]{orgManageUserId.toString()}));
                processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)ProcDefKey.OPPO_ESTIMATE_CHANGE.name(), (String)("\u5546\u673a\u6210\u672c\u4f30\u7b97-" + vo.getCode() + "-\u53d8\u66f4\u5ba1\u6279\u6d41\u7a0b"), (String)("" + saveId), batchMap));
            }
            OpportunityCostEstimatePayload payload0 = new OpportunityCostEstimatePayload();
            payload0.setId(payload.getId());
            payload0.setSubmitTime(LocalDateTime.now());
            payload0.setApprStatus(apprStatusTemp);
            ComBusinessChangePayload businessChangePayload = new ComBusinessChangePayload();
            businessChangePayload.setId(saveId);
            businessChangePayload.setApprProcInstId(processInfo.getProcInstId());
            businessChangePayload.setApprStatus(changeApprStatusTemp);
            businessChangePayload.setChangeStatus(changeStatusTemp);
            this.transactionUtilService.executeWithRunnable(() -> {
                this.opportunityCostEstimateDAO.updateWorkFlow(payload0);
                this.businessChangeDao.updateWorkFlow(businessChangePayload);
            });
            if (!this.workflow_enabled.booleanValue() && null != (comBusinessChangeVO = this.businessChangeDao.queryByKey(saveId))) {
                OpportunityCostEstimatePayload opportunityCostEstimatePayload = new OpportunityCostEstimatePayload();
                opportunityCostEstimatePayload.setId(Long.valueOf(comBusinessChangeVO.getChangeDocId()));
                opportunityCostEstimatePayload.setApprStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
                opportunityCostEstimatePayload = (OpportunityCostEstimatePayload)JSON.parseObject((String)comBusinessChangeVO.getChangeContent(), OpportunityCostEstimatePayload.class);
                opportunityCostEstimatePayload.setApprStatus(WorkFlowStatusEnum.APPROVED.getCode());
                opportunityCostEstimatePayload.setApprovedTime(LocalDateTime.now());
                opportunityCostEstimatePayload.setVersion("v" + comBusinessChangeVO.getVersionNo().toString());
                ComBusinessChangePayload changePayload = new ComBusinessChangePayload();
                changePayload.setId(comBusinessChangeVO.getId());
                changePayload.setChangeStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
                this.businessChangeDao.updateWorkFlow(changePayload);
                this.updatePro(opportunityCostEstimatePayload);
            }
            return vo;
        }
        throw TwException.error("", "\u4ec5\u6fc0\u6d3b\u72b6\u6001\u652f\u6301\u53d8\u66f4\uff0c\u8bf7\u6838\u9a8c\uff01");
    }

    @Transactional(rollbackFor={Exception.class})
    public OpportunityCostEstimateVO updatePro(OpportunityCostEstimatePayload payload) {
        OpportunityCostEstimateDO entity = this.opportunityCostEstimateRepo.findById(payload.getId()).orElseGet(OpportunityCostEstimateDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u6210\u672c\u4f30\u7b97\u4e0d\u5b58\u5728");
        OpportunityCostEstimateDO entityDo = OpportunityCostEstimateConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        OpportunityCostEstimateDO save = (OpportunityCostEstimateDO)this.opportunityCostEstimateRepo.save(entity);
        this.saveDetails(save, payload.getDetails());
        return OpportunityCostEstimateConvert.INSTANCE.toVo(save);
    }

    void submitProc(OpportunityCostEstimatePayload payload) {
        ProcessInfo processInfo = new ProcessInfo();
        String status = WorkFlowStatusEnum.APPROVED_WORK.getCode();
        if (this.workflow_enabled.booleanValue()) {
            status = WorkFlowStatusEnum.APPROVING_WORK.getCode();
            Long orgManageUserId = this.cacheUtil.getOrgManageUserId(payload.getOrgId());
            HashMap<String, ArrayList> batchMap = new HashMap<String, ArrayList>();
            batchMap.put("Activity_0mln9fy", Lists.newArrayList((Object[])new String[]{orgManageUserId.toString()}));
            processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)ProcDefKey.OPPO_ESTIMATE.name(), (String)("\u5546\u673a\u6210\u672c\u4f30\u7b97-" + payload.getCode() + "-\u5ba1\u6279\u6d41\u7a0b"), (String)("" + payload.getId()), batchMap));
        }
        OpportunityCostEstimatePayload payload0 = new OpportunityCostEstimatePayload();
        payload0.setId(payload.getId());
        payload0.setProcInstId(processInfo.getProcInstId());
        payload0.setProcInstStatus(processInfo.getProcInstStatus());
        payload0.setSubmitTime(LocalDateTime.now());
        payload0.setApprStatus(status);
        this.transactionUtilService.executeWithRunnable(() -> this.opportunityCostEstimateDAO.updateWorkFlow(payload0));
    }

    private ProcessInfo startChangeWorkFlow(OpportunityCostEstimateVO vo, Long saveId) {
        Long orgManageUserId = this.cacheUtil.getOrgManageUserId(vo.getOrgId());
        HashMap<String, ArrayList> batchMap = new HashMap<String, ArrayList>();
        batchMap.put("Activity_02uvbcr", Lists.newArrayList((Object[])new String[]{orgManageUserId.toString()}));
        ProcessInfo processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)ProcDefKey.OPPO_ESTIMATE_CHANGE.name(), (String)("\u5546\u673a\u6210\u672c\u4f30\u7b97-" + vo.getCode() + "-\u53d8\u66f4\u5ba1\u6279\u6d41\u7a0b"), (String)("" + saveId), batchMap));
        return processInfo;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.opportunityCostEstimateRepo.findById(id);
                if (!optional.isEmpty()) {
                    OpportunityCostEstimateDO entity = (OpportunityCostEstimateDO)optional.get();
                    if (!entity.getApprStatus().equals(WorkFlowStatusEnum.CREATE_WORK.getCode())) {
                        throw TwException.error("", "\u5f53\u524d\u72b6\u6001\u4e0d\u80fd\u5220\u9664");
                    }
                    entity.setDeleteFlag(1);
                    this.opportunityCostEstimateRepo.save(entity);
                }
            });
        }
    }

    public OpportunityCostEstimateServiceImpl(OpportunityCostEstimateRepo opportunityCostEstimateRepo, OpportunityCostEstimateDAO opportunityCostEstimateDAO, OpportunityCostEstimateDetailsService opportunityCostEstimateDetailsService, CacheUtil cacheUtil, WorkflowUtil workflowUtil, ComBusinessChangeService businessChangeService, ComBusinessChangeDAO businessChangeDao, WorkflowService workflowService, UdcUtil udcUtil, TransactionUtilService transactionUtilService) {
        this.opportunityCostEstimateRepo = opportunityCostEstimateRepo;
        this.opportunityCostEstimateDAO = opportunityCostEstimateDAO;
        this.opportunityCostEstimateDetailsService = opportunityCostEstimateDetailsService;
        this.cacheUtil = cacheUtil;
        this.workflowUtil = workflowUtil;
        this.businessChangeService = businessChangeService;
        this.businessChangeDao = businessChangeDao;
        this.workflowService = workflowService;
        this.udcUtil = udcUtil;
        this.transactionUtilService = transactionUtilService;
    }
}

