/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.oppo.service;

import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.common.TwWorkFlowCommonVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.common.workFlow.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import com.elitesland.tw.tw5crm.api.common.change.payload.ComBusinessChangePayload;
import com.elitesland.tw.tw5crm.api.common.change.service.ComBusinessChangeService;
import com.elitesland.tw.tw5crm.api.common.change.vo.ComBusinessChangeVO;
import com.elitesland.tw.tw5crm.api.oppo.payload.OpportunityQuoteDetailsPayload;
import com.elitesland.tw.tw5crm.api.oppo.payload.OpportunityQuotePayload;
import com.elitesland.tw.tw5crm.api.oppo.query.OpportunityQuoteDetailsQuery;
import com.elitesland.tw.tw5crm.api.oppo.query.OpportunityQuoteQuery;
import com.elitesland.tw.tw5crm.api.oppo.service.OpportunityQuoteService;
import com.elitesland.tw.tw5crm.api.oppo.vo.OpportunityQuoteDetailsVO;
import com.elitesland.tw.tw5crm.api.oppo.vo.OpportunityQuoteVO;
import com.elitesland.tw.tw5crm.server.common.change.changeTypeEnum.ChangeTypeEnum;
import com.elitesland.tw.tw5crm.server.common.change.dao.ComBusinessChangeDAO;
import com.elitesland.tw.tw5crm.server.oppo.convert.OpportunityQuoteConvert;
import com.elitesland.tw.tw5crm.server.oppo.convert.OpportunityQuoteDetailsConvert;
import com.elitesland.tw.tw5crm.server.oppo.dao.OpportunityQuoteDAO;
import com.elitesland.tw.tw5crm.server.oppo.dao.OpportunityQuoteDetailsDAO;
import com.elitesland.tw.tw5crm.server.oppo.entity.OpportunityQuoteDO;
import com.elitesland.tw.tw5crm.server.oppo.entity.OpportunityQuoteDetailsDO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.TaskInfo;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.WorkflowService;
import com.elitesland.workflow.payload.CurrentTaskInfosPayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class OpportunityQuoteServiceImpl
extends BaseServiceImpl
implements OpportunityQuoteService {
    private static final Logger log = LoggerFactory.getLogger(OpportunityQuoteServiceImpl.class);
    private final WorkflowService workflowService;
    private final OpportunityQuoteDAO dao;
    private final OpportunityQuoteDetailsDAO detailsDao;
    private final CacheUtil cacheUtil;
    private final WorkflowUtil workflowUtil;
    private final TransactionUtilService transactionUtilService;
    private final UdcUtil udcUtil;
    private final ComBusinessChangeService businessChangeService;
    private final ComBusinessChangeDAO businessChangeDao;
    @Value(value="${tw5.workflow.enabled:false}")
    private Boolean workflow_enabled;

    public PagingVO<OpportunityQuoteVO> queryPaging(OpportunityQuoteQuery query) {
        PagingVO<OpportunityQuoteVO> opportunityQuoteVOPagingVO = this.dao.queryPaging(query);
        List records = opportunityQuoteVOPagingVO.getRecords();
        records.forEach(this::translate);
        this.getTaskInfo(records);
        return opportunityQuoteVOPagingVO;
    }

    private void getTaskInfo(List<OpportunityQuoteVO> voList) {
        Map map;
        if (!CollectionUtils.isEmpty(voList) && null != (map = voList.stream().filter(vo -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{vo.getProcInstId()})).collect(Collectors.toMap(TwWorkFlowCommonVO::getProcInstId, Function.identity()))) && !map.isEmpty()) {
            Set<String> procInstIds = map.keySet();
            HashSet<String> hashSet = new HashSet<String>(procInstIds);
            CurrentTaskInfosPayload currentTaskInfosPayload = new CurrentTaskInfosPayload();
            currentTaskInfosPayload.setProcInstIds(hashSet);
            WorkflowResult workflowResult = this.workflowService.currentTaskInfos(currentTaskInfosPayload);
            if (workflowResult.isSuccess()) {
                HashMap currentTaskNames = (HashMap)workflowResult.getData();
                currentTaskNames.forEach((key, value) -> {
                    TwWorkFlowCommonVO vo = (TwWorkFlowCommonVO)map.get(key);
                    vo.setTaskInfo(value);
                });
            }
        }
    }

    public OpportunityQuoteVO queryByKey(Long key) {
        OpportunityQuoteVO vo = this.dao.queryByKey(key);
        this.translate(vo);
        OpportunityQuoteDetailsQuery query = new OpportunityQuoteDetailsQuery();
        query.setQuoteId(vo.getId());
        List<OpportunityQuoteDetailsVO> detailsVOS = this.detailsDao.queryListDynamic(query);
        vo.setDetails(detailsVOS);
        WorkflowResult workflowResult = this.workflowService.currentTaskInfo(vo.getProcInstId());
        if (workflowResult.isSuccess()) {
            TaskInfo taskInfo = (TaskInfo)workflowResult.getData();
            vo.setTaskInfo(taskInfo);
        }
        return vo;
    }

    private void translate(OpportunityQuoteVO vo) {
        Long manageUserId = vo.getManageUserId();
        if (manageUserId != null) {
            vo.setManageUserName(this.cacheUtil.getUserName(manageUserId));
        }
        if (vo.getQuoteStatus() != null) {
            WorkFlowStatusEnum byCode = WorkFlowStatusEnum.getByCode(vo.getQuoteStatus());
            vo.setQuoteStatusDesc(byCode.getDesc());
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public OpportunityQuoteVO insert(OpportunityQuotePayload payload) {
        this.verifyTotalAmt(payload);
        OpportunityQuoteDO entityDo = OpportunityQuoteConvert.INSTANCE.toDo(payload);
        String code = this.generateSeqNum("CRM_OPPO_QUOTE", new String[0]);
        entityDo.setQuoteNo(code);
        entityDo.setQuoteStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
        entityDo.setVersion("v0");
        OpportunityQuoteDO save = this.dao.save(entityDo);
        this.insertDetail(payload.getDetails(), save.getId());
        if (payload.getSubmit().booleanValue()) {
            payload.setId(save.getId());
            if (payload.getQuoteNo() == null) {
                payload.setQuoteNo(save.getQuoteNo());
            }
            this.submitProc(payload);
        }
        return OpportunityQuoteConvert.INSTANCE.toVo(save);
    }

    void submitProc(OpportunityQuotePayload payload) {
        ProcessInfo processInfo = new ProcessInfo();
        String status = WorkFlowStatusEnum.APPROVED_WORK.getCode();
        if (this.workflow_enabled.booleanValue()) {
            status = WorkFlowStatusEnum.APPROVING_WORK.getCode();
            Long orgManageUserId = this.cacheUtil.getOrgManageUserId(payload.getOrgId());
            HashMap<String, ArrayList> batchMap = new HashMap<String, ArrayList>();
            batchMap.put("Activity_1be86d6", Lists.newArrayList((Object[])new String[]{orgManageUserId.toString()}));
            processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)ProcDefKey.OPPO_QUOTE.name(), (String)("\u5546\u673a\u62a5\u4ef7-" + payload.getQuoteNo() + "-\u5ba1\u6279\u6d41\u7a0b"), (String)("" + payload.getId()), batchMap));
        }
        OpportunityQuotePayload payload0 = new OpportunityQuotePayload();
        payload0.setId(payload.getId());
        payload0.setProcInstId(processInfo.getProcInstId());
        payload0.setProcInstStatus(processInfo.getProcInstStatus());
        payload0.setSubmitTime(LocalDateTime.now());
        payload0.setQuoteStatus(status);
        this.transactionUtilService.executeWithRunnable(() -> this.dao.updateWorkFlow(payload0));
    }

    private ProcessInfo startChangeWorkFlow(OpportunityQuoteVO opportunityQuoteVO, Long saveId) {
        Long orgManageUserId = this.cacheUtil.getOrgManageUserId(opportunityQuoteVO.getOrgId());
        HashMap<String, ArrayList> batchMap = new HashMap<String, ArrayList>();
        batchMap.put("Activity_0bih1cr", Lists.newArrayList((Object[])new String[]{orgManageUserId.toString()}));
        ProcessInfo processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)ProcDefKey.OPPO_QUOTE_CHANGE.name(), (String)("\u5546\u673a\u62a5\u4ef7-" + opportunityQuoteVO.getQuoteNo() + "-\u53d8\u66f4\u5ba1\u6279\u6d41\u7a0b"), (String)("" + saveId), batchMap));
        return processInfo;
    }

    public void verifyTotalAmt(OpportunityQuotePayload payload) {
        List details = payload.getDetails();
        if (details != null && details.size() > 0) {
            BigDecimal quoteTaxAmt;
            BigDecimal quoteAmt;
            BigDecimal productPriceTotal = details.stream().map(e -> {
                Integer quantity = e.getQuantity() == null ? 1 : e.getQuantity();
                BigDecimal markedMoney = e.getMarkedMoney() == null ? BigDecimal.ZERO : e.getMarkedMoney();
                BigDecimal salesDiscount = e.getSalesDiscount() == null ? BigDecimal.ZERO : e.getSalesDiscount();
                return markedMoney.multiply(new BigDecimal(quantity)).multiply(salesDiscount);
            }).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
            String wholeOrderDiscount = payload.getWholeOrderDiscount();
            BigDecimal quoteAmtByCount = productPriceTotal.multiply(new BigDecimal(wholeOrderDiscount)).setScale(2, RoundingMode.HALF_UP);
            BigDecimal bigDecimal = quoteAmt = payload.getQuoteAmt() == null ? BigDecimal.ZERO : payload.getQuoteAmt().setScale(2, RoundingMode.HALF_UP);
            if (quoteAmtByCount.compareTo(quoteAmt) != 0) {
                log.error("\u524d\u7aef\u4f20\u9012\u91d1\u989d={},\u540e\u7aef\u8ba1\u7b97\u91d1\u989d={}", (Object)quoteAmt, (Object)quoteAmtByCount);
                throw TwException.error("", "\u62a5\u4ef7\u5355\u91d1\u989d\u9a8c\u8bc1\u5931\u8d25");
            }
            BigDecimal productSalesIncludeTaxTotal = details.stream().map(e -> {
                Integer quantity = e.getQuantity() == null ? 1 : e.getQuantity();
                BigDecimal markedMoney = e.getMarkedMoney() == null ? BigDecimal.ZERO : e.getMarkedMoney();
                BigDecimal salesDiscount = e.getSalesDiscount() == null ? BigDecimal.ZERO : e.getSalesDiscount();
                BigDecimal taxRate = e.getTaxRate() == null ? BigDecimal.ZERO : e.getTaxRate();
                return markedMoney.multiply(new BigDecimal(quantity)).multiply(salesDiscount).multiply(taxRate.add(BigDecimal.ONE));
            }).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
            BigDecimal quoteTaxAmtByCount = productSalesIncludeTaxTotal.multiply(new BigDecimal(wholeOrderDiscount)).setScale(2, RoundingMode.HALF_UP);
            BigDecimal bigDecimal2 = quoteTaxAmt = payload.getQuoteTaxAmt() == null ? BigDecimal.ZERO : payload.getQuoteTaxAmt().setScale(2, RoundingMode.HALF_UP);
            if (quoteTaxAmtByCount.compareTo(quoteTaxAmt) != 0) {
                log.error("\u524d\u7aef\u4f20\u9012\u542b\u7a0e\u91d1\u989d={},\u540e\u7aef\u8ba1\u7b97\u542b\u7a0e\u91d1\u989d={}", (Object)quoteTaxAmt, (Object)quoteTaxAmtByCount);
                throw TwException.error("", "\u62a5\u4ef7\u5355\u542b\u7a0e\u91d1\u989d\u9a8c\u8bc1\u5931\u8d25");
            }
        }
    }

    private void insertDetail(List<OpportunityQuoteDetailsPayload> details, Long quoteId) {
        if (details != null && details.size() > 0) {
            details.forEach(e -> {
                OpportunityQuoteDetailsDO detailsDO = OpportunityQuoteDetailsConvert.INSTANCE.toDo((OpportunityQuoteDetailsPayload)e);
                detailsDO.setQuoteId(quoteId);
                this.detailsDao.save(detailsDO);
            });
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public long update(OpportunityQuotePayload payload) {
        if (payload.getId() == null) {
            throw TwException.error("", "\u83b7\u53d6id\u5931\u8d25");
        }
        this.verifyTotalAmt(payload);
        long l = this.dao.updateByKeyDynamic(payload);
        if (payload.getDetails() != null && payload.getDetails().size() > 0) {
            this.detailsDao.deleteByQuoteId(payload.getId());
            this.insertDetail(payload.getDetails(), payload.getId());
        }
        if (payload.getSubmit().booleanValue()) {
            payload.setId(payload.getId());
            this.submitProc(payload);
        }
        return l;
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateChange(OpportunityQuotePayload payload) {
        if (payload.getId() == null) {
            throw TwException.error("", "\u83b7\u53d6id\u5931\u8d25");
        }
        this.verifyTotalAmt(payload);
        long l = this.dao.updateByKeyDynamic(payload);
        if (payload.getDetails() != null && payload.getDetails().size() > 0) {
            List details = payload.getDetails();
            details.forEach(e -> this.detailsDao.updateByKeyDynamic((OpportunityQuoteDetailsPayload)e));
        }
        return l;
    }

    @Transactional(rollbackFor={Exception.class})
    public long change(OpportunityQuotePayload payload) {
        ComBusinessChangeVO comBusinessChangeVO;
        if (payload.getId() == null) {
            throw TwException.error("", "\u83b7\u53d6id\u5931\u8d25");
        }
        if (payload.getQuoteStatus() == null || !payload.getQuoteStatus().equals(WorkFlowStatusEnum.APPROVED.getCode())) {
            throw TwException.error("", "\u4ec5\u5ba1\u6279\u901a\u8fc7\u7684\u6570\u636e\u53ef\u4ee5\u7533\u8bf7\u53d8\u66f4");
        }
        this.verifyTotalAmt(payload);
        OpportunityQuoteVO opportunityQuoteVO = this.dao.queryByKey(payload.getId());
        if (opportunityQuoteVO.getId() == null) {
            throw TwException.error("", "\u539f\u6570\u636e\u4e0d\u5b58\u5728");
        }
        OpportunityQuotePayload opportunityQuotePayload = OpportunityQuoteConvert.INSTANCE.toPayload(opportunityQuoteVO);
        OpportunityQuoteDetailsQuery query = new OpportunityQuoteDetailsQuery();
        query.setQuoteId(payload.getId());
        List<OpportunityQuoteDetailsVO> detailsVOS = this.detailsDao.queryListDynamic(query);
        if (detailsVOS != null && detailsVOS.size() > 0) {
            List<OpportunityQuoteDetailsPayload> opportunityQuoteDetailsPayloads = OpportunityQuoteDetailsConvert.INSTANCE.toPayloadList(detailsVOS);
            opportunityQuotePayload.setDetails((List)this.udcUtil.translate(opportunityQuoteDetailsPayloads));
        }
        Long saveId = this.businessChangeService.save(ChangeTypeEnum.OPPO_QUOTE.getCode(), this.udcUtil.translate(opportunityQuotePayload), this.udcUtil.translate(payload), "" + payload.getId());
        ProcessInfo processInfo = new ProcessInfo();
        String apprStatusTemp = WorkFlowStatusEnum.APPROVED_WORK.getCode();
        String changeApprStatusTemp = WorkFlowStatusEnum.APPROVED_WORK.getCode();
        String changeStatusTemp = WorkFlowStatusEnum.APPROVED_WORK.getCode();
        if (this.workflow_enabled.booleanValue()) {
            apprStatusTemp = WorkFlowStatusEnum.CHANGING_WORK.getCode();
            changeApprStatusTemp = WorkFlowStatusEnum.APPROVING_WORK.getCode();
            changeStatusTemp = WorkFlowStatusEnum.CHANGING_WORK.getCode();
            Long orgManageUserId = this.cacheUtil.getOrgManageUserId(opportunityQuoteVO.getOrgId());
            HashMap<String, ArrayList> batchMap = new HashMap<String, ArrayList>();
            batchMap.put("Activity_0bih1cr", Lists.newArrayList((Object[])new String[]{orgManageUserId.toString()}));
            processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)ProcDefKey.OPPO_QUOTE_CHANGE.name(), (String)("\u5546\u673a\u62a5\u4ef7-" + opportunityQuoteVO.getQuoteNo() + "-\u53d8\u66f4\u5ba1\u6279\u6d41\u7a0b"), (String)("" + saveId), batchMap));
        }
        OpportunityQuotePayload payload0 = new OpportunityQuotePayload();
        payload0.setId(payload.getId());
        payload0.setSubmitTime(LocalDateTime.now());
        payload0.setQuoteStatus(apprStatusTemp);
        ComBusinessChangePayload businessChangePayload = new ComBusinessChangePayload();
        businessChangePayload.setId(saveId);
        businessChangePayload.setApprProcInstId(processInfo.getProcInstId());
        businessChangePayload.setApprStatus(changeApprStatusTemp);
        businessChangePayload.setChangeStatus(changeStatusTemp);
        this.transactionUtilService.executeWithRunnable(() -> {
            this.dao.updateWorkFlow(payload0);
            this.businessChangeDao.updateWorkFlow(businessChangePayload);
        });
        if (!this.workflow_enabled.booleanValue() && (comBusinessChangeVO = this.businessChangeDao.queryByKey(saveId)) != null) {
            OpportunityQuotePayload quotePayload = new OpportunityQuotePayload();
            quotePayload.setId(Long.valueOf(comBusinessChangeVO.getChangeDocId()));
            quotePayload.setQuoteStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
            quotePayload = (OpportunityQuotePayload)JSON.parseObject((String)comBusinessChangeVO.getChangeContent(), OpportunityQuotePayload.class);
            quotePayload.setApprovedTime(LocalDateTime.now());
            quotePayload.setVersion("v" + comBusinessChangeVO.getVersionNo().toString());
            ComBusinessChangePayload changePayload = new ComBusinessChangePayload();
            changePayload.setId(comBusinessChangeVO.getId());
            changePayload.setChangeStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
            this.businessChangeDao.updateWorkFlow(changePayload);
            this.updateChange(quotePayload);
        }
        return saveId;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.dao.deleteSoft(keys);
        }
    }

    public OpportunityQuoteServiceImpl(WorkflowService workflowService, OpportunityQuoteDAO dao, OpportunityQuoteDetailsDAO detailsDao, CacheUtil cacheUtil, WorkflowUtil workflowUtil, TransactionUtilService transactionUtilService, UdcUtil udcUtil, ComBusinessChangeService businessChangeService, ComBusinessChangeDAO businessChangeDao) {
        this.workflowService = workflowService;
        this.dao = dao;
        this.detailsDao = detailsDao;
        this.cacheUtil = cacheUtil;
        this.workflowUtil = workflowUtil;
        this.transactionUtilService = transactionUtilService;
        this.udcUtil = udcUtil;
        this.businessChangeService = businessChangeService;
        this.businessChangeDao = businessChangeDao;
    }
}

