/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.product.controller;

import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.annotation.ReSubmitCheck;
import com.elitesland.tw.tw5crm.api.product.payload.ProductCategoryColumnRefListPayload;
import com.elitesland.tw.tw5crm.api.product.payload.ProductCategoryColumnRefPayload;
import com.elitesland.tw.tw5crm.api.product.query.ProductCategoryColumnRefQuery;
import com.elitesland.tw.tw5crm.api.product.service.ProductCategoryColumnRefService;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/crm/product/categoryColumnRef"})
public class ProductCategoryColumnRefController {
    private static final Logger log = LoggerFactory.getLogger(ProductCategoryColumnRefController.class);
    private final ProductCategoryColumnRefService productCategoryColumnRefService;

    @PostMapping
    public TwOutputUtil insert(@RequestBody ProductCategoryColumnRefPayload payload) {
        return TwOutputUtil.ok(this.productCategoryColumnRefService.insert(payload));
    }

    @PostMapping(value={"batchInsert"})
    @ReSubmitCheck(argExpressions={"[0].categoryColumnRefList[0].id", "[0].categoryColumnRefList[0].columnId"})
    public TwOutputUtil batchSaveOrUpdate(@RequestBody ProductCategoryColumnRefListPayload payload) {
        return TwOutputUtil.ok(this.productCategoryColumnRefService.batchSaveOrUpdate(payload));
    }

    @PutMapping
    public TwOutputUtil update(@RequestBody ProductCategoryColumnRefPayload payload) {
        return TwOutputUtil.ok(this.productCategoryColumnRefService.update(payload));
    }

    @GetMapping(value={"/{key}"})
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(this.productCategoryColumnRefService.queryByKey(key));
    }

    @GetMapping(value={"/paging"})
    public TwOutputUtil paging(ProductCategoryColumnRefQuery query) {
        if (null == query.getCategoryId()) {
            return TwOutputUtil.error("", "\u53c2\u6570\u7f3a\u5931", null);
        }
        return TwOutputUtil.ok(this.productCategoryColumnRefService.paging(query));
    }

    @GetMapping(value={"/list"})
    public TwOutputUtil queryList(ProductCategoryColumnRefQuery query) {
        if (null == query.getCategoryId()) {
            return TwOutputUtil.error("", "\u53c2\u6570\u7f3a\u5931", null);
        }
        return TwOutputUtil.ok(this.productCategoryColumnRefService.queryList(query));
    }

    @DeleteMapping(value={"/deleteSoft"})
    public TwOutputUtil deleteSoft(Long[] keys) {
        this.productCategoryColumnRefService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    public ProductCategoryColumnRefController(ProductCategoryColumnRefService productCategoryColumnRefService) {
        this.productCategoryColumnRefService = productCategoryColumnRefService;
    }
}

