/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.product.controller;

import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.annotation.ReSubmitCheck;
import com.elitesland.tw.tw5crm.api.product.payload.ProductCategoryPayload;
import com.elitesland.tw.tw5crm.api.product.query.ProductCategoryQuery;
import com.elitesland.tw.tw5crm.api.product.service.ProductCategoryService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4ea7\u54c1\u5206\u7c7b"})
@RestController
@RequestMapping(value={"/api/crm/product/category"})
public class ProductCategoryController {
    private static final Logger log = LoggerFactory.getLogger(ProductCategoryController.class);
    private final ProductCategoryService productCategoryService;

    @PostMapping
    @ApiOperation(value="\u65b0\u589e")
    @ReSubmitCheck(argExpressions={"[0].id", "[0].objName"})
    public TwOutputUtil insert(@RequestBody ProductCategoryPayload payload) {
        return TwOutputUtil.ok(this.productCategoryService.insert(payload));
    }

    @PostMapping(value={"checkUnique"})
    public TwOutputUtil checkUnique(Long id, String objName) {
        return TwOutputUtil.ok(this.productCategoryService.checkUnique(id, objName));
    }

    @PutMapping
    public TwOutputUtil update(@RequestBody ProductCategoryPayload payload) {
        return TwOutputUtil.ok(this.productCategoryService.update(payload));
    }

    @GetMapping(value={"/lazy"})
    public TwOutputUtil queryAllCategory(Long pid) {
        return TwOutputUtil.ok(this.productCategoryService.queryAllCategory(pid));
    }

    @GetMapping(value={"/tree"})
    public TwOutputUtil tree() {
        List categoryVOList = this.productCategoryService.tree();
        return TwOutputUtil.ok(categoryVOList);
    }

    @GetMapping(value={"/{key}"})
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(this.productCategoryService.queryByKey(key));
    }

    @GetMapping(value={"/getAttrs"})
    public TwOutputUtil getAttrs() {
        return TwOutputUtil.ok(this.productCategoryService.getAttrs());
    }

    @GetMapping(value={"/getAttrsAndAttrGroups/{key}"})
    public TwOutputUtil getAttrsAndAttrGroups(@PathVariable Long key) {
        return TwOutputUtil.ok(this.productCategoryService.getAttrsAndAttrGroups(key));
    }

    @GetMapping(value={"/paging"})
    public TwOutputUtil paging(ProductCategoryQuery query) {
        return TwOutputUtil.ok(this.productCategoryService.paging(query));
    }

    @GetMapping(value={"/list"})
    public TwOutputUtil queryList(ProductCategoryQuery query) {
        return TwOutputUtil.ok(this.productCategoryService.queryList(query));
    }

    @DeleteMapping(value={"/deleteSoft"})
    public TwOutputUtil deleteSoft(Long[] keys) {
        this.productCategoryService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    public ProductCategoryController(ProductCategoryService productCategoryService) {
        this.productCategoryService = productCategoryService;
    }
}

