/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.product.controller;

import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitesland.tw.tw5crm.api.product.payload.ProductPricePayload;
import com.elitesland.tw.tw5crm.api.product.query.ProductPriceQuery;
import com.elitesland.tw.tw5crm.api.product.service.ProductPriceService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5546\u54c1\u4ef7\u76ee"})
@RestController
@RequestMapping(value={"/api/crm/product/price"})
public class ProductPriceController {
    private static final Logger log = LoggerFactory.getLogger(ProductPriceController.class);
    private final ProductPriceService productPriceService;

    @PostMapping
    @ApiOperation(value="\u65b0\u589e")
    public TwOutputUtil insert(@RequestBody ProductPricePayload payload) {
        return TwOutputUtil.ok(this.productPriceService.insert(payload));
    }

    @PutMapping
    @ApiOperation(value="\u66f4\u65b0")
    public TwOutputUtil update(@RequestBody ProductPricePayload payload) {
        return TwOutputUtil.ok(this.productPriceService.update(payload));
    }

    @GetMapping(value={"/{key}"})
    @UdcNameClass
    @ApiOperation(value="\u4e3b\u952e\u67e5\u8be2")
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(this.productPriceService.queryByKey(key));
    }

    @GetMapping(value={"/paging"})
    @UdcNameClass
    @ApiOperation(value="\u5206\u9875")
    public TwOutputUtil paging(ProductPriceQuery query) {
        return TwOutputUtil.ok(this.productPriceService.queryPaging(query));
    }

    @GetMapping(value={"/list"})
    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    public TwOutputUtil queryList(ProductPriceQuery query) {
        return TwOutputUtil.ok(this.productPriceService.queryListDynamic(query));
    }

    @DeleteMapping(value={"/deleteSoft"})
    @ApiOperation(value="\u5220\u9664")
    public TwOutputUtil deleteSoft(Long[] keys) {
        this.productPriceService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @DeleteMapping(value={"/updateStatus"})
    @ApiOperation(value="\u4fee\u6539\u72b6\u6001")
    public TwOutputUtil updateStatus(Long[] keys) {
        this.productPriceService.updateStatus(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    public ProductPriceController(ProductPriceService productPriceService) {
        this.productPriceService = productPriceService;
    }
}

