/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.product.controller;

import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5crm.api.product.payload.ProductSpuPayload;
import com.elitesland.tw.tw5crm.api.product.query.ProductSpuQuery;
import com.elitesland.tw.tw5crm.api.product.service.ProductSpuService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5546\u54c1SPU"})
@RestController
@RequestMapping(value={"/api/crm/product/spu"})
public class ProductSpuController {
    private static final Logger log = LoggerFactory.getLogger(ProductSpuController.class);
    private final ProductSpuService productSpuService;

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping
    public TwOutputUtil insert(@RequestBody ProductSpuPayload payload) {
        return TwOutputUtil.ok(this.productSpuService.insert(payload));
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PutMapping
    public TwOutputUtil update(@RequestBody ProductSpuPayload payload) {
        return TwOutputUtil.ok(this.productSpuService.update(payload));
    }

    @GetMapping(value={"/{key}"})
    @ApiOperation(value="\u4e3b\u952e\u67e5\u8be2")
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(this.productSpuService.queryByKey(key));
    }

    @GetMapping(value={"/paging"})
    @ApiOperation(value="\u5206\u9875")
    public TwOutputUtil paging(ProductSpuQuery query) {
        return TwOutputUtil.ok(this.productSpuService.paging(query));
    }

    @GetMapping(value={"/list"})
    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    public TwOutputUtil queryList(ProductSpuQuery query) {
        return TwOutputUtil.ok(this.productSpuService.queryList(query));
    }

    @DeleteMapping(value={"/deleteSoft"})
    @ApiOperation(value="\u5220\u9664spu")
    public TwOutputUtil deleteSoft(Long[] keys) {
        this.productSpuService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="\u5220\u9664sku")
    @DeleteMapping(value={"/deleteSoftSku"})
    public TwOutputUtil deleteSoftSku(Long[] keys) {
        this.productSpuService.deleteSoftSku(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    public ProductSpuController(ProductSpuService productSpuService) {
        this.productSpuService = productSpuService;
    }
}

