/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.product.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5crm.api.product.payload.CrmBusinessAttributeGroupDetailPayload;
import com.elitesland.tw.tw5crm.api.product.query.CrmBusinessAttributeGroupDetailQuery;
import com.elitesland.tw.tw5crm.api.product.vo.CrmBusinessAttributeGroupDetailVO;
import com.elitesland.tw.tw5crm.server.product.entity.CrmBusinessAttributeGroupDetailDO;
import com.elitesland.tw.tw5crm.server.product.entity.QCrmBusinessAttributeGroupDetailDO;
import com.elitesland.tw.tw5crm.server.product.entity.QCrmBusinessTableColumnsDO;
import com.elitesland.tw.tw5crm.server.product.repo.CrmBusinessAttributeGroupDetailRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.StringTemplate;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class CrmBusinessAttributeGroupDetailDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final CrmBusinessAttributeGroupDetailRepo repo;
    private final QCrmBusinessAttributeGroupDetailDO qdo = QCrmBusinessAttributeGroupDetailDO.crmBusinessAttributeGroupDetailDO;
    private final QCrmBusinessTableColumnsDO columnsQdo = QCrmBusinessTableColumnsDO.crmBusinessTableColumnsDO;

    private JPAQuery<CrmBusinessAttributeGroupDetailVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(CrmBusinessAttributeGroupDetailVO.class, (Expression[])new Expression[]{this.qdo.groupId, this.qdo.attributeId, this.qdo.unitClass, this.qdo.isRequired, this.qdo.creator, this.qdo.createTime, this.qdo.createUserId, this.qdo.updater, this.qdo.modifyTime, this.qdo.modifyUserId, this.qdo.sortNo})).from((EntityPath)this.qdo);
    }

    private JPAQuery<CrmBusinessAttributeGroupDetailVO> getJpaQueryJoinSelect() {
        return (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(CrmBusinessAttributeGroupDetailVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.groupId, this.qdo.attributeId, this.qdo.unitClass, this.qdo.isRequired, this.qdo.creator, this.qdo.createTime, this.qdo.createUserId, this.qdo.updater, this.qdo.modifyTime, this.qdo.modifyUserId, this.columnsQdo.attributeDesc, this.columnsQdo.columnName, this.columnsQdo.selectionCode, this.columnsQdo.isMultiple, this.columnsQdo.attributeType, this.columnsQdo.componentType, this.columnsQdo.attributeScope, this.columnsQdo.attributePrompt, this.columnsQdo.status, this.qdo.sortNo})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.columnsQdo)).on((Predicate)this.qdo.attributeId.eq(this.columnsQdo.id));
    }

    private JPAQuery<CrmBusinessAttributeGroupDetailVO> getJpaListQuerySelect() {
        StringTemplate attributeNameStr = Expressions.stringTemplate((String)"CONCAT(GROUP_CONCAT({0}),'')", (Object[])new Object[]{this.columnsQdo.attributeDesc});
        StringTemplate attributeIdStr = Expressions.stringTemplate((String)"CONCAT(GROUP_CONCAT({0}),'')", (Object[])new Object[]{this.columnsQdo.id});
        return (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(CrmBusinessAttributeGroupDetailVO.class, (Expression[])new Expression[]{this.qdo.groupId.as("id"), this.qdo.groupId, attributeIdStr.as("attributeIdStr"), attributeNameStr.as("attributeNameStr")})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.columnsQdo)).on((Predicate)this.qdo.attributeId.eq(this.columnsQdo.id))).groupBy(this.qdo.groupId);
    }

    private JPAQuery<CrmBusinessAttributeGroupDetailVO> getJpaQueryWhere(CrmBusinessAttributeGroupDetailQuery query) {
        JPAQuery<CrmBusinessAttributeGroupDetailVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery;
    }

    public long count(CrmBusinessAttributeGroupDetailQuery query) {
        long total = (Long)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo)).where(this.where(query))).fetchOne();
        return total;
    }

    private Predicate where(CrmBusinessAttributeGroupDetailQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getGroupId())) {
            list.add(this.qdo.groupId.eq((Object)query.getGroupId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getGroupIdList())) {
            list.add(this.qdo.groupId.in(query.getGroupIdList()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getAttributeId())) {
            list.add(this.qdo.attributeId.eq((Object)query.getAttributeId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getUnitClass())) {
            list.add(this.qdo.unitClass.eq((Object)query.getUnitClass()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getIsRequired())) {
            list.add(this.qdo.isRequired.eq((Object)query.getIsRequired()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSortNo())) {
            list.add(this.qdo.sortNo.eq((Object)query.getSortNo()));
        }
        return ExpressionUtils.allOf(list);
    }

    public List<CrmBusinessAttributeGroupDetailVO> queryDetailNameStrByGroupIdList(List<Long> groupIdList) {
        JPAQuery<CrmBusinessAttributeGroupDetailVO> jpaQuery = this.getJpaListQuerySelect();
        jpaQuery.where((Predicate)this.qdo.groupId.in(groupIdList));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public List<CrmBusinessAttributeGroupDetailVO> queryByGroupId(List<Long> groupIdList) {
        JPAQuery<CrmBusinessAttributeGroupDetailVO> jpaQuerySelect = this.getJpaQueryJoinSelect();
        jpaQuerySelect.where((Predicate)this.qdo.groupId.in(groupIdList));
        jpaQuerySelect.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuerySelect.fetch();
    }

    public CrmBusinessAttributeGroupDetailVO queryByKey(Long id) {
        JPAQuery<CrmBusinessAttributeGroupDetailVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (CrmBusinessAttributeGroupDetailVO)jpaQuery.fetchFirst();
    }

    public List<CrmBusinessAttributeGroupDetailVO> queryByGroupId(Long groupId) {
        JPAQuery<CrmBusinessAttributeGroupDetailVO> jpaQuery = this.getJpaQueryJoinSelect();
        jpaQuery.where((Predicate)this.qdo.groupId.eq((Object)groupId));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public List<CrmBusinessAttributeGroupDetailVO> queryListDynamic(CrmBusinessAttributeGroupDetailQuery query) {
        JPAQuery<CrmBusinessAttributeGroupDetailVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public List<CrmBusinessAttributeGroupDetailVO> queryListJoinDynamic(CrmBusinessAttributeGroupDetailQuery query) {
        JPAQuery<CrmBusinessAttributeGroupDetailVO> jpaQuery = this.getJpaQueryJoinSelect();
        jpaQuery.where(this.where(query));
        return jpaQuery.fetch();
    }

    public PagingVO<CrmBusinessAttributeGroupDetailVO> queryPaging(CrmBusinessAttributeGroupDetailQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<CrmBusinessAttributeGroupDetailVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public CrmBusinessAttributeGroupDetailDO save(CrmBusinessAttributeGroupDetailDO ado) {
        return (CrmBusinessAttributeGroupDetailDO)this.repo.save(ado);
    }

    public List<CrmBusinessAttributeGroupDetailDO> saveAll(List<CrmBusinessAttributeGroupDetailDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(CrmBusinessAttributeGroupDetailPayload payload) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getGroupId() != null) {
            update.set(this.qdo.groupId, (Object)payload.getGroupId());
        }
        if (payload.getAttributeId() != null) {
            update.set(this.qdo.attributeId, (Object)payload.getAttributeId());
        }
        if (payload.getUnitClass() != null) {
            update.set((Path)this.qdo.unitClass, (Object)payload.getUnitClass());
        }
        if (payload.getIsRequired() != null) {
            update.set(this.qdo.isRequired, (Object)payload.getIsRequired());
        }
        if (payload.getSortNo() != null) {
            update.set(this.qdo.sortNo, (Object)payload.getSortNo());
        }
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long deleteByGroupId(Long groupId) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.groupId.eq((Object)groupId)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public CrmBusinessAttributeGroupDetailDAO(JPAQueryFactory jpaQueryFactory, CrmBusinessAttributeGroupDetailRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

