/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.product.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5crm.api.product.payload.ProductCategoryAttrGroupRefPayload;
import com.elitesland.tw.tw5crm.api.product.query.ProductCategoryAttrGroupRefQuery;
import com.elitesland.tw.tw5crm.api.product.vo.ProductCategoryAttrGroupRefVO;
import com.elitesland.tw.tw5crm.server.product.entity.ProductCategoryAttrGroupRefDO;
import com.elitesland.tw.tw5crm.server.product.entity.QProductCategoryAttrGroupRefDO;
import com.elitesland.tw.tw5crm.server.product.repo.ProductCategoryAttrGroupRefRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class ProductCategoryAttrGroupRefDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final ProductCategoryAttrGroupRefRepo repo;
    private final QProductCategoryAttrGroupRefDO qdo = QProductCategoryAttrGroupRefDO.productCategoryAttrGroupRefDO;

    private JPAQuery<ProductCategoryAttrGroupRefVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ProductCategoryAttrGroupRefVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.categoryId, this.qdo.categoryName, this.qdo.groupId, this.qdo.groupName, this.qdo.status, this.qdo.sortNo, this.qdo.sortNoSelf})).from((EntityPath)this.qdo);
    }

    private JPAQuery<ProductCategoryAttrGroupRefVO> getJpaQueryWhere(ProductCategoryAttrGroupRefQuery query) {
        JPAQuery<ProductCategoryAttrGroupRefVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery;
    }

    public long count(ProductCategoryAttrGroupRefQuery query) {
        long total = (Long)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo)).where(this.where(query))).fetchOne();
        return total;
    }

    private Predicate where(ProductCategoryAttrGroupRefQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCategoryId())) {
            list.add(this.qdo.categoryId.eq((Object)query.getCategoryId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCategoryName())) {
            list.add(this.qdo.categoryName.like(SqlUtil.toSqlLikeString(query.getCategoryName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getGroupId())) {
            list.add(this.qdo.groupId.eq((Object)query.getGroupId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getGroupName())) {
            list.add(this.qdo.groupName.like(SqlUtil.toSqlLikeString(query.getGroupName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getStatus())) {
            list.add(this.qdo.status.eq((Object)query.getStatus()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSortNo())) {
            list.add(this.qdo.sortNo.eq((Object)query.getSortNo()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSortNoSelf())) {
            list.add(this.qdo.sortNoSelf.eq((Object)query.getSortNoSelf()));
        }
        return ExpressionUtils.allOf(list);
    }

    public ProductCategoryAttrGroupRefVO queryByKey(Long id) {
        JPAQuery<ProductCategoryAttrGroupRefVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (ProductCategoryAttrGroupRefVO)jpaQuery.fetchFirst();
    }

    public List<ProductCategoryAttrGroupRefVO> queryListDynamic(ProductCategoryAttrGroupRefQuery query) {
        JPAQuery<ProductCategoryAttrGroupRefVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<ProductCategoryAttrGroupRefVO> queryPaging(ProductCategoryAttrGroupRefQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<ProductCategoryAttrGroupRefVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public ProductCategoryAttrGroupRefDO save(ProductCategoryAttrGroupRefDO ado) {
        return (ProductCategoryAttrGroupRefDO)this.repo.save(ado);
    }

    public List<ProductCategoryAttrGroupRefDO> saveAll(List<ProductCategoryAttrGroupRefDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(ProductCategoryAttrGroupRefPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getCategoryId() != null) {
            update.set(this.qdo.categoryId, (Object)payload.getCategoryId());
        }
        if (payload.getCategoryName() != null) {
            update.set((Path)this.qdo.categoryName, (Object)payload.getCategoryName());
        }
        if (payload.getGroupId() != null) {
            update.set(this.qdo.groupId, (Object)payload.getGroupId());
        }
        if (payload.getGroupName() != null) {
            update.set((Path)this.qdo.groupName, (Object)payload.getGroupName());
        }
        if (payload.getStatus() != null) {
            update.set(this.qdo.status, (Object)payload.getStatus());
        }
        if (payload.getSortNo() != null) {
            update.set(this.qdo.sortNo, (Object)payload.getSortNo());
        }
        if (payload.getSortNoSelf() != null) {
            update.set(this.qdo.sortNoSelf, (Object)payload.getSortNoSelf());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("categoryId")) {
                update.setNull(this.qdo.categoryId);
            }
            if (nullFields.contains("categoryName")) {
                update.setNull((Path)this.qdo.categoryName);
            }
            if (nullFields.contains("groupId")) {
                update.setNull(this.qdo.groupId);
            }
            if (nullFields.contains("groupName")) {
                update.setNull((Path)this.qdo.groupName);
            }
            if (nullFields.contains("status")) {
                update.setNull(this.qdo.status);
            }
            if (nullFields.contains("sortNo")) {
                update.setNull(this.qdo.sortNo);
            }
            if (nullFields.contains("sortNoSelf")) {
                update.setNull(this.qdo.sortNoSelf);
            }
        }
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public ProductCategoryAttrGroupRefDAO(JPAQueryFactory jpaQueryFactory, ProductCategoryAttrGroupRefRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

