/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.product.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5crm.api.product.payload.ProductCategoryPayload;
import com.elitesland.tw.tw5crm.api.product.query.ProductCategoryQuery;
import com.elitesland.tw.tw5crm.api.product.vo.ProductCategoryVO;
import com.elitesland.tw.tw5crm.server.product.entity.ProductCategoryDO;
import com.elitesland.tw.tw5crm.server.product.entity.QProductCategoryDO;
import com.elitesland.tw.tw5crm.server.product.repo.ProductCategoryRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class ProductCategoryDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final ProductCategoryRepo repo;
    private final QProductCategoryDO qdo = QProductCategoryDO.productCategoryDO;

    private JPAQuery<ProductCategoryVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ProductCategoryVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.objName, this.qdo.objNo, this.qdo.parentId, this.qdo.sortNo, this.qdo.previewBefore, this.qdo.previewAfter, this.qdo.status})).from((EntityPath)this.qdo);
    }

    private JPAQuery<ProductCategoryVO> getJpaQueryWhere(ProductCategoryQuery query) {
        JPAQuery<ProductCategoryVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery;
    }

    public long count(ProductCategoryQuery query) {
        long total = (Long)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo)).where(this.where(query))).fetchOne();
        return total;
    }

    private Predicate where(ProductCategoryQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getIdNotEq())) {
            list.add(this.qdo.id.ne((Object)query.getIdNotEq()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getObjName())) {
            list.add(this.qdo.objName.like(SqlUtil.toSqlLikeString(query.getObjName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getObjNameEq())) {
            list.add(this.qdo.objName.eq((Object)query.getObjNameEq()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getObjNo())) {
            list.add(this.qdo.objNo.like(SqlUtil.toSqlLikeString(query.getObjNo())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getParentId())) {
            list.add(this.qdo.parentId.eq((Object)query.getParentId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSortNo())) {
            list.add(this.qdo.sortNo.eq((Object)query.getSortNo()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPreviewBefore())) {
            list.add(this.qdo.previewBefore.like(SqlUtil.toSqlLikeString(query.getPreviewBefore())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPreviewAfter())) {
            list.add(this.qdo.previewAfter.like(SqlUtil.toSqlLikeString(query.getPreviewAfter())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getStatus())) {
            list.add(this.qdo.status.eq((Object)query.getStatus()));
        }
        return ExpressionUtils.allOf(list);
    }

    public ProductCategoryVO queryByKey(Long id) {
        JPAQuery<ProductCategoryVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (ProductCategoryVO)jpaQuery.fetchFirst();
    }

    public List<ProductCategoryVO> queryListDynamic(ProductCategoryQuery query) {
        JPAQuery<ProductCategoryVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<ProductCategoryVO> queryPaging(ProductCategoryQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<ProductCategoryVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public ProductCategoryDO save(ProductCategoryDO ado) {
        return (ProductCategoryDO)this.repo.save(ado);
    }

    public List<ProductCategoryDO> saveAll(List<ProductCategoryDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(ProductCategoryPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getObjName() != null) {
            update.set((Path)this.qdo.objName, (Object)payload.getObjName());
        }
        if (payload.getObjNo() != null) {
            update.set((Path)this.qdo.objNo, (Object)payload.getObjNo());
        }
        if (payload.getParentId() != null) {
            update.set(this.qdo.parentId, (Object)payload.getParentId());
        }
        if (payload.getSortNo() != null) {
            update.set(this.qdo.sortNo, (Object)payload.getSortNo());
        }
        if (payload.getPreviewBefore() != null) {
            update.set((Path)this.qdo.previewBefore, (Object)payload.getPreviewBefore());
        }
        if (payload.getPreviewAfter() != null) {
            update.set((Path)this.qdo.previewAfter, (Object)payload.getPreviewAfter());
        }
        if (payload.getStatus() != null) {
            update.set(this.qdo.status, (Object)payload.getStatus());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("objName")) {
                update.setNull((Path)this.qdo.objName);
            }
            if (nullFields.contains("objNo")) {
                update.setNull((Path)this.qdo.objNo);
            }
            if (nullFields.contains("parentId")) {
                update.setNull(this.qdo.parentId);
            }
            if (nullFields.contains("sortNo")) {
                update.setNull(this.qdo.sortNo);
            }
            if (nullFields.contains("previewBefore")) {
                update.setNull((Path)this.qdo.previewBefore);
            }
            if (nullFields.contains("previewAfter")) {
                update.setNull((Path)this.qdo.previewAfter);
            }
            if (nullFields.contains("status")) {
                update.setNull(this.qdo.status);
            }
        }
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public ProductCategoryDAO(JPAQueryFactory jpaQueryFactory, ProductCategoryRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

