/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.product.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5crm.api.product.payload.ProductSkuPayload;
import com.elitesland.tw.tw5crm.api.product.query.ProductSkuQuery;
import com.elitesland.tw.tw5crm.api.product.vo.ProductSkuVO;
import com.elitesland.tw.tw5crm.server.product.entity.ProductSkuDO;
import com.elitesland.tw.tw5crm.server.product.entity.QProductSkuDO;
import com.elitesland.tw.tw5crm.server.product.repo.ProductSkuRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class ProductSkuDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final ProductSkuRepo repo;
    private final QProductSkuDO qdo = QProductSkuDO.productSkuDO;

    private JPAQuery<ProductSkuVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ProductSkuVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.spuId, this.qdo.categoryId, this.qdo.skuName, this.qdo.skuCode, this.qdo.standardPrice, this.qdo.saleUnit, this.qdo.imgCodes, this.qdo.spuType, this.qdo.spuCategory, this.qdo.attribute, this.qdo.attributeGroup, this.qdo.skuContent, this.qdo.fileCodes, this.qdo.skuStatus, this.qdo.sortNo, this.qdo.attributeStr})).from((EntityPath)this.qdo);
    }

    private JPAQuery<ProductSkuVO> getJpaQueryWhere(ProductSkuQuery query) {
        JPAQuery<ProductSkuVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery;
    }

    public long count(ProductSkuQuery query) {
        long total = (Long)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo)).where(this.where(query))).fetchOne();
        return total;
    }

    private Predicate where(ProductSkuQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSpuId())) {
            list.add(this.qdo.spuId.eq((Object)query.getSpuId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCategoryId())) {
            list.add(this.qdo.categoryId.eq((Object)query.getCategoryId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSkuName())) {
            list.add(this.qdo.skuName.like(SqlUtil.toSqlLikeString(query.getSkuName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSkuCode())) {
            list.add(this.qdo.skuCode.like(SqlUtil.toSqlLikeString(query.getSkuCode())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getStandardPrice())) {
            list.add(this.qdo.standardPrice.eq((Object)query.getStandardPrice()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSaleUnit())) {
            list.add(this.qdo.saleUnit.eq((Object)query.getSaleUnit()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getImgCodes())) {
            list.add(this.qdo.imgCodes.like(SqlUtil.toSqlLikeString(query.getImgCodes())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getAttribute())) {
            list.add(this.qdo.attribute.like(SqlUtil.toSqlLikeString(query.getAttribute())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getAttributeGroup())) {
            list.add(this.qdo.attributeGroup.like(SqlUtil.toSqlLikeString(query.getAttributeGroup())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSkuContent())) {
            list.add(this.qdo.skuContent.like(SqlUtil.toSqlLikeString(query.getSkuContent())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getFileCodes())) {
            list.add(this.qdo.fileCodes.like(SqlUtil.toSqlLikeString(query.getFileCodes())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSkuStatus())) {
            list.add(this.qdo.skuStatus.eq((Object)query.getSkuStatus()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSortNo())) {
            list.add(this.qdo.sortNo.eq((Object)query.getSortNo()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getAttributeStr())) {
            list.add(this.qdo.attributeStr.like(SqlUtil.toSqlLikeString(query.getAttributeStr())));
        }
        return ExpressionUtils.allOf(list);
    }

    public ProductSkuVO queryByKey(Long id) {
        JPAQuery<ProductSkuVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (ProductSkuVO)jpaQuery.fetchFirst();
    }

    public List<ProductSkuVO> queryByKeys(List<Long> ids) {
        JPAQuery<ProductSkuVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.in(ids));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public List<ProductSkuVO> queryListDynamic(ProductSkuQuery query) {
        JPAQuery<ProductSkuVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public List<ProductSkuVO> queryListBySpuIds(List<Long> spuIds) {
        JPAQuery<ProductSkuVO> jpaQuery = this.getJpaQuerySelect();
        ((JPAQuery)jpaQuery.where((Predicate)this.qdo.spuId.in(spuIds))).where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        ArrayList<OrderItem> orderse = new ArrayList<OrderItem>();
        orderse.add(OrderItem.asc((String)"sortNo"));
        orderse.add(OrderItem.desc((String)"createTime"));
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, orderse));
        return jpaQuery.fetch();
    }

    public PagingVO<ProductSkuVO> queryPaging(ProductSkuQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<ProductSkuVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public ProductSkuDO save(ProductSkuDO ado) {
        return (ProductSkuDO)this.repo.save(ado);
    }

    public List<ProductSkuDO> saveAll(List<ProductSkuDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(ProductSkuPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getSpuId() != null) {
            update.set(this.qdo.spuId, (Object)payload.getSpuId());
        }
        if (payload.getCategoryId() != null) {
            update.set(this.qdo.categoryId, (Object)payload.getCategoryId());
        }
        if (payload.getSkuName() != null) {
            update.set((Path)this.qdo.skuName, (Object)payload.getSkuName());
        }
        if (payload.getSkuCode() != null) {
            update.set((Path)this.qdo.skuCode, (Object)payload.getSkuCode());
        }
        if (payload.getStandardPrice() != null) {
            update.set(this.qdo.standardPrice, (Object)payload.getStandardPrice());
        }
        if (payload.getSaleUnit() != null) {
            update.set((Path)this.qdo.saleUnit, (Object)payload.getSaleUnit());
        }
        if (payload.getImgCodes() != null) {
            update.set((Path)this.qdo.imgCodes, (Object)payload.getImgCodes());
        }
        if (payload.getSkuContent() != null) {
            update.set((Path)this.qdo.skuContent, (Object)payload.getSkuContent());
        }
        if (payload.getFileCodes() != null) {
            update.set((Path)this.qdo.fileCodes, (Object)payload.getFileCodes());
        }
        if (payload.getSkuStatus() != null) {
            update.set((Path)this.qdo.skuStatus, (Object)payload.getSkuStatus());
        }
        if (payload.getSortNo() != null) {
            update.set(this.qdo.sortNo, (Object)payload.getSortNo());
        }
        if (payload.getAttributeStr() != null) {
            update.set((Path)this.qdo.attributeStr, (Object)payload.getAttributeStr());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("spuId")) {
                update.setNull(this.qdo.spuId);
            }
            if (nullFields.contains("categoryId")) {
                update.setNull(this.qdo.categoryId);
            }
            if (nullFields.contains("skuName")) {
                update.setNull((Path)this.qdo.skuName);
            }
            if (nullFields.contains("skuCode")) {
                update.setNull((Path)this.qdo.skuCode);
            }
            if (nullFields.contains("standardPrice")) {
                update.setNull(this.qdo.standardPrice);
            }
            if (nullFields.contains("saleUnit")) {
                update.setNull((Path)this.qdo.saleUnit);
            }
            if (nullFields.contains("imgCodes")) {
                update.setNull((Path)this.qdo.imgCodes);
            }
            if (nullFields.contains("attribute")) {
                update.setNull((Path)this.qdo.attribute);
            }
            if (nullFields.contains("attributeGroup")) {
                update.setNull((Path)this.qdo.attributeGroup);
            }
            if (nullFields.contains("skuContent")) {
                update.setNull((Path)this.qdo.skuContent);
            }
            if (nullFields.contains("fileCodes")) {
                update.setNull((Path)this.qdo.fileCodes);
            }
            if (nullFields.contains("skuStatus")) {
                update.setNull((Path)this.qdo.skuStatus);
            }
            if (nullFields.contains("sortNo")) {
                update.setNull(this.qdo.sortNo);
            }
            if (nullFields.contains("attributeStr")) {
                update.setNull((Path)this.qdo.attributeStr);
            }
        }
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long updateStatus(ProductSkuPayload payload) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set((Path)this.qdo.skuStatus, (Object)payload.getSkuStatus()).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public ProductSkuDAO(JPAQueryFactory jpaQueryFactory, ProductSkuRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

