/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.product.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5crm.api.product.payload.ProductSpuPayload;
import com.elitesland.tw.tw5crm.api.product.query.ProductSpuQuery;
import com.elitesland.tw.tw5crm.api.product.vo.ProductSpuVO;
import com.elitesland.tw.tw5crm.server.product.entity.ProductSpuDO;
import com.elitesland.tw.tw5crm.server.product.entity.QProductSpuDO;
import com.elitesland.tw.tw5crm.server.product.repo.ProductSpuRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class ProductSpuDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final ProductSpuRepo repo;
    private final QProductSpuDO qdo = QProductSpuDO.productSpuDO;

    private JPAQuery<ProductSpuVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ProductSpuVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.createTime, this.qdo.createUserId, this.qdo.categoryId, this.qdo.spuCategory, this.qdo.spuName, this.qdo.spuCode, this.qdo.spuProfile, this.qdo.spuType, this.qdo.manageUserId, this.qdo.orgId, this.qdo.imgCodes, this.qdo.attribute, this.qdo.attributeGroup, this.qdo.spuStatus, this.qdo.sortNo})).from((EntityPath)this.qdo);
    }

    private JPAQuery<ProductSpuVO> getJpaQueryWhere(ProductSpuQuery query) {
        JPAQuery<ProductSpuVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery;
    }

    public long count(ProductSpuQuery query) {
        long total = (Long)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo)).where(this.where(query))).fetchOne();
        return total;
    }

    private Predicate where(ProductSpuQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCategoryId())) {
            list.add(this.qdo.categoryId.eq((Object)query.getCategoryId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSpuName())) {
            list.add(this.qdo.spuName.like(SqlUtil.toSqlLikeString(query.getSpuName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSpuCode())) {
            list.add(this.qdo.spuCode.like(SqlUtil.toSqlLikeString(query.getSpuCode())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSpuProfile())) {
            list.add(this.qdo.spuProfile.like(SqlUtil.toSqlLikeString(query.getSpuProfile())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSpuType())) {
            list.add(this.qdo.spuType.eq((Object)query.getSpuType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getManageUserId())) {
            list.add(this.qdo.manageUserId.eq((Object)query.getManageUserId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getOrgId())) {
            list.add(this.qdo.orgId.eq((Object)query.getOrgId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getImgCodes())) {
            list.add(this.qdo.imgCodes.like(SqlUtil.toSqlLikeString(query.getImgCodes())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getAttribute())) {
            list.add(this.qdo.attribute.like(SqlUtil.toSqlLikeString(query.getAttribute())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getAttributeGroup())) {
            list.add(this.qdo.attributeGroup.like(SqlUtil.toSqlLikeString(query.getAttributeGroup())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSpuStatus())) {
            list.add(this.qdo.spuStatus.eq((Object)query.getSpuStatus()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSortNo())) {
            list.add(this.qdo.sortNo.eq((Object)query.getSortNo()));
        }
        if (query.getPermissionFlag().booleanValue()) {
            BooleanExpression jpaQueryOr = this.qdo.createUserId.eq((Object)query.getCreateUserId()).or((Predicate)this.qdo.manageUserId.eq((Object)query.getCreateUserId()));
            if (!ObjectUtils.isEmpty((Object)query.getOrgIdList())) {
                jpaQueryOr = jpaQueryOr.or((Predicate)this.qdo.orgId.in((Collection)query.getOrgIdList()));
            }
            list.add(jpaQueryOr);
        }
        return ExpressionUtils.allOf(list);
    }

    public ProductSpuVO queryByKey(Long id) {
        JPAQuery<ProductSpuVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (ProductSpuVO)jpaQuery.fetchFirst();
    }

    public List<ProductSpuVO> queryListDynamic(ProductSpuQuery query) {
        JPAQuery<ProductSpuVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<ProductSpuVO> queryPaging(ProductSpuQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<ProductSpuVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public ProductSpuDO save(ProductSpuDO ado) {
        return (ProductSpuDO)this.repo.save(ado);
    }

    public List<ProductSpuDO> saveAll(List<ProductSpuDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(ProductSpuPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getCategoryId() != null) {
            update.set(this.qdo.categoryId, (Object)payload.getCategoryId());
        }
        if (payload.getSpuCategory() != null) {
            update.set((Path)this.qdo.spuCategory, (Object)payload.getSpuCategory());
        }
        if (payload.getSpuName() != null) {
            update.set((Path)this.qdo.spuName, (Object)payload.getSpuName());
        }
        if (payload.getSpuCode() != null) {
            update.set((Path)this.qdo.spuCode, (Object)payload.getSpuCode());
        }
        if (payload.getSpuProfile() != null) {
            update.set((Path)this.qdo.spuProfile, (Object)payload.getSpuProfile());
        }
        if (payload.getSpuType() != null) {
            update.set((Path)this.qdo.spuType, (Object)payload.getSpuType());
        }
        if (payload.getManageUserId() != null) {
            update.set(this.qdo.manageUserId, (Object)payload.getManageUserId());
        }
        if (payload.getOrgId() != null) {
            update.set(this.qdo.orgId, (Object)payload.getOrgId());
        }
        if (payload.getImgCodes() != null) {
            update.set((Path)this.qdo.imgCodes, (Object)payload.getImgCodes());
        }
        if (payload.getSpuStatus() != null) {
            update.set((Path)this.qdo.spuStatus, (Object)payload.getSpuStatus());
        }
        if (payload.getSortNo() != null) {
            update.set(this.qdo.sortNo, (Object)payload.getSortNo());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("categoryId")) {
                update.setNull(this.qdo.categoryId);
            }
            if (nullFields.contains("spuCategory")) {
                update.setNull((Path)this.qdo.spuCategory);
            }
            if (nullFields.contains("spuName")) {
                update.setNull((Path)this.qdo.spuName);
            }
            if (nullFields.contains("spuCode")) {
                update.setNull((Path)this.qdo.spuCode);
            }
            if (nullFields.contains("spuProfile")) {
                update.setNull((Path)this.qdo.spuProfile);
            }
            if (nullFields.contains("spuType")) {
                update.setNull((Path)this.qdo.spuType);
            }
            if (nullFields.contains("manageUserId")) {
                update.setNull(this.qdo.manageUserId);
            }
            if (nullFields.contains("orgId")) {
                update.setNull(this.qdo.orgId);
            }
            if (nullFields.contains("imgCodes")) {
                update.setNull((Path)this.qdo.imgCodes);
            }
            if (nullFields.contains("attribute")) {
                update.setNull((Path)this.qdo.attribute);
            }
            if (nullFields.contains("attributeGroup")) {
                update.setNull((Path)this.qdo.attributeGroup);
            }
            if (nullFields.contains("spuStatus")) {
                update.setNull((Path)this.qdo.spuStatus);
            }
            if (nullFields.contains("sortNo")) {
                update.setNull(this.qdo.sortNo);
            }
        }
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        return update.execute();
    }

    public ProductSpuDAO(JPAQueryFactory jpaQueryFactory, ProductSpuRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

