/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.product.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5crm.api.product.payload.ProductCategoryAttrGroupDetailRefPayload;
import com.elitesland.tw.tw5crm.api.product.payload.ProductCategoryAttrGroupRefListPayload;
import com.elitesland.tw.tw5crm.api.product.payload.ProductCategoryAttrGroupRefPayload;
import com.elitesland.tw.tw5crm.api.product.query.ProductCategoryAttrGroupDetailRefQuery;
import com.elitesland.tw.tw5crm.api.product.query.ProductCategoryAttrGroupRefQuery;
import com.elitesland.tw.tw5crm.api.product.query.ProductCategoryColumnRefQuery;
import com.elitesland.tw.tw5crm.api.product.query.ProductSkuQuery;
import com.elitesland.tw.tw5crm.api.product.query.ProductSpuQuery;
import com.elitesland.tw.tw5crm.api.product.service.ProductCategoryAttrGroupDetailRefService;
import com.elitesland.tw.tw5crm.api.product.service.ProductCategoryAttrGroupRefService;
import com.elitesland.tw.tw5crm.api.product.vo.CrmBusinessAttributeGroupDetailVO;
import com.elitesland.tw.tw5crm.api.product.vo.CrmBusinessAttributeGroupVO;
import com.elitesland.tw.tw5crm.api.product.vo.CrmBusinessTableColumnsVO;
import com.elitesland.tw.tw5crm.api.product.vo.ProductCategoryAttrGroupDetailRefVO;
import com.elitesland.tw.tw5crm.api.product.vo.ProductCategoryAttrGroupRefVO;
import com.elitesland.tw.tw5crm.api.product.vo.ProductCategoryColumnRefVO;
import com.elitesland.tw.tw5crm.api.product.vo.ProductCategoryVO;
import com.elitesland.tw.tw5crm.server.product.convert.ProductCategoryAttrGroupRefConvert;
import com.elitesland.tw.tw5crm.server.product.dao.CrmBusinessAttributeGroupDAO;
import com.elitesland.tw.tw5crm.server.product.dao.CrmBusinessAttributeGroupDetailDAO;
import com.elitesland.tw.tw5crm.server.product.dao.CrmBusinessTableColumnsDAO;
import com.elitesland.tw.tw5crm.server.product.dao.ProductCategoryAttrGroupDetailRefDAO;
import com.elitesland.tw.tw5crm.server.product.dao.ProductCategoryColumnRefDAO;
import com.elitesland.tw.tw5crm.server.product.dao.ProductCategoryDAO;
import com.elitesland.tw.tw5crm.server.product.dao.ProductSkuDAO;
import com.elitesland.tw.tw5crm.server.product.dao.ProductSpuDAO;
import com.elitesland.tw.tw5crm.server.product.entity.ProductCategoryAttrGroupRefDO;
import com.elitesland.tw.tw5crm.server.product.repo.ProductCategoryAttrGroupRefRepo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class ProductCategoryAttrGroupRefServiceImpl
implements ProductCategoryAttrGroupRefService {
    private static final Logger log = LoggerFactory.getLogger(ProductCategoryAttrGroupRefServiceImpl.class);
    private final ProductCategoryAttrGroupRefRepo productCategoryAttrGroupRefRepo;
    private final ProductCategoryAttrGroupDetailRefService productCategoryAttrGroupDetailRefService;
    private final ProductCategoryAttrGroupDetailRefDAO productCategoryAttrGroupDetailRefDAO;
    private final ProductCategoryColumnRefDAO productCategoryColumnRefDAO;
    private final CrmBusinessAttributeGroupDAO crmBusinessAttributeGroupDAO;
    private final CrmBusinessAttributeGroupDetailDAO crmBusinessAttributeGroupDetailDAO;
    private final CrmBusinessTableColumnsDAO crmBusinessTableColumnsDAO;
    private final ProductCategoryDAO productCategoryDAO;
    private final ProductSpuDAO productSpuDAO;
    private final ProductSkuDAO productSkuDAO;

    public PagingVO<ProductCategoryAttrGroupRefVO> paging(ProductCategoryAttrGroupRefQuery query) {
        Page page = this.productCategoryAttrGroupRefRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), (Pageable)query.getPageRequest());
        Page pageVo = page.map(ProductCategoryAttrGroupRefConvert.INSTANCE::toVo);
        pageVo.getContent().forEach(groupRefVO -> this.detailsProcessDynamic((ProductCategoryAttrGroupRefVO)groupRefVO));
        return PageUtil.toPageVo(pageVo);
    }

    private void detailsProcessDynamic(ProductCategoryAttrGroupRefVO groupRefVO) {
        List<CrmBusinessAttributeGroupDetailVO> attributeGroupDetailVOList = this.crmBusinessAttributeGroupDetailDAO.queryByGroupId(groupRefVO.getGroupId());
        List attrGroupDetailRefVOList = attributeGroupDetailVOList.stream().filter(crmBusinessAttributeGroupDetailVO -> null != crmBusinessAttributeGroupDetailVO.getStatus() && crmBusinessAttributeGroupDetailVO.getStatus().equals(1)).map(crmBusinessAttributeGroupDetailVO -> {
            ProductCategoryAttrGroupDetailRefVO attrGroupDetailRefVO = new ProductCategoryAttrGroupDetailRefVO();
            attrGroupDetailRefVO.setGroupRefId(groupRefVO.getId());
            attrGroupDetailRefVO.setCategoryId(groupRefVO.getCategoryId());
            attrGroupDetailRefVO.setCategoryName(groupRefVO.getCategoryName());
            attrGroupDetailRefVO.setGroupId(groupRefVO.getGroupId());
            attrGroupDetailRefVO.setGroupName(groupRefVO.getGroupName());
            Long attributeId = crmBusinessAttributeGroupDetailVO.getAttributeId();
            attrGroupDetailRefVO.setAttributeId(attributeId);
            CrmBusinessTableColumnsVO columnsVO = this.crmBusinessTableColumnsDAO.findByKey(attributeId);
            Assert.notNull((Object)columnsVO, (String)"\u5c5e\u6027\u4e0d\u5b58\u5728");
            if (ObjectUtils.isEmpty((Object)attrGroupDetailRefVO.getColumnName())) {
                attrGroupDetailRefVO.setColumnName(columnsVO.getColumnName());
            }
            if (ObjectUtils.isEmpty((Object)attrGroupDetailRefVO.getColumnDesc())) {
                attrGroupDetailRefVO.setColumnDesc(columnsVO.getColumnDesc());
            }
            if (ObjectUtils.isEmpty((Object)attrGroupDetailRefVO.getAttributeDesc())) {
                attrGroupDetailRefVO.setAttributeDesc(columnsVO.getAttributeDesc());
            }
            if (ObjectUtils.isEmpty((Object)attrGroupDetailRefVO.getAttributeType())) {
                attrGroupDetailRefVO.setAttributeType(columnsVO.getAttributeType());
            }
            if (ObjectUtils.isEmpty((Object)attrGroupDetailRefVO.getComponentType())) {
                attrGroupDetailRefVO.setComponentType(columnsVO.getComponentType());
            }
            if (ObjectUtils.isEmpty((Object)attrGroupDetailRefVO.getAttributeScope())) {
                attrGroupDetailRefVO.setAttributeScope(columnsVO.getAttributeScope());
            }
            if (ObjectUtils.isEmpty((Object)attrGroupDetailRefVO.getAttributePrompt())) {
                attrGroupDetailRefVO.setAttributePrompt(columnsVO.getAttributePrompt());
            }
            if (ObjectUtils.isEmpty((Object)attrGroupDetailRefVO.getSelectionCode())) {
                attrGroupDetailRefVO.setSelectionCode(columnsVO.getSelectionCode());
            }
            if (ObjectUtils.isEmpty((Object)attrGroupDetailRefVO.getIsMultiple())) {
                attrGroupDetailRefVO.setIsMultiple(columnsVO.getIsMultiple());
            }
            if (ObjectUtils.isEmpty((Object)attrGroupDetailRefVO.getSortNo())) {
                if (columnsVO.getSortNo() == null) {
                    columnsVO.setSortNo(Integer.valueOf(0));
                }
                attrGroupDetailRefVO.setSortNo(Integer.valueOf(columnsVO.getSortNo() != null ? columnsVO.getSortNo() : 0));
            }
            if (ObjectUtils.isEmpty((Object)attrGroupDetailRefVO.getSortNoSelf())) {
                attrGroupDetailRefVO.setSortNoSelf(columnsVO.getSortNo());
            }
            return attrGroupDetailRefVO;
        }).collect(Collectors.toList());
        String attrStr = attributeGroupDetailVOList.stream().map(CrmBusinessAttributeGroupDetailVO::getAttributeDesc).collect(Collectors.joining("\u3001"));
        groupRefVO.setAttrStr(attrStr);
        groupRefVO.setDetails(attrGroupDetailRefVOList);
    }

    private void detailsProcessRedundant(ProductCategoryAttrGroupRefVO groupRefVO) {
        Long id = groupRefVO.getId();
        ProductCategoryAttrGroupDetailRefQuery groupDetailRefQuery = new ProductCategoryAttrGroupDetailRefQuery();
        groupDetailRefQuery.setGroupRefId(id);
        List attrGroupDetailRefVOList = this.productCategoryAttrGroupDetailRefService.queryList(groupDetailRefQuery);
        String attrStr = attrGroupDetailRefVOList.stream().map(ProductCategoryAttrGroupDetailRefVO::getCategoryName).collect(Collectors.joining("\u3001"));
        groupRefVO.setAttrStr(attrStr);
        groupRefVO.setDetails(attrGroupDetailRefVOList);
    }

    public List<ProductCategoryAttrGroupRefVO> queryList(ProductCategoryAttrGroupRefQuery query) {
        List<ProductCategoryAttrGroupRefVO> productCategoryAttrGroupRefVOS = ProductCategoryAttrGroupRefConvert.INSTANCE.toVoList(this.productCategoryAttrGroupRefRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder)));
        productCategoryAttrGroupRefVOS.forEach(groupRefVO -> this.detailsProcessDynamic((ProductCategoryAttrGroupRefVO)groupRefVO));
        return productCategoryAttrGroupRefVOS;
    }

    public ProductCategoryAttrGroupRefVO queryByKey(Long key) {
        ProductCategoryAttrGroupRefDO entity = this.productCategoryAttrGroupRefRepo.findById(key).orElseGet(ProductCategoryAttrGroupRefDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        ProductCategoryAttrGroupRefVO vo = ProductCategoryAttrGroupRefConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public ProductCategoryAttrGroupRefVO insert(ProductCategoryAttrGroupRefPayload payload) {
        this.check(payload);
        this.dataProcess(payload);
        ProductCategoryAttrGroupRefDO entityDo = ProductCategoryAttrGroupRefConvert.INSTANCE.toDo(payload);
        ProductCategoryAttrGroupRefDO save = (ProductCategoryAttrGroupRefDO)this.productCategoryAttrGroupRefRepo.save(entityDo);
        Long groupRefId = save.getId();
        Long categoryId = save.getCategoryId();
        Long groupId = save.getGroupId();
        if (payload.getId() != null && payload.getId() > 0L) {
            this.productCategoryAttrGroupDetailRefDAO.deleteSoftByGroupRefId(payload.getId());
        }
        this.insertDetails(payload, groupRefId, categoryId, groupId);
        return ProductCategoryAttrGroupRefConvert.INSTANCE.toVo(save);
    }

    @Transactional(rollbackFor={Exception.class})
    public List<ProductCategoryAttrGroupRefVO> batchSaveOrUpdate(ProductCategoryAttrGroupRefListPayload payload) {
        if (!CollectionUtils.isEmpty((Collection)payload.getDeleteIdList())) {
            this.deleteSoft(payload.getDeleteIdList());
        }
        ArrayList<ProductCategoryAttrGroupRefVO> list = new ArrayList<ProductCategoryAttrGroupRefVO>();
        if (!CollectionUtils.isEmpty((Collection)payload.getCategoryAttrGroupRefList())) {
            payload.getCategoryAttrGroupRefList().forEach(attrGroupRefPayload -> list.add(this.insert((ProductCategoryAttrGroupRefPayload)attrGroupRefPayload)));
        }
        return list;
    }

    private void check(ProductCategoryAttrGroupRefPayload payload) {
        Long categoryId = payload.getCategoryId();
        if (null == categoryId) {
            throw TwException.error("", "categoryId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long groupId = payload.getGroupId();
        if (null == groupId) {
            throw TwException.error("", "groupId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List details = payload.getDetails();
        if (!CollectionUtils.isEmpty((Collection)details)) {
            Set attrIdList = details.stream().map(ProductCategoryAttrGroupDetailRefPayload::getAttributeId).collect(Collectors.toSet());
            if (CollectionUtils.isEmpty(attrIdList)) {
                throw TwException.error("", "details->attributeId\u53c2\u6570\u7f3a\u5931");
            }
            ProductCategoryColumnRefQuery categoryColumnRefQuery = new ProductCategoryColumnRefQuery();
            categoryColumnRefQuery.setCategoryId(categoryId);
            categoryColumnRefQuery.setColumnIdList(attrIdList);
            List<ProductCategoryColumnRefVO> categoryColumnRefVOList = this.productCategoryColumnRefDAO.queryListDynamic(categoryColumnRefQuery);
            if (!CollectionUtils.isEmpty(categoryColumnRefVOList)) {
                String collect = categoryColumnRefVOList.stream().map(ProductCategoryColumnRefVO::getAttributeDesc).collect(Collectors.joining("\u3001"));
                throw TwException.error("", "\u89c4\u683c\u5c5e\u6027\u4e2d\u5df2\u5b58\u5728\u3010" + collect + "\u3011\u5c5e\u6027\uff0c\u4e0d\u53ef\u91cd\u590d\u9009\u62e9\u3010" + payload.getGroupName() + "\u3011\uff01");
            }
            ProductCategoryAttrGroupDetailRefQuery groupDetailRefQuery = new ProductCategoryAttrGroupDetailRefQuery();
            groupDetailRefQuery.setCategoryId(categoryId);
            groupDetailRefQuery.setAttributeIdList(attrIdList);
            groupDetailRefQuery.setGroupIdNotEq(groupId);
            List<ProductCategoryAttrGroupDetailRefVO> attrGroupDetailRefVOList = this.productCategoryAttrGroupDetailRefDAO.queryListDynamic(groupDetailRefQuery);
            if (!CollectionUtils.isEmpty(attrGroupDetailRefVOList)) {
                String collect = attrGroupDetailRefVOList.stream().map(ProductCategoryAttrGroupDetailRefVO::getAttributeDesc).collect(Collectors.joining("\u3001"));
                String groupNames = attrGroupDetailRefVOList.stream().map(ProductCategoryAttrGroupDetailRefVO::getGroupName).distinct().collect(Collectors.joining("\u3001"));
                throw TwException.error("", "\u540c\u7ea7\u62d3\u5c55\u5c5e\u6027\u7ec4\u3010" + groupNames + "\u3011\u4e2d\u5df2\u5b58\u5728\u3010" + collect + "\u3011\u5c5e\u6027\uff0c\u4e0d\u53ef\u91cd\u590d\u9009\u62e9\u3010" + payload.getGroupName() + "\u3011\uff01");
            }
        }
    }

    private void dataProcess(ProductCategoryAttrGroupRefPayload payload) {
        if (!StringUtils.hasText((String)payload.getCategoryName())) {
            ProductCategoryVO categoryVO = this.productCategoryDAO.queryByKey(payload.getCategoryId());
            Assert.notNull((Object)categoryVO, (String)"\u5206\u7c7b\u4e0d\u5b58\u5728");
            payload.setCategoryName(categoryVO.getObjName());
        }
        if (!StringUtils.hasText((String)payload.getGroupName())) {
            CrmBusinessAttributeGroupVO crmBusinessAttributeGroupVO = this.crmBusinessAttributeGroupDAO.queryByKey(payload.getGroupId());
            Assert.notNull((Object)crmBusinessAttributeGroupVO, (String)"\u5c5e\u6027\u7ec4\u4e0d\u5b58\u5728");
            payload.setGroupName(crmBusinessAttributeGroupVO.getGroupName());
        }
        if (payload.getSortNo() == null) {
            payload.setSortNo(Integer.valueOf(0));
        }
        if (payload.getSortNoSelf() == null) {
            payload.setSortNoSelf(Integer.valueOf(0));
        }
    }

    private void insertDetails(ProductCategoryAttrGroupRefPayload payload, Long groupRefId, Long categoryId, Long groupId) {
        List details = payload.getDetails();
        String groupName = payload.getGroupName();
        if (!CollectionUtils.isEmpty((Collection)details)) {
            details.forEach(detailRefPayload -> {
                detailRefPayload.setGroupRefId(groupRefId);
                detailRefPayload.setCategoryId(categoryId);
                detailRefPayload.setCategoryName(payload.getCategoryName());
                detailRefPayload.setGroupId(groupId);
                detailRefPayload.setGroupName(groupName);
                Long attributeId = detailRefPayload.getAttributeId();
                CrmBusinessTableColumnsVO columnsVO = this.crmBusinessTableColumnsDAO.findByKey(attributeId);
                Assert.notNull((Object)columnsVO, (String)"\u5c5e\u6027\u4e0d\u5b58\u5728");
                if (ObjectUtils.isEmpty((Object)detailRefPayload.getColumnName())) {
                    detailRefPayload.setColumnName(columnsVO.getColumnName());
                }
                if (ObjectUtils.isEmpty((Object)detailRefPayload.getColumnDesc())) {
                    detailRefPayload.setColumnDesc(columnsVO.getColumnDesc());
                }
                if (ObjectUtils.isEmpty((Object)detailRefPayload.getAttributeDesc())) {
                    detailRefPayload.setAttributeDesc(columnsVO.getAttributeDesc());
                }
                if (ObjectUtils.isEmpty((Object)detailRefPayload.getAttributeType())) {
                    detailRefPayload.setAttributeType(columnsVO.getAttributeType());
                }
                if (ObjectUtils.isEmpty((Object)detailRefPayload.getComponentType())) {
                    detailRefPayload.setComponentType(columnsVO.getComponentType());
                }
                if (ObjectUtils.isEmpty((Object)detailRefPayload.getAttributeScope())) {
                    detailRefPayload.setAttributeScope(columnsVO.getAttributeScope());
                }
                if (ObjectUtils.isEmpty((Object)detailRefPayload.getAttributePrompt())) {
                    detailRefPayload.setAttributePrompt(columnsVO.getAttributePrompt());
                }
                if (ObjectUtils.isEmpty((Object)detailRefPayload.getSelectionCode())) {
                    detailRefPayload.setSelectionCode(columnsVO.getSelectionCode());
                }
                if (ObjectUtils.isEmpty((Object)detailRefPayload.getIsMultiple())) {
                    detailRefPayload.setIsMultiple(columnsVO.getIsMultiple());
                }
                if (ObjectUtils.isEmpty((Object)detailRefPayload.getSortNo())) {
                    if (columnsVO.getSortNo() == null) {
                        columnsVO.setSortNo(Integer.valueOf(0));
                    }
                    detailRefPayload.setSortNo(Integer.valueOf(columnsVO.getSortNo() != null ? columnsVO.getSortNo() : 0));
                }
                if (ObjectUtils.isEmpty((Object)detailRefPayload.getSortNoSelf())) {
                    detailRefPayload.setSortNoSelf(columnsVO.getSortNo());
                }
                this.productCategoryAttrGroupDetailRefService.insert(detailRefPayload);
            });
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.productCategoryAttrGroupRefRepo.findById(id);
                if (!optional.isEmpty()) {
                    ProductCategoryAttrGroupRefDO entity = (ProductCategoryAttrGroupRefDO)optional.get();
                    Long categoryId = entity.getCategoryId();
                    ProductSpuQuery spuQuery = new ProductSpuQuery();
                    spuQuery.setCategoryId(categoryId);
                    spuQuery.setPermissionFlag(Boolean.valueOf(false));
                    long spuCount = this.productSpuDAO.count(spuQuery);
                    ProductSkuQuery skuQuery = new ProductSkuQuery();
                    skuQuery.setCategoryId(categoryId);
                    long skuCount = this.productSkuDAO.count(skuQuery);
                    if (spuCount > 0L || skuCount > 0L) {
                        throw TwException.error("", "\u8be5\u5c5e\u6027\u7ec4\u6b63\u88ab\u4f7f\u7528\uff0c\u65e0\u6cd5\u5220\u9664");
                    }
                    entity.setDeleteFlag(1);
                    this.productCategoryAttrGroupRefRepo.save(entity);
                    this.productCategoryAttrGroupDetailRefDAO.deleteSoftByGroupRefId(entity.getId());
                }
            });
        }
    }

    public ProductCategoryAttrGroupRefServiceImpl(ProductCategoryAttrGroupRefRepo productCategoryAttrGroupRefRepo, ProductCategoryAttrGroupDetailRefService productCategoryAttrGroupDetailRefService, ProductCategoryAttrGroupDetailRefDAO productCategoryAttrGroupDetailRefDAO, ProductCategoryColumnRefDAO productCategoryColumnRefDAO, CrmBusinessAttributeGroupDAO crmBusinessAttributeGroupDAO, CrmBusinessAttributeGroupDetailDAO crmBusinessAttributeGroupDetailDAO, CrmBusinessTableColumnsDAO crmBusinessTableColumnsDAO, ProductCategoryDAO productCategoryDAO, ProductSpuDAO productSpuDAO, ProductSkuDAO productSkuDAO) {
        this.productCategoryAttrGroupRefRepo = productCategoryAttrGroupRefRepo;
        this.productCategoryAttrGroupDetailRefService = productCategoryAttrGroupDetailRefService;
        this.productCategoryAttrGroupDetailRefDAO = productCategoryAttrGroupDetailRefDAO;
        this.productCategoryColumnRefDAO = productCategoryColumnRefDAO;
        this.crmBusinessAttributeGroupDAO = crmBusinessAttributeGroupDAO;
        this.crmBusinessAttributeGroupDetailDAO = crmBusinessAttributeGroupDetailDAO;
        this.crmBusinessTableColumnsDAO = crmBusinessTableColumnsDAO;
        this.productCategoryDAO = productCategoryDAO;
        this.productSpuDAO = productSpuDAO;
        this.productSkuDAO = productSkuDAO;
    }
}

