/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.product.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5crm.api.product.payload.ProductCategoryColumnRefListPayload;
import com.elitesland.tw.tw5crm.api.product.payload.ProductCategoryColumnRefPayload;
import com.elitesland.tw.tw5crm.api.product.query.CrmBusinessAttributeGroupDetailQuery;
import com.elitesland.tw.tw5crm.api.product.query.ProductCategoryAttrGroupRefQuery;
import com.elitesland.tw.tw5crm.api.product.query.ProductCategoryColumnRefQuery;
import com.elitesland.tw.tw5crm.api.product.query.ProductSkuQuery;
import com.elitesland.tw.tw5crm.api.product.query.ProductSpuQuery;
import com.elitesland.tw.tw5crm.api.product.service.ProductCategoryColumnRefService;
import com.elitesland.tw.tw5crm.api.product.vo.CrmBusinessAttributeGroupDetailVO;
import com.elitesland.tw.tw5crm.api.product.vo.CrmBusinessTableColumnsVO;
import com.elitesland.tw.tw5crm.api.product.vo.ProductCategoryAttrGroupRefVO;
import com.elitesland.tw.tw5crm.api.product.vo.ProductCategoryColumnRefVO;
import com.elitesland.tw.tw5crm.api.product.vo.ProductCategoryVO;
import com.elitesland.tw.tw5crm.server.product.convert.ProductCategoryColumnRefConvert;
import com.elitesland.tw.tw5crm.server.product.dao.CrmBusinessAttributeGroupDetailDAO;
import com.elitesland.tw.tw5crm.server.product.dao.CrmBusinessTableColumnsDAO;
import com.elitesland.tw.tw5crm.server.product.dao.ProductCategoryAttrGroupRefDAO;
import com.elitesland.tw.tw5crm.server.product.dao.ProductCategoryColumnRefDAO;
import com.elitesland.tw.tw5crm.server.product.dao.ProductCategoryDAO;
import com.elitesland.tw.tw5crm.server.product.dao.ProductSkuDAO;
import com.elitesland.tw.tw5crm.server.product.dao.ProductSpuDAO;
import com.elitesland.tw.tw5crm.server.product.entity.ProductCategoryColumnRefDO;
import com.elitesland.tw.tw5crm.server.product.repo.ProductCategoryColumnRefRepo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class ProductCategoryColumnRefServiceImpl
implements ProductCategoryColumnRefService {
    private static final Logger log = LoggerFactory.getLogger(ProductCategoryColumnRefServiceImpl.class);
    private final ProductCategoryColumnRefRepo productCategoryColumnRefRepo;
    private final ProductCategoryAttrGroupRefDAO productCategoryAttrGroupRefDAO;
    private final ProductCategoryDAO productCategoryDAO;
    private final ProductCategoryColumnRefDAO productCategoryColumnRefDAO;
    private final CrmBusinessAttributeGroupDetailDAO crmBusinessAttributeGroupDetailDAO;
    private final CrmBusinessTableColumnsDAO crmBusinessTableColumnsDAO;
    private final ProductSpuDAO productSpuDAO;
    private final ProductSkuDAO productSkuDAO;

    public PagingVO<ProductCategoryColumnRefVO> paging(ProductCategoryColumnRefQuery query) {
        return this.productCategoryColumnRefDAO.queryPaging(query);
    }

    public List<ProductCategoryColumnRefVO> queryList(ProductCategoryColumnRefQuery query) {
        return this.productCategoryColumnRefDAO.queryListDynamic(query);
    }

    public ProductCategoryColumnRefVO queryByKey(Long key) {
        ProductCategoryColumnRefDO entity = this.productCategoryColumnRefRepo.findById(key).orElseGet(ProductCategoryColumnRefDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        ProductCategoryColumnRefVO vo = ProductCategoryColumnRefConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public ProductCategoryColumnRefVO insert(ProductCategoryColumnRefPayload payload) {
        this.check(payload);
        this.dataProcess(payload);
        ProductCategoryColumnRefDO entityDo = ProductCategoryColumnRefConvert.INSTANCE.toDo(payload);
        return ProductCategoryColumnRefConvert.INSTANCE.toVo((ProductCategoryColumnRefDO)this.productCategoryColumnRefRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public List<ProductCategoryColumnRefVO> batchSaveOrUpdate(ProductCategoryColumnRefListPayload payload) {
        if (!CollectionUtils.isEmpty((Collection)payload.getDeleteIdList())) {
            this.deleteSoft(payload.getDeleteIdList());
        }
        ArrayList<ProductCategoryColumnRefVO> list = new ArrayList<ProductCategoryColumnRefVO>();
        if (!CollectionUtils.isEmpty((Collection)payload.getCategoryColumnRefList())) {
            payload.getCategoryColumnRefList().forEach(productCategoryColumnRefPayload -> list.add(this.insert((ProductCategoryColumnRefPayload)productCategoryColumnRefPayload)));
        }
        return list;
    }

    private void check(ProductCategoryColumnRefPayload payload) {
        Long categoryId = payload.getCategoryId();
        if (null == categoryId) {
            throw TwException.error("", "categoryId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long columnId = payload.getColumnId();
        if (null == columnId) {
            throw TwException.error("", "columnId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ProductCategoryAttrGroupRefQuery attrGroupRefQuery = new ProductCategoryAttrGroupRefQuery();
        attrGroupRefQuery.setCategoryId(categoryId);
        List<ProductCategoryAttrGroupRefVO> attrGroupRefVOList = this.productCategoryAttrGroupRefDAO.queryListDynamic(attrGroupRefQuery);
        if (!CollectionUtils.isEmpty(attrGroupRefVOList)) {
            List groupIds = attrGroupRefVOList.stream().map(ProductCategoryAttrGroupRefVO::getGroupId).distinct().collect(Collectors.toList());
            String groupNames = attrGroupRefVOList.stream().map(ProductCategoryAttrGroupRefVO::getGroupName).collect(Collectors.joining("\u3001"));
            CrmBusinessAttributeGroupDetailQuery groupDetailQuery = new CrmBusinessAttributeGroupDetailQuery();
            groupDetailQuery.setGroupIdList(groupIds);
            groupDetailQuery.setAttributeId(columnId);
            List<CrmBusinessAttributeGroupDetailVO> attributeGroupDetailVOList = this.crmBusinessAttributeGroupDetailDAO.queryListJoinDynamic(groupDetailQuery);
            if (!CollectionUtils.isEmpty(attributeGroupDetailVOList)) {
                String attrsDesc = attributeGroupDetailVOList.stream().map(CrmBusinessAttributeGroupDetailVO::getAttributeDesc).distinct().collect(Collectors.joining("\u3001"));
                throw TwException.error("", "\u6269\u5c55\u5c5e\u6027\u7ec4\u3010" + groupNames + "\u3011\u4e2d\u5df2\u5b58\u5728\u8be5\u5c5e\u6027\u3010" + attrsDesc + "\u3011\uff0c\u4e0d\u53ef\u91cd\u590d\u9009\u62e9\uff01");
            }
        }
    }

    private void dataProcess(ProductCategoryColumnRefPayload payload) {
        if (null == payload.getStatus()) {
            payload.setStatus(Integer.valueOf(0));
        }
        ProductCategoryVO categoryVO = this.productCategoryDAO.queryByKey(payload.getCategoryId());
        Assert.notNull((Object)categoryVO, (String)"\u5206\u7c7b\u4e0d\u5b58\u5728");
        payload.setCategoryName(categoryVO.getObjName());
        CrmBusinessTableColumnsVO columnsVO = this.crmBusinessTableColumnsDAO.findByKey(payload.getColumnId());
        Assert.notNull((Object)columnsVO, (String)"\u5c5e\u6027\u4e0d\u5b58\u5728");
        payload.setColumnName(columnsVO.getColumnName());
        payload.setColumnDesc(columnsVO.getColumnDesc());
        payload.setAttributeDesc(columnsVO.getAttributeDesc());
        payload.setAttributeType(columnsVO.getAttributeType());
        payload.setComponentType(columnsVO.getComponentType());
        payload.setAttributeScope(columnsVO.getAttributeScope());
        payload.setAttributePrompt(columnsVO.getAttributePrompt());
        payload.setSelectionCode(columnsVO.getSelectionCode());
        payload.setIsMultiple(columnsVO.getIsMultiple());
        if (columnsVO.getSortNo() == null) {
            columnsVO.setSortNo(Integer.valueOf(0));
        }
        payload.setSortNo(columnsVO.getSortNo());
        if (payload.getSortNoSelf() == null) {
            payload.setSortNoSelf(columnsVO.getSortNo());
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public ProductCategoryColumnRefVO update(ProductCategoryColumnRefPayload payload) {
        ProductCategoryColumnRefDO entity = this.productCategoryColumnRefRepo.findById(payload.getId()).orElseGet(ProductCategoryColumnRefDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        ProductCategoryColumnRefDO entityDo = ProductCategoryColumnRefConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return ProductCategoryColumnRefConvert.INSTANCE.toVo((ProductCategoryColumnRefDO)this.productCategoryColumnRefRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.productCategoryColumnRefRepo.findById(id);
                if (!optional.isEmpty()) {
                    ProductCategoryColumnRefDO entity = (ProductCategoryColumnRefDO)optional.get();
                    Long categoryId = entity.getCategoryId();
                    ProductSpuQuery spuQuery = new ProductSpuQuery();
                    spuQuery.setPermissionFlag(Boolean.valueOf(false));
                    spuQuery.setCategoryId(categoryId);
                    long spuCount = this.productSpuDAO.count(spuQuery);
                    ProductSkuQuery skuQuery = new ProductSkuQuery();
                    skuQuery.setCategoryId(categoryId);
                    long skuCount = this.productSkuDAO.count(skuQuery);
                    if (spuCount > 0L || skuCount > 0L) {
                        throw TwException.error("", "\u8be5\u5c5e\u6027\u6b63\u88ab\u4f7f\u7528\uff0c\u65e0\u6cd5\u5220\u9664");
                    }
                    entity.setDeleteFlag(1);
                    this.productCategoryColumnRefRepo.save(entity);
                }
            });
        }
    }

    public ProductCategoryColumnRefServiceImpl(ProductCategoryColumnRefRepo productCategoryColumnRefRepo, ProductCategoryAttrGroupRefDAO productCategoryAttrGroupRefDAO, ProductCategoryDAO productCategoryDAO, ProductCategoryColumnRefDAO productCategoryColumnRefDAO, CrmBusinessAttributeGroupDetailDAO crmBusinessAttributeGroupDetailDAO, CrmBusinessTableColumnsDAO crmBusinessTableColumnsDAO, ProductSpuDAO productSpuDAO, ProductSkuDAO productSkuDAO) {
        this.productCategoryColumnRefRepo = productCategoryColumnRefRepo;
        this.productCategoryAttrGroupRefDAO = productCategoryAttrGroupRefDAO;
        this.productCategoryDAO = productCategoryDAO;
        this.productCategoryColumnRefDAO = productCategoryColumnRefDAO;
        this.crmBusinessAttributeGroupDetailDAO = crmBusinessAttributeGroupDetailDAO;
        this.crmBusinessTableColumnsDAO = crmBusinessTableColumnsDAO;
        this.productSpuDAO = productSpuDAO;
        this.productSkuDAO = productSkuDAO;
    }
}

