/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.product.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5crm.api.product.dto.ProductAttrGroupJsonDTO;
import com.elitesland.tw.tw5crm.api.product.dto.ProductAttrJsonDTO;
import com.elitesland.tw.tw5crm.api.product.payload.ProductCategoryPayload;
import com.elitesland.tw.tw5crm.api.product.query.CrmBusinessTableColumnsQuery;
import com.elitesland.tw.tw5crm.api.product.query.ProductCategoryAttrGroupDetailRefQuery;
import com.elitesland.tw.tw5crm.api.product.query.ProductCategoryAttrGroupRefQuery;
import com.elitesland.tw.tw5crm.api.product.query.ProductCategoryColumnRefQuery;
import com.elitesland.tw.tw5crm.api.product.query.ProductCategoryQuery;
import com.elitesland.tw.tw5crm.api.product.query.ProductSkuQuery;
import com.elitesland.tw.tw5crm.api.product.query.ProductSpuQuery;
import com.elitesland.tw.tw5crm.api.product.service.ProductCategoryService;
import com.elitesland.tw.tw5crm.api.product.vo.CrmBusinessAttributeGroupDetailVO;
import com.elitesland.tw.tw5crm.api.product.vo.CrmBusinessTableColumnsVO;
import com.elitesland.tw.tw5crm.api.product.vo.ProductCategoryAttrGroupDetailRefVO;
import com.elitesland.tw.tw5crm.api.product.vo.ProductCategoryAttrGroupRefVO;
import com.elitesland.tw.tw5crm.api.product.vo.ProductCategoryAttrsAndAttrGroupsVO;
import com.elitesland.tw.tw5crm.api.product.vo.ProductCategoryColumnRefVO;
import com.elitesland.tw.tw5crm.api.product.vo.ProductCategoryVO;
import com.elitesland.tw.tw5crm.server.common.constants.ProductComponentType;
import com.elitesland.tw.tw5crm.server.product.convert.ProductCategoryConvert;
import com.elitesland.tw.tw5crm.server.product.dao.CrmBusinessAttributeGroupDetailDAO;
import com.elitesland.tw.tw5crm.server.product.dao.CrmBusinessTableColumnsDAO;
import com.elitesland.tw.tw5crm.server.product.dao.ProductCategoryAttrGroupDetailRefDAO;
import com.elitesland.tw.tw5crm.server.product.dao.ProductCategoryAttrGroupRefDAO;
import com.elitesland.tw.tw5crm.server.product.dao.ProductCategoryColumnRefDAO;
import com.elitesland.tw.tw5crm.server.product.dao.ProductCategoryDAO;
import com.elitesland.tw.tw5crm.server.product.dao.ProductSkuDAO;
import com.elitesland.tw.tw5crm.server.product.dao.ProductSpuDAO;
import com.elitesland.tw.tw5crm.server.product.entity.ProductCategoryDO;
import com.elitesland.tw.tw5crm.server.product.repo.ProductCategoryRepo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
public class ProductCategoryServiceImpl
extends BaseServiceImpl
implements ProductCategoryService {
    private static final Logger log = LoggerFactory.getLogger(ProductCategoryServiceImpl.class);
    private static final String TABLE_NAME = "crm_business_table_columns";
    private final ProductCategoryRepo productCategoryRepo;
    private final ProductCategoryDAO productCategoryDAO;
    private final CrmBusinessTableColumnsDAO crmBusinessTableColumnsDAO;
    private final ProductCategoryAttrGroupRefDAO productCategoryAttrGroupRefDAO;
    private final ProductCategoryColumnRefDAO productCategoryColumnRefDAO;
    private final CrmBusinessAttributeGroupDetailDAO crmBusinessAttributeGroupDetailDAO;
    private final ProductCategoryAttrGroupDetailRefDAO productCategoryAttrGroupDetailRefDAO;
    private final ProductSpuDAO productSpuDAO;
    private final ProductSkuDAO productSkuDAO;

    public PagingVO<ProductCategoryVO> paging(ProductCategoryQuery query) {
        Page page = this.productCategoryRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), (Pageable)query.getPageRequest());
        return PageUtil.toPageVo(page.map(ProductCategoryConvert.INSTANCE::toVo));
    }

    public List<ProductCategoryVO> queryList(ProductCategoryQuery query) {
        return ProductCategoryConvert.INSTANCE.toVoList(this.productCategoryRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder)));
    }

    public ProductCategoryVO queryByKey(Long key) {
        ProductCategoryDO entity = this.productCategoryRepo.findById(key).orElseGet(ProductCategoryDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        ProductCategoryVO vo = ProductCategoryConvert.INSTANCE.toVo(entity);
        return vo;
    }

    public List<ProductAttrJsonDTO> getAttrs() {
        List<ProductAttrJsonDTO> attrJsonDTOList = this.attrJsonBuildByTableColumns();
        return attrJsonDTOList;
    }

    private List<ProductAttrJsonDTO> attrJsonBuildByTableColumns() {
        ArrayList<ProductAttrJsonDTO> attrJsonDTOList = new ArrayList<ProductAttrJsonDTO>();
        CrmBusinessTableColumnsQuery crmBusinessTableColumnsQuery = new CrmBusinessTableColumnsQuery();
        crmBusinessTableColumnsQuery.setComponentType(ProductComponentType.SELECT.getCode());
        crmBusinessTableColumnsQuery.setIsMultiple(Integer.valueOf(1));
        crmBusinessTableColumnsQuery.setStatus(Integer.valueOf(1));
        crmBusinessTableColumnsQuery.setTableName(TABLE_NAME);
        List<CrmBusinessTableColumnsVO> crmBusinessTableColumnsVOS = this.crmBusinessTableColumnsDAO.queryListDynamic(crmBusinessTableColumnsQuery);
        crmBusinessTableColumnsVOS.forEach(columnRef -> {
            ProductAttrJsonDTO attrJson = ProductAttrJsonDTO.builder().attrId("" + columnRef.getId()).attrKey(columnRef.getColumnName()).attrDesc(columnRef.getAttributeDesc()).attrType(columnRef.getAttributeType()).selectionCode(columnRef.getSelectionCode()).sortNo(columnRef.getSortNo()).sortNoSelf(columnRef.getSortNo()).isMultiple(columnRef.getIsMultiple()).componentType(columnRef.getComponentType()).build();
            attrJsonDTOList.add(attrJson);
        });
        return attrJsonDTOList;
    }

    public ProductCategoryAttrsAndAttrGroupsVO getAttrsAndAttrGroups(Long key) {
        ProductCategoryDO entity = this.productCategoryRepo.findById(key).orElseGet(ProductCategoryDO::new);
        Long categoryId = entity.getId();
        Assert.notNull((Object)categoryId, (String)"\u4ea7\u54c1\u5206\u7c7b\u4e0d\u5b58\u5728");
        ProductCategoryAttrsAndAttrGroupsVO resultVo = ProductCategoryConvert.INSTANCE.toVoAttrsAndAttrGroups(entity);
        List<ProductAttrGroupJsonDTO> attrGroupJson = this.attrGroupsBuild(categoryId);
        resultVo.setGroups(attrGroupJson);
        List<ProductAttrJsonDTO> attrJsonDTOList = this.attrJsonBuild(categoryId);
        resultVo.setAttrs(attrJsonDTOList);
        return resultVo;
    }

    @NotNull
    private List<ProductAttrJsonDTO> attrJsonBuild(Long categoryId) {
        ArrayList<ProductAttrJsonDTO> attrJsonDTOList = new ArrayList<ProductAttrJsonDTO>();
        ProductCategoryColumnRefQuery columnRefQuery = new ProductCategoryColumnRefQuery();
        columnRefQuery.setCategoryId(categoryId);
        List<ProductCategoryColumnRefVO> categoryColumnRefVOList = this.productCategoryColumnRefDAO.queryListDynamic(columnRefQuery);
        categoryColumnRefVOList.forEach(columnRef -> {
            CrmBusinessTableColumnsVO tableColumnsVO = this.crmBusinessTableColumnsDAO.findByKey(columnRef.getColumnId());
            ProductAttrJsonDTO attrJson = ProductAttrJsonDTO.builder().attrId("" + columnRef.getColumnId()).attrKey(tableColumnsVO.getColumnName()).attrDesc(tableColumnsVO.getAttributeDesc()).attrType(tableColumnsVO.getAttributeType()).selectionCode(tableColumnsVO.getSelectionCode()).sortNo(tableColumnsVO.getSortNo()).sortNoSelf(tableColumnsVO.getSortNo()).isMultiple(tableColumnsVO.getIsMultiple()).componentType(tableColumnsVO.getComponentType()).build();
            attrJsonDTOList.add(attrJson);
        });
        return attrJsonDTOList;
    }

    private List<ProductAttrGroupJsonDTO> attrGroupsBuild(Long categoryId) {
        ArrayList<ProductAttrGroupJsonDTO> groups = new ArrayList<ProductAttrGroupJsonDTO>();
        ProductCategoryAttrGroupRefQuery attrGroupRefQuery = new ProductCategoryAttrGroupRefQuery();
        attrGroupRefQuery.setCategoryId(categoryId);
        List<ProductCategoryAttrGroupRefVO> productCategoryAttrGroupRefVOS = this.productCategoryAttrGroupRefDAO.queryListDynamic(attrGroupRefQuery);
        productCategoryAttrGroupRefVOS.forEach(groupRef -> {
            Long groupId = groupRef.getGroupId();
            ArrayList<ProductAttrJsonDTO> attrValueList = new ArrayList<ProductAttrJsonDTO>();
            this.dynamicGetAttrInfo(groupId, attrValueList);
            ProductAttrGroupJsonDTO groupJson = ProductAttrGroupJsonDTO.builder().groupId("" + groupId).groupName(groupRef.getGroupName()).sort(groupRef.getSortNo()).sortSelf(groupRef.getSortNoSelf()).attrList(attrValueList).build();
            groups.add(groupJson);
        });
        return groups;
    }

    private void redundanceGetAttrInfo(Long groupRefId, List<ProductAttrJsonDTO> attrValueList) {
        ProductCategoryAttrGroupDetailRefQuery groupDetailRefQuery = new ProductCategoryAttrGroupDetailRefQuery();
        groupDetailRefQuery.setGroupRefId(groupRefId);
        List<ProductCategoryAttrGroupDetailRefVO> attrGroupDetailRefVOS = this.productCategoryAttrGroupDetailRefDAO.queryListDynamic(groupDetailRefQuery);
        attrGroupDetailRefVOS.forEach(groupDetailRef -> {
            ProductAttrJsonDTO attrJson = ProductAttrJsonDTO.builder().attrId("" + groupDetailRef.getAttributeId()).attrKey(groupDetailRef.getColumnName()).attrDesc(groupDetailRef.getAttributeDesc()).attrType(groupDetailRef.getAttributeType()).selectionCode(groupDetailRef.getSelectionCode()).sortNo(groupDetailRef.getSortNo()).sortNoSelf(groupDetailRef.getSortNoSelf()).isMultiple(groupDetailRef.getIsMultiple()).componentType(groupDetailRef.getComponentType()).unitClass(groupDetailRef.getUnitClass()).isRequired(groupDetailRef.getIsRequired()).build();
            attrValueList.add(attrJson);
        });
    }

    private void dynamicGetAttrInfo(Long groupId, List<ProductAttrJsonDTO> attrValueList) {
        List<CrmBusinessAttributeGroupDetailVO> crmBusinessAttributeGroupDetailVOS = this.crmBusinessAttributeGroupDetailDAO.queryByGroupId(groupId);
        crmBusinessAttributeGroupDetailVOS.forEach(attr -> {
            ProductAttrJsonDTO attrJson = ProductAttrJsonDTO.builder().attrId("" + attr.getAttributeId()).attrKey(attr.getColumnName()).attrDesc(attr.getAttributeDesc()).attrType(attr.getAttributeType()).selectionCode(attr.getSelectionCode()).sortNo(attr.getSortNo()).isMultiple(attr.getIsMultiple()).componentType(attr.getComponentType()).unitClass(attr.getUnitClass()).isRequired(attr.getIsRequired()).build();
            attrValueList.add(attrJson);
        });
    }

    @Transactional(rollbackFor={Exception.class})
    public ProductCategoryVO insert(ProductCategoryPayload payload) {
        this.check(payload);
        this.checkUnique(null, payload.getObjName());
        String code = this.generateSeqNum("CRM_PRODUCT_CATEGORY_NO", new String[0]);
        payload.setObjNo(code);
        if (null != payload.getParentId() && payload.getParentId().equals(0L)) {
            payload.setParentId(null);
        }
        if (null == payload.getStatus()) {
            payload.setStatus(Integer.valueOf(0));
        }
        ProductCategoryDO entityDo = ProductCategoryConvert.INSTANCE.toDo(payload);
        ProductCategoryDO save = (ProductCategoryDO)this.productCategoryRepo.save(entityDo);
        entityDo.setSubCount(0);
        this.updateSubCnt(entityDo.getParentId());
        return ProductCategoryConvert.INSTANCE.toVo(save);
    }

    private void check(ProductCategoryPayload payload) {
        if (!StringUtils.hasText((String)payload.getObjName())) {
            throw TwException.error("", "\u8bf7\u8f93\u5165\u5206\u7c7b\u540d\u79f0");
        }
    }

    private void updateSubCnt(Long pid) {
        if (pid != null) {
            int count = this.productCategoryRepo.countByParentId(pid);
            this.productCategoryRepo.updateSubCntById(count, pid);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public ProductCategoryVO update(ProductCategoryPayload payload) {
        ProductCategoryDO entity = this.productCategoryRepo.findById(payload.getId()).orElseGet(ProductCategoryDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        if (payload.getId().equals(payload.getParentId())) {
            throw TwException.error("", "\u4e0a\u7ea7\u4e0d\u80fd\u4e3a\u81ea\u5df1");
        }
        Long oldPid = entity.getParentId();
        Long newPid = payload.getParentId();
        ProductCategoryDO entityDo = ProductCategoryConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        ProductCategoryDO save = (ProductCategoryDO)this.productCategoryRepo.save(entity);
        this.updateSubCnt(oldPid);
        this.updateSubCnt(newPid);
        return ProductCategoryConvert.INSTANCE.toVo(save);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                Optional optional = this.productCategoryRepo.findById(id);
                if (!optional.isEmpty()) {
                    ProductSpuQuery spuQuery = new ProductSpuQuery();
                    spuQuery.setCategoryId(id);
                    spuQuery.setPermissionFlag(Boolean.valueOf(false));
                    long spuCount = this.productSpuDAO.count(spuQuery);
                    ProductSkuQuery skuQuery = new ProductSkuQuery();
                    skuQuery.setCategoryId(id);
                    long skuCount = this.productSkuDAO.count(skuQuery);
                    if (spuCount > 0L || skuCount > 0L) {
                        throw TwException.error("", "\u8be5\u5206\u7c7b\u6b63\u88ab\u4f7f\u7528\uff0c\u65e0\u6cd5\u5220\u9664");
                    }
                    ProductCategoryDO entity = (ProductCategoryDO)optional.get();
                    entity.setDeleteFlag(1);
                    this.productCategoryRepo.save(entity);
                }
            });
        }
    }

    public List<ProductCategoryVO> queryAllCategory(Long pid) {
        List<ProductCategoryDO> categoryDOList = pid != null && !pid.equals(0L) ? this.productCategoryRepo.findByParentId(pid) : this.productCategoryRepo.findByParentIdIsNull();
        return ProductCategoryConvert.INSTANCE.toVoList(categoryDOList);
    }

    public List<ProductCategoryVO> buildTree(List<ProductCategoryVO> categoryVOList) {
        List<Object> trees = new ArrayList<ProductCategoryVO>();
        HashSet<Long> ids = new HashSet<Long>();
        for (ProductCategoryVO categoryDTO : categoryVOList) {
            if (categoryDTO.getParentId() == null) {
                trees.add(categoryDTO);
            }
            for (ProductCategoryVO it : categoryVOList) {
                if (!categoryDTO.getId().equals(it.getParentId())) continue;
                if (categoryDTO.getChildren() == null) {
                    categoryDTO.setChildren(new ArrayList());
                }
                categoryDTO.getChildren().add(it);
                ids.add(it.getId());
            }
        }
        if (trees.size() == 0) {
            trees = categoryVOList.stream().filter(s -> !ids.contains(s.getId())).collect(Collectors.toList());
        }
        return trees;
    }

    public List<ProductCategoryVO> tree() {
        ProductCategoryQuery query = new ProductCategoryQuery();
        List<ProductCategoryVO> categoryVOList = this.queryList(query);
        List<ProductCategoryVO> tree = this.buildTree(categoryVOList);
        return tree;
    }

    public long checkUnique(Long id, String objName) {
        ProductCategoryQuery categoryQuery = new ProductCategoryQuery();
        categoryQuery.setIdNotEq(id);
        categoryQuery.setObjNameEq(objName);
        long count = this.productCategoryDAO.count(categoryQuery);
        if (count > 0L) {
            throw TwException.error("", "\u5b58\u5728\u76f8\u540c\u4ea7\u54c1\u540d\u79f0");
        }
        return count;
    }

    public ProductCategoryServiceImpl(ProductCategoryRepo productCategoryRepo, ProductCategoryDAO productCategoryDAO, CrmBusinessTableColumnsDAO crmBusinessTableColumnsDAO, ProductCategoryAttrGroupRefDAO productCategoryAttrGroupRefDAO, ProductCategoryColumnRefDAO productCategoryColumnRefDAO, CrmBusinessAttributeGroupDetailDAO crmBusinessAttributeGroupDetailDAO, ProductCategoryAttrGroupDetailRefDAO productCategoryAttrGroupDetailRefDAO, ProductSpuDAO productSpuDAO, ProductSkuDAO productSkuDAO) {
        this.productCategoryRepo = productCategoryRepo;
        this.productCategoryDAO = productCategoryDAO;
        this.crmBusinessTableColumnsDAO = crmBusinessTableColumnsDAO;
        this.productCategoryAttrGroupRefDAO = productCategoryAttrGroupRefDAO;
        this.productCategoryColumnRefDAO = productCategoryColumnRefDAO;
        this.crmBusinessAttributeGroupDetailDAO = crmBusinessAttributeGroupDetailDAO;
        this.productCategoryAttrGroupDetailRefDAO = productCategoryAttrGroupDetailRefDAO;
        this.productSpuDAO = productSpuDAO;
        this.productSkuDAO = productSkuDAO;
    }
}

