/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.product.service;

import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.common.base.BaseViewModel;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.common.TwWorkFlowCommonVO;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemSelectionVO;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.common.workFlow.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import com.elitesland.tw.tw5crm.api.common.change.payload.ComBusinessChangePayload;
import com.elitesland.tw.tw5crm.api.common.change.service.ComBusinessChangeService;
import com.elitesland.tw.tw5crm.api.common.change.vo.ComBusinessChangeVO;
import com.elitesland.tw.tw5crm.api.product.payload.ProductPriceCustomerPayload;
import com.elitesland.tw.tw5crm.api.product.payload.ProductPriceDetailPayload;
import com.elitesland.tw.tw5crm.api.product.payload.ProductPriceOrgPayload;
import com.elitesland.tw.tw5crm.api.product.payload.ProductPricePayload;
import com.elitesland.tw.tw5crm.api.product.query.ProductPriceQuery;
import com.elitesland.tw.tw5crm.api.product.service.ProductPriceService;
import com.elitesland.tw.tw5crm.api.product.vo.ProductPriceCustomerVO;
import com.elitesland.tw.tw5crm.api.product.vo.ProductPriceDetailVO;
import com.elitesland.tw.tw5crm.api.product.vo.ProductPriceOrgVO;
import com.elitesland.tw.tw5crm.api.product.vo.ProductPriceVO;
import com.elitesland.tw.tw5crm.api.product.vo.ProductSkuVO;
import com.elitesland.tw.tw5crm.server.common.change.changeTypeEnum.ChangeTypeEnum;
import com.elitesland.tw.tw5crm.server.common.change.dao.ComBusinessChangeDAO;
import com.elitesland.tw.tw5crm.server.product.convert.ProductPriceConvert;
import com.elitesland.tw.tw5crm.server.product.convert.ProductPriceCustomerConvert;
import com.elitesland.tw.tw5crm.server.product.convert.ProductPriceDetailConvert;
import com.elitesland.tw.tw5crm.server.product.convert.ProductPriceOrgConvert;
import com.elitesland.tw.tw5crm.server.product.dao.ProductPriceDAO;
import com.elitesland.tw.tw5crm.server.product.dao.ProductPriceDetailDAO;
import com.elitesland.tw.tw5crm.server.product.dao.ProductSkuDAO;
import com.elitesland.tw.tw5crm.server.product.entity.ProductPriceCustomerDO;
import com.elitesland.tw.tw5crm.server.product.entity.ProductPriceDO;
import com.elitesland.tw.tw5crm.server.product.entity.ProductPriceDetailDO;
import com.elitesland.tw.tw5crm.server.product.entity.ProductPriceOrgDO;
import com.elitesland.tw.tw5crm.server.product.repo.ProductPriceCustomerRepo;
import com.elitesland.tw.tw5crm.server.product.repo.ProductPriceOrgRepo;
import com.elitesland.tw.tw5crm.server.product.repo.ProductPriceRepo;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.WorkflowService;
import com.elitesland.workflow.payload.CurrentTaskInfosPayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import com.google.common.collect.Lists;
import com.xxl.job.core.log.XxlJobLogger;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class ProductPriceServiceImpl
extends BaseServiceImpl
implements ProductPriceService {
    private static final Logger log = LoggerFactory.getLogger(ProductPriceServiceImpl.class);
    private final ComBusinessChangeService businessChangeService;
    private final TransactionUtilService transactionUtilService;
    private final ProductPriceRepo productPriceRepo;
    private final ProductPriceOrgRepo productPriceOrgRepo;
    private final ProductPriceCustomerRepo productPriceCustomerRepo;
    private final ProductPriceDAO productPriceDAO;
    private final ProductPriceDetailDAO detailDAO;
    private final ProductSkuDAO skuDAO;
    private final CacheUtil cacheUtil;
    private final WorkflowUtil workflowUtil;
    private final ComBusinessChangeDAO businessChangeDao;
    private final UdcUtil udcUtil;
    private final WorkflowService workflowService;
    @Value(value="${tw5.workflow.enabled:false}")
    private Boolean workflow_enabled;

    public PagingVO<ProductPriceVO> queryPaging(ProductPriceQuery query) {
        this.operPermissionFlag(query);
        PagingVO<ProductPriceVO> productPriceVOPagingVO = this.productPriceDAO.queryPaging(query);
        List priceVOs = productPriceVOPagingVO.getRecords();
        if (!ObjectUtils.isEmpty((Object)priceVOs)) {
            List<Long> priceVOIds = priceVOs.stream().map(BaseViewModel::getId).collect(Collectors.toList());
            List<ProductPriceDetailVO> productPriceDetailVOS = this.detailDAO.queryByPriceIds(priceVOIds);
            priceVOs.forEach(priceVO -> {
                List<ProductPriceDetailVO> collect = productPriceDetailVOS.stream().filter(detailVO -> detailVO.getPriceId().equals(priceVO.getId())).collect(Collectors.toList());
                collect.forEach(e -> {
                    List systemSelectionChildren;
                    PrdSystemSelectionVO prdSystemSelectionVO;
                    PrdSystemSelectionVO systemSelection = this.cacheUtil.getSystemSelection("crm:product:spu_type");
                    if (systemSelection != null && (prdSystemSelectionVO = (PrdSystemSelectionVO)(systemSelectionChildren = systemSelection.getChildren()).stream().filter(s -> s.getSelectionValue().equals(e.getSpuType())).findFirst().orElse(null)) != null) {
                        String extString1 = prdSystemSelectionVO.getExtString1();
                        e.setTaxRate(extString1);
                    }
                });
                priceVO.setPriceDetailVOs(collect);
            });
        }
        this.getTaskInfo(priceVOs);
        return productPriceVOPagingVO;
    }

    private void getTaskInfo(List<ProductPriceVO> voList) {
        Map map;
        if (!CollectionUtils.isEmpty(voList) && null != (map = voList.stream().filter(vo -> org.apache.commons.lang3.StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{vo.getProcInstId()})).collect(Collectors.toMap(TwWorkFlowCommonVO::getProcInstId, Function.identity()))) && !map.isEmpty()) {
            Set<String> procInstIds = map.keySet();
            HashSet<String> hashSet = new HashSet<String>(procInstIds);
            CurrentTaskInfosPayload currentTaskInfosPayload = new CurrentTaskInfosPayload();
            currentTaskInfosPayload.setProcInstIds(hashSet);
            WorkflowResult workflowResult = this.workflowService.currentTaskInfos(currentTaskInfosPayload);
            if (workflowResult.isSuccess()) {
                HashMap currentTaskNames = (HashMap)workflowResult.getData();
                currentTaskNames.forEach((key, value) -> {
                    TwWorkFlowCommonVO vo = (TwWorkFlowCommonVO)map.get(key);
                    vo.setTaskInfo(value);
                });
            }
        }
    }

    public List<ProductPriceVO> queryList(ProductPriceQuery query) {
        return ProductPriceConvert.INSTANCE.toVoList(this.productPriceRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), query.getPageRequest().getSort()));
    }

    public List<ProductPriceVO> queryListDynamic(ProductPriceQuery query) {
        return this.productPriceDAO.queryListDynamic(query);
    }

    public ProductPriceVO queryByKey(Long key) {
        List<ProductPriceOrgDO> orgDOs;
        ProductPriceVO productPriceVO = this.productPriceDAO.queryByKey(key);
        if (ObjectUtils.isEmpty((Object)productPriceVO)) {
            throw TwException.error("", "\u4ea7\u54c1\u4ef7\u76ee\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        List<ProductPriceCustomerDO> custDOs = this.productPriceCustomerRepo.findByPriceIdAndDeleteFlag(key, 0);
        if (!ObjectUtils.isEmpty(custDOs)) {
            List<ProductPriceCustomerVO> productPriceCustomerVOS = ProductPriceCustomerConvert.INSTANCE.toVoList(custDOs);
            productPriceVO.setPriceCustomerVOs(productPriceCustomerVOS);
        }
        if (!ObjectUtils.isEmpty(orgDOs = this.productPriceOrgRepo.findByPriceIdAndDeleteFlag(key, 0))) {
            List<ProductPriceOrgVO> productPriceOrgVOS = ProductPriceOrgConvert.INSTANCE.toVoList(orgDOs);
            productPriceVO.setPriceOrgVOs(productPriceOrgVOS);
        }
        List<ProductPriceDetailVO> productPriceDetailVOs = this.detailDAO.queryByPriceIds(List.of(key));
        productPriceVO.setPriceDetailVOs(productPriceDetailVOs);
        return productPriceVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public ProductPriceVO insert(ProductPricePayload payload) {
        this.checkData(payload);
        ProductPriceDO entityDo = ProductPriceConvert.INSTANCE.toDo(payload);
        String code = this.generateSeqNum("CRM_PRODUCT_PRICE", new String[0]);
        entityDo.setPriceCode(code);
        entityDo.setPriceStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
        entityDo = this.productPriceDAO.save(entityDo);
        Long id = entityDo.getId();
        this.saveOtherDatas(payload, id);
        ProductPriceVO productPriceVO = ProductPriceConvert.INSTANCE.toVo(entityDo);
        if (payload.getSubmit().booleanValue()) {
            payload.setId(id);
            this.submitProc(payload);
        }
        return productPriceVO;
    }

    void submitProc(ProductPricePayload payload) {
        ProcessInfo processInfo = new ProcessInfo();
        String status = WorkFlowStatusEnum.APPROVED_WORK.getCode();
        if (this.workflow_enabled.booleanValue()) {
            status = WorkFlowStatusEnum.APPROVING_WORK.getCode();
            Long orgManageUserId = this.cacheUtil.getOrgManageUserId(payload.getOrgId());
            HashMap<String, ArrayList> batchMap = new HashMap<String, ArrayList>();
            batchMap.put("Activity_03fjkz8", Lists.newArrayList((Object[])new String[]{orgManageUserId.toString()}));
            processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)ProcDefKey.PRODUCT_PRICE.name(), (String)(payload.getPriceName() + "-\u4ea7\u54c1\u4ef7\u76ee\u5ba1\u6279\u6d41\u7a0b"), (String)("" + payload.getId()), batchMap));
        }
        ProductPricePayload payload0 = new ProductPricePayload();
        payload0.setId(payload.getId());
        payload0.setProcInstId(processInfo.getProcInstId());
        payload0.setProcInstStatus(processInfo.getProcInstStatus());
        payload0.setSubmitTime(LocalDateTime.now());
        payload0.setPriceStatus(status);
        this.transactionUtilService.executeWithRunnable(() -> this.productPriceDAO.updateWorkFlow(payload0));
    }

    @Transactional(rollbackFor={Exception.class})
    public ProductPriceVO update(ProductPricePayload payload) {
        ProductPriceVO productPriceVO = this.productPriceDAO.queryByKey(payload.getId());
        if (!ObjectUtils.isEmpty((Object)productPriceVO)) {
            this.checkData(payload);
            if (productPriceVO.getPriceStatus().equals(WorkFlowStatusEnum.CREATE_WORK.getCode())) {
                this.updateProductPrice(payload);
                if (payload.getSubmit().booleanValue()) {
                    this.submitProc(payload);
                }
            } else if (productPriceVO.getPriceStatus().equals(WorkFlowStatusEnum.APPROVED_WORK.getCode())) {
                ProductPricePayload productPricePayload = ProductPriceConvert.INSTANCE.toPayload(productPriceVO);
                this.insertPayload(productPricePayload);
                Long saveId = this.businessChangeService.save(ChangeTypeEnum.PROJECT_PRICE.getCode(), this.udcUtil.translate(productPricePayload), this.udcUtil.translate(payload), "" + payload.getId());
                ProcessInfo processInfo = new ProcessInfo();
                String priceStatus = WorkFlowStatusEnum.APPROVED_WORK.getCode();
                String changeApprStatus = WorkFlowStatusEnum.APPROVED_WORK.name();
                if (this.workflow_enabled.booleanValue()) {
                    priceStatus = WorkFlowStatusEnum.CHANGING_WORK.getCode();
                    changeApprStatus = WorkFlowStatusEnum.CHANGING_WORK.getCode();
                    Long orgManageUserId = this.cacheUtil.getOrgManageUserId(productPriceVO.getOrgId());
                    HashMap<String, ArrayList> batchMap = new HashMap<String, ArrayList>();
                    batchMap.put("Activity_0wctf3c", Lists.newArrayList((Object[])new String[]{orgManageUserId.toString()}));
                    processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)ProcDefKey.PRODUCT_PRICE_CHANGE.name(), (String)(productPriceVO.getPriceName() + "-\u4ea7\u54c1\u4ef7\u76ee\u53d8\u66f4\u5ba1\u6279\u6d41\u7a0b"), (String)("" + saveId), batchMap));
                }
                ProductPricePayload payload0 = new ProductPricePayload();
                payload0.setId(payload.getId());
                payload0.setSubmitTime(LocalDateTime.now());
                payload0.setPriceStatus(priceStatus);
                ComBusinessChangePayload businessChangePayload = new ComBusinessChangePayload();
                businessChangePayload.setId(saveId);
                businessChangePayload.setApprProcInstId(processInfo.getProcInstId());
                businessChangePayload.setApprStatus(priceStatus);
                businessChangePayload.setChangeStatus(changeApprStatus);
                this.transactionUtilService.executeWithRunnable(() -> {
                    this.productPriceDAO.updateWorkFlow(payload0);
                    this.businessChangeDao.updateWorkFlow(businessChangePayload);
                });
                if (!this.workflow_enabled.booleanValue()) {
                    ComBusinessChangeVO comBusinessChangeVO = this.businessChangeDao.queryByKey(saveId);
                    ProductPricePayload pricePayload = new ProductPricePayload();
                    pricePayload.setId(Long.valueOf(comBusinessChangeVO.getChangeDocId()));
                    pricePayload.setPriceStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
                    pricePayload = (ProductPricePayload)JSON.parseObject((String)comBusinessChangeVO.getChangeContent(), ProductPricePayload.class);
                    pricePayload.setPriceStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
                    LocalDate now = LocalDate.now();
                    LocalDate startTime = pricePayload.getStartTime();
                    LocalDate endTime = pricePayload.getEndTime();
                    if (!ObjectUtils.isEmpty((Object)startTime)) {
                        if (startTime.isAfter(now)) {
                            pricePayload.setPriceStatus(WorkFlowStatusEnum.PENDING_WORK.getCode());
                        } else if (!ObjectUtils.isEmpty((Object)endTime) && endTime.isBefore(now)) {
                            pricePayload.setPriceStatus(WorkFlowStatusEnum.PENDING_WORK.getCode());
                        }
                    }
                    pricePayload.setApprovedTime(LocalDateTime.now());
                    ComBusinessChangePayload changePayload = new ComBusinessChangePayload();
                    changePayload.setId(comBusinessChangeVO.getId());
                    changePayload.setChangeStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
                    this.businessChangeDao.updateWorkFlow(changePayload);
                    this.updateProductPrice(pricePayload);
                }
            } else {
                throw TwException.error("", "\u4ec5\u65b0\u5efa\u548c\u6fc0\u6d3b\u72b6\u6001\u652f\u6301\u53d8\u66f4\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            return null;
        }
        throw TwException.error("", "\u53d8\u66f4\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
    }

    void insertPayload(ProductPricePayload payload) {
        List<ProductPriceDetailVO> productPriceDetailVOs = this.detailDAO.queryByPriceIds(List.of(payload.getId()));
        if (!ObjectUtils.isEmpty(productPriceDetailVOs)) {
            List<ProductPriceDetailPayload> productPriceDetailPayloads = ProductPriceDetailConvert.INSTANCE.toPayloadList(productPriceDetailVOs);
            payload.setPriceDetailPayloads((List)this.udcUtil.translate(productPriceDetailPayloads));
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public Long updateStatus(List<Long> keys) {
        String priceStatusNew;
        if (!keys.isEmpty()) {
            List<ProductPriceVO> productPriceVOS = this.productPriceDAO.queryByKeys(keys);
            if (ObjectUtils.isEmpty(productPriceVOS)) {
                throw TwException.error("", "\u64cd\u4f5c\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            List collect = productPriceVOS.stream().map(ProductPriceVO::getPriceStatus).distinct().collect(Collectors.toList());
            if (collect.size() > 1) {
                throw TwException.error("", "\u76f8\u540c\u6570\u636e\u72b6\u6001\u53ef\u8fdb\u884c\u8be5\u64cd\u4f5c\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            String priceStatus = (String)collect.get(0);
            String string = priceStatusNew = priceStatus.equals(WorkFlowStatusEnum.PENDING_WORK.getCode()) ? WorkFlowStatusEnum.APPROVED_WORK.getCode() : WorkFlowStatusEnum.PENDING_WORK.getCode();
            if (priceStatusNew.equals(WorkFlowStatusEnum.APPROVED_WORK.getCode())) {
                LocalDate now = LocalDate.now();
                productPriceVOS.forEach(productPriceVO -> {
                    LocalDate startTime = productPriceVO.getStartTime();
                    LocalDate endTime = productPriceVO.getEndTime();
                    if (!ObjectUtils.isEmpty((Object)startTime) && startTime.isAfter(now)) {
                        throw TwException.error("", "\u5f53\u524d\u65e5\u671f\u4e0d\u5728\u6709\u6548\u671f\u8303\u56f4\u5185\uff0c\u8bf7\u6838\u9a8c\uff01");
                    }
                    if (!ObjectUtils.isEmpty((Object)endTime) && endTime.isBefore(now)) {
                        throw TwException.error("", "\u5f53\u524d\u65e5\u671f\u4e0d\u5728\u6709\u6548\u671f\u8303\u56f4\u5185\uff0c\u8bf7\u6838\u9a8c\uff01");
                    }
                });
            }
        } else {
            throw TwException.error("", "\u64cd\u4f5c\u6570\u636e\u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        this.productPriceDAO.updateStatus(keys, priceStatusNew);
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public void xxxJobCheckProductPriceStatus() {
        XxlJobLogger.log((String)"\u5b9a\u65f6\u6838\u9a8c\u4ea7\u54c1\u4ef7\u76ee\u8868\u72b6\u6001\u6838\u9a8c\u5f00\u59cb...", (Object[])new Object[0]);
        int count = 0;
        List<ProductPriceVO> productPriceVOS = this.productPriceDAO.queryByDateAndStatus(LocalDate.now(), WorkFlowStatusEnum.APPROVED_WORK.getCode());
        if (!ObjectUtils.isEmpty(productPriceVOS)) {
            List<Long> collect = productPriceVOS.stream().map(BaseViewModel::getId).collect(Collectors.toList());
            this.productPriceDAO.updateStatusForXxxJob(collect, WorkFlowStatusEnum.PENDING_WORK.getCode());
            count = collect.size();
        }
        XxlJobLogger.log((String)"\u5b9a\u65f6\u6838\u9a8c\u4ea7\u54c1\u4ef7\u76ee\u8868\u72b6\u6001 \u7ed3\u675f...\u53d8\u66f4\u6570\u91cf\uff1a{}", (Object[])new Object[]{count});
    }

    void saveOtherDatas(ProductPricePayload payload, Long id) {
        List priceOrgPayloads;
        List priceCustomerPayloads = payload.getPriceCustomerPayloads();
        if (!ObjectUtils.isEmpty((Object)priceCustomerPayloads)) {
            ArrayList customerDOS = new ArrayList();
            priceCustomerPayloads.forEach(customerPayload -> {
                ProductPriceCustomerDO productPriceCustomerDO = ProductPriceCustomerConvert.INSTANCE.toDo((ProductPriceCustomerPayload)customerPayload);
                productPriceCustomerDO.setPriceId(id);
                customerDOS.add(productPriceCustomerDO);
            });
            this.productPriceCustomerRepo.saveAll(customerDOS);
        }
        if (!ObjectUtils.isEmpty((Object)(priceOrgPayloads = payload.getPriceOrgPayloads()))) {
            ArrayList orgDOS = new ArrayList();
            priceOrgPayloads.forEach(orgPayload -> {
                ProductPriceOrgDO productPriceOrgDO = ProductPriceOrgConvert.INSTANCE.toDo((ProductPriceOrgPayload)orgPayload);
                productPriceOrgDO.setPriceId(id);
                orgDOS.add(productPriceOrgDO);
            });
            this.productPriceOrgRepo.saveAll(orgDOS);
        }
        List priceDetailPayloads = payload.getPriceDetailPayloads();
        Set skuIds = priceDetailPayloads.stream().map(ProductPriceDetailPayload::getSkuId).collect(Collectors.toSet());
        List<ProductSkuVO> productSkuVOS = this.skuDAO.queryByKeys(new ArrayList<Long>(skuIds));
        Map productSkuVOMap = productSkuVOS.stream().collect(Collectors.toMap(BaseViewModel::getId, Function.identity()));
        ArrayList<ProductPriceDetailDO> priceDetailDOs = new ArrayList<ProductPriceDetailDO>();
        priceDetailPayloads.forEach(priceDetailPayload -> {
            ProductPriceDetailDO productPriceDetailDO = ProductPriceDetailConvert.INSTANCE.toDo((ProductPriceDetailPayload)priceDetailPayload);
            ProductSkuVO productSkuVO = (ProductSkuVO)productSkuVOMap.get(productPriceDetailDO.getSkuId());
            if (productSkuVO.getStandardPrice().compareTo(productPriceDetailDO.getStandardPrice()) == 0) {
                productPriceDetailDO.setIsChange(false);
            }
            productPriceDetailDO.setPriceId(id);
            priceDetailDOs.add(productPriceDetailDO);
        });
        this.detailDAO.saveAll(priceDetailDOs);
    }

    public void updateProductPrice(ProductPricePayload payload) {
        ProductPriceDO entityDo = ProductPriceConvert.INSTANCE.toDo(payload);
        this.productPriceDAO.save(entityDo);
        if (!ObjectUtils.isEmpty((Object)payload.getDelDetailIds())) {
            this.detailDAO.deleteSoft(payload.getDelDetailIds());
        }
        Long id = entityDo.getId();
        this.productPriceCustomerRepo.deleteByPriceId(id);
        this.productPriceOrgRepo.deleteByPriceId(id);
        this.saveOtherDatas(payload, id);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            List<ProductPriceVO> productPriceVOS = this.productPriceDAO.queryByKeys(keys);
            productPriceVOS.forEach(productPriceVO -> {
                String priceStatus = productPriceVO.getPriceStatus();
                if (!priceStatus.equals(WorkFlowStatusEnum.CREATE_WORK.getCode()) && !priceStatus.equals(WorkFlowStatusEnum.PENDING_WORK.getCode())) {
                    throw TwException.error("", "\u4ec5\u652f\u6301\u65b0\u5efa\u548c\u6682\u6302\u72b6\u6001\u4e0b\u7684\u5220\u9664\uff0c\u8bf7\u6838\u9a8c\uff01");
                }
            });
            this.productPriceDAO.deleteSoft(keys);
            this.detailDAO.deleteSoftByPriceIds(keys);
        }
    }

    private ProcessInfo startChangeWorkFlow(ProductPriceVO productPriceVO, Long saveId) {
        ProcessInfo processInfo = new ProcessInfo();
        if (this.workflow_enabled.booleanValue()) {
            Long orgManageUserId = this.cacheUtil.getOrgManageUserId(productPriceVO.getOrgId());
            HashMap<String, ArrayList> batchMap = new HashMap<String, ArrayList>();
            batchMap.put("Activity_0wctf3c", Lists.newArrayList((Object[])new String[]{orgManageUserId.toString()}));
            processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)ProcDefKey.PRODUCT_PRICE_CHANGE.name(), (String)(productPriceVO.getPriceName() + "-\u4ea7\u54c1\u4ef7\u76ee\u53d8\u66f4\u5ba1\u6279\u6d41\u7a0b"), (String)("" + saveId), batchMap));
        }
        return processInfo;
    }

    void checkData(ProductPricePayload payload) {
        if (!StringUtils.hasText((String)payload.getPriceName())) {
            throw TwException.error("", "\u4ef7\u76ee\u8868\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)payload.getOrgId())) {
            throw TwException.error("", "\u5f52\u5c5e\u90e8\u95e8\u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)payload.getManageUserId())) {
            throw TwException.error("", "\u8d1f\u8d23\u4eba\u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)payload.getCurrCode())) {
            throw TwException.error("", "\u5e01\u79cd\u4e3a\u5fc5\u586b\u9879\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)payload.getSaleCustType())) {
            throw TwException.error("", "\u9500\u552e\u5ba2\u6237\u7c7b\u578b\u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (!payload.getSaleCustType().equals("all") && ObjectUtils.isEmpty((Object)payload.getPriceCustomerPayloads())) {
            throw TwException.error("", "\u9500\u552e\u5ba2\u6237\u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)payload.getSaleOrgType())) {
            throw TwException.error("", "\u9500\u552e\u7ec4\u7ec7\u7c7b\u578b\u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (!payload.getSaleOrgType().equals("all") && ObjectUtils.isEmpty((Object)payload.getPriceOrgPayloads())) {
            throw TwException.error("", "\u9500\u552e\u7ec4\u7ec7\u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)payload.getPriceDetailPayloads())) {
            throw TwException.error("", "\u4ef7\u76ee\u8868\u660e\u7ec6\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        Set skuIds = payload.getPriceDetailPayloads().stream().filter(priceDetailPayload -> priceDetailPayload.getSkuId() != null).map(ProductPriceDetailPayload::getSkuId).collect(Collectors.toSet());
        List<ProductSkuVO> productSkuVOS = this.skuDAO.queryByKeys(new ArrayList<Long>(skuIds));
        payload.getPriceDetailPayloads().forEach(priceDetailPayload -> {
            if (ObjectUtils.isEmpty((Object)priceDetailPayload.getSkuId())) {
                throw TwException.error("", "\u672a\u5173\u8054\u4ea7\u54c1\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            if (ObjectUtils.isEmpty((Object)priceDetailPayload.getMarkedMoney())) {
                throw TwException.error("", "\u4ef7\u76ee\u8868\u552e\u4ef7\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            if (ObjectUtils.isEmpty((Object)priceDetailPayload.getDiscount())) {
                throw TwException.error("", "\u6298\u6263\u6bd4\u4f8b\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            Optional<ProductSkuVO> first = productSkuVOS.stream().filter(productSkuVO -> productSkuVO.getId().equals(priceDetailPayload.getSkuId())).findFirst();
            if (!first.isPresent()) {
                throw TwException.error("", "\u5173\u8054\u4ea7\u54c1\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            ProductSkuVO productSkuVO2 = first.get();
            priceDetailPayload.setSkuCode(productSkuVO2.getSkuCode());
            priceDetailPayload.setSkuName(productSkuVO2.getSkuName());
            priceDetailPayload.setSaleUnit(productSkuVO2.getSaleUnit());
            priceDetailPayload.setStandardPrice(productSkuVO2.getStandardPrice());
        });
    }

    void operPermissionFlag(ProductPriceQuery query) {
        Boolean rolePermission = this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode()));
        query.setPermissionFlag(Boolean.valueOf(rolePermission == false));
        if (!rolePermission.booleanValue()) {
            List<Long> longs;
            Long userId = GlobalUtil.getLoginUserId();
            query.setLoginUserId(GlobalUtil.getLoginUserId());
            List<Long> orgIdList = this.cacheUtil.getManagerOrgIdsByUserId(userId);
            HashSet<Long> orgIds = new HashSet<Long>();
            if (!ObjectUtils.isEmpty(orgIdList)) {
                orgIds.addAll(orgIdList);
            }
            if (!ObjectUtils.isEmpty(longs = this.cacheUtil.getMyOrgIdsByUserId(userId))) {
                orgIds.addAll(longs);
            }
            query.setOrgIdList(orgIds);
        }
    }

    public ProductPriceServiceImpl(ComBusinessChangeService businessChangeService, TransactionUtilService transactionUtilService, ProductPriceRepo productPriceRepo, ProductPriceOrgRepo productPriceOrgRepo, ProductPriceCustomerRepo productPriceCustomerRepo, ProductPriceDAO productPriceDAO, ProductPriceDetailDAO detailDAO, ProductSkuDAO skuDAO, CacheUtil cacheUtil, WorkflowUtil workflowUtil, ComBusinessChangeDAO businessChangeDao, UdcUtil udcUtil, WorkflowService workflowService) {
        this.businessChangeService = businessChangeService;
        this.transactionUtilService = transactionUtilService;
        this.productPriceRepo = productPriceRepo;
        this.productPriceOrgRepo = productPriceOrgRepo;
        this.productPriceCustomerRepo = productPriceCustomerRepo;
        this.productPriceDAO = productPriceDAO;
        this.detailDAO = detailDAO;
        this.skuDAO = skuDAO;
        this.cacheUtil = cacheUtil;
        this.workflowUtil = workflowUtil;
        this.businessChangeDao = businessChangeDao;
        this.udcUtil = udcUtil;
        this.workflowService = workflowService;
    }
}

