/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.product.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5crm.api.product.payload.ProductSkuPayload;
import com.elitesland.tw.tw5crm.api.product.query.ProductSkuQuery;
import com.elitesland.tw.tw5crm.api.product.service.ProductSkuService;
import com.elitesland.tw.tw5crm.api.product.vo.ProductSkuVO;
import com.elitesland.tw.tw5crm.server.product.convert.ProductSkuConvert;
import com.elitesland.tw.tw5crm.server.product.dao.ProductPriceDetailDAO;
import com.elitesland.tw.tw5crm.server.product.dao.ProductSkuDAO;
import com.elitesland.tw.tw5crm.server.product.entity.ProductPriceDetailDO;
import com.elitesland.tw.tw5crm.server.product.entity.ProductSkuDO;
import com.elitesland.tw.tw5crm.server.product.repo.ProductSkuRepo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Service
public class ProductSkuServiceImpl
implements ProductSkuService {
    private static final Logger log = LoggerFactory.getLogger(ProductSkuServiceImpl.class);
    private final ProductSkuRepo productSkuRepo;
    private final ProductSkuDAO productSkuDAO;
    private final ProductPriceDetailDAO productPriceDetailDAO;

    public PagingVO<ProductSkuVO> paging(ProductSkuQuery query) {
        query.setSkuStatus("on");
        return this.productSkuDAO.queryPaging(query);
    }

    public List<ProductSkuVO> queryList(ProductSkuQuery query) {
        return this.productSkuDAO.queryListDynamic(query);
    }

    public ProductSkuVO queryByKey(Long key) {
        ProductSkuDO entity = this.productSkuRepo.findById(key).orElseGet(ProductSkuDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        ProductSkuVO vo = ProductSkuConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public ProductSkuVO insert(ProductSkuPayload payload) {
        ProductSkuDO entityDo = ProductSkuConvert.INSTANCE.toDo(payload);
        return ProductSkuConvert.INSTANCE.toVo((ProductSkuDO)this.productSkuRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public ProductSkuVO update(ProductSkuPayload payload) {
        ProductSkuDO entity = this.productSkuRepo.findById(payload.getId()).orElseGet(ProductSkuDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        ProductSkuDO entityDo = ProductSkuConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return ProductSkuConvert.INSTANCE.toVo((ProductSkuDO)this.productSkuRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateStatus(ProductSkuPayload payload) {
        ProductSkuDO entity = this.productSkuRepo.findById(payload.getId()).orElseGet(ProductSkuDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        this.productSkuDAO.updateStatus(payload);
        if (payload.getSkuStatus().equals("off")) {
            this.productPriceDetailDAO.deleteSoftBySkuIds(List.of(payload.getId()));
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (keys.isEmpty()) {
            throw TwException.error("", "\u64cd\u4f5c\u6570\u636e\u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        this.productSkuDAO.deleteSoft(keys);
        this.productPriceDetailDAO.deleteSoftBySkuIds(keys);
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveAll(List<ProductSkuPayload> skuPayloads) {
        List<ProductPriceDetailDO> productPriceDetailDOS;
        List<ProductSkuDO> productSkuDOS = ProductSkuConvert.INSTANCE.toDoList(skuPayloads);
        this.productSkuDAO.saveAll(productSkuDOS);
        ArrayList<Long> skuIds = new ArrayList<Long>();
        HashMap map = new HashMap();
        skuPayloads.forEach(skuPayload -> {
            if (skuPayload.getId() != null) {
                skuIds.add(skuPayload.getId());
                map.put(skuPayload.getId(), skuPayload);
            }
        });
        if (!ObjectUtils.isEmpty(skuIds) && !ObjectUtils.isEmpty(productPriceDetailDOS = this.productPriceDetailDAO.queryBySkuIds(skuIds))) {
            ArrayList<ProductPriceDetailDO> detailDOS = new ArrayList<ProductPriceDetailDO>();
            productPriceDetailDOS.forEach(detailVO -> {
                ProductSkuPayload productSkuPayload = (ProductSkuPayload)map.get(detailVO.getSkuId());
                if (!productSkuPayload.getSkuName().equals(detailVO.getSkuName())) {
                    detailDOS.add((ProductPriceDetailDO)detailVO);
                    detailVO.setSkuName(productSkuPayload.getSkuName());
                    if (productSkuPayload.getStandardPrice().compareTo(detailVO.getStandardPrice()) != 0) {
                        detailVO.setIsChange(true);
                    }
                } else if (productSkuPayload.getStandardPrice().compareTo(detailVO.getStandardPrice()) != 0) {
                    detailVO.setIsChange(true);
                    detailDOS.add((ProductPriceDetailDO)detailVO);
                }
            });
            if (detailDOS.size() > 0) {
                this.productPriceDetailDAO.saveAll(detailDOS);
            }
        }
    }

    public ProductSkuServiceImpl(ProductSkuRepo productSkuRepo, ProductSkuDAO productSkuDAO, ProductPriceDetailDAO productPriceDetailDAO) {
        this.productSkuRepo = productSkuRepo;
        this.productSkuDAO = productSkuDAO;
        this.productPriceDetailDAO = productPriceDetailDAO;
    }
}

