/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.product.service;

import com.alibaba.fastjson.JSONObject;
import com.elitescloud.cloudt.common.base.BaseModel;
import com.elitescloud.cloudt.common.base.BaseViewModel;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgOrganizationDO;
import com.elitesland.tw.tw5crm.api.common.change.service.ComBusinessChangeService;
import com.elitesland.tw.tw5crm.api.product.dto.ProductAttrGroupJsonDTO;
import com.elitesland.tw.tw5crm.api.product.dto.ProductAttrJsonDTO;
import com.elitesland.tw.tw5crm.api.product.dto.ProductAttrUdcValueDTO;
import com.elitesland.tw.tw5crm.api.product.payload.ProductSkuPayload;
import com.elitesland.tw.tw5crm.api.product.payload.ProductSpuPayload;
import com.elitesland.tw.tw5crm.api.product.query.ProductSpuQuery;
import com.elitesland.tw.tw5crm.api.product.service.ProductSkuService;
import com.elitesland.tw.tw5crm.api.product.service.ProductSpuService;
import com.elitesland.tw.tw5crm.api.product.vo.ProductSkuVO;
import com.elitesland.tw.tw5crm.api.product.vo.ProductSpuVO;
import com.elitesland.tw.tw5crm.server.common.change.changeTypeEnum.ChangeTypeEnum;
import com.elitesland.tw.tw5crm.server.common.constants.ProductComponentType;
import com.elitesland.tw.tw5crm.server.product.convert.ProductSpuConvert;
import com.elitesland.tw.tw5crm.server.product.dao.ProductSkuDAO;
import com.elitesland.tw.tw5crm.server.product.dao.ProductSpuDAO;
import com.elitesland.tw.tw5crm.server.product.entity.ProductSpuDO;
import com.elitesland.tw.tw5crm.server.product.repo.ProductSpuRepo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class ProductSpuServiceImpl
extends BaseServiceImpl
implements ProductSpuService {
    private static final Logger log = LoggerFactory.getLogger(ProductSpuServiceImpl.class);
    private final ComBusinessChangeService service;
    private final ProductSpuRepo productSpuRepo;
    private final ProductSpuDAO dao;
    private final ProductSkuDAO daoSku;
    private final CacheUtil cacheUtil;
    private final PrdOrgOrganizationDAO prdOrgOrganizationDAO;
    private final FileUtil fileUtil;
    private final ProductSkuService productSkuService;

    @Transactional(rollbackFor={Exception.class})
    public ProductSpuVO insert(ProductSpuPayload payload) {
        return this.saveData(payload, null);
    }

    ProductSpuVO saveData(ProductSpuPayload payload, ProductSpuVO productSpuVO) {
        List attributes = payload.getAttributes();
        List attributeGroups = payload.getAttributeGroups();
        List skuPayloads = payload.getSkuPayloads();
        this.checkDatas(attributes, attributeGroups, skuPayloads);
        String attributeStr = JSONObject.toJSONString((Object)attributes);
        ProductSpuDO entityDo = ProductSpuConvert.INSTANCE.toDo(payload);
        entityDo.setAttribute(attributeStr);
        if (!ObjectUtils.isEmpty((Object)attributeGroups)) {
            String attributeGroupStr = JSONObject.toJSONString((Object)attributeGroups);
            entityDo.setAttributeGroup(attributeGroupStr);
        }
        if (payload.getId() == null) {
            String code = this.generateSeqNum("CRM_PRODUCT_SPU", new String[0]);
            entityDo.setSpuCode(code);
        } else if (!ObjectUtils.isEmpty((Object)payload.getDelSkuIds())) {
            this.productSkuService.deleteSoft(payload.getDelSkuIds());
        }
        entityDo = this.dao.save(entityDo);
        if (!ObjectUtils.isEmpty((Object)skuPayloads)) {
            List skuPayloads1 = null;
            if (!ObjectUtils.isEmpty((Object)productSpuVO)) {
                skuPayloads1 = productSpuVO.getSkuPayloads();
            }
            for (int i = 0; i < skuPayloads.size(); ++i) {
                Optional<ProductSkuVO> first;
                ProductSkuPayload skuPayload = (ProductSkuPayload)skuPayloads.get(i);
                List attributes1 = skuPayload.getAttributes();
                Object attributeStr1 = "";
                for (ProductAttrJsonDTO attribute : attributes1) {
                    List attrValues = attribute.getAttrValues();
                    if (CollectionUtils.isEmpty((Collection)attrValues)) continue;
                    String collect = attrValues.stream().map(ProductAttrUdcValueDTO::getSelectionName).collect(Collectors.joining(","));
                    attributeStr1 = (String)attributeStr1 + collect + ",";
                }
                if (!"".equals(attributeStr1)) {
                    attributeStr1 = ((String)attributeStr1).substring(0, ((String)attributeStr1).length() - 1);
                }
                skuPayload.setSpuCategory(entityDo.getSpuCategory());
                skuPayload.setSpuType(entityDo.getSpuType());
                skuPayload.setAttribute(JSONObject.toJSONString((Object)attributes1));
                List attributeGroups1 = skuPayload.getAttributeGroups();
                if (!ObjectUtils.isEmpty((Object)attributeGroups1)) {
                    skuPayload.setAttributeGroup(JSONObject.toJSONString((Object)attributeGroups1));
                }
                skuPayload.setAttributeStr((String)attributeStr1);
                skuPayload.setSpuId(entityDo.getId());
                if (skuPayload.getId() == null || skuPayloads1 == null || !(first = skuPayloads1.stream().filter(skuPayload1 -> skuPayload1.getId().equals(skuPayload.getId())).findFirst()).isPresent()) continue;
                ProductSkuVO productSkuVO = first.get();
                skuPayload.setSkuStatus(productSkuVO.getSkuStatus());
                skuPayload.setSkuCode(productSkuVO.getSkuCode());
                skuPayload.setSpuId(productSkuVO.getSpuId());
                skuPayload.setCreateUserId(productSkuVO.getCreateUserId());
            }
            List collect = skuPayloads.stream().filter(productSku -> productSku.getId() == null).collect(Collectors.toList());
            if (!ObjectUtils.isEmpty(collect)) {
                int count = skuPayloads.size() - collect.size();
                for (int i = 0; i < collect.size(); ++i) {
                    ProductSkuPayload productSkuDO = (ProductSkuPayload)collect.get(i);
                    String skuCode = entityDo.getSpuCode() + "-" + (i + count + 1);
                    productSkuDO.setSkuCode(skuCode);
                    productSkuDO.setSkuStatus("off");
                }
            }
            this.productSkuService.saveAll(skuPayloads);
        }
        return ProductSpuConvert.INSTANCE.toVo(entityDo);
    }

    @Transactional(rollbackFor={Exception.class})
    public ProductSpuVO update(ProductSpuPayload payload) {
        if (payload.getId() == null) {
            throw TwException.error("", "\u53d8\u66f4\u6570\u636e\u4e3b\u952e\u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        ProductSpuVO productSpuVO = this.queryByKey(payload.getId());
        this.saveData(payload, productSpuVO);
        ProductSpuVO productSpuVO1 = this.queryByKey(payload.getId());
        this.service.save(ChangeTypeEnum.PROJECT.getCode(), (Object)productSpuVO, (Object)productSpuVO1, "" + productSpuVO.getId());
        return productSpuVO1;
    }

    void checkDatas(List<ProductAttrJsonDTO> attributes, List<ProductAttrGroupJsonDTO> attributeGroups, List<ProductSkuPayload> skuPayloads) {
        if (ObjectUtils.isEmpty(attributes)) {
            throw TwException.error("", "\u89c4\u683c\u5c5e\u6027\u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        HashMap attributeMap = new HashMap();
        attributes.forEach(attribute -> {
            if (attributeMap.containsKey(attribute.getAttrId())) {
                throw TwException.error("", "\u89c4\u683c\u5c5e\u6027\u540d\u4e0d\u53ef\u91cd\u590d\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            List attrValues = attribute.getAttrValues();
            if (!ObjectUtils.isEmpty((Object)attrValues)) {
                List selectValues = attrValues.stream().map(ProductAttrUdcValueDTO::getSelectionValue).distinct().collect(Collectors.toList());
                if (attrValues.size() != selectValues.size()) {
                    throw TwException.error("", "\u89c4\u683c\u5c5e\u6027\u503c\u4e0d\u53ef\u91cd\u590d\uff0c\u8bf7\u6838\u9a8c\uff01");
                }
                attributeMap.put(attribute.getAttrId(), selectValues);
            } else if (attribute.getIsRequired() == 1) {
                if (!ObjectUtils.isEmpty((Object)attribute.getObjValue())) {
                    attributeMap.put(attribute.getAttrId(), List.of("" + attribute.getObjValue()));
                } else {
                    throw TwException.error("", "[" + attribute.getAttrDesc() + "]\u4e3a\u5fc5\u586b\u5b57\u6bb5\u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
                }
            }
        });
        HashMap groupMap = new HashMap();
        if (!ObjectUtils.isEmpty(attributeGroups)) {
            attributeGroups.forEach(attributeGroup -> {
                HashMap<String, List> longListMap = (HashMap<String, List>)groupMap.get(attributeGroup.getGroupId());
                if (ObjectUtils.isEmpty((Object)longListMap)) {
                    longListMap = new HashMap<String, List>();
                    groupMap.put(attributeGroup.getGroupId(), longListMap);
                }
                List attrValues = attributeGroup.getAttrList();
                groupMap.put(attributeGroup.getGroupId(), longListMap);
                for (ProductAttrJsonDTO attrValue : attrValues) {
                    String unitClass = attrValue.getUnitClass();
                    if (!unitClass.toLowerCase().equals("spu")) {
                        if (attrValue.getComponentType().equals(ProductComponentType.SELECT.getCode()) && !ObjectUtils.isEmpty((Object)attrValue.getAttrValues())) {
                            throw TwException.error("", "\u62d3\u5c55\u5c5e\u6027\u4e2d\u7ef4\u62a4\u7ea7\u522b\u975espu\u5c5e\u6027\u4e0d\u80fd\u5b58\u50a8\uff0c\u8bf7\u6838\u9a8c\uff01");
                        }
                        if (!attrValue.getComponentType().equals(ProductComponentType.INPUT.getCode()) || ObjectUtils.isEmpty((Object)attrValue.getObjValue())) continue;
                        throw TwException.error("", "\u62d3\u5c55\u5c5e\u6027\u4e2d\u7ef4\u62a4\u7ea7\u522b\u975espu\u5c5e\u6027\u4e0d\u80fd\u5b58\u50a8\uff0c\u8bf7\u6838\u9a8c\uff01");
                    }
                    if (!ObjectUtils.isEmpty((Object)attrValue.getAttrValues())) {
                        longListMap.put(attrValue.getAttrId(), attrValue.getAttrValues());
                        continue;
                    }
                    if (attrValue.getIsRequired() != 1) continue;
                    if (attrValue.getComponentType().equals(ProductComponentType.INPUT.getCode())) {
                        if (!ObjectUtils.isEmpty((Object)attrValue.getObjValue())) continue;
                        throw TwException.error("", "\u62d3\u5c55\u5c5e\u6027\u7ec4[" + attributeGroup.getGroupName() + "]\u2014[" + attrValue.getAttrDesc() + "]\u4e3a\u5fc5\u586b\u5b57\u6bb5\u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
                    }
                    throw TwException.error("", "\u62d3\u5c55\u5c5e\u6027\u7ec4[" + attributeGroup.getGroupName() + "]\u2014[" + attrValue.getAttrDesc() + "]\u4e3a\u5fc5\u586b\u5b57\u6bb5\u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
                }
            });
        }
        if (!ObjectUtils.isEmpty(skuPayloads)) {
            int size = attributes.size();
            skuPayloads.forEach(skuPayload -> {
                List attributes1 = skuPayload.getAttributes();
                attributes1.forEach(attribute -> {
                    List strings = (List)attributeMap.get(attribute.getAttrId());
                    List attrValues = attribute.getAttrValues();
                    if (!CollectionUtils.isEmpty((Collection)attrValues)) {
                        attrValues.forEach(attrValue -> {
                            if (!strings.contains(attrValue.getSelectionValue())) {
                                throw TwException.error("", "\u4ea7\u54c1\u7ec4\u5408\u5c5e\u6027\u503c\u8303\u56f4\u5fc5\u987b\u5728\u4ea7\u54c1\u5c5e\u6027\u503c\u8303\u7574\u5185\uff0c\u8bf7\u6838\u9a8c\uff01");
                            }
                        });
                    }
                });
                List attributeGroups1 = skuPayload.getAttributeGroups();
                if (!ObjectUtils.isEmpty((Object)attributeGroups1)) {
                    attributeGroups1.forEach(attributeGroup -> {
                        List attrValues = attributeGroup.getAttrList();
                        for (ProductAttrJsonDTO attrValue : attrValues) {
                            String unitClass = attrValue.getUnitClass();
                            if (unitClass.toLowerCase().equals("spu")) {
                                Map longListMap = (Map)groupMap.get(attributeGroup.getGroupId());
                                if (ObjectUtils.isEmpty((Object)longListMap)) continue;
                                List productAttrUdcValueDTOS = (List)longListMap.get(attrValue.getAttrId());
                                List attrValues1 = attrValue.getAttrValues();
                                if (ObjectUtils.isEmpty((Object)productAttrUdcValueDTOS) || ObjectUtils.isEmpty((Object)attrValues1) || productAttrUdcValueDTOS.containsAll(attrValues1) || productAttrUdcValueDTOS.size() == attrValues1.size()) continue;
                                throw TwException.error("", "sku\u5bf9\u62d3\u5c55\u5c5e\u6027\u7ec4\u4e2d\u7684spu\u7c7b\u578b\u5c5e\u6027\u4e0d\u80fd\u7f16\u8f91\uff0c\u8bf7\u6838\u9a8c\uff01");
                            }
                            if (!ObjectUtils.isEmpty((Object)attrValue.getAttrValues()) || !ObjectUtils.isEmpty((Object)attrValue.getObjValue()) || attrValue.getIsRequired() != 1) continue;
                            throw TwException.error("", "\u62d3\u5c55\u5c5e\u6027\u7ec4[" + attributeGroup.getGroupName() + "]\u2014[" + attrValue.getAttrDesc() + "]\u4e3a\u5fc5\u586b\u5b57\u6bb5\u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
                        }
                    });
                }
            });
        }
    }

    void operPermissionFlag(ProductSpuQuery query) {
        Boolean rolePermission = this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode()));
        query.setPermissionFlag(Boolean.valueOf(rolePermission == false));
        if (!rolePermission.booleanValue()) {
            Long userId = GlobalUtil.getLoginUserId();
            query.setCreateUserId(GlobalUtil.getLoginUserId());
            List<PrdOrgOrganizationDO> organizationDOList = this.prdOrgOrganizationDAO.queryByManagerId(userId);
            Set orgIdList = null;
            if (!CollectionUtils.isEmpty(organizationDOList)) {
                orgIdList = organizationDOList.stream().map(BaseModel::getId).collect(Collectors.toSet());
            }
            query.setOrgIdList(orgIdList);
        }
    }

    public PagingVO<ProductSpuVO> paging(ProductSpuQuery query) {
        this.operPermissionFlag(query);
        PagingVO<ProductSpuVO> productSpuVOPagingVO = this.dao.queryPaging(query);
        List spuVOs = productSpuVOPagingVO.getRecords();
        if (!ObjectUtils.isEmpty((Object)spuVOs)) {
            List<Long> spuVOIds = spuVOs.stream().map(BaseViewModel::getId).collect(Collectors.toList());
            List<ProductSkuVO> productSkuVOS = this.daoSku.queryListBySpuIds(spuVOIds);
            spuVOs.forEach(spuVO -> {
                List collect = productSkuVOS.stream().filter(productSkuVO -> productSkuVO.getSpuId().equals(spuVO.getId())).collect(Collectors.toList());
                spuVO.setSkuPayloads(collect);
                this.transferSpuData((ProductSpuVO)spuVO);
            });
        }
        return productSpuVOPagingVO;
    }

    public List<ProductSpuVO> queryList(ProductSpuQuery query) {
        return ProductSpuConvert.INSTANCE.toVoList(this.productSpuRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder)));
    }

    void transferSpuData(ProductSpuVO spuVO) {
        List skuPayloads;
        String attributeGroup;
        spuVO.setImgDatas(this.fileUtil.getFileDatas(spuVO.getImgCodes()));
        String attribute = spuVO.getAttribute();
        if (StringUtils.hasText((String)attribute)) {
            spuVO.setAttributes(JSONObject.parseArray((String)attribute, ProductAttrJsonDTO.class));
        }
        if (StringUtils.hasText((String)(attributeGroup = spuVO.getAttributeGroup()))) {
            spuVO.setAttributeGroups(JSONObject.parseArray((String)attributeGroup, ProductAttrGroupJsonDTO.class));
        }
        if (!ObjectUtils.isEmpty((Object)(skuPayloads = spuVO.getSkuPayloads()))) {
            skuPayloads.forEach(skuPayload -> this.transferSkuData((ProductSkuVO)skuPayload));
        }
        spuVO.setAttribute("");
        spuVO.setAttributeGroup("");
        spuVO.setManageUserName(this.cacheUtil.getUserName(spuVO.getManageUserId()));
        spuVO.setOrgName(this.cacheUtil.getOrgName(spuVO.getOrgId()));
    }

    void transferSkuData(ProductSkuVO skuVO) {
        String attributeGroup;
        skuVO.setImgDatas(this.fileUtil.getFileDatas(skuVO.getImgCodes()));
        skuVO.setFileDatas(this.fileUtil.getFileDatas(skuVO.getFileCodes()));
        String attribute = skuVO.getAttribute();
        if (StringUtils.hasText((String)attribute)) {
            skuVO.setAttributes(JSONObject.parseArray((String)attribute, ProductAttrJsonDTO.class));
        }
        if (StringUtils.hasText((String)(attributeGroup = skuVO.getAttributeGroup()))) {
            skuVO.setAttributeGroups(JSONObject.parseArray((String)attributeGroup, ProductAttrGroupJsonDTO.class));
        }
    }

    public ProductSpuVO queryByKey(Long key) {
        ProductSpuVO spuVO = this.dao.queryByKey(key);
        if (ObjectUtils.isEmpty((Object)spuVO)) {
            throw TwException.error("", "\u4ea7\u54c1\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        List<ProductSkuVO> productSkuVOS = this.daoSku.queryListBySpuIds(List.of(spuVO.getId()));
        spuVO.setSkuPayloads(productSkuVOS);
        this.transferSpuData(spuVO);
        return spuVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            List<ProductSkuVO> productSkuVOS = this.daoSku.queryListBySpuIds(keys);
            ArrayList skuIds = new ArrayList();
            productSkuVOS.forEach(skuDO -> {
                if (skuDO.getSkuStatus().equals("on")) {
                    throw TwException.error("", "\u8bf7\u5148\u5c06\u4ea7\u54c1\u4e0b\u67b6\u540e\u518d\u8fdb\u884c\u5220\u9664\uff01");
                }
                skuIds.add(skuDO.getId());
            });
            this.dao.deleteSoft(keys);
            this.productSkuService.deleteSoft(skuIds);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoftSku(List<Long> keys) {
        if (!keys.isEmpty()) {
            List<ProductSkuVO> productSkuDOs = this.daoSku.queryByKeys(keys);
            productSkuDOs.forEach(skuDO -> {
                if (skuDO.getSkuStatus().equals("on")) {
                    throw TwException.error("", "\u8bf7\u5148\u5c06\u4ea7\u54c1\u4e0b\u67b6\u540e\u518d\u8fdb\u884c\u5220\u9664\uff01");
                }
            });
            this.productSkuService.deleteSoft(keys);
        }
    }

    public ProductSpuServiceImpl(ComBusinessChangeService service, ProductSpuRepo productSpuRepo, ProductSpuDAO dao, ProductSkuDAO daoSku, CacheUtil cacheUtil, PrdOrgOrganizationDAO prdOrgOrganizationDAO, FileUtil fileUtil, ProductSkuService productSkuService) {
        this.service = service;
        this.productSpuRepo = productSpuRepo;
        this.dao = dao;
        this.daoSku = daoSku;
        this.cacheUtil = cacheUtil;
        this.prdOrgOrganizationDAO = prdOrgOrganizationDAO;
        this.fileUtil = fileUtil;
        this.productSkuService = productSkuService;
    }
}

