/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5crm.server.sale.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5crm.api.sale.payload.ExamInformationPayload;
import com.elitesland.tw.tw5crm.api.sale.query.ExamInformationQuery;
import com.elitesland.tw.tw5crm.api.sale.vo.ExamInformationVO;
import com.elitesland.tw.tw5crm.server.sale.entity.ExamInformationDO;
import com.elitesland.tw.tw5crm.server.sale.entity.QExamInformationDO;
import com.elitesland.tw.tw5crm.server.sale.repo.ExamInformationRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class ExamInformationDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final ExamInformationRepo repo;
    private final QExamInformationDO qdo = QExamInformationDO.examInformationDO;

    private JPAQuery<ExamInformationVO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ExamInformationVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.goalId, this.qdo.examTarget, this.qdo.fieldKey, this.qdo.fieldName, this.qdo.searchType, this.qdo.searchScope, this.qdo.searchCondition, this.qdo.settingKey, this.qdo.settingName, this.qdo.settingValue, this.qdo.ext1, this.qdo.ext2, this.qdo.ext3, this.qdo.ext4, this.qdo.ext5})).from((EntityPath)this.qdo);
    }

    private JPAQuery<ExamInformationVO> getJpaQueryWhere(ExamInformationQuery query) {
        JPAQuery<ExamInformationVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery;
    }

    public long count(ExamInformationQuery query) {
        long total = (Long)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo)).where(this.where(query))).fetchOne();
        return total;
    }

    private Predicate where(ExamInformationQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getGoalId())) {
            list.add(this.qdo.goalId.eq((Object)query.getGoalId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExamTarget())) {
            list.add(this.qdo.examTarget.eq((Object)query.getExamTarget()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getFieldKey())) {
            list.add(this.qdo.fieldKey.eq((Object)query.getFieldKey()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getFieldName())) {
            list.add(this.qdo.fieldName.like(SqlUtil.toSqlLikeString(query.getFieldName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSearchType())) {
            list.add(this.qdo.searchType.eq((Object)query.getSearchType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSearchScope())) {
            list.add(this.qdo.searchScope.like(SqlUtil.toSqlLikeString(query.getSearchScope())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSearchCondition())) {
            list.add(this.qdo.searchCondition.like(SqlUtil.toSqlLikeString(query.getSearchCondition())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSettingKey())) {
            list.add(this.qdo.settingKey.eq((Object)query.getSettingKey()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSettingName())) {
            list.add(this.qdo.settingName.eq((Object)query.getSettingName()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSettingValue())) {
            list.add(this.qdo.settingValue.eq((Object)query.getSettingValue()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExt1())) {
            list.add(this.qdo.ext1.eq((Object)query.getExt1()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExt2())) {
            list.add(this.qdo.ext2.eq((Object)query.getExt2()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExt3())) {
            list.add(this.qdo.ext3.eq((Object)query.getExt3()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExt4())) {
            list.add(this.qdo.ext4.eq((Object)query.getExt4()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getExt5())) {
            list.add(this.qdo.ext5.eq((Object)query.getExt5()));
        }
        return ExpressionUtils.allOf(list);
    }

    public ExamInformationVO queryByKey(Long id) {
        JPAQuery<ExamInformationVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (ExamInformationVO)jpaQuery.fetchFirst();
    }

    public List<ExamInformationVO> queryListDynamic(ExamInformationQuery query) {
        JPAQuery<ExamInformationVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<ExamInformationVO> queryPaging(ExamInformationQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<ExamInformationVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public ExamInformationDO save(ExamInformationDO ado) {
        return (ExamInformationDO)this.repo.save(ado);
    }

    public List<ExamInformationDO> saveAll(List<ExamInformationDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(ExamInformationPayload payload) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        List nullFields = payload.getNullFields();
        if (nullFields == null || nullFields.size() > 0) {
            // empty if block
        }
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long deleteSoftByGoalId(Long goalId) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.goalId.eq((Object)goalId)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public ExamInformationDAO(JPAQueryFactory jpaQueryFactory, ExamInformationRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

